/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.init.NCBlocks;
import nc.tile.energy.TileEnergy;
import nc.util.OreStackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;

public class TileDecayGenerator
extends TileEnergy {
    static final String[] DECAY_BLOCK_NAMES = new String[]{"blockThorium", "blockUranium", "blockDepletedThorium", "blockDepletedUranium"};
    static final Block[] DECAY_PATHS = new Block[]{NCBlocks.block_depleted_thorium, NCBlocks.block_depleted_uranium};
    Random rand = new Random();
    public int tickCount;

    public TileDecayGenerator() {
        super(200 * TileDecayGenerator.maxPower(), EnumStorage.EnergyConnection.OUT);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tick();
            if (this.shouldCheck()) {
                this.storage.changeEnergyStored(this.getGenerated());
            }
            this.pushEnergy();
        }
    }

    public void tick() {
        this.tickCount = this.tickCount > 20 ? 0 : ++this.tickCount;
    }

    public boolean shouldCheck() {
        return this.tickCount > 20;
    }

    private static int maxPower() {
        int maxPower = NCConfig.decay_power[0];
        for (int i = 1; i < NCConfig.decay_power.length; ++i) {
            if (NCConfig.decay_power[i] <= maxPower) continue;
            maxPower = NCConfig.decay_power[i];
        }
        return maxPower;
    }

    public int getGenerated() {
        int power = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            power += this.powerFromOreName(this.func_174877_v().func_177972_a(side));
        }
        return power;
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    private int powerFromOreName(BlockPos pos) {
        ArrayList<List> types = new ArrayList<List>();
        for (int i = 0; i < DECAY_BLOCK_NAMES.length; ++i) {
            types.add(i, OreDictionary.getOres((String)DECAY_BLOCK_NAMES[i]));
        }
        ItemStack stack = OreStackHelper.blockToStack(this.field_145850_b.func_180495_p(pos));
        for (int i = 0; i < types.size(); ++i) {
            for (ItemStack oreStack : (List)types.get(i)) {
                if (!oreStack.func_77969_a(stack)) continue;
                if (i < 2 && this.rand.nextInt(1800) == 0) {
                    this.field_145850_b.func_175656_a(pos, DECAY_PATHS[i].func_176223_P());
                }
                return NCConfig.decay_power[i];
            }
        }
        return 0;
    }
}

