/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.fluid.EnumTank;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;
import nc.recipe.SorptionType;
import nc.tile.IGui;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileFluidGenerator
extends TileEnergyFluidSidedInventory
implements IInterfaceable,
IGui {
    public final int fluidInputSize;
    public final int fluidOutputSize;
    public final int otherSlotsSize;
    public int time;
    public boolean isGenerating;
    public boolean hasConsumed;
    public int tickCount;
    public final BaseRecipeHandler recipes;

    public TileFluidGenerator(String name, int fluidInSize, int fluidOutSize, int otherSize, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[][] allowedFluids, int capacity, BaseRecipeHandler recipes) {
        super(name, otherSize, capacity, EnumStorage.EnergyConnection.OUT, fluidCapacity, fluidCapacity, fluidCapacity, fluidConnection, allowedFluids);
        this.fluidInputSize = fluidInSize;
        this.fluidOutputSize = fluidOutSize;
        this.otherSlotsSize = otherSize;
        this.recipes = recipes;
        this.areTanksShared = fluidInSize > 1;
    }

    public static String[][] validFluids(BaseRecipeHandler recipes, String ... exceptions) {
        int i;
        int fluidInputSize = recipes.inputSizeFluid;
        int fluidOutputSize = recipes.outputSizeFluid;
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (Fluid fluid : fluidList) {
            fluidStackList.add(new FluidStack(fluid, 1000));
        }
        ArrayList<String> exceptionsList = new ArrayList<String>();
        if (exceptions != null) {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                exceptionsList.add(exceptions[i2]);
            }
        }
        ArrayList<String> fluidNameList = new ArrayList<String>();
        for (FluidStack fluidStack : fluidStackList) {
            String fluidName = fluidStack.getFluid().getName();
            if (!recipes.isValidManualInput(fluidStack) || exceptionsList.contains(fluidName)) continue;
            fluidNameList.add(fluidName);
        }
        String[] allowedFluidArray = new String[fluidNameList.size()];
        for (int i3 = 0; i3 < fluidNameList.size(); ++i3) {
            allowedFluidArray[i3] = (String)fluidNameList.get(i3);
        }
        String[][] allowedFluidArrays = new String[fluidInputSize + fluidOutputSize][];
        for (i = 0; i < fluidInputSize; ++i) {
            allowedFluidArrays[i] = allowedFluidArray;
        }
        for (i = fluidInputSize; i < fluidInputSize + fluidOutputSize; ++i) {
            allowedFluidArrays[i] = new String[0];
        }
        return allowedFluidArrays;
    }

    public static EnumTank.FluidConnection[] fluidConnections(int inSize, int outSize) {
        int i;
        EnumTank.FluidConnection[] fluidConnections = new EnumTank.FluidConnection[2 * inSize + outSize];
        for (i = 0; i < inSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.IN;
        }
        for (i = inSize; i < inSize + outSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.OUT;
        }
        for (i = inSize + outSize; i < 2 * inSize + outSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.NON;
        }
        return fluidConnections;
    }

    public static int[] tankCapacities(int capacity, int inSize, int outSize) {
        int[] tankCapacities = new int[2 * inSize + outSize];
        for (int i = 0; i < 2 * inSize + outSize; ++i) {
            tankCapacities[i] = capacity;
        }
        return tankCapacities;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateGenerator();
    }

    public void updateGenerator() {
        boolean flag = this.isGenerating;
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.time == 0) {
                this.consume();
            }
            if (this.canProcess() && this.isPowered()) {
                this.isGenerating = true;
                this.time += this.getRateMultiplier();
                this.storage.changeEnergyStored(this.getProcessPower());
                if (this.time >= this.getProcessTime()) {
                    this.time = 0;
                    this.output();
                }
            } else {
                this.isGenerating = false;
            }
            if (flag != this.isGenerating) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
                    this.addTileToENet();
                }
            }
            this.pushEnergy();
        } else {
            boolean bl = this.isGenerating = this.canProcess() && this.isPowered();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public abstract void setBlockState();

    public void tick() {
        this.tickCount = this.tickCount > NCConfig.generator_update_rate ? 0 : ++this.tickCount;
    }

    public boolean shouldCheck() {
        return this.tickCount > NCConfig.generator_update_rate;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.isGenerating = this.isGenerating();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.hasConsumed = this.hasConsumed();
        }
    }

    public boolean isGenerating() {
        if (this.field_145850_b.field_72995_K) {
            return this.isGenerating;
        }
        return this.isPowered() && this.time > 0;
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (this.tanks[i + this.fluidInputSize + this.fluidOutputSize].getFluid() == null) continue;
            return true;
        }
        return false;
    }

    public boolean canProcess() {
        return this.canProcessStacks();
    }

    public abstract int getRateMultiplier();

    public abstract void setRateMultiplier(int var1);

    public abstract int getProcessTime();

    public abstract void setProcessTime(int var1);

    public abstract int getProcessPower();

    public abstract void setProcessPower(int var1);

    public boolean canProcessStacks() {
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (this.tanks[i].getFluidAmount() > 0 || this.hasConsumed) continue;
            return false;
        }
        if (this.time >= this.getProcessTime()) {
            return true;
        }
        Object[] output = this.outputs();
        if (output == null || output.length != this.fluidOutputSize) {
            return false;
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            if (output[j] == null) {
                return false;
            }
            if (this.tanks[j + this.fluidInputSize].getFluid() == null) continue;
            if (!this.tanks[j + this.fluidInputSize].getFluid().isFluidEqual((FluidStack)output[j])) {
                return false;
            }
            if (this.tanks[j + this.fluidInputSize].getFluidAmount() + ((FluidStack)output[j]).amount <= this.tanks[j + this.fluidInputSize].getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consume() {
        IRecipe recipe = this.getRecipe(false);
        Object[] outputs = this.outputs();
        int[] inputOrder = this.inputOrder();
        if (outputs == null || inputOrder == NCUtil.INVALID) {
            return;
        }
        if (!this.hasConsumed) {
            int i;
            for (i = 0; i < this.fluidInputSize; ++i) {
                if (this.tanks[i + this.fluidInputSize + this.fluidOutputSize].getFluid() == null) continue;
                this.tanks[i + this.fluidInputSize + this.fluidOutputSize].setFluid(null);
            }
            for (i = 0; i < this.fluidInputSize; ++i) {
                if (this.recipes != null) {
                    this.tanks[i + this.fluidInputSize + this.fluidOutputSize].changeFluidStored(this.tanks[i].getFluid().getFluid(), recipe.inputs().get(inputOrder[i]).getStackSize());
                    this.tanks[i].changeFluidStored(-recipe.inputs().get(inputOrder[i]).getStackSize());
                } else {
                    this.tanks[i + this.fluidInputSize + this.fluidOutputSize].changeFluidStored(this.tanks[i].getFluid().getFluid(), 1000);
                    this.tanks[i].changeFluidStored(-1000);
                }
                if (this.tanks[i].getFluidAmount() > 0) continue;
                this.tanks[i].setFluidStored(null);
            }
            this.hasConsumed = true;
        }
    }

    public void output() {
        if (this.hasConsumed) {
            Object[] outputs = this.outputs();
            for (int j = 0; j < this.fluidOutputSize; ++j) {
                FluidStack outputStack = (FluidStack)outputs[j];
                if (this.tanks[j + this.fluidInputSize].getFluid() == null) {
                    this.tanks[j + this.fluidInputSize].setFluidStored(outputStack);
                    continue;
                }
                if (!this.tanks[j + this.fluidInputSize].getFluid().isFluidEqual(outputStack)) continue;
                this.tanks[j + this.fluidInputSize].changeFluidStored(outputStack.amount);
            }
            for (int i = this.fluidInputSize + this.fluidOutputSize; i < 2 * this.fluidInputSize + this.fluidOutputSize; ++i) {
                this.tanks[i].setFluid(null);
            }
            this.hasConsumed = false;
        }
    }

    public IRecipe getRecipe(boolean consumed) {
        return this.recipes.getRecipeFromInputs(consumed ? this.consumedInputs() : this.inputs());
    }

    public Object[] inputs() {
        Object[] input = new Object[this.fluidInputSize];
        for (int i = 0; i < this.fluidInputSize; ++i) {
            input[i] = this.tanks[i].getFluid();
        }
        return input;
    }

    public Object[] consumedInputs() {
        Object[] input = new Object[this.fluidInputSize];
        for (int i = 0; i < this.fluidInputSize; ++i) {
            input[i] = this.tanks[i + this.fluidInputSize + this.fluidOutputSize].getFluid();
        }
        return input;
    }

    public int[] inputOrder() {
        int[] inputOrder = new int[this.fluidInputSize];
        IRecipe recipe = this.getRecipe(false);
        if (recipe == null) {
            return new int[0];
        }
        ArrayList<IIngredient> recipeIngredients = recipe.inputs();
        for (int i = 0; i < this.fluidInputSize; ++i) {
            inputOrder[i] = -1;
            for (int j = 0; j < recipeIngredients.size(); ++j) {
                if (!recipeIngredients.get(j).matches(this.inputs()[i], SorptionType.INPUT)) continue;
                inputOrder[i] = j;
                break;
            }
            if (inputOrder[i] != -1) continue;
            return NCUtil.INVALID;
        }
        return inputOrder;
    }

    public Object[] outputs() {
        Object[] output = new Object[this.fluidOutputSize];
        IRecipe recipe = this.getRecipe(this.hasConsumed);
        if (recipe == null) {
            return null;
        }
        ArrayList<IIngredient> outputs = recipe.outputs();
        for (int i = 0; i < this.fluidOutputSize; ++i) {
            Object out = RecipeMethods.getIngredientFromList(outputs, i);
            if (out == null) {
                return null;
            }
            output[i] = out;
        }
        return output;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean canFill(FluidStack resource, int tankNumber) {
        if (tankNumber >= this.fluidInputSize) {
            return false;
        }
        if (!this.areTanksShared) {
            return true;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (tankNumber == i || !this.fluidConnection[i].canFill() || this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("time", this.time);
        nbt.func_74757_a("isGenerating", this.isGenerating);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74762_e("time");
        this.isGenerating = nbt.func_74767_n("isGenerating");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
            }
        }
    }
}

