/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import nc.block.fluid.BlockFluidPlasma;
import nc.block.tile.generator.BlockFusionCore;
import nc.block.tile.passive.BlockActiveCooler;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.fluid.Tank;
import nc.handler.SoundHandler;
import nc.init.NCBlocks;
import nc.init.NCFluids;
import nc.recipe.generator.FusionRecipes;
import nc.tile.fluid.TileActiveCooler;
import nc.tile.generator.TileFluidGenerator;
import nc.util.NCUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;

public class TileFusionCore
extends TileFluidGenerator {
    public double rateMultiplier;
    public double processTime;
    public double processPower;
    public double heat;
    public double efficiency;
    public int tickCount;
    public int soundCount;
    public int size;
    public int complete;
    public String problem = I18n.func_74837_a((String)"gui.container.fusion_core.ring_incomplete", (Object[])new Object[0]);

    public TileFusionCore() {
        super("Fusion Core", 2, 4, 0, TileFusionCore.tankCapacities(32000, 2, 4), TileFusionCore.fluidConnections(2, 4), TileFusionCore.validFluids(FusionRecipes.instance(), new String[0]), 0x7D0000, FusionRecipes.instance());
        this.areTanksShared = false;
    }

    @Override
    public void updateGenerator() {
        boolean flag = this.isGenerating;
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K && this.time == 0) {
            this.consume();
        }
        this.tick();
        this.setSize();
        if (!this.field_145850_b.field_72995_K) {
            this.run();
            this.heating();
            if (this.shouldCheck() && NCConfig.fusion_active_cooling) {
                this.cooling();
            }
            this.plasma();
            if (this.overheat()) {
                return;
            }
            if (this.canProcess() && !this.isPowered()) {
                this.isGenerating = true;
                this.time += this.getRateMultiplier();
                this.storage.changeEnergyStored(this.getProcessPower());
                if (this.time >= this.getProcessTime()) {
                    this.time = 0;
                    this.output();
                }
            } else {
                this.isGenerating = false;
            }
            if (flag != this.isGenerating) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
                    this.addTileToENet();
                }
            }
            if (this.isHotEnough()) {
                this.pushEnergy();
            }
            if (this.findAdjacentComparator() && this.shouldCheck()) {
                flag1 = true;
            }
        } else {
            this.isGenerating = this.complete == 1 && !this.isPowered() && this.time > 0 && this.isHotEnough();
            this.playSounds();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @Override
    public void setBlockState() {
        BlockFusionCore.setState(this.field_145850_b, this.field_174879_c);
    }

    public boolean overheat() {
        if (this.heat >= this.getMaxHeat() && NCConfig.fusion_overheat) {
            this.meltdown();
            return true;
        }
        return false;
    }

    public void meltdown() {
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, NCFluids.block_plasma.func_176223_P());
        for (int r = -this.size - 2; r <= this.size + 2; ++r) {
            this.field_145850_b.func_175713_t(this.position(r, 0, this.size + 2));
            this.field_145850_b.func_175698_g(this.position(r, 0, this.size + 2));
            this.field_145850_b.func_175656_a(this.position(r, 1, this.size + 2), Blocks.field_150353_l.func_176223_P());
            this.field_145850_b.func_175713_t(this.position(r, 0, -this.size - 2));
            this.field_145850_b.func_175698_g(this.position(r, 0, -this.size - 2));
            this.field_145850_b.func_175656_a(this.position(r, 1, -this.size - 2), Blocks.field_150353_l.func_176223_P());
            this.field_145850_b.func_175713_t(this.position(this.size + 2, 0, r));
            this.field_145850_b.func_175698_g(this.position(this.size + 2, 0, r));
            this.field_145850_b.func_175656_a(this.position(this.size + 2, 1, r), Blocks.field_150353_l.func_176223_P());
            this.field_145850_b.func_175713_t(this.position(-this.size - 2, 0, r));
            this.field_145850_b.func_175698_g(this.position(-this.size - 2, 0, r));
            this.field_145850_b.func_175656_a(this.position(-this.size - 2, 1, r), Blocks.field_150353_l.func_176223_P());
        }
    }

    @Override
    public void tick() {
        this.tickCount = this.tickCount > NCConfig.fusion_update_rate ? 0 : ++this.tickCount;
    }

    @Override
    public boolean shouldCheck() {
        return this.tickCount > NCConfig.fusion_update_rate;
    }

    public boolean findAdjacentComparator() {
        if (this.field_145850_b.func_180495_p(this.position(2, 0, 1)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(2, 0, 0)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(2, 0, -1)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(-2, 0, 1)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(-2, 0, 0)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(-2, 0, -1)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(1, 0, 2)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(0, 0, 2)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(-1, 0, 2)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(1, 0, -2)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(0, 0, -2)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        return this.field_145850_b.func_180495_p(this.position(-1, 0, -2)).func_177230_c() instanceof BlockRedstoneComparator;
    }

    @Override
    public boolean canProcess() {
        return this.canProcessStacks() && this.complete == 1 && this.isHotEnough();
    }

    public boolean isHotEnough() {
        return this.heat > 8000.0;
    }

    @Override
    public boolean isGenerating() {
        if (this.field_145850_b.field_72995_K) {
            return this.isGenerating;
        }
        return this.complete == 1 && !this.isPowered() && this.time > 0 && this.isHotEnough();
    }

    @Override
    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1)) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1)) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1)) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1)) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1)) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) || this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1));
    }

    public void playSounds() {
        if (this.soundCount >= this.getSoundTime()) {
            if ((this.isGenerating() || this.canProcess()) && !this.isPowered()) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                for (int r = 0; r <= (this.size - 1) / 2; ++r) {
                    this.field_145850_b.func_184134_a((double)(this.field_174879_c.func_177958_n() - this.size - 2 + 2 * r * (2 * this.size + 5) / this.size), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + this.size + 2), this.getSound(), SoundCategory.BLOCKS, 0.8f, 1.0f, false);
                    this.field_145850_b.func_184134_a((double)(this.field_174879_c.func_177958_n() - this.size - 2 + 2 * r * (2 * this.size + 5) / this.size), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() - this.size - 2), this.getSound(), SoundCategory.BLOCKS, 0.8f, 1.0f, false);
                    this.field_145850_b.func_184134_a((double)(this.field_174879_c.func_177958_n() + this.size + 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + this.size + 2 - 2 * r * (2 * this.size + 5) / this.size), this.getSound(), SoundCategory.BLOCKS, 0.8f, 1.0f, false);
                    this.field_145850_b.func_184134_a((double)(this.field_174879_c.func_177958_n() - this.size - 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() - this.size - 2 + 2 * r * (2 * this.size + 5) / this.size), this.getSound(), SoundCategory.BLOCKS, 0.8f, 1.0f, false);
                }
            }
            this.soundCount = 0;
        } else {
            ++this.soundCount;
        }
    }

    private int getSoundTime() {
        return !NCConfig.fusion_alternate_sound ? 67 : 67;
    }

    private SoundEvent getSound() {
        return !NCConfig.fusion_alternate_sound ? SoundHandler.FUSION_RUN : SoundHandler.ACCELERATOR_RUN;
    }

    @Override
    public boolean canExtract() {
        return this.isHotEnough();
    }

    @Override
    public boolean canReceive() {
        return !this.isHotEnough();
    }

    @Override
    public int getSourceTier() {
        return 4;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public int getRateMultiplier() {
        return (int)Math.max(1.0, this.rateMultiplier);
    }

    @Override
    public void setRateMultiplier(int value) {
        this.rateMultiplier = Math.max(1, value);
    }

    @Override
    public int getProcessTime() {
        return (int)Math.max(1.0, this.processTime);
    }

    @Override
    public void setProcessTime(int value) {
        this.processTime = Math.max(1, value);
    }

    @Override
    public int getProcessPower() {
        return (int)this.processPower;
    }

    @Override
    public void setProcessPower(int value) {
        this.processPower = value;
    }

    public double getMaxHeat() {
        return 2.0E7;
    }

    public ArrayList getComboStats() {
        return this.getRecipe(this.hasConsumed) != null ? this.getRecipe(this.hasConsumed).extras() : null;
    }

    public double getComboTime() {
        if (this.getComboStats() != null && this.getComboStats().get(0) instanceof Double) {
            return (Double)this.getComboStats().get(0) * NCConfig.fusion_fuel_use;
        }
        return NCConfig.fusion_fuel_use;
    }

    public double getComboPower() {
        if (this.getComboStats() != null && this.getComboStats().get(1) instanceof Double) {
            return (Double)this.getComboStats().get(1);
        }
        return 0.0;
    }

    public double getComboHeatVariable() {
        if (this.getComboStats() != null && this.getComboStats().get(2) instanceof Double) {
            return (Double)this.getComboStats().get(2);
        }
        return 1000.0;
    }

    private void setAir(int x, int y, int z) {
        this.field_145850_b.func_175698_g(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z));
    }

    private void setPlasma(int x, int y, int z) {
        this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z), NCFluids.block_plasma.func_176223_P());
    }

    public void plasma() {
        block9: {
            block8: {
                if (!this.isGenerating() && !this.canProcess()) break block8;
                for (int r = -this.size - 2; r <= this.size + 2; ++r) {
                    if (!this.findPlasma(r, 1, this.size + 2)) {
                        this.setPlasma(r, 1, this.size + 2);
                    }
                    if (!this.findPlasma(r, 1, -this.size - 2)) {
                        this.setPlasma(r, 1, -this.size - 2);
                    }
                    if (!this.findPlasma(this.size + 2, 1, r)) {
                        this.setPlasma(this.size + 2, 1, r);
                    }
                    if (this.findPlasma(-this.size - 2, 1, r)) continue;
                    this.setPlasma(-this.size - 2, 1, r);
                }
                break block9;
            }
            if (this.isGenerating() && this.canProcess() || this.complete != 1) break block9;
            for (int r = -this.size - 2; r <= this.size + 2; ++r) {
                if (this.findPlasma(r, 1, this.size + 2)) {
                    this.setAir(r, 1, this.size + 2);
                }
                if (this.findPlasma(r, 1, -this.size - 2)) {
                    this.setAir(r, 1, -this.size - 2);
                }
                if (this.findPlasma(this.size + 2, 1, r)) {
                    this.setAir(this.size + 2, 1, r);
                }
                if (!this.findPlasma(-this.size - 2, 1, r)) continue;
                this.setAir(-this.size - 2, 1, r);
            }
        }
    }

    private BlockPos position(int x, int y, int z) {
        int xCheck = this.func_174877_v().func_177958_n();
        int yCheck = this.func_174877_v().func_177956_o() + y;
        int zCheck = this.func_174877_v().func_177952_p();
        if (this.func_145832_p() == 4) {
            return new BlockPos(xCheck + x, yCheck, zCheck + z);
        }
        if (this.func_145832_p() == 2) {
            return new BlockPos(xCheck - z, yCheck, zCheck + x);
        }
        if (this.func_145832_p() == 5) {
            return new BlockPos(xCheck - x, yCheck, zCheck - z);
        }
        if (this.func_145832_p() == 3) {
            return new BlockPos(xCheck + z, yCheck, zCheck - x);
        }
        return new BlockPos(xCheck + x, yCheck, zCheck + z);
    }

    private boolean findConnector(int x, int y, int z) {
        IBlockState findState = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z));
        return findState == NCBlocks.fusion_connector.func_176223_P();
    }

    private boolean findElectromagnetActive(int x, int y, int z) {
        IBlockState findState = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z));
        if (findState == NCBlocks.fusion_electromagnet_active.func_176223_P()) {
            return true;
        }
        return findState == NCBlocks.fusion_electromagnet_transparent_active.func_176223_P();
    }

    private boolean findElectromagnet(int x, int y, int z) {
        IBlockState findState = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z));
        if (findState == NCBlocks.fusion_electromagnet_idle.func_176223_P()) {
            return true;
        }
        if (findState == NCBlocks.fusion_electromagnet_active.func_176223_P()) {
            return true;
        }
        if (findState == NCBlocks.fusion_electromagnet_transparent_idle.func_176223_P()) {
            return true;
        }
        return findState == NCBlocks.fusion_electromagnet_transparent_active.func_176223_P();
    }

    private boolean findAir(int x, int y, int z) {
        Material mat = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)).func_185904_a();
        Block findBlock = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)).func_177230_c();
        return NCUtil.isReplaceable(mat) || findBlock instanceof BlockFluidPlasma;
    }

    private boolean findPlasma(int x, int y, int z) {
        Block findBlock = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)).func_177230_c();
        return findBlock instanceof BlockFluidPlasma;
    }

    private boolean findActiveCooler(int x, int y, int z) {
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockActiveCooler) {
            if (this.field_145850_b.func_175625_s(this.position(x, y, z)) == null) {
                return false;
            }
            if (this.field_145850_b.func_175625_s(this.position(x, y, z)) instanceof TileActiveCooler) {
                return true;
            }
        }
        return false;
    }

    public boolean setSize() {
        if (this.shouldCheck()) {
            int r;
            int s = 1;
            for (r = 0; r <= NCConfig.fusion_max_size && this.findConnector(2 + r, 1, 0) && this.findConnector(-2 - r, 1, 0) && this.findConnector(0, 1, 2 + r) && this.findConnector(0, 1, -2 - r); ++r) {
                ++s;
            }
            this.size = s;
            for (r = -this.size - 1; r <= this.size + 1; ++r) {
                if (this.findElectromagnet(r, 1, this.size + 1) && this.findElectromagnet(r, 1, -this.size - 1) && this.findElectromagnet(this.size + 1, 1, r) && this.findElectromagnet(-this.size - 1, 1, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.ring_incomplete", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 3; r <= this.size + 3; ++r) {
                if (this.findElectromagnet(r, 1, this.size + 3) && this.findElectromagnet(r, 1, -this.size - 3) && this.findElectromagnet(this.size + 3, 1, r) && this.findElectromagnet(-this.size - 3, 1, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.ring_incomplete", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 2; r <= this.size + 2; ++r) {
                if (this.findElectromagnet(r, 2, this.size + 2) && this.findElectromagnet(r, 2, -this.size - 2) && this.findElectromagnet(this.size + 2, 2, r) && this.findElectromagnet(-this.size - 2, 2, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.ring_incomplete", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 2; r <= this.size + 2; ++r) {
                if (this.findElectromagnet(r, 0, this.size + 2) && this.findElectromagnet(r, 0, -this.size - 2) && this.findElectromagnet(this.size + 2, 0, r) && this.findElectromagnet(-this.size - 2, 0, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.ring_incomplete", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 2; r <= this.size + 2; ++r) {
                if (this.findAir(r, 1, this.size + 2) && this.findAir(r, 1, -this.size - 2) && this.findAir(this.size + 2, 1, r) && this.findAir(-this.size - 2, 1, r)) continue;
                this.complete = 0;
                I18n.func_74837_a((String)"gui.container.fusion_core.ring_blocked", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 1; r <= this.size + 1; ++r) {
                if (this.findElectromagnetActive(r, 1, this.size + 1) && this.findElectromagnetActive(r, 1, -this.size - 1) && this.findElectromagnetActive(this.size + 1, 1, r) && this.findElectromagnetActive(-this.size - 1, 1, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.power_issue", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 3; r <= this.size + 3; ++r) {
                if (this.findElectromagnetActive(r, 1, this.size + 3) && this.findElectromagnetActive(r, 1, -this.size - 3) && this.findElectromagnetActive(this.size + 3, 1, r) && this.findElectromagnetActive(-this.size - 3, 1, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.power_issue", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 2; r <= this.size + 2; ++r) {
                if (this.findElectromagnetActive(r, 2, this.size + 2) && this.findElectromagnetActive(r, 2, -this.size - 2) && this.findElectromagnetActive(this.size + 2, 2, r) && this.findElectromagnetActive(-this.size - 2, 2, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.power_issue", (Object[])new Object[0]);
                return false;
            }
            for (r = -this.size - 2; r <= this.size + 2; ++r) {
                if (this.findElectromagnetActive(r, 0, this.size + 2) && this.findElectromagnetActive(r, 0, -this.size - 2) && this.findElectromagnetActive(this.size + 2, 0, r) && this.findElectromagnetActive(-this.size - 2, 0, r)) continue;
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.power_issue", (Object[])new Object[0]);
                return false;
            }
            this.complete = 1;
            this.problem = I18n.func_74837_a((String)"gui.container.fusion_core.incorrect_structure", (Object[])new Object[0]);
            return true;
        }
        return this.complete == 1;
    }

    public void run() {
        this.processTime = (int)this.getComboTime();
        this.efficiency = this.efficiency();
        double heatChange = 0.0;
        if (this.canProcess() && !this.isPowered()) {
            heatChange = NCConfig.fusion_heat_generation * (100.0 - 0.9 * this.efficiency) / 2.2;
            this.setProcessPower((int)(this.efficiency * NCConfig.fusion_base_power * (double)this.size * this.getComboPower()));
            this.setRateMultiplier(this.size);
        } else {
            heatChange = 0.0;
            this.setProcessPower(0);
            this.setRateMultiplier(0);
            if (this.heat >= 0.3) {
                this.heat -= this.heat / 100000.0 * Math.log10(1000.0 * this.heat - 298.0);
            }
        }
        this.heat = this.heat + heatChange >= 0.0 ? (this.heat += heatChange) : 0.0;
    }

    public double efficiency() {
        if (!this.canProcess()) {
            return 0.0;
        }
        if (this.isHotEnough()) {
            double heatMK = this.heat / 1000.0;
            double z = 7.415 * (Math.exp(-heatMK / this.getComboHeatVariable()) + Math.tanh(heatMK / this.getComboHeatVariable()) - 1.0);
            return 100.0 * Math.pow(z, 2.0);
        }
        return 0.0;
    }

    public void heating() {
        if (!this.canProcess()) {
            if (this.storage.getEnergyStored() >= 800000) {
                this.storage.changeEnergyStored(-800000);
                this.heat += 40.0 * NCConfig.fusion_heat_generation;
            } else {
                double r = 5.0E-5 * (double)this.storage.getEnergyStored();
                this.storage.changeEnergyStored(-this.storage.getEnergyStored());
                this.heat += r * NCConfig.fusion_heat_generation;
            }
            this.setConnection(EnumStorage.EnergyConnection.IN);
            if (this.heat < 0.0) {
                this.heat = 0.0;
            }
        } else {
            this.setConnection(EnumStorage.EnergyConnection.OUT);
        }
    }

    public BlockPos getOpposite(BlockPos pos) {
        BlockPos corePos = this.field_174879_c;
        BlockPos relativePos = new BlockPos(pos.func_177958_n() - corePos.func_177958_n(), pos.func_177956_o() - corePos.func_177956_o(), pos.func_177952_p() - corePos.func_177952_p());
        return this.position(-relativePos.func_177958_n(), -relativePos.func_177956_o() + 2, -relativePos.func_177952_p());
    }

    public void cooling() {
        if (this.complete == 1) {
            int r;
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            for (r = -this.size - 3; r <= this.size + 3; ++r) {
                if (this.findActiveCooler(r, 0, this.size + 3) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)0, (int)(this.size + 3)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 0, this.size + 3));
                }
                if (this.findActiveCooler(r, 2, this.size + 3) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)2, (int)(this.size + 3)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 2, this.size + 3));
                }
                if (this.findActiveCooler(r, 0, -this.size - 3) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)0, (int)(-this.size - 3)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 0, -this.size - 3));
                }
                if (this.findActiveCooler(r, 2, -this.size - 3) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)2, (int)(-this.size - 3)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 2, -this.size - 3));
                }
                if (this.findActiveCooler(this.size + 3, 0, r) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(this.size + 3), (int)0, (int)r))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(this.size + 3, 0, r));
                }
                if (this.findActiveCooler(this.size + 3, 2, r) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(this.size + 3), (int)2, (int)r))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(this.size + 3, 2, r));
                }
                if (this.findActiveCooler(-this.size - 3, 0, r) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(-this.size - 3), (int)0, (int)r))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(-this.size - 3, 0, r));
                }
                if (!this.findActiveCooler(-this.size - 3, 2, r) || ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(-this.size - 3), (int)2, (int)r))).tanks[0].getFluidAmount() <= 0) continue;
                posList.add(this.position(-this.size - 3, 2, r));
            }
            for (r = -this.size - 1; r <= this.size + 1; ++r) {
                if (this.findActiveCooler(r, 0, this.size + 1) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)0, (int)(this.size + 1)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 0, this.size + 1));
                }
                if (this.findActiveCooler(r, 2, this.size + 1) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)2, (int)(this.size + 1)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 2, this.size + 1));
                }
                if (this.findActiveCooler(r, 0, -this.size - 1) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)0, (int)(-this.size - 1)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 0, -this.size - 1));
                }
                if (this.findActiveCooler(r, 2, -this.size - 1) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)r, (int)2, (int)(-this.size - 1)))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(r, 2, -this.size - 1));
                }
                if (this.findActiveCooler(this.size + 1, 0, r) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(this.size + 1), (int)0, (int)r))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(this.size + 1, 0, r));
                }
                if (this.findActiveCooler(this.size + 1, 2, r) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(this.size + 1), (int)2, (int)r))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(this.size + 1, 2, r));
                }
                if (this.findActiveCooler(-this.size - 1, 0, r) && ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(-this.size - 1), (int)0, (int)r))).tanks[0].getFluidAmount() > 0) {
                    posList.add(this.position(-this.size - 1, 0, r));
                }
                if (!this.findActiveCooler(-this.size - 1, 2, r) || ((TileActiveCooler)this.field_145850_b.func_175625_s((BlockPos)this.position((int)(-this.size - 1), (int)2, (int)r))).tanks[0].getFluidAmount() <= 0) continue;
                posList.add(this.position(-this.size - 1, 2, r));
            }
            if (posList.isEmpty()) {
                return;
            }
            for (BlockPos pos : posList) {
                double newHeat;
                Tank tank;
                int fluidAmount;
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (tile == null || !(tile instanceof TileActiveCooler) || (fluidAmount = (tank = ((TileActiveCooler)tile).getTanks()[0]).getFluidAmount()) <= 0) continue;
                if (this.heat > 0.0) {
                    double cool_mult;
                    double d = cool_mult = posList.contains(this.getOpposite(pos)) ? 0.02 * NCConfig.fusion_heat_generation : 0.005 * NCConfig.fusion_heat_generation;
                    if (tank.getFluidName() == "water") {
                        this.heat -= NCConfig.fission_active_cooling_rate[0] * (double)fluidAmount * cool_mult;
                    } else if (tank.getFluidName() == "redstone") {
                        this.heat -= NCConfig.fission_active_cooling_rate[1] * (double)fluidAmount * cool_mult;
                    } else if (tank.getFluidName() == "glowstone") {
                        this.heat -= NCConfig.fission_active_cooling_rate[2] * (double)fluidAmount * cool_mult;
                    } else if (tank.getFluidName() == "liquidhelium") {
                        this.heat -= NCConfig.fission_active_cooling_rate[3] * (double)fluidAmount * cool_mult;
                    } else if (tank.getFluidName() == "ender") {
                        this.heat -= NCConfig.fission_active_cooling_rate[4] * (double)fluidAmount * cool_mult;
                    } else if (tank.getFluidName() == "cryotheum") {
                        this.heat -= NCConfig.fission_active_cooling_rate[5] * (double)fluidAmount * cool_mult;
                    }
                }
                if ((newHeat = this.heat) > 0.0) {
                    ((TileActiveCooler)this.field_145850_b.func_175625_s(pos)).getTanks()[0].drain(fluidAmount, true);
                }
                if (!(this.heat < 0.0)) continue;
                this.heat = 0.0;
            }
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("processTime", this.processTime);
        nbt.func_74780_a("processPower", this.processPower);
        nbt.func_74780_a("rateMultiplier", this.rateMultiplier);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74768_a("size", this.size);
        nbt.func_74768_a("complete", this.complete);
        nbt.func_74778_a("problem", this.problem);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.processTime = nbt.func_74769_h("processTime");
        this.processPower = nbt.func_74769_h("processPower");
        this.rateMultiplier = nbt.func_74769_h("rateMultiplier");
        this.heat = nbt.func_74762_e("heat");
        this.efficiency = nbt.func_74769_h("efficiency");
        this.size = nbt.func_74762_e("size");
        this.complete = nbt.func_74762_e("complete");
        this.problem = nbt.func_74779_i("problem");
    }

    @Override
    public int func_174890_g() {
        return 9;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
            case 2: {
                return this.getProcessTime();
            }
            case 3: {
                return this.getProcessPower();
            }
            case 4: {
                return (int)this.heat;
            }
            case 5: {
                return (int)this.efficiency;
            }
            case 6: {
                return this.getRateMultiplier();
            }
            case 7: {
                return this.size;
            }
            case 8: {
                return this.complete;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
                break;
            }
            case 2: {
                this.setProcessTime(value);
                break;
            }
            case 3: {
                this.setProcessPower(value);
                break;
            }
            case 4: {
                this.heat = value;
                break;
            }
            case 5: {
                this.efficiency = value;
                break;
            }
            case 6: {
                this.setRateMultiplier(value);
                break;
            }
            case 7: {
                this.size = value;
                break;
            }
            case 8: {
                this.complete = value;
            }
        }
    }
}

