/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.fluid.EnumTank;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;
import nc.recipe.SorptionType;
import nc.tile.IGui;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileItemFluidGenerator
extends TileEnergyFluidSidedInventory
implements IInterfaceable,
IGui {
    public final int itemInputSize;
    public final int fluidInputSize;
    public final int itemOutputSize;
    public final int fluidOutputSize;
    public final int otherSlotsSize;
    public int time;
    public boolean isGenerating;
    public boolean hasConsumed;
    public int tickCount;
    public final BaseRecipeHandler recipes;

    public TileItemFluidGenerator(String name, int itemInSize, int fluidInSize, int itemOutSize, int fluidOutSize, int otherSize, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[][] allowedFluids, int capacity, BaseRecipeHandler recipes) {
        super(name, 2 * itemInSize + itemOutSize + otherSize, capacity, EnumStorage.EnergyConnection.OUT, fluidCapacity, fluidCapacity, fluidCapacity, fluidConnection, allowedFluids);
        this.itemInputSize = itemInSize;
        this.fluidInputSize = fluidInSize;
        this.itemOutputSize = itemOutSize;
        this.fluidOutputSize = fluidOutSize;
        this.otherSlotsSize = otherSize;
        this.recipes = recipes;
        this.areTanksShared = fluidInSize > 1;
        int[] topSlots1 = new int[itemInSize];
        for (int i = 0; i < topSlots1.length; ++i) {
            topSlots1[i] = i;
        }
        this.topSlots = topSlots1;
        int[] sideSlots1 = new int[itemInSize + itemOutSize];
        for (int i = 0; i < sideSlots1.length; ++i) {
            sideSlots1[i] = i;
        }
        this.sideSlots = sideSlots1;
        int[] bottomSlots1 = new int[itemOutSize];
        for (int i = itemInSize; i < itemInSize + bottomSlots1.length; ++i) {
            bottomSlots1[i - itemInSize] = i;
        }
        this.bottomSlots = bottomSlots1;
    }

    public static String[][] validFluids(BaseRecipeHandler recipes, String ... exceptions) {
        int i;
        int fluidInputSize = recipes.inputSizeFluid;
        int fluidOutputSize = recipes.outputSizeFluid;
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (Fluid fluid : fluidList) {
            fluidStackList.add(new FluidStack(fluid, 1000));
        }
        ArrayList<String> exceptionsList = new ArrayList<String>();
        if (exceptions != null) {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                exceptionsList.add(exceptions[i2]);
            }
        }
        ArrayList<String> fluidNameList = new ArrayList<String>();
        for (FluidStack fluidStack : fluidStackList) {
            String fluidName = fluidStack.getFluid().getName();
            if (!recipes.isValidManualInput(fluidStack) || exceptionsList.contains(fluidName)) continue;
            fluidNameList.add(fluidName);
        }
        String[] allowedFluidArray = new String[fluidNameList.size()];
        for (int i3 = 0; i3 < fluidNameList.size(); ++i3) {
            allowedFluidArray[i3] = (String)fluidNameList.get(i3);
        }
        String[][] allowedFluidArrays = new String[fluidInputSize + fluidOutputSize][];
        for (i = 0; i < fluidInputSize; ++i) {
            allowedFluidArrays[i] = allowedFluidArray;
        }
        for (i = fluidInputSize; i < fluidInputSize + fluidOutputSize; ++i) {
            allowedFluidArrays[i] = new String[0];
        }
        return allowedFluidArrays;
    }

    public static EnumTank.FluidConnection[] fluidConnections(int inSize, int outSize) {
        int i;
        EnumTank.FluidConnection[] fluidConnections = new EnumTank.FluidConnection[2 * inSize + outSize];
        for (i = 0; i < inSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.IN;
        }
        for (i = inSize; i < inSize + outSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.OUT;
        }
        for (i = inSize + outSize; i < 2 * inSize + outSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.NON;
        }
        return fluidConnections;
    }

    public static int[] tankCapacities(int capacity, int inSize, int outSize) {
        int[] tankCapacities = new int[2 * inSize + outSize];
        for (int i = 0; i < 2 * inSize + outSize; ++i) {
            tankCapacities[i] = capacity;
        }
        return tankCapacities;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateGenerator();
    }

    public void updateGenerator() {
        boolean flag = this.isGenerating;
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.time == 0) {
                this.consume();
            }
            if (this.canProcess() && this.isPowered()) {
                this.isGenerating = true;
                this.time += this.getRateMultiplier();
                this.storage.changeEnergyStored(this.getProcessPower());
                if (this.time >= this.getProcessTime()) {
                    this.time = 0;
                    this.output();
                }
            } else {
                this.isGenerating = false;
            }
            if (flag != this.isGenerating) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
                    this.addTileToENet();
                }
            }
            this.pushEnergy();
        } else {
            boolean bl = this.isGenerating = this.canProcess() && this.isPowered();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public abstract void setBlockState();

    public void tick() {
        this.tickCount = this.tickCount > NCConfig.generator_update_rate ? 0 : ++this.tickCount;
    }

    public boolean shouldCheck() {
        return this.tickCount > NCConfig.generator_update_rate;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.isGenerating = this.isGenerating();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.hasConsumed = this.hasConsumed();
        }
    }

    public boolean isGenerating() {
        if (this.field_145850_b.field_72995_K) {
            return this.isGenerating;
        }
        return this.isPowered() && this.time > 0;
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean hasConsumed() {
        int i;
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            if (this.inventoryStacks[i + this.itemInputSize + this.itemOutputSize + this.otherSlotsSize] == null) continue;
            return true;
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            if (this.tanks[i + this.fluidInputSize + this.fluidOutputSize].getFluid() == null) continue;
            return true;
        }
        return false;
    }

    public boolean canProcess() {
        return this.canProcessStacks();
    }

    public abstract int getRateMultiplier();

    public abstract void setRateMultiplier(int var1);

    public abstract int getProcessTime();

    public abstract void setProcessTime(int var1);

    public abstract int getProcessPower();

    public abstract void setProcessPower(int var1);

    public boolean canProcessStacks() {
        int j;
        int i;
        for (i = 0; i < this.itemInputSize; ++i) {
            if (this.inventoryStacks[i] != null || this.hasConsumed) continue;
            return false;
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            if (this.tanks[i].getFluidAmount() > 0 || this.hasConsumed) continue;
            return false;
        }
        if (this.time >= this.getProcessTime()) {
            return true;
        }
        Object[] output = this.outputs();
        if (output == null || output.length != this.itemOutputSize + this.fluidInputSize) {
            return false;
        }
        for (j = 0; j < this.itemOutputSize; ++j) {
            if (output[j] == null) {
                return false;
            }
            if (this.inventoryStacks[j + this.itemInputSize] == null) continue;
            if (!this.inventoryStacks[j + this.itemInputSize].func_77969_a((ItemStack)output[j])) {
                return false;
            }
            if (this.inventoryStacks[j + this.itemInputSize].field_77994_a + ((ItemStack)output[j]).field_77994_a <= this.inventoryStacks[j + this.itemInputSize].func_77976_d()) continue;
            return false;
        }
        for (j = 0; j < this.fluidOutputSize; ++j) {
            if (output[this.recipes.outputSizeItem + j] == null) {
                return false;
            }
            if (this.tanks[j + this.fluidInputSize].getFluid() == null) continue;
            if (!this.tanks[j + this.fluidInputSize].getFluid().isFluidEqual((FluidStack)output[this.recipes.outputSizeItem + j])) {
                return false;
            }
            if (this.tanks[j + this.fluidInputSize].getFluidAmount() + ((FluidStack)output[this.recipes.outputSizeItem + j]).amount <= this.tanks[j + this.fluidInputSize].getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consume() {
        IRecipe recipe = this.getRecipe(false);
        Object[] outputs = this.outputs();
        int[] itemInputOrder = this.itemInputOrder();
        int[] fluidInputOrder = this.fluidInputOrder();
        if (outputs == null || itemInputOrder == NCUtil.INVALID || fluidInputOrder == NCUtil.INVALID) {
            return;
        }
        if (!this.hasConsumed) {
            int i;
            for (i = 0; i < this.itemInputSize; ++i) {
                if (this.inventoryStacks[i + this.itemInputSize + this.itemOutputSize + this.otherSlotsSize] == null) continue;
                this.inventoryStacks[i + this.itemInputSize + this.itemOutputSize + this.otherSlotsSize] = null;
            }
            for (i = 0; i < this.fluidInputSize; ++i) {
                if (this.tanks[i + this.fluidInputSize + this.fluidOutputSize].getFluid() == null) continue;
                this.tanks[i + this.fluidInputSize + this.fluidOutputSize].setFluid(null);
            }
            for (i = 0; i < this.itemInputSize; ++i) {
                if (this.recipes != null) {
                    this.inventoryStacks[i + this.itemInputSize + this.itemOutputSize + this.otherSlotsSize] = new ItemStack(this.inventoryStacks[i].func_77973_b(), recipe.inputs().get(itemInputOrder[i]).getStackSize(), this.inventoryStacks[i].func_77960_j());
                    this.inventoryStacks[i].field_77994_a -= recipe.inputs().get(itemInputOrder[i]).getStackSize();
                } else {
                    this.inventoryStacks[i + this.itemInputSize + this.itemOutputSize + this.otherSlotsSize] = new ItemStack(this.inventoryStacks[i].func_77973_b(), 1, this.inventoryStacks[i].func_77960_j());
                    --this.inventoryStacks[i].field_77994_a;
                }
                if (this.inventoryStacks[i].field_77994_a > 0) continue;
                this.inventoryStacks[i] = null;
            }
            for (i = 0; i < this.fluidInputSize; ++i) {
                if (this.recipes != null) {
                    this.tanks[i + this.fluidInputSize + this.fluidOutputSize].changeFluidStored(this.tanks[i].getFluid().getFluid(), recipe.inputs().get(fluidInputOrder[i] + this.itemInputSize).getStackSize());
                    this.tanks[i].changeFluidStored(-recipe.inputs().get(fluidInputOrder[i] + this.itemInputSize).getStackSize());
                } else {
                    this.tanks[i + this.fluidInputSize + this.fluidOutputSize].changeFluidStored(this.tanks[i].getFluid().getFluid(), 1000);
                    this.tanks[i].changeFluidStored(-1000);
                }
                if (this.tanks[i].getFluidAmount() > 0) continue;
                this.tanks[i].setFluidStored(null);
            }
            this.hasConsumed = true;
        }
    }

    public void output() {
        if (this.hasConsumed) {
            int i;
            ItemStack outputStack;
            int j;
            Object[] outputs = this.outputs();
            for (j = 0; j < this.itemOutputSize; ++j) {
                outputStack = (ItemStack)outputs[j];
                if (this.inventoryStacks[j + this.itemInputSize] == null) {
                    this.inventoryStacks[j + this.itemInputSize] = outputStack;
                    continue;
                }
                if (!this.inventoryStacks[j + this.itemInputSize].func_77969_a(outputStack)) continue;
                this.inventoryStacks[j + this.itemInputSize].field_77994_a += outputStack.field_77994_a;
            }
            for (j = 0; j < this.fluidOutputSize; ++j) {
                outputStack = (FluidStack)outputs[j + this.itemOutputSize];
                if (this.tanks[j + this.fluidInputSize].getFluid() == null) {
                    this.tanks[j + this.fluidInputSize].setFluidStored((FluidStack)outputStack);
                    continue;
                }
                if (!this.tanks[j + this.fluidInputSize].getFluid().isFluidEqual((FluidStack)outputStack)) continue;
                this.tanks[j + this.fluidInputSize].changeFluidStored(outputStack.amount);
            }
            for (i = this.itemInputSize + this.itemOutputSize + this.otherSlotsSize; i < 2 * this.itemInputSize + this.itemOutputSize + this.otherSlotsSize; ++i) {
                this.inventoryStacks[i] = null;
            }
            for (i = this.fluidInputSize + this.fluidOutputSize; i < 2 * this.fluidInputSize + this.fluidOutputSize; ++i) {
                this.tanks[i].setFluid(null);
            }
            this.hasConsumed = false;
        }
    }

    public IRecipe getRecipe(boolean consumed) {
        return this.recipes.getRecipeFromInputs(consumed ? this.consumedInputs() : this.inputs());
    }

    public Object[] inputs() {
        int i;
        Object[] input = new Object[this.itemInputSize + this.fluidInputSize];
        for (i = 0; i < this.itemInputSize; ++i) {
            input[i] = this.inventoryStacks[i];
        }
        for (i = this.itemInputSize; i < this.fluidInputSize + this.itemInputSize; ++i) {
            input[i] = this.tanks[i - this.itemInputSize].getFluid();
        }
        return input;
    }

    public Object[] consumedInputs() {
        int i;
        Object[] input = new Object[this.itemInputSize + this.fluidInputSize];
        for (i = 0; i < this.itemInputSize; ++i) {
            input[i] = this.inventoryStacks[i + this.itemInputSize + this.itemOutputSize + this.otherSlotsSize];
        }
        for (i = this.itemInputSize; i < this.fluidInputSize; ++i) {
            input[i] = this.tanks[i + this.fluidInputSize + this.fluidOutputSize].getFluid();
        }
        return input;
    }

    public int[] itemInputOrder() {
        int[] inputOrder = new int[this.itemInputSize];
        IRecipe recipe = this.getRecipe(false);
        if (recipe == null) {
            return new int[0];
        }
        ArrayList<IIngredient> recipeIngredients = recipe.inputs();
        for (int i = 0; i < this.itemInputSize; ++i) {
            inputOrder[i] = -1;
            for (int j = 0; j < recipeIngredients.size(); ++j) {
                if (!recipeIngredients.get(j).matches(this.inputs()[i], SorptionType.INPUT)) continue;
                inputOrder[i] = j;
                break;
            }
            if (inputOrder[i] != -1) continue;
            return NCUtil.INVALID;
        }
        return inputOrder;
    }

    public int[] fluidInputOrder() {
        int[] inputOrder = new int[this.fluidInputSize];
        IRecipe recipe = this.getRecipe(false);
        if (recipe == null) {
            return new int[0];
        }
        ArrayList<IIngredient> recipeIngredients = recipe.inputs();
        for (int i = 0; i < this.fluidInputSize; ++i) {
            inputOrder[i] = -1;
            for (int j = 0; j < recipeIngredients.size(); ++j) {
                if (!recipeIngredients.get(j).matches(this.inputs()[i + this.itemInputSize], SorptionType.INPUT)) continue;
                inputOrder[i] = j - this.itemInputSize;
                break;
            }
            if (inputOrder[i] != -1) continue;
            return NCUtil.INVALID;
        }
        return inputOrder;
    }

    public Object[] outputs() {
        Object[] output = new Object[this.itemOutputSize + this.fluidOutputSize];
        IRecipe recipe = this.getRecipe(this.hasConsumed);
        if (recipe == null) {
            return null;
        }
        ArrayList<IIngredient> outputs = recipe.outputs();
        for (int i = 0; i < this.itemOutputSize + this.fluidOutputSize; ++i) {
            Object out = RecipeMethods.getIngredientFromList(outputs, i);
            if (out == null) {
                return null;
            }
            output[i] = out;
        }
        return output;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot >= this.itemInputSize && slot < this.itemInputSize + this.itemOutputSize) {
            return false;
        }
        return this.recipes.isValidManualInput(stack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.bottomSlots : (side == EnumFacing.UP ? this.topSlots : this.sideSlots);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack) && direction != EnumFacing.DOWN;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.UP && slot >= this.itemInputSize && slot < this.itemInputSize + this.itemOutputSize;
    }

    @Override
    public boolean canFill(FluidStack resource, int tankNumber) {
        if (tankNumber >= this.fluidInputSize) {
            return false;
        }
        if (!this.areTanksShared) {
            return true;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (tankNumber == i || !this.fluidConnection[i].canFill() || this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("time", this.time);
        nbt.func_74757_a("isGenerating", this.isGenerating);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74762_e("time");
        this.isGenerating = nbt.func_74767_n("isGenerating");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
            }
        }
    }
}

