/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.tile.energy.TileEnergy;

public abstract class TilePassiveGenerator
extends TileEnergy {
    public final int power;

    public TilePassiveGenerator(int capacity) {
        this(capacity, capacity);
    }

    public TilePassiveGenerator(int capacity, int maxTransfer) {
        super(2 * capacity * NCConfig.generator_rf_per_eu, maxTransfer * NCConfig.generator_rf_per_eu, EnumStorage.EnergyConnection.OUT);
        this.power = capacity;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.storage.changeEnergyStored(this.getGenerated());
            this.pushEnergy();
        }
    }

    public abstract int getGenerated();

    @Override
    public int getSourceTier() {
        double euPerTick = (double)this.power / (double)NCConfig.generator_rf_per_eu;
        return euPerTick < 32.0 ? 1 : (euPerTick < 128.0 ? 2 : (euPerTick < 512.0 ? 3 : 4));
    }

    @Override
    public int getSinkTier() {
        return 4;
    }
}

