/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.passive;

import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.fluid.EnumTank;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.util.NCStackHelper;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TilePassive
extends TileEnergyFluidSidedInventory {
    public int tickCount;
    public final int updateRate;
    public boolean isRunning;
    public boolean energyBool;
    public boolean stackBool;
    public boolean fluidBool;
    public final int energyChange;
    public final ItemStack stackChange;
    public final int itemChange;
    public final int fluidChange;
    public final FluidStack fluidStackChange;
    public final Fluid fluidType;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TilePassive(String name, int energyChange, int changeRate) {
        this(name, new ItemStack(Items.field_151082_bd), 0, energyChange, FluidRegistry.LAVA, 0, changeRate);
    }

    public TilePassive(String name, ItemStack stack, int itemChange, int changeRate) {
        this(name, stack, itemChange, 0, FluidRegistry.LAVA, 0, changeRate);
    }

    public TilePassive(String name, Fluid fluid, int fluidChange, int changeRate) {
        this(name, new ItemStack(Items.field_151082_bd), 0, 0, fluid, fluidChange, changeRate);
    }

    public TilePassive(String name, Fluid fluid, int fluidChange, int changeRate, String[] fluidTypes) {
        this(name, new ItemStack(Items.field_151082_bd), 0, 0, fluid, fluidChange, changeRate, fluidTypes);
    }

    public TilePassive(String name, ItemStack stack, int itemChange, int energyChange, int changeRate) {
        this(name, stack, itemChange, energyChange, FluidRegistry.LAVA, 0, changeRate);
    }

    public TilePassive(String name, int energyChange, Fluid fluid, int fluidChange, int changeRate) {
        this(name, new ItemStack(Items.field_151082_bd), 0, energyChange, fluid, fluidChange, changeRate);
    }

    public TilePassive(String name, ItemStack stack, int itemChange, Fluid fluid, int fluidChange, int changeRate) {
        this(name, stack, itemChange, 0, fluid, fluidChange, changeRate);
    }

    public TilePassive(String name, ItemStack stack, int itemChange, int energyChange, Fluid fluid, int fluidChange, int changeRate) {
        this(name, stack, itemChange, energyChange, fluid, fluidChange, changeRate, new String[]{fluid.getName()});
    }

    public TilePassive(String name, ItemStack stack, int itemChange, int energyChange, Fluid fluid, int fluidChange, int changeRate, String[] fluidTypes) {
        super(name, 1, energyChange == 0 ? 1 : 2 * MathHelper.func_76130_a((int)energyChange) * changeRate * NCConfig.generator_rf_per_eu, energyChange == 0 ? 0 : MathHelper.func_76130_a((int)energyChange) * NCConfig.generator_rf_per_eu, energyChange > 0 ? EnumStorage.EnergyConnection.OUT : (energyChange < 0 ? EnumStorage.EnergyConnection.IN : EnumStorage.EnergyConnection.NON), new int[]{fluidChange == 0 ? 1 : 2 * MathHelper.func_76130_a((int)fluidChange) * changeRate}, new EnumTank.FluidConnection[]{fluidChange > 0 ? EnumTank.FluidConnection.OUT : (fluidChange < 0 ? EnumTank.FluidConnection.IN : EnumTank.FluidConnection.NON)}, (String[][])new String[][]{fluidTypes});
        this.energyChange = energyChange * changeRate;
        this.itemChange = itemChange * changeRate;
        this.stackChange = NCStackHelper.changeStackSize(stack, MathHelper.func_76130_a((int)itemChange) * changeRate);
        this.fluidChange = fluidChange * changeRate;
        this.fluidStackChange = new FluidStack(fluid, MathHelper.func_76130_a((int)fluidChange) * changeRate);
        this.fluidType = fluid;
        this.updateRate = changeRate * 20;
    }

    @Override
    public void func_73660_a() {
        boolean flag = this.isRunning;
        boolean flag1 = false;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tick();
            if (this.shouldUpdate()) {
                this.energyBool = this.changeEnergy(false);
                this.stackBool = this.changeStack(false);
                this.fluidBool = this.changeFluid(false);
            }
            this.isRunning = this.isRunning(this.energyBool, this.stackBool, this.fluidBool);
            if (flag != this.isRunning) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
                }
            }
            if (this.energyChange > 0) {
                this.pushEnergy();
            }
            if (this.fluidChange > 0) {
                this.pushFluid();
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void tick() {
        this.tickCount = this.tickCount > this.updateRate ? 0 : ++this.tickCount;
    }

    public boolean shouldUpdate() {
        return this.tickCount > this.updateRate;
    }

    public boolean changeEnergy(boolean b) {
        if (this.energyChange == 0) {
            return b;
        }
        if (this.storage.getEnergyStored() >= this.storage.getMaxEnergyStored() && this.energyChange > 0) {
            return false;
        }
        if ((float)this.storage.getEnergyStored() < MathHelper.func_76135_e((float)this.energyChange) && this.energyChange < 0) {
            return false;
        }
        if (!b && this.changeStack(true) && this.changeFluid(true)) {
            this.storage.changeEnergyStored(this.energyChange);
        }
        if (this.energyChange < 0) {
            return this.storage.getEnergyStored() > -this.energyChange;
        }
        return true;
    }

    public boolean changeStack(boolean b) {
        if (this.itemChange == 0) {
            return b;
        }
        if (!ItemStack.func_179545_c((ItemStack)this.inventoryStacks[0], (ItemStack)this.stackChange) && this.inventoryStacks[0] != null && !b) {
            this.inventoryStacks[0] = null;
        }
        if (this.itemChange > 0) {
            if (this.inventoryStacks[0] != null && this.inventoryStacks[0].field_77994_a + this.itemChange > this.func_70297_j_()) {
                return false;
            }
            if (this.inventoryStacks[0] == null && !b) {
                if (this.changeEnergy(true) && this.changeFluid(true)) {
                    this.inventoryStacks[0] = this.stackChange;
                }
            } else if (!b && this.changeEnergy(true) && this.changeFluid(true)) {
                this.inventoryStacks[0].field_77994_a += this.itemChange;
            }
            return true;
        }
        if (this.inventoryStacks[0] == null || this.inventoryStacks[0].field_77994_a < MathHelper.func_76130_a((int)this.itemChange)) {
            return false;
        }
        if (this.inventoryStacks[0].field_77994_a > MathHelper.func_76130_a((int)this.itemChange) && !b) {
            if (this.changeEnergy(true) && this.changeFluid(true)) {
                this.inventoryStacks[0].field_77994_a += this.itemChange;
            }
        } else if (this.inventoryStacks[0].field_77994_a == MathHelper.func_76130_a((int)this.itemChange) && !b && this.changeEnergy(true) && this.changeFluid(true)) {
            this.inventoryStacks[0] = null;
        }
        return true;
    }

    public boolean changeFluid(boolean b) {
        if (this.fluidChange == 0) {
            return b;
        }
        if (this.tanks[0].getFluidAmount() >= this.tanks[0].getCapacity() && this.fluidChange > 0) {
            return false;
        }
        if ((float)this.tanks[0].getFluidAmount() < MathHelper.func_76135_e((float)this.fluidChange) && this.fluidChange < 0) {
            return false;
        }
        if (!b && this.changeEnergy(true) && this.changeStack(true)) {
            if (this.fluidChange > 0) {
                if (this.fluidStackChange != null) {
                    this.tanks[0].changeFluidStored(this.fluidType, this.fluidStackChange.amount);
                }
            } else {
                this.tanks[0].changeFluidStored(this.fluidStackChange.amount);
            }
        }
        return true;
    }

    public abstract void setBlockState();

    public boolean isRunning(boolean energy, boolean stack, boolean fluid) {
        if (this.energyChange >= 0) {
            if (this.itemChange >= 0) {
                if (this.fluidChange >= 0) {
                    return energy || stack || fluid;
                }
                return fluid;
            }
            if (this.fluidChange >= 0) {
                return stack;
            }
            return stack && fluid;
        }
        if (this.itemChange >= 0) {
            if (this.fluidChange >= 0) {
                return energy;
            }
            return energy && fluid;
        }
        if (this.fluidChange >= 0) {
            return energy && stack;
        }
        return energy && stack && fluid;
    }

    @Override
    public int func_70297_j_() {
        return this.itemChange == 0 ? 1 : 2 * MathHelper.func_76130_a((int)this.itemChange);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.itemChange < 0 && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.stackChange);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return this.itemChange > 0;
    }

    @Override
    public int getSourceTier() {
        return 2;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74757_a("isRunning", this.isRunning);
        nbt.func_74757_a("energyBool", this.energyBool);
        nbt.func_74757_a("stackBool", this.stackBool);
        nbt.func_74757_a("fluidBool", this.fluidBool);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.isRunning = nbt.func_74767_n("isRunning");
        this.energyBool = nbt.func_74767_n("energyBool");
        this.stackBool = nbt.func_74767_n("stackBool");
        this.fluidBool = nbt.func_74767_n("fluidBool");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.energyChange != 0 && CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return true;
        }
        if (this.energyChange != 0 && this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return true;
        }
        if (this.fluidChange != 0 && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return this.itemChange != 0 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.energyChange != 0 && CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return (T)this.storage;
        }
        if (this.energyChange != 0 && this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.storage;
        }
        if (this.fluidChange != 0 && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (this.itemChange != 0 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerSide;
        }
        return super.getCapability(capability, facing);
    }
}

