/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import java.util.ArrayList;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.fluid.EnumTank;
import nc.init.NCItems;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;
import nc.recipe.SorptionType;
import nc.tile.IGui;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileEnergyFluidProcessor
extends TileEnergyFluidSidedInventory
implements IInterfaceable,
IGui {
    public final int defaultProcessTime;
    public int baseProcessTime;
    public final int baseProcessPower;
    public final int fluidInputSize;
    public final int fluidOutputSize;
    public int time;
    public boolean isProcessing;
    public final boolean hasUpgrades;
    public final int upgradeMeta;
    public int tickCount;
    public final BaseRecipeHandler recipes;

    public TileEnergyFluidProcessor(String name, int fluidInSize, int fluidOutSize, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[][] allowedFluids, int time, int power, BaseRecipeHandler recipes) {
        this(name, fluidInSize, fluidOutSize, fluidCapacity, fluidConnection, allowedFluids, time, power, false, recipes, 1);
    }

    public TileEnergyFluidProcessor(String name, int fluidInSize, int fluidOutSize, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[][] allowedFluids, int time, int power, BaseRecipeHandler recipes, int upgradeMeta) {
        this(name, fluidInSize, fluidOutSize, fluidCapacity, fluidConnection, allowedFluids, time, power, true, recipes, upgradeMeta);
    }

    public TileEnergyFluidProcessor(String name, int fluidInSize, int fluidOutSize, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[][] allowedFluids, int time, int power, boolean upgrades, BaseRecipeHandler recipes, int upgradeMeta) {
        super(name, upgrades ? 2 : 0, 32000, power != 0 ? EnumStorage.EnergyConnection.IN : EnumStorage.EnergyConnection.NON, fluidCapacity, fluidCapacity, fluidCapacity, fluidConnection, allowedFluids);
        this.fluidInputSize = fluidInSize;
        this.fluidOutputSize = fluidOutSize;
        this.defaultProcessTime = time;
        this.baseProcessTime = time;
        this.baseProcessPower = power;
        this.hasUpgrades = upgrades;
        this.recipes = recipes;
        this.upgradeMeta = upgradeMeta;
        this.areTanksShared = fluidInSize > 1;
    }

    public static String[][] validFluids(BaseRecipeHandler recipes, String ... exceptions) {
        int i;
        int fluidInputSize = recipes.inputSizeFluid;
        int fluidOutputSize = recipes.outputSizeFluid;
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (Fluid fluid : fluidList) {
            fluidStackList.add(new FluidStack(fluid, 1000));
        }
        ArrayList<String> exceptionsList = new ArrayList<String>();
        if (exceptions != null) {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                exceptionsList.add(exceptions[i2]);
            }
        }
        ArrayList<String> fluidNameList = new ArrayList<String>();
        for (FluidStack fluidStack : fluidStackList) {
            String fluidName = fluidStack.getFluid().getName();
            if (!recipes.isValidManualInput(fluidStack) || exceptionsList.contains(fluidName)) continue;
            fluidNameList.add(fluidName);
        }
        String[] allowedFluidArray = new String[fluidNameList.size()];
        for (int i3 = 0; i3 < fluidNameList.size(); ++i3) {
            allowedFluidArray[i3] = (String)fluidNameList.get(i3);
        }
        String[][] allowedFluidArrays = new String[fluidInputSize + fluidOutputSize][];
        for (i = 0; i < fluidInputSize; ++i) {
            allowedFluidArrays[i] = allowedFluidArray;
        }
        for (i = fluidInputSize; i < fluidInputSize + fluidOutputSize; ++i) {
            allowedFluidArrays[i] = new String[0];
        }
        return allowedFluidArrays;
    }

    public static EnumTank.FluidConnection[] fluidConnections(int inSize, int outSize) {
        int i;
        EnumTank.FluidConnection[] fluidConnections = new EnumTank.FluidConnection[inSize + outSize];
        for (i = 0; i < inSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.IN;
        }
        for (i = inSize; i < inSize + outSize; ++i) {
            fluidConnections[i] = EnumTank.FluidConnection.OUT;
        }
        return fluidConnections;
    }

    public static int[] tankCapacities(int capacity, int inSize, int outSize) {
        int[] tankCapacities = new int[inSize + outSize];
        for (int i = 0; i < inSize + outSize; ++i) {
            tankCapacities[i] = capacity;
        }
        return tankCapacities;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateProcessor();
    }

    public void updateProcessor() {
        boolean flag = this.isProcessing;
        boolean flag1 = false;
        this.setCapacityFromSpeed();
        if (!this.field_145850_b.field_72995_K) {
            this.tick();
            if (this.canProcess() && !this.isPowered()) {
                this.isProcessing = true;
                this.time += this.getSpeedMultiplier();
                this.storage.changeEnergyStored(-this.getProcessPower());
                if (this.time >= this.baseProcessTime) {
                    this.time = 0;
                    this.process();
                }
            } else {
                this.isProcessing = false;
                if (this.time != 0 && !this.isPowered()) {
                    this.time = MathHelper.func_76125_a((int)(this.time - 2 * this.getSpeedMultiplier()), (int)0, (int)this.baseProcessTime);
                }
            }
            if (flag != this.isProcessing) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
                    this.addTileToENet();
                }
            }
        } else {
            boolean bl = this.isProcessing = this.canProcess() && !this.isPowered();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public abstract void setBlockState();

    public void tick() {
        this.tickCount = this.tickCount > NCConfig.processor_update_rate ? 0 : ++this.tickCount;
    }

    public boolean shouldCheck() {
        return this.tickCount > NCConfig.processor_update_rate;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.baseProcessTime = this.defaultProcessTime;
        if (!this.field_145850_b.field_72995_K) {
            this.isProcessing = this.isProcessing();
        }
    }

    public boolean isProcessing() {
        if (this.field_145850_b.field_72995_K) {
            return this.isProcessing;
        }
        return !this.isPowered() && this.canProcess();
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean canProcess() {
        return this.canProcessStacks();
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public int getSinkTier() {
        return 2;
    }

    public int getSpeedMultiplier() {
        if (!this.hasUpgrades) {
            return 1;
        }
        ItemStack speedStack = this.inventoryStacks[0];
        if (speedStack == null) {
            return 1;
        }
        return speedStack.field_77994_a + 1;
    }

    public int getProcessTime() {
        return Math.max(1, this.baseProcessTime / this.getSpeedMultiplier());
    }

    public int getProcessPower() {
        return this.baseProcessPower * this.getSpeedMultiplier() * (this.getSpeedMultiplier() + 1) / 2;
    }

    public int getProcessEnergy() {
        return this.getProcessTime() * this.getProcessPower();
    }

    public void setCapacityFromSpeed() {
        this.storage.setStorageCapacity(MathHelper.func_76125_a((int)(2 * this.getProcessPower()), (int)32000, (int)Integer.MAX_VALUE));
    }

    public boolean canProcessStacks() {
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (this.tanks[i].getFluidAmount() > 0) continue;
            return false;
        }
        if (this.time >= this.baseProcessTime) {
            return true;
        }
        if (this.getProcessEnergy() > this.getMaxEnergyStored() && this.time <= 0 && this.getEnergyStored() < this.getMaxEnergyStored()) {
            return false;
        }
        if (this.getProcessEnergy() <= this.getMaxEnergyStored() && this.time <= 0 && this.getProcessEnergy() > this.getEnergyStored()) {
            return false;
        }
        if (this.getEnergyStored() < this.getProcessPower()) {
            return false;
        }
        Object[] outputs = this.outputs();
        if (outputs == null || outputs.length != this.fluidOutputSize) {
            return false;
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            if (outputs[j] == null) {
                return false;
            }
            if (this.tanks[j + this.fluidInputSize].getFluid() == null) continue;
            if (!this.tanks[j + this.fluidInputSize].getFluid().isFluidEqual((FluidStack)outputs[j])) {
                return false;
            }
            if (this.tanks[j + this.fluidInputSize].getFluidAmount() + ((FluidStack)outputs[j]).amount <= this.tanks[j + this.fluidInputSize].getCapacity()) continue;
            return false;
        }
        Object[] inputs = this.inputs();
        if (this.recipes.getRecipeFromInputs(inputs).extras().get(0) instanceof Integer) {
            this.baseProcessTime = (Integer)this.recipes.getRecipeFromInputs(inputs).extras().get(0);
        }
        return true;
    }

    public void process() {
        IRecipe recipe = this.getRecipe();
        Object[] outputs = this.outputs();
        int[] inputOrder = this.inputOrder();
        if (outputs == null || inputOrder == NCUtil.INVALID) {
            return;
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            FluidStack outputStack = (FluidStack)outputs[j];
            if (this.tanks[j + this.fluidInputSize].getFluid() == null) {
                this.tanks[j + this.fluidInputSize].setFluidStored(outputStack);
                continue;
            }
            if (!this.tanks[j + this.fluidInputSize].getFluid().isFluidEqual(outputStack)) continue;
            this.tanks[j + this.fluidInputSize].changeFluidStored(outputStack.amount);
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (this.recipes != null) {
                this.tanks[i].changeFluidStored(-recipe.inputs().get(inputOrder[i]).getStackSize());
            } else {
                this.tanks[i].changeFluidStored(-1000);
            }
            if (this.tanks[i].getFluidAmount() > 0) continue;
            this.tanks[i].setFluidStored(null);
        }
    }

    public IRecipe getRecipe() {
        return this.recipes.getRecipeFromInputs(this.inputs());
    }

    public Object[] inputs() {
        Object[] input = new Object[this.fluidInputSize];
        for (int i = 0; i < this.fluidInputSize; ++i) {
            input[i] = this.tanks[i].getFluid();
        }
        return input;
    }

    public int[] inputOrder() {
        int[] inputOrder = new int[this.fluidInputSize];
        IRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return new int[0];
        }
        ArrayList<IIngredient> recipeIngredients = recipe.inputs();
        for (int i = 0; i < this.fluidInputSize; ++i) {
            inputOrder[i] = -1;
            for (int j = 0; j < recipeIngredients.size(); ++j) {
                if (!recipeIngredients.get(j).matches(this.inputs()[i], SorptionType.INPUT)) continue;
                inputOrder[i] = j;
                break;
            }
            if (inputOrder[i] != -1) continue;
            return NCUtil.INVALID;
        }
        return inputOrder;
    }

    public Object[] outputs() {
        Object[] output = new Object[this.fluidOutputSize];
        IRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return null;
        }
        ArrayList<IIngredient> outputs = recipe.outputs();
        for (int i = 0; i < this.fluidOutputSize; ++i) {
            Object out = RecipeMethods.getIngredientFromList(outputs, i);
            if (out == null) {
                return null;
            }
            output[i] = out;
        }
        return output;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.hasUpgrades && stack.func_77973_b() == NCItems.upgrade) {
            if (slot == 0) {
                return stack.func_77960_j() == 0;
            }
            if (slot == 1) {
                return stack.func_77960_j() == this.upgradeMeta;
            }
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean canFill(FluidStack resource, int tankNumber) {
        if (tankNumber >= this.fluidInputSize) {
            return false;
        }
        if (!this.areTanksShared) {
            return true;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (tankNumber == i || !this.fluidConnection[i].canFill() || this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74762_e("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
            case 2: {
                return this.baseProcessTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
                break;
            }
            case 2: {
                this.baseProcessTime = value;
            }
        }
    }
}

