/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import net.minecraft.util.math.MathHelper;

public class NCMath {
    public static final String[] SI_PREFIX = new String[]{" y", " z", " a", " f", " p", " n", " u", " m", " ", " k", " M", " G", " T", " P", " E", " Z", " Y"};

    public static double Round(double value, int precision) {
        double scale = Math.pow(10.0, precision);
        return (double)Math.round(value * scale) / (double)Math.round(scale);
    }

    public static int kroneckerDelta(int ... indices) {
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == indices[(i + 1) % indices.length]) continue;
            return 0;
        }
        return 1;
    }

    public static double[] cartesianFromSpherical(double r, double theta, double phi) {
        return new double[]{r * Math.sin(theta * Math.PI / 180.0) * Math.cos(phi * Math.PI / 180.0), r * Math.sin(theta * Math.PI / 180.0) * Math.sin(phi * Math.PI / 180.0), r * Math.cos(theta * Math.PI / 180.0)};
    }

    public static int magnitudeMult(int in, int power) {
        double doubleOut = 1.0 * (double)in * Math.pow(10.0, 1.0 * (double)power);
        double roundedOut = Math.round(doubleOut);
        return (int)roundedOut;
    }

    public static double magnitudeMult(double in, int power) {
        return 1.0 * in * Math.pow(10.0, 1.0 * (double)power);
    }

    private static boolean atLimit(int number, int divider) {
        return Math.abs(number) > Integer.MAX_VALUE / divider;
    }

    public static int numberLength(long number) {
        return String.valueOf(number).length();
    }

    public static String prefix(int value, int maxValue, int maxLength, String unit, int startingPrefixNo, int lowestPrefixNo) {
        double newMaxDouble;
        String maxVal;
        int minPrefixNumber = Math.max(lowestPrefixNo + 8, 0);
        int prefixNumber = MathHelper.func_76125_a((int)(startingPrefixNo + 8), (int)minPrefixNumber, (int)16);
        String string = maxVal = maxValue == -1 ? "" : " / " + maxValue;
        if (value == 0) {
            return value + maxVal + SI_PREFIX[minPrefixNumber] + unit;
        }
        double newDouble = 1.0 * (double)value;
        double d = newMaxDouble = maxValue == -1 ? newDouble : 1.0 * (double)maxValue;
        while (prefixNumber > minPrefixNumber) {
            newDouble = NCMath.magnitudeMult(newDouble, 3);
            newMaxDouble = NCMath.magnitudeMult(newMaxDouble, 3);
            if (!NCMath.atLimit((int)newDouble, 1000) && !NCMath.atLimit((int)newMaxDouble, 1000) && --prefixNumber != minPrefixNumber) continue;
        }
        int newValue = (int)newDouble;
        int newMaxValue = (int)newMaxDouble;
        int length = NCMath.numberLength(newValue);
        while (prefixNumber < SI_PREFIX.length - 1) {
            length = NCMath.numberLength(newValue);
            if (length <= maxLength) {
                maxVal = maxValue == -1 ? "" : " / " + newMaxValue;
                return newValue + maxVal + SI_PREFIX[prefixNumber] + unit;
            }
            newValue = NCMath.magnitudeMult(newValue, -3);
            newMaxValue = NCMath.magnitudeMult(newMaxValue, -3);
            ++prefixNumber;
        }
        maxVal = maxValue == -1 ? "" : " / " + NCMath.magnitudeMult(newMaxValue, -3);
        return NCMath.magnitudeMult(newValue, -3) + maxVal + SI_PREFIX[SI_PREFIX.length - 1] + unit;
    }

    public static String prefix(int value, int maxLength, String unit, int startingPrefixNo, int lowestPrefixNo) {
        return NCMath.prefix(value, -1, maxLength, unit, startingPrefixNo, lowestPrefixNo);
    }

    public static String prefix(int value, int maxValue, int maxLength, String unit, int startingPrefixNo) {
        return NCMath.prefix(value, maxValue, maxLength, unit, startingPrefixNo, startingPrefixNo);
    }

    public static String prefix(int value, int maxLength, String unit, int startingPrefixNo) {
        return NCMath.prefix(value, maxLength, unit, startingPrefixNo, startingPrefixNo);
    }

    public static String prefix(int value, int maxValue, int maxLength, String unit) {
        return NCMath.prefix(value, maxValue, maxLength, unit, 0);
    }

    public static String prefix(int value, int maxLength, String unit) {
        return NCMath.prefix(value, maxLength, unit, 0);
    }
}

