/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.generator;

import java.util.Random;
import nc.block.tile.processor.BlockProcessor;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.init.NCBlocks;
import nc.proxy.CommonProxy;
import nc.tile.generator.TileFissionController;
import nc.util.NCInventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockFissionController
extends BlockProcessor {
    public BlockFissionController(String unlocalizedName, String registryName, boolean isActive, int guiId) {
        super(unlocalizedName, registryName, "", "", null, isActive, guiId);
        if (!isActive) {
            this.func_149647_a(CommonProxy.TAB_FISSION_BLOCKS);
        }
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileFissionController();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)NCBlocks.fission_controller_idle);
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(NCBlocks.fission_controller_idle);
    }

    @Override
    public void dropItems(World world, BlockPos pos, IInventory tileentity) {
        NCInventoryHelper.dropInventoryItems(world, pos, tileentity, 0, 1);
    }

    public static void setState(boolean active, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            world.func_180501_a(pos, NCBlocks.fission_controller_active.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
        } else {
            world.func_180501_a(pos, NCBlocks.fission_controller_idle.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
        }
        keepInventory = false;
        if (tile != null) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileFissionController) {
            return MathHelper.func_76125_a((int)Math.round(15.0f * (float)((TileFissionController)tile).heat / (float)((TileFissionController)tile).getMaxHeat()), (int)0, (int)15);
        }
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileFissionController) {
            TileFissionController controller = (TileFissionController)tile;
            BlockPos position = controller.getCentreWithRand();
            double size = controller.lengthX + controller.lengthY + controller.lengthZ;
            double div = (double)NCConfig.fission_max_size * 5.0;
            double rate = 1.0 * (double)controller.cells * size / div;
            if (controller.isGenerating() && rand.nextDouble() < rate) {
                world.func_184134_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), SoundHandler.GEIGER_TICK, SoundCategory.BLOCKS, 1.6f, 1.0f + 0.12f * (rand.nextFloat() - 0.5f), false);
            }
        }
    }
}

