/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.processor;

import java.util.Random;
import nc.block.tile.BlockSidedInventoryGui;
import nc.proxy.CommonProxy;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockProcessor
extends BlockSidedInventoryGui {
    private final boolean isActive;
    private SoundEvent sound = null;
    private String particle1 = "";
    private String particle2 = "";

    public BlockProcessor(String unlocalizedName, String registryName, String particle1, String particle2, SoundEvent sound, boolean isActive, int guiId) {
        super(unlocalizedName, registryName, Material.field_151573_f, guiId);
        this.particle1 = particle1;
        this.particle2 = particle2;
        this.sound = sound;
        this.isActive = isActive;
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        if (!isActive) {
            this.func_149647_a(CommonProxy.TAB_MACHINES);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.particle1 == "" && this.particle2 == "") {
            return;
        }
        if (this.isActive) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.125 + rand.nextDouble() * 0.75;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (this.sound != null && rand.nextDouble() < 0.2) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.sound, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    if (this.particle1 != "") {
                        world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle1), d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (this.particle2 == "") break;
                    world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle2), d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    if (this.particle1 != "") {
                        world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle1), d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (this.particle2 == "") break;
                    world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle2), d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    if (this.particle1 != "") {
                        world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle1), d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (this.particle2 == "") break;
                    world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle2), d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    if (this.particle1 != "") {
                        world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle1), d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (this.particle2 == "") break;
                    world.func_175688_a(EnumParticleTypes.func_186831_a((String)this.particle2), d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

