/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.quantum;

import java.util.Random;
import javax.annotation.Nullable;
import nc.block.NCBlock;
import nc.proxy.CommonProxy;
import nc.tile.quantum.TileSpin;
import nc.util.Complex;
import nc.util.NCUtil;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSpin
extends NCBlock
implements ITileEntityProvider {
    private Random rand = new Random();
    public double phi = 0.0;
    public double theta = 0.0;

    public BlockSpin(String unlocalizedName, String registryName) {
        super(unlocalizedName, registryName, Material.field_151573_f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(CommonProxy.TAB_MISC);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSpin();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileSpin) {
            this.phi = ((double)placer.field_70177_z + 360.0) % 360.0;
            this.theta = placer.field_70125_A;
            ((TileSpin)tile).setStateFromAngles(this.phi, this.theta);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileSpin && !player.func_70093_af()) {
            double newSpin;
            double phi = ((double)player.field_70177_z + 360.0) % 360.0;
            double theta = player.field_70125_A;
            NCUtil.getLogger().info(phi + "   " + theta);
            Complex[] newState = ((TileSpin)tile).getStateFromAngles(phi, theta);
            NCUtil.getLogger().info(newState[0].re() + "   " + newState[0].im() + "   " + newState[1].re() + "   " + newState[1].im());
            NCUtil.getLogger().info(((TileSpin)tile).stateVector[0].re() + "   " + ((TileSpin)tile).stateVector[0].im() + "   " + ((TileSpin)tile).stateVector[1].re() + "   " + ((TileSpin)tile).stateVector[1].im());
            double expectation = 0.5;
            NCUtil.getLogger().info((Object)expectation);
            ((TileSpin)tile).measuredSpin = newSpin = expectation > this.rand.nextDouble() ? 0.5 : -0.5;
            ((TileSpin)tile).setStateFromAngles(phi, theta);
            ((TileSpin)tile).phi = phi;
            ((TileSpin)tile).theta = theta;
            ((TileSpin)tile).isMeasured = 10;
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileSpin && ((TileSpin)tile).measuredSpin > 0.0) {
            return 15;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof TileSpin && ((TileSpin)tile).measuredSpin > 0.0) {
            return 15;
        }
        return 0;
    }
}

