/*
 * Decompiled with CFR 0.152.
 */
package nc.config;

import java.io.File;
import java.util.ArrayList;
import nc.util.NCMath;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NCConfig {
    private static Configuration config = null;
    public static final String CATEGORY_ORES = "ores";
    public static final String CATEGORY_PROCESSORS = "processors";
    public static final String CATEGORY_GENERATORS = "generators";
    public static final String CATEGORY_FISSION = "fission";
    public static final String CATEGORY_FUSION = "fusion";
    public static final String CATEGORY_ACCELERATOR = "accelerator";
    public static final String CATEGORY_ENERGY_STORAGE = "energy_storage";
    public static final String CATEGORY_TOOLS = "tools";
    public static final String CATEGORY_ARMOR = "armor";
    public static final String CATEGORY_OTHER = "other";
    public static int[] ore_dims;
    public static boolean ore_dims_list_type;
    public static boolean[] ore_gen;
    public static int[] ore_size;
    public static int[] ore_rate;
    public static int[] ore_min_height;
    public static int[] ore_max_height;
    public static boolean[] ore_drops;
    public static boolean hide_disabled_ores;
    public static int[] processor_time;
    public static int[] processor_power;
    public static int processor_rf_per_eu;
    public static int processor_update_rate;
    public static int[] processor_passive_rate;
    public static int cobble_gen_power;
    public static boolean ore_processing;
    public static boolean update_block_type;
    public static int[] rtg_power;
    public static int[] solar_power;
    public static int[] decay_power;
    public static int generator_rf_per_eu;
    public static int generator_update_rate;
    public static double fission_power;
    public static double fission_fuel_use;
    public static double fission_heat_generation;
    public static double[] fission_cooling_rate;
    public static double[] fission_active_cooling_rate;
    public static boolean fission_water_cooler_requirement;
    public static boolean fission_overheat;
    public static int fission_update_rate;
    public static int fission_min_size;
    public static int fission_max_size;
    public static int fission_active_cooler_max_rate;
    public static double[] fission_thorium_fuel_time;
    public static double[] fission_thorium_power;
    public static double[] fission_thorium_heat_generation;
    public static double[] fission_uranium_fuel_time;
    public static double[] fission_uranium_power;
    public static double[] fission_uranium_heat_generation;
    public static double[] fission_neptunium_fuel_time;
    public static double[] fission_neptunium_power;
    public static double[] fission_neptunium_heat_generation;
    public static double[] fission_plutonium_fuel_time;
    public static double[] fission_plutonium_power;
    public static double[] fission_plutonium_heat_generation;
    public static double[] fission_mox_fuel_time;
    public static double[] fission_mox_power;
    public static double[] fission_mox_heat_generation;
    public static double[] fission_americium_fuel_time;
    public static double[] fission_americium_power;
    public static double[] fission_americium_heat_generation;
    public static double[] fission_curium_fuel_time;
    public static double[] fission_curium_power;
    public static double[] fission_curium_heat_generation;
    public static double[] fission_berkelium_fuel_time;
    public static double[] fission_berkelium_power;
    public static double[] fission_berkelium_heat_generation;
    public static double[] fission_californium_fuel_time;
    public static double[] fission_californium_power;
    public static double[] fission_californium_heat_generation;
    public static double fusion_base_power;
    public static double fusion_fuel_use;
    public static double fusion_heat_generation;
    public static boolean fusion_overheat;
    public static boolean fusion_active_cooling;
    public static int fusion_update_rate;
    public static int fusion_min_size;
    public static int fusion_max_size;
    public static int fusion_electromagnet_power;
    public static boolean fusion_alternate_sound;
    public static double[] fusion_fuel_time;
    public static double[] fusion_power;
    public static double[] fusion_heat_variable;
    public static int accelerator_electromagnet_power;
    public static int accelerator_supercooler_coolant;
    public static int[] battery_capacity;
    public static int[] tool_mining_level;
    public static int[] tool_durability;
    public static double[] tool_speed;
    public static double[] tool_attack_damage;
    public static int[] tool_enchantability;
    public static int[] armor_durability;
    public static int[] armor_boron;
    public static int[] armor_tough;
    public static int[] armor_hard_carbon;
    public static int[] armor_boron_nitride;
    public static int[] armor_enchantability;
    public static double[] armor_toughness;
    public static boolean rare_drops;

    public static void preInit() {
        File configFile = new File(Loader.instance().getConfigDir(), "nuclearcraft.cfg");
        config = new Configuration(configFile);
        NCConfig.syncFromFiles();
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void clientPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventHandler());
    }

    public static void syncFromFiles() {
        NCConfig.syncConfig(true, true);
    }

    public static void syncFromGui() {
        NCConfig.syncConfig(false, true);
    }

    public static void syncFromFields() {
        NCConfig.syncConfig(false, false);
    }

    private static void syncConfig(boolean loadFromConfigFile, boolean readFieldFromConfig) {
        if (loadFromConfigFile) {
            config.load();
        }
        Property propertyOreDims = config.get(CATEGORY_ORES, "ore_dims", new int[]{0, 6, -11325, -9999, -100}, I18n.func_74837_a((String)"gui.config.ores.ore_dims.comment", (Object[])new Object[0]), Integer.MIN_VALUE, Integer.MAX_VALUE);
        propertyOreDims.setLanguageKey("gui.config.ores.ore_dims");
        Property propertyOreDimsListType = config.get(CATEGORY_ORES, "ore_dims_list_type", false, I18n.func_74837_a((String)"gui.config.ores.ore_dims_list_type.comment", (Object[])new Object[0]));
        propertyOreDimsListType.setLanguageKey("gui.config.ores.ore_dims_list_type");
        Property propertyOreGen = config.get(CATEGORY_ORES, "ore_gen", new boolean[]{true, true, true, true, true, true, true, true}, I18n.func_74837_a((String)"gui.config.ores.ore_gen.comment", (Object[])new Object[0]));
        propertyOreGen.setLanguageKey("gui.config.ores.ore_gen");
        Property propertyOreSize = config.get(CATEGORY_ORES, "ore_size", new int[]{8, 8, 8, 8, 8, 8, 8, 8}, I18n.func_74837_a((String)"gui.config.ores.ore_size.comment", (Object[])new Object[0]), 1, Integer.MAX_VALUE);
        propertyOreSize.setLanguageKey("gui.config.ores.ore_size");
        Property propertyOreRate = config.get(CATEGORY_ORES, "ore_rate", new int[]{6, 6, 8, 4, 4, 8, 6, 4}, I18n.func_74837_a((String)"gui.config.ores.ore_rate.comment", (Object[])new Object[0]), 1, Integer.MAX_VALUE);
        propertyOreRate.setLanguageKey("gui.config.ores.ore_rate");
        Property propertyOreMinHeight = config.get(CATEGORY_ORES, "ore_min_height", new int[]{0, 0, 0, 0, 0, 0, 0, 0}, I18n.func_74837_a((String)"gui.config.ores.ore_min_height.comment", (Object[])new Object[0]), 1, 255);
        propertyOreMinHeight.setLanguageKey("gui.config.ores.ore_min_height");
        Property propertyOreMaxHeight = config.get(CATEGORY_ORES, "ore_max_height", new int[]{32, 32, 32, 32, 32, 32, 32, 32}, I18n.func_74837_a((String)"gui.config.ores.ore_max_height.comment", (Object[])new Object[0]), 1, 255);
        propertyOreMaxHeight.setLanguageKey("gui.config.ores.ore_max_height");
        Property propertyOreDrops = config.get(CATEGORY_ORES, "ore_drops", new boolean[]{true, true, true, true, true}, I18n.func_74837_a((String)"gui.config.ores.ore_drops.comment", (Object[])new Object[0]));
        propertyOreDrops.setLanguageKey("gui.config.ores.ore_drops");
        Property propertyHideDisabledOres = config.get(CATEGORY_ORES, "hide_disabled_ores", false, I18n.func_74837_a((String)"gui.config.ores.hide_disabled_ores.comment", (Object[])new Object[0]));
        propertyHideDisabledOres.setLanguageKey("gui.config.ores.hide_disabled_ores");
        Property propertyProcessorTime = config.get(CATEGORY_PROCESSORS, "processor_time", new int[]{400, 800, 800, 400, 400, 600, 800, 1600, 1600, 800, 400, 600, 800, 600, 1600, 600}, I18n.func_74837_a((String)"gui.config.processors.processor_time.comment", (Object[])new Object[0]), 1, 128000);
        propertyProcessorTime.setLanguageKey("gui.config.processors.processor_time");
        Property propertyProcessorPower = config.get(CATEGORY_PROCESSORS, "processor_power", new int[]{20, 10, 10, 20, 10, 10, 40, 20, 40, 20, 0, 40, 10, 20, 10, 10}, I18n.func_74837_a((String)"gui.config.processors.processor_power.comment", (Object[])new Object[0]), 0, 16000);
        propertyProcessorPower.setLanguageKey("gui.config.processors.processor_power");
        Property propertyProcessorRFPerEU = config.get(CATEGORY_PROCESSORS, "processor_rf_per_eu", 4, I18n.func_74837_a((String)"gui.config.processors.processor_rf_per_eu.comment", (Object[])new Object[0]), 1, 255);
        propertyProcessorRFPerEU.setLanguageKey("gui.config.processors.processor_rf_per_eu");
        Property propertyProcessorUpdateRate = config.get(CATEGORY_PROCESSORS, "processor_update_rate", 20, I18n.func_74837_a((String)"gui.config.processors.processor_update_rate.comment", (Object[])new Object[0]), 1, 1200);
        propertyProcessorUpdateRate.setLanguageKey("gui.config.processors.processor_update_rate");
        Property propertyProcessorPassiveRate = config.get(CATEGORY_PROCESSORS, "processor_passive_rate", new int[]{200, 2, 400, 200}, I18n.func_74837_a((String)"gui.config.processors.processor_passive_rate.comment", (Object[])new Object[0]), 1, 4000);
        propertyProcessorPassiveRate.setLanguageKey("gui.config.processors.processor_passive_rate");
        Property propertyCobbleGenPower = config.get(CATEGORY_PROCESSORS, "cobble_gen_power", 0, I18n.func_74837_a((String)"gui.config.processors.cobble_gen_power.comment", (Object[])new Object[0]), 0, 255);
        propertyCobbleGenPower.setLanguageKey("gui.config.processors.cobble_gen_power");
        Property propertyOreProcessing = config.get(CATEGORY_PROCESSORS, "ore_processing", true, I18n.func_74837_a((String)"gui.config.processors.ore_processing.comment", (Object[])new Object[0]));
        propertyOreProcessing.setLanguageKey("gui.config.processors.ore_processing");
        Property propertyRTGPower = config.get(CATEGORY_GENERATORS, "rtg_power", new int[]{4, 100, 50, 400}, I18n.func_74837_a((String)"gui.config.generators.rtg_power.comment", (Object[])new Object[0]), 1, Integer.MAX_VALUE);
        propertyRTGPower.setLanguageKey("gui.config.generators.rtg_power");
        Property propertySolarPower = config.get(CATEGORY_GENERATORS, "solar_power", new int[]{5}, I18n.func_74837_a((String)"gui.config.generators.solar_power.comment", (Object[])new Object[0]), 1, Integer.MAX_VALUE);
        propertySolarPower.setLanguageKey("gui.config.generators.solar_power");
        Property propertyDecayPower = config.get(CATEGORY_GENERATORS, "decay_power", new int[]{80, 80, 10, 10}, I18n.func_74837_a((String)"gui.config.generators.decay_power.comment", (Object[])new Object[0]), 0, Integer.MAX_VALUE);
        propertyDecayPower.setLanguageKey("gui.config.generators.decay_power");
        Property propertyGeneratorRFPerEU = config.get(CATEGORY_GENERATORS, "generator_rf_per_eu", 16, I18n.func_74837_a((String)"gui.config.generators.generator_rf_per_eu.comment", (Object[])new Object[0]), 1, 255);
        propertyGeneratorRFPerEU.setLanguageKey("gui.config.generators.generator_rf_per_eu");
        Property propertyGeneratorUpdateRate = config.get(CATEGORY_GENERATORS, "generator_update_rate", 20, I18n.func_74837_a((String)"gui.config.generators.generator_update_rate.comment", (Object[])new Object[0]), 1, 1200);
        propertyGeneratorUpdateRate.setLanguageKey("gui.config.generators.generator_update_rate");
        Property propertyFissionPower = config.get(CATEGORY_FISSION, "fission_power", 1.0, I18n.func_74837_a((String)"gui.config.fission.fission_power.comment", (Object[])new Object[0]), 0.0, 255.0);
        propertyFissionPower.setLanguageKey("gui.config.fission.fission_power");
        Property propertyFissionFuelUse = config.get(CATEGORY_FISSION, "fission_fuel_use", 1.0, I18n.func_74837_a((String)"gui.config.fission.fission_fuel_use.comment", (Object[])new Object[0]), 0.0, 255.0);
        propertyFissionFuelUse.setLanguageKey("gui.config.fission.fission_fuel_use");
        Property propertyFissionHeatGeneration = config.get(CATEGORY_FISSION, "fission_heat_generation", 1.0, I18n.func_74837_a((String)"gui.config.fission.fission_heat_generation.comment", (Object[])new Object[0]), 0.0, 255.0);
        propertyFissionHeatGeneration.setLanguageKey("gui.config.fission.fission_heat_generation");
        Property propertyFissionCoolingRate = config.get(CATEGORY_FISSION, "fission_cooling_rate", new double[]{20.0, 80.0, 80.0, 120.0, 120.0, 100.0, 120.0, 120.0, 140.0, 140.0}, I18n.func_74837_a((String)"gui.config.fission.fission_cooling_rate.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionCoolingRate.setLanguageKey("gui.config.fission.fission_cooling_rate");
        Property propertyFissionActiveCoolingRate = config.get(CATEGORY_FISSION, "fission_active_cooling_rate", new double[]{200.0, 6400.0, 8000.0, 16000.0, 10800.0, 12800.0}, I18n.func_74837_a((String)"gui.config.fission.fission_active_cooling_rate.comment", (Object[])new Object[0]), 1.0, 1.6777215E7);
        propertyFissionActiveCoolingRate.setLanguageKey("gui.config.fission.fission_active_cooling_rate");
        Property propertyFissionWaterCoolerRequirement = config.get(CATEGORY_FISSION, "fission_water_cooler_requirement", true, I18n.func_74837_a((String)"gui.config.fission.fission_water_cooler_requirement.comment", (Object[])new Object[0]));
        propertyFissionWaterCoolerRequirement.setLanguageKey("gui.config.fission.fission_water_cooler_requirement");
        Property propertyFissionOverheat = config.get(CATEGORY_FISSION, "fission_overheat", true, I18n.func_74837_a((String)"gui.config.fission.fission_overheat.comment", (Object[])new Object[0]));
        propertyFissionOverheat.setLanguageKey("gui.config.fission.fission_overheat");
        Property propertyFissionUpdateRate = config.get(CATEGORY_FISSION, "fission_update_rate", 40, I18n.func_74837_a((String)"gui.config.fission.fission_update_rate.comment", (Object[])new Object[0]), 1, 1200);
        propertyFissionUpdateRate.setLanguageKey("gui.config.fission.fission_update_rate");
        Property propertyFissionMinSize = config.get(CATEGORY_FISSION, "fission_min_size", 1, I18n.func_74837_a((String)"gui.config.fission.fission_min_size.comment", (Object[])new Object[0]), 1, 255);
        propertyFissionMinSize.setLanguageKey("gui.config.fission.fission_min_size");
        Property propertyFissionMaxSize = config.get(CATEGORY_FISSION, "fission_max_size", 24, I18n.func_74837_a((String)"gui.config.fission.fission_max_size.comment", (Object[])new Object[0]), 1, 255);
        propertyFissionMaxSize.setLanguageKey("gui.config.fission.fission_max_size");
        Property propertyFissionActiveCoolerMaxRate = config.get(CATEGORY_FISSION, "fission_active_cooler_max_rate", 5, I18n.func_74837_a((String)"gui.config.fission.fission_active_cooler_max_rate.comment", (Object[])new Object[0]), 1, 8000);
        propertyFissionActiveCoolerMaxRate.setLanguageKey("gui.config.fission.fission_active_cooler_max_rate");
        Property propertyFissionThoriumFuelTime = config.get(CATEGORY_FISSION, "fission_thorium_fuel_time", new double[]{144000.0, 144000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_thorium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionThoriumFuelTime.setLanguageKey("gui.config.fission.fission_thorium_fuel_time");
        Property propertyFissionThoriumPower = config.get(CATEGORY_FISSION, "fission_thorium_power", new double[]{60.0, NCMath.Round(84.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_thorium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionThoriumPower.setLanguageKey("gui.config.fission.fission_thorium_power");
        Property propertyFissionThoriumHeatGeneration = config.get(CATEGORY_FISSION, "fission_thorium_heat_generation", new double[]{18.0, NCMath.Round(22.5, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_thorium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionThoriumHeatGeneration.setLanguageKey("gui.config.fission.fission_thorium_heat_generation");
        Property propertyFissionUraniumFuelTime = config.get(CATEGORY_FISSION, "fission_uranium_fuel_time", new double[]{64000.0, 64000.0, 64000.0, 64000.0, 72000.0, 72000.0, 72000.0, 72000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_uranium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionUraniumFuelTime.setLanguageKey("gui.config.fission.fission_uranium_fuel_time");
        Property propertyFissionUraniumPower = config.get(CATEGORY_FISSION, "fission_uranium_power", new double[]{144.0, NCMath.Round(201.6, 1), 576.0, NCMath.Round(806.4, 1), 120.0, NCMath.Round(168.0, 1), 480.0, NCMath.Round(672.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_uranium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionUraniumPower.setLanguageKey("gui.config.fission.fission_uranium_power");
        Property propertyFissionUraniumHeatGeneration = config.get(CATEGORY_FISSION, "fission_uranium_heat_generation", new double[]{60.0, NCMath.Round(75.0, 1), 360.0, NCMath.Round(450.0, 1), 50.0, NCMath.Round(62.5, 1), 300.0, NCMath.Round(375.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_uranium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionUraniumHeatGeneration.setLanguageKey("gui.config.fission.fission_uranium_heat_generation");
        Property propertyFissionNeptuniumFuelTime = config.get(CATEGORY_FISSION, "fission_neptunium_fuel_time", new double[]{102000.0, 102000.0, 102000.0, 102000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_neptunium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionNeptuniumFuelTime.setLanguageKey("gui.config.fission.fission_neptunium_fuel_time");
        Property propertyFissionNeptuniumPower = config.get(CATEGORY_FISSION, "fission_neptunium_power", new double[]{90.0, NCMath.Round(125.99999999999999, 1), 360.0, NCMath.Round(503.99999999999994, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_neptunium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionNeptuniumPower.setLanguageKey("gui.config.fission.fission_neptunium_power");
        Property propertyFissionNeptuniumHeatGeneration = config.get(CATEGORY_FISSION, "fission_neptunium_heat_generation", new double[]{36.0, NCMath.Round(45.0, 1), 216.0, NCMath.Round(270.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_neptunium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionNeptuniumHeatGeneration.setLanguageKey("gui.config.fission.fission_neptunium_heat_generation");
        Property propertyFissionPlutoniumFuelTime = config.get(CATEGORY_FISSION, "fission_plutonium_fuel_time", new double[]{92000.0, 92000.0, 92000.0, 92000.0, 60000.0, 60000.0, 60000.0, 60000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_plutonium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionPlutoniumFuelTime.setLanguageKey("gui.config.fission.fission_plutonium_fuel_time");
        Property propertyFissionPlutoniumPower = config.get(CATEGORY_FISSION, "fission_plutonium_power", new double[]{105.0, NCMath.Round(147.0, 1), 420.0, NCMath.Round(588.0, 1), 165.0, NCMath.Round(230.99999999999997, 1), 660.0, NCMath.Round(923.9999999999999, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_plutonium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionPlutoniumPower.setLanguageKey("gui.config.fission.fission_plutonium_power");
        Property propertyFissionPlutoniumHeatGeneration = config.get(CATEGORY_FISSION, "fission_plutonium_heat_generation", new double[]{40.0, NCMath.Round(50.0, 1), 240.0, NCMath.Round(300.0, 1), 70.0, NCMath.Round(87.5, 1), 420.0, NCMath.Round(525.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_plutonium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionPlutoniumHeatGeneration.setLanguageKey("gui.config.fission.fission_plutonium_heat_generation");
        Property propertyFissionMOXFuelTime = config.get(CATEGORY_FISSION, "fission_mox_fuel_time", new double[]{84000.0, 56000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_mox_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionMOXFuelTime.setLanguageKey("gui.config.fission.fission_mox_fuel_time");
        Property propertyFissionMOXPower = config.get(CATEGORY_FISSION, "fission_mox_power", new double[]{NCMath.Round(155.39999999999998, 1), NCMath.Round(243.6, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_mox_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionMOXPower.setLanguageKey("gui.config.fission.fission_mox_power");
        Property propertyFissionMOXHeatGeneration = config.get(CATEGORY_FISSION, "fission_mox_heat_generation", new double[]{NCMath.Round(57.5, 1), NCMath.Round(97.5, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_mox_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionMOXHeatGeneration.setLanguageKey("gui.config.fission.fission_mox_heat_generation");
        Property propertyFissionAmericiumFuelTime = config.get(CATEGORY_FISSION, "fission_americium_fuel_time", new double[]{54000.0, 54000.0, 54000.0, 54000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_americium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionAmericiumFuelTime.setLanguageKey("gui.config.fission.fission_americium_fuel_time");
        Property propertyFissionAmericiumPower = config.get(CATEGORY_FISSION, "fission_americium_power", new double[]{192.0, NCMath.Round(268.79999999999995, 1), 768.0, NCMath.Round(1075.1999999999998, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_americium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionAmericiumPower.setLanguageKey("gui.config.fission.fission_americium_power");
        Property propertyFissionAmericiumHeatGeneration = config.get(CATEGORY_FISSION, "fission_americium_heat_generation", new double[]{94.0, NCMath.Round(117.5, 1), 564.0, NCMath.Round(705.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_americium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionAmericiumHeatGeneration.setLanguageKey("gui.config.fission.fission_americium_heat_generation");
        Property propertyFissionCuriumFuelTime = config.get(CATEGORY_FISSION, "fission_curium_fuel_time", new double[]{52000.0, 52000.0, 52000.0, 52000.0, 68000.0, 68000.0, 68000.0, 68000.0, 78000.0, 78000.0, 78000.0, 78000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_curium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionCuriumFuelTime.setLanguageKey("gui.config.fission.fission_curium_fuel_time");
        Property propertyFissionCuriumPower = config.get(CATEGORY_FISSION, "fission_curium_power", new double[]{210.0, NCMath.Round(294.0, 1), 840.0, NCMath.Round(1176.0, 1), 162.0, NCMath.Round(226.79999999999998, 1), 648.0, NCMath.Round(907.1999999999999, 1), 138.0, NCMath.Round(193.2, 1), 552.0, NCMath.Round(772.8, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_curium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionCuriumPower.setLanguageKey("gui.config.fission.fission_curium_power");
        Property propertyFissionCuriumHeatGeneration = config.get(CATEGORY_FISSION, "fission_curium_heat_generation", new double[]{112.0, NCMath.Round(140.0, 1), 672.0, NCMath.Round(840.0, 1), 68.0, NCMath.Round(85.0, 1), 408.0, NCMath.Round(510.0, 1), 54.0, NCMath.Round(67.5, 1), 324.0, NCMath.Round(405.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_curium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionCuriumHeatGeneration.setLanguageKey("gui.config.fission.fission_curium_heat_generation");
        Property propertyFissionBerkeliumFuelTime = config.get(CATEGORY_FISSION, "fission_berkelium_fuel_time", new double[]{86000.0, 86000.0, 86000.0, 86000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_berkelium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionBerkeliumFuelTime.setLanguageKey("gui.config.fission.fission_berkelium_fuel_time");
        Property propertyFissionBerkeliumPower = config.get(CATEGORY_FISSION, "fission_berkelium_power", new double[]{135.0, NCMath.Round(189.0, 1), 540.0, NCMath.Round(756.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_berkelium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionBerkeliumPower.setLanguageKey("gui.config.fission.fission_berkelium_power");
        Property propertyFissionBerkeliumHeatGeneration = config.get(CATEGORY_FISSION, "fission_berkelium_heat_generation", new double[]{52.0, NCMath.Round(65.0, 1), 312.0, NCMath.Round(390.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_berkelium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionBerkeliumHeatGeneration.setLanguageKey("gui.config.fission.fission_berkelium_heat_generation");
        Property propertyFissionCaliforniumFuelTime = config.get(CATEGORY_FISSION, "fission_californium_fuel_time", new double[]{60000.0, 60000.0, 60000.0, 60000.0, 58000.0, 58000.0, 58000.0, 58000.0}, I18n.func_74837_a((String)"gui.config.fission.fission_californium_fuel_time.comment", (Object[])new Object[0]), 1.0, Double.MAX_VALUE);
        propertyFissionCaliforniumFuelTime.setLanguageKey("gui.config.fission.fission_californium_fuel_time");
        Property propertyFissionCaliforniumPower = config.get(CATEGORY_FISSION, "fission_californium_power", new double[]{216.0, NCMath.Round(302.4, 1), 864.0, NCMath.Round(1209.6, 1), 225.0, NCMath.Round(315.0, 1), 900.0, NCMath.Round(1260.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_californium_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionCaliforniumPower.setLanguageKey("gui.config.fission.fission_californium_power");
        Property propertyFissionCaliforniumHeatGeneration = config.get(CATEGORY_FISSION, "fission_californium_heat_generation", new double[]{116.0, NCMath.Round(145.0, 1), 696.0, NCMath.Round(870.0, 1), 120.0, NCMath.Round(150.0, 1), 720.0, NCMath.Round(900.0, 1)}, I18n.func_74837_a((String)"gui.config.fission.fission_californium_heat_generation.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFissionCaliforniumHeatGeneration.setLanguageKey("gui.config.fission.fission_californium_heat_generation");
        Property propertyFusionBasePower = config.get(CATEGORY_FUSION, "fusion_base_power", 1.0, I18n.func_74837_a((String)"gui.config.fusion.fusion_base_power.comment", (Object[])new Object[0]), 0.0, 255.0);
        propertyFusionBasePower.setLanguageKey("gui.config.fusion.fusion_base_power");
        Property propertyFusionFuelUse = config.get(CATEGORY_FUSION, "fusion_fuel_use", 1.0, I18n.func_74837_a((String)"gui.config.fusion.fusion_fuel_use.comment", (Object[])new Object[0]), 0.001, 255.0);
        propertyFusionFuelUse.setLanguageKey("gui.config.fusion.fusion_fuel_use");
        Property propertyFusionHeatGeneration = config.get(CATEGORY_FUSION, "fusion_heat_generation", 1.0, I18n.func_74837_a((String)"gui.config.fusion.fusion_heat_generation.comment", (Object[])new Object[0]), 0.0, 255.0);
        propertyFusionHeatGeneration.setLanguageKey("gui.config.fusion.fusion_heat_generation");
        Property propertyFusionOverheat = config.get(CATEGORY_FUSION, "fusion_overheat", true, I18n.func_74837_a((String)"gui.config.fusion.fusion_overheat.comment", (Object[])new Object[0]));
        propertyFusionOverheat.setLanguageKey("gui.config.fusion.fusion_overheat");
        Property propertyFusionActiveCooling = config.get(CATEGORY_FUSION, "fusion_active_cooling", true, I18n.func_74837_a((String)"gui.config.fusion.fusion_active_cooling.comment", (Object[])new Object[0]));
        propertyFusionActiveCooling.setLanguageKey("gui.config.fusion.fusion_active_cooling");
        Property propertyFusionUpdateRate = config.get(CATEGORY_FUSION, "fusion_update_rate", 40, I18n.func_74837_a((String)"gui.config.fusion.fusion_update_rate.comment", (Object[])new Object[0]), 1, 1200);
        propertyFusionUpdateRate.setLanguageKey("gui.config.fusion.fusion_update_rate");
        Property propertyFusionMinSize = config.get(CATEGORY_FUSION, "fusion_min_size", 1, I18n.func_74837_a((String)"gui.config.fusion.fusion_min_size.comment", (Object[])new Object[0]), 1, 255);
        propertyFusionMinSize.setLanguageKey("gui.config.fusion.fusion_min_size");
        Property propertyFusionMaxSize = config.get(CATEGORY_FUSION, "fusion_max_size", 24, I18n.func_74837_a((String)"gui.config.fusion.fusion_max_size.comment", (Object[])new Object[0]), 1, 255);
        propertyFusionMaxSize.setLanguageKey("gui.config.fusion.fusion_max_size");
        Property propertyFusionElectromagnetPower = config.get(CATEGORY_FUSION, "fusion_electromagnet_power", 4000, I18n.func_74837_a((String)"gui.config.fusion.fusion_electromagnet_power.comment", (Object[])new Object[0]), 0, Integer.MAX_VALUE);
        propertyFusionElectromagnetPower.setLanguageKey("gui.config.fusion.fusion_electromagnet_power");
        Property propertyFusionAlternateSound = config.get(CATEGORY_FUSION, "fusion_alternate_sound", false, I18n.func_74837_a((String)"gui.config.fusion.fusion_alternate_sound.comment", (Object[])new Object[0]));
        propertyFusionAlternateSound.setLanguageKey("gui.config.fusion.fusion_alternate_sound");
        Property propertyFusionFuelTime = config.get(CATEGORY_FUSION, "fusion_fuel_time", new double[]{100.0, 208.3, 312.5, 312.5, 1250.0, 1250.0, 625.0, 312.5, 156.3, 500.0, 1250.0, 500.0, 2500.0, 833.3, 1250.0, 1250.0, 6250.0, 3125.0, 833.3, 2500.0, 625.0, 1250.0, 2500.0, 2500.0, 5000.0, 5000.0, 2500.0, 5000.0}, I18n.func_74837_a((String)"gui.config.fusion.fusion_fuel_time.comment", (Object[])new Object[0]), 1.0, 32767.0);
        propertyFusionFuelTime.setLanguageKey("gui.config.fusion.fusion_fuel_time");
        Property propertyFusionPower = config.get(CATEGORY_FUSION, "fusion_power", new double[]{640.0, 480.0, 160.0, 160.0, 640.0, 240.0, 960.0, 1120.0, 1600.0, 1280.0, 160.0, 1200.0, 80.0, 480.0, 320.0, 80.0, 40.0, 80.0, 960.0, 40.0, 1120.0, 240.0, 80.0, 40.0, 40.0, 40.0, 40.0, 20.0}, I18n.func_74837_a((String)"gui.config.fusion.fusion_power.comment", (Object[])new Object[0]), 0.0, 32767.0);
        propertyFusionPower.setLanguageKey("gui.config.fusion.fusion_power");
        Property propertyFusionHeatVariable = config.get(CATEGORY_FUSION, "fusion_heat_variable", new double[]{2140.0, 1380.0, 4700.0, 4820.0, 5660.0, 4550.0, 4640.0, 4780.0, 670.0, 2370.0, 5955.0, 5335.0, 7345.0, 3875.0, 5070.0, 7810.0, 7510.0, 8060.0, 6800.0, 8060.0, 8800.0, 12500.0, 8500.0, 9200.0, 13000.0, 12000.0, 11000.0, 14000.0}, I18n.func_74837_a((String)"gui.config.fusion.fusion_heat_variable.comment", (Object[])new Object[0]), 500.0, 20000.0);
        propertyFusionHeatVariable.setLanguageKey("gui.config.fusion.fusion_heat_variable");
        Property propertyAcceleratorElectromagnetPower = config.get(CATEGORY_ACCELERATOR, "accelerator_electromagnet_power", 20000, I18n.func_74837_a((String)"gui.config.accelerator.accelerator_electromagnet_power.comment", (Object[])new Object[0]), 0, Integer.MAX_VALUE);
        propertyAcceleratorElectromagnetPower.setLanguageKey("gui.config.accelerator.accelerator_electromagnet_power");
        Property propertyAcceleratorSupercoolerCoolant = config.get(CATEGORY_ACCELERATOR, "accelerator_supercooler_coolant", 1, I18n.func_74837_a((String)"gui.config.accelerator.accelerator_supercooler_coolant.comment", (Object[])new Object[0]), 0, Short.MAX_VALUE);
        propertyAcceleratorSupercoolerCoolant.setLanguageKey("gui.config.accelerator.accelerator_supercooler_coolant");
        Property propertyBatteryCapacity = config.get(CATEGORY_ENERGY_STORAGE, "battery_capacity", new int[]{1600000, 64000000}, I18n.func_74837_a((String)"gui.config.energy_storage.battery_capacity.comment", (Object[])new Object[0]), 1, Integer.MAX_VALUE);
        propertyBatteryCapacity.setLanguageKey("gui.config.energy_storage.battery_capacity");
        Property propertyToolMiningLevel = config.get(CATEGORY_TOOLS, "tool_mining_level", new int[]{2, 2, 3, 3, 3, 3, 3, 3}, I18n.func_74837_a((String)"gui.config.tools.tool_mining_level.comment", (Object[])new Object[0]), 1, 15);
        propertyToolMiningLevel.setLanguageKey("gui.config.tools.tool_mining_level");
        Property propertyToolDurability = config.get(CATEGORY_TOOLS, "tool_durability", new int[]{547, 2735, 929, 4645, 1245, 6225, 1928, 9640}, I18n.func_74837_a((String)"gui.config.tools.tool_durability.comment", (Object[])new Object[0]), 1, Short.MAX_VALUE);
        propertyToolDurability.setLanguageKey("gui.config.tools.tool_durability");
        Property propertyToolSpeed = config.get(CATEGORY_TOOLS, "tool_speed", new double[]{8.0, 8.0, 10.0, 10.0, 11.0, 11.0, 12.0, 12.0}, I18n.func_74837_a((String)"gui.config.tools.tool_speed.comment", (Object[])new Object[0]), 1.0, 255.0);
        propertyToolSpeed.setLanguageKey("gui.config.tools.tool_speed");
        Property propertyToolAttackDamage = config.get(CATEGORY_TOOLS, "tool_attack_damage", new double[]{2.5, 2.5, 3.0, 3.0, 3.0, 3.0, 3.5, 3.5}, I18n.func_74837_a((String)"gui.config.tools.tool_attack_damage.comment", (Object[])new Object[0]), 0.0, 255.0);
        propertyToolAttackDamage.setLanguageKey("gui.config.tools.tool_attack_damage");
        Property propertyToolEnchantability = config.get(CATEGORY_TOOLS, "tool_enchantability", new int[]{6, 6, 15, 15, 12, 12, 20, 20}, I18n.func_74837_a((String)"gui.config.tools.tool_enchantability.comment", (Object[])new Object[0]), 1, 255);
        propertyToolEnchantability.setLanguageKey("gui.config.tools.tool_enchantability");
        Property propertyArmorDurability = config.get(CATEGORY_ARMOR, "armor_durability", new int[]{22, 30, 34, 42}, I18n.func_74837_a((String)"gui.config.armor.armor_durability.comment", (Object[])new Object[0]), 1, 127);
        propertyArmorDurability.setLanguageKey("gui.config.armor.armor_durability");
        Property propertyArmorBoron = config.get(CATEGORY_ARMOR, "armor_boron", new int[]{2, 5, 7, 3}, I18n.func_74837_a((String)"gui.config.armor.armor_boron.comment", (Object[])new Object[0]), 1, 25);
        propertyArmorBoron.setLanguageKey("gui.config.armor.armor_boron");
        Property propertyArmorTough = config.get(CATEGORY_ARMOR, "armor_tough", new int[]{3, 6, 7, 3}, I18n.func_74837_a((String)"gui.config.armor.armor_tough.comment", (Object[])new Object[0]), 1, 25);
        propertyArmorTough.setLanguageKey("gui.config.armor.armor_tough");
        Property propertyArmorHardCarbon = config.get(CATEGORY_ARMOR, "armor_hard_carbon", new int[]{3, 5, 7, 3}, I18n.func_74837_a((String)"gui.config.armor.armor_hard_carbon.comment", (Object[])new Object[0]), 1, 25);
        propertyArmorHardCarbon.setLanguageKey("gui.config.armor.armor_hard_carbon");
        Property propertyArmorBoronNitride = config.get(CATEGORY_ARMOR, "armor_boron_nitride", new int[]{3, 6, 8, 3}, I18n.func_74837_a((String)"gui.config.armor.armor_boron_nitride.comment", (Object[])new Object[0]), 1, 25);
        propertyArmorBoronNitride.setLanguageKey("gui.config.armor.armor_boron_nitride");
        Property propertyArmorEnchantability = config.get(CATEGORY_ARMOR, "armor_enchantability", new int[]{6, 15, 12, 20}, I18n.func_74837_a((String)"gui.config.armor.armor_enchantability.comment", (Object[])new Object[0]), 1, 255);
        propertyArmorEnchantability.setLanguageKey("gui.config.armor.armor_enchantability");
        Property propertyArmorToughness = config.get(CATEGORY_ARMOR, "armor_toughness", new double[]{1.0, 2.0, 1.0, 2.0}, I18n.func_74837_a((String)"gui.config.armor.armor_toughness.comment", (Object[])new Object[0]), 1.0, 8.0);
        propertyArmorToughness.setLanguageKey("gui.config.armor.armor_toughness");
        Property propertyRareDrops = config.get(CATEGORY_OTHER, "rare_drops", false, I18n.func_74837_a((String)"gui.config.other.rare_drops.comment", (Object[])new Object[0]));
        propertyRareDrops.setLanguageKey("gui.config.other.rare_drops");
        ArrayList<String> propertyOrderOres = new ArrayList<String>();
        propertyOrderOres.add(propertyOreDims.getName());
        propertyOrderOres.add(propertyOreDimsListType.getName());
        propertyOrderOres.add(propertyOreGen.getName());
        propertyOrderOres.add(propertyOreSize.getName());
        propertyOrderOres.add(propertyOreRate.getName());
        propertyOrderOres.add(propertyOreMinHeight.getName());
        propertyOrderOres.add(propertyOreMaxHeight.getName());
        propertyOrderOres.add(propertyOreDrops.getName());
        propertyOrderOres.add(propertyHideDisabledOres.getName());
        config.setCategoryPropertyOrder(CATEGORY_ORES, propertyOrderOres);
        ArrayList<String> propertyOrderProcessors = new ArrayList<String>();
        propertyOrderProcessors.add(propertyProcessorTime.getName());
        propertyOrderProcessors.add(propertyProcessorPower.getName());
        propertyOrderProcessors.add(propertyProcessorRFPerEU.getName());
        propertyOrderProcessors.add(propertyProcessorUpdateRate.getName());
        propertyOrderProcessors.add(propertyProcessorPassiveRate.getName());
        propertyOrderProcessors.add(propertyCobbleGenPower.getName());
        propertyOrderProcessors.add(propertyOreProcessing.getName());
        config.setCategoryPropertyOrder(CATEGORY_PROCESSORS, propertyOrderProcessors);
        ArrayList<String> propertyOrderGenerators = new ArrayList<String>();
        propertyOrderGenerators.add(propertyRTGPower.getName());
        propertyOrderGenerators.add(propertySolarPower.getName());
        propertyOrderGenerators.add(propertyDecayPower.getName());
        propertyOrderGenerators.add(propertyGeneratorRFPerEU.getName());
        propertyOrderGenerators.add(propertyGeneratorUpdateRate.getName());
        config.setCategoryPropertyOrder(CATEGORY_GENERATORS, propertyOrderGenerators);
        ArrayList<String> propertyOrderFission = new ArrayList<String>();
        propertyOrderFission.add(propertyFissionPower.getName());
        propertyOrderFission.add(propertyFissionFuelUse.getName());
        propertyOrderFission.add(propertyFissionHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionCoolingRate.getName());
        propertyOrderFission.add(propertyFissionActiveCoolingRate.getName());
        propertyOrderFission.add(propertyFissionWaterCoolerRequirement.getName());
        propertyOrderFission.add(propertyFissionOverheat.getName());
        propertyOrderFission.add(propertyFissionMinSize.getName());
        propertyOrderFission.add(propertyFissionMaxSize.getName());
        propertyOrderFission.add(propertyFissionActiveCoolerMaxRate.getName());
        propertyOrderFission.add(propertyFissionThoriumFuelTime.getName());
        propertyOrderFission.add(propertyFissionThoriumPower.getName());
        propertyOrderFission.add(propertyFissionThoriumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionUraniumFuelTime.getName());
        propertyOrderFission.add(propertyFissionUraniumPower.getName());
        propertyOrderFission.add(propertyFissionUraniumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionNeptuniumFuelTime.getName());
        propertyOrderFission.add(propertyFissionNeptuniumPower.getName());
        propertyOrderFission.add(propertyFissionNeptuniumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionPlutoniumFuelTime.getName());
        propertyOrderFission.add(propertyFissionPlutoniumPower.getName());
        propertyOrderFission.add(propertyFissionPlutoniumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionMOXFuelTime.getName());
        propertyOrderFission.add(propertyFissionMOXPower.getName());
        propertyOrderFission.add(propertyFissionMOXHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionAmericiumFuelTime.getName());
        propertyOrderFission.add(propertyFissionAmericiumPower.getName());
        propertyOrderFission.add(propertyFissionAmericiumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionCuriumFuelTime.getName());
        propertyOrderFission.add(propertyFissionCuriumPower.getName());
        propertyOrderFission.add(propertyFissionCuriumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionBerkeliumFuelTime.getName());
        propertyOrderFission.add(propertyFissionBerkeliumPower.getName());
        propertyOrderFission.add(propertyFissionBerkeliumHeatGeneration.getName());
        propertyOrderFission.add(propertyFissionCaliforniumFuelTime.getName());
        propertyOrderFission.add(propertyFissionCaliforniumPower.getName());
        propertyOrderFission.add(propertyFissionCaliforniumHeatGeneration.getName());
        config.setCategoryPropertyOrder(CATEGORY_FISSION, propertyOrderFission);
        ArrayList<String> propertyOrderEnergyStorage = new ArrayList<String>();
        propertyOrderEnergyStorage.add(propertyBatteryCapacity.getName());
        config.setCategoryPropertyOrder(CATEGORY_ENERGY_STORAGE, propertyOrderEnergyStorage);
        ArrayList<String> propertyOrderFusion = new ArrayList<String>();
        propertyOrderFusion.add(propertyFusionBasePower.getName());
        propertyOrderFusion.add(propertyFusionFuelUse.getName());
        propertyOrderFusion.add(propertyFusionHeatGeneration.getName());
        propertyOrderFusion.add(propertyFusionOverheat.getName());
        propertyOrderFusion.add(propertyFusionActiveCooling.getName());
        propertyOrderFusion.add(propertyFusionMinSize.getName());
        propertyOrderFusion.add(propertyFusionMaxSize.getName());
        propertyOrderFusion.add(propertyFusionElectromagnetPower.getName());
        propertyOrderFusion.add(propertyFusionAlternateSound.getName());
        propertyOrderFusion.add(propertyFusionFuelTime.getName());
        propertyOrderFusion.add(propertyFusionPower.getName());
        propertyOrderFusion.add(propertyFusionHeatVariable.getName());
        config.setCategoryPropertyOrder(CATEGORY_FUSION, propertyOrderFusion);
        ArrayList<String> propertyOrderAccelerator = new ArrayList<String>();
        propertyOrderAccelerator.add(propertyAcceleratorElectromagnetPower.getName());
        propertyOrderAccelerator.add(propertyAcceleratorSupercoolerCoolant.getName());
        config.setCategoryPropertyOrder(CATEGORY_ACCELERATOR, propertyOrderAccelerator);
        ArrayList<String> propertyOrderTools = new ArrayList<String>();
        propertyOrderTools.add(propertyToolMiningLevel.getName());
        propertyOrderTools.add(propertyToolDurability.getName());
        propertyOrderTools.add(propertyToolSpeed.getName());
        propertyOrderTools.add(propertyToolAttackDamage.getName());
        propertyOrderTools.add(propertyToolEnchantability.getName());
        config.setCategoryPropertyOrder(CATEGORY_TOOLS, propertyOrderTools);
        ArrayList<String> propertyOrderArmor = new ArrayList<String>();
        propertyOrderArmor.add(propertyArmorDurability.getName());
        propertyOrderArmor.add(propertyArmorEnchantability.getName());
        propertyOrderArmor.add(propertyArmorBoron.getName());
        propertyOrderArmor.add(propertyArmorTough.getName());
        propertyOrderArmor.add(propertyArmorHardCarbon.getName());
        propertyOrderArmor.add(propertyArmorBoronNitride.getName());
        propertyOrderArmor.add(propertyArmorToughness.getName());
        config.setCategoryPropertyOrder(CATEGORY_ARMOR, propertyOrderArmor);
        ArrayList<String> propertyOrderOther = new ArrayList<String>();
        propertyOrderOther.add(propertyRareDrops.getName());
        config.setCategoryPropertyOrder(CATEGORY_OTHER, propertyOrderOther);
        if (readFieldFromConfig) {
            ore_dims = propertyOreDims.getIntList();
            ore_dims_list_type = propertyOreDimsListType.getBoolean();
            ore_gen = NCConfig.readBooleanArrayFromConfig(propertyOreGen);
            ore_size = NCConfig.readIntegerArrayFromConfig(propertyOreSize);
            ore_rate = NCConfig.readIntegerArrayFromConfig(propertyOreRate);
            ore_min_height = NCConfig.readIntegerArrayFromConfig(propertyOreMinHeight);
            ore_max_height = NCConfig.readIntegerArrayFromConfig(propertyOreMaxHeight);
            ore_drops = NCConfig.readBooleanArrayFromConfig(propertyOreDrops);
            hide_disabled_ores = propertyHideDisabledOres.getBoolean();
            processor_time = NCConfig.readIntegerArrayFromConfig(propertyProcessorTime);
            processor_power = NCConfig.readIntegerArrayFromConfig(propertyProcessorPower);
            processor_rf_per_eu = propertyProcessorRFPerEU.getInt();
            processor_update_rate = propertyProcessorUpdateRate.getInt();
            processor_passive_rate = NCConfig.readIntegerArrayFromConfig(propertyProcessorPassiveRate);
            cobble_gen_power = propertyCobbleGenPower.getInt();
            ore_processing = propertyOreProcessing.getBoolean();
            rtg_power = NCConfig.readIntegerArrayFromConfig(propertyRTGPower);
            solar_power = NCConfig.readIntegerArrayFromConfig(propertySolarPower);
            decay_power = NCConfig.readIntegerArrayFromConfig(propertyDecayPower);
            generator_rf_per_eu = propertyGeneratorRFPerEU.getInt();
            generator_update_rate = propertyGeneratorUpdateRate.getInt();
            fission_power = propertyFissionPower.getDouble();
            fission_fuel_use = propertyFissionFuelUse.getDouble();
            fission_heat_generation = propertyFissionHeatGeneration.getDouble();
            fission_cooling_rate = NCConfig.readDoubleArrayFromConfig(propertyFissionCoolingRate);
            fission_active_cooling_rate = NCConfig.readDoubleArrayFromConfig(propertyFissionActiveCoolingRate);
            fission_water_cooler_requirement = propertyFissionWaterCoolerRequirement.getBoolean();
            fission_overheat = propertyFissionOverheat.getBoolean();
            fission_update_rate = propertyFissionUpdateRate.getInt();
            fission_min_size = propertyFissionMinSize.getInt();
            fission_max_size = propertyFissionMaxSize.getInt();
            fission_active_cooler_max_rate = propertyFissionActiveCoolerMaxRate.getInt();
            fission_thorium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionThoriumFuelTime);
            fission_thorium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionThoriumPower);
            fission_thorium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionThoriumHeatGeneration);
            fission_uranium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionUraniumFuelTime);
            fission_uranium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionUraniumPower);
            fission_uranium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionUraniumHeatGeneration);
            fission_neptunium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionNeptuniumFuelTime);
            fission_neptunium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionNeptuniumPower);
            fission_neptunium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionNeptuniumHeatGeneration);
            fission_plutonium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionPlutoniumFuelTime);
            fission_plutonium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionPlutoniumPower);
            fission_plutonium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionPlutoniumHeatGeneration);
            fission_mox_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionMOXFuelTime);
            fission_mox_power = NCConfig.readDoubleArrayFromConfig(propertyFissionMOXPower);
            fission_mox_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionMOXHeatGeneration);
            fission_americium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionAmericiumFuelTime);
            fission_americium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionAmericiumPower);
            fission_americium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionAmericiumHeatGeneration);
            fission_curium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionCuriumFuelTime);
            fission_curium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionCuriumPower);
            fission_curium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionCuriumHeatGeneration);
            fission_berkelium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionBerkeliumFuelTime);
            fission_berkelium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionBerkeliumPower);
            fission_berkelium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionBerkeliumHeatGeneration);
            fission_californium_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFissionCaliforniumFuelTime);
            fission_californium_power = NCConfig.readDoubleArrayFromConfig(propertyFissionCaliforniumPower);
            fission_californium_heat_generation = NCConfig.readDoubleArrayFromConfig(propertyFissionCaliforniumHeatGeneration);
            fusion_base_power = propertyFusionBasePower.getDouble();
            fusion_fuel_use = propertyFusionFuelUse.getDouble();
            fusion_heat_generation = propertyFusionHeatGeneration.getDouble();
            fusion_overheat = propertyFusionOverheat.getBoolean();
            fusion_active_cooling = propertyFusionActiveCooling.getBoolean();
            fusion_update_rate = propertyFusionUpdateRate.getInt();
            fusion_min_size = propertyFusionMinSize.getInt();
            fusion_max_size = propertyFusionMaxSize.getInt();
            fusion_electromagnet_power = propertyFusionElectromagnetPower.getInt();
            fusion_alternate_sound = propertyFusionAlternateSound.getBoolean();
            fusion_fuel_time = NCConfig.readDoubleArrayFromConfig(propertyFusionFuelTime);
            fusion_power = NCConfig.readDoubleArrayFromConfig(propertyFusionPower);
            fusion_heat_variable = NCConfig.readDoubleArrayFromConfig(propertyFusionHeatVariable);
            accelerator_electromagnet_power = propertyAcceleratorElectromagnetPower.getInt();
            accelerator_supercooler_coolant = propertyAcceleratorSupercoolerCoolant.getInt();
            battery_capacity = NCConfig.readIntegerArrayFromConfig(propertyBatteryCapacity);
            tool_mining_level = NCConfig.readIntegerArrayFromConfig(propertyToolMiningLevel);
            tool_durability = NCConfig.readIntegerArrayFromConfig(propertyToolDurability);
            tool_speed = NCConfig.readDoubleArrayFromConfig(propertyToolSpeed);
            tool_attack_damage = NCConfig.readDoubleArrayFromConfig(propertyToolAttackDamage);
            tool_enchantability = NCConfig.readIntegerArrayFromConfig(propertyToolEnchantability);
            armor_durability = NCConfig.readIntegerArrayFromConfig(propertyArmorDurability);
            armor_enchantability = NCConfig.readIntegerArrayFromConfig(propertyArmorEnchantability);
            armor_boron = NCConfig.readIntegerArrayFromConfig(propertyArmorBoron);
            armor_tough = NCConfig.readIntegerArrayFromConfig(propertyArmorTough);
            armor_hard_carbon = NCConfig.readIntegerArrayFromConfig(propertyArmorHardCarbon);
            armor_boron_nitride = NCConfig.readIntegerArrayFromConfig(propertyArmorBoronNitride);
            armor_toughness = NCConfig.readDoubleArrayFromConfig(propertyArmorToughness);
            rare_drops = propertyRareDrops.getBoolean();
        }
        propertyOreDims.set(ore_dims);
        propertyOreDimsListType.set(ore_dims_list_type);
        propertyOreGen.set(ore_gen);
        propertyOreSize.set(ore_size);
        propertyOreRate.set(ore_rate);
        propertyOreMinHeight.set(ore_min_height);
        propertyOreMaxHeight.set(ore_max_height);
        propertyOreDrops.set(ore_drops);
        propertyHideDisabledOres.set(hide_disabled_ores);
        propertyProcessorTime.set(processor_time);
        propertyProcessorPower.set(processor_power);
        propertyProcessorRFPerEU.set(processor_rf_per_eu);
        propertyProcessorUpdateRate.set(processor_update_rate);
        propertyProcessorPassiveRate.set(processor_passive_rate);
        propertyCobbleGenPower.set(cobble_gen_power);
        propertyOreProcessing.set(ore_processing);
        propertyRTGPower.set(rtg_power);
        propertySolarPower.set(solar_power);
        propertyDecayPower.set(decay_power);
        propertyGeneratorRFPerEU.set(generator_rf_per_eu);
        propertyGeneratorUpdateRate.set(generator_update_rate);
        propertyFissionPower.set(fission_power);
        propertyFissionFuelUse.set(fission_fuel_use);
        propertyFissionHeatGeneration.set(fission_heat_generation);
        propertyFissionCoolingRate.set(fission_cooling_rate);
        propertyFissionActiveCoolingRate.set(fission_active_cooling_rate);
        propertyFissionWaterCoolerRequirement.set(fission_water_cooler_requirement);
        propertyFissionOverheat.set(fission_overheat);
        propertyFissionUpdateRate.set(fission_update_rate);
        propertyFissionMinSize.set(fission_min_size);
        propertyFissionMaxSize.set(fission_max_size);
        propertyFissionActiveCoolerMaxRate.set(fission_active_cooler_max_rate);
        propertyFissionThoriumFuelTime.set(fission_thorium_fuel_time);
        propertyFissionThoriumPower.set(fission_thorium_power);
        propertyFissionThoriumHeatGeneration.set(fission_thorium_heat_generation);
        propertyFissionUraniumFuelTime.set(fission_uranium_fuel_time);
        propertyFissionUraniumPower.set(fission_uranium_power);
        propertyFissionUraniumHeatGeneration.set(fission_uranium_heat_generation);
        propertyFissionNeptuniumFuelTime.set(fission_neptunium_fuel_time);
        propertyFissionNeptuniumPower.set(fission_neptunium_power);
        propertyFissionNeptuniumHeatGeneration.set(fission_neptunium_heat_generation);
        propertyFissionPlutoniumFuelTime.set(fission_plutonium_fuel_time);
        propertyFissionPlutoniumPower.set(fission_plutonium_power);
        propertyFissionPlutoniumHeatGeneration.set(fission_plutonium_heat_generation);
        propertyFissionMOXFuelTime.set(fission_mox_fuel_time);
        propertyFissionMOXPower.set(fission_mox_power);
        propertyFissionMOXHeatGeneration.set(fission_mox_heat_generation);
        propertyFissionAmericiumFuelTime.set(fission_americium_fuel_time);
        propertyFissionAmericiumPower.set(fission_americium_power);
        propertyFissionAmericiumHeatGeneration.set(fission_americium_heat_generation);
        propertyFissionCuriumFuelTime.set(fission_curium_fuel_time);
        propertyFissionCuriumPower.set(fission_curium_power);
        propertyFissionCuriumHeatGeneration.set(fission_curium_heat_generation);
        propertyFissionBerkeliumFuelTime.set(fission_berkelium_fuel_time);
        propertyFissionBerkeliumPower.set(fission_berkelium_power);
        propertyFissionBerkeliumHeatGeneration.set(fission_berkelium_heat_generation);
        propertyFissionCaliforniumFuelTime.set(fission_californium_fuel_time);
        propertyFissionCaliforniumPower.set(fission_californium_power);
        propertyFissionCaliforniumHeatGeneration.set(fission_californium_heat_generation);
        propertyFusionBasePower.set(fusion_base_power);
        propertyFusionFuelUse.set(fusion_fuel_use);
        propertyFusionHeatGeneration.set(fusion_heat_generation);
        propertyFusionOverheat.set(fusion_overheat);
        propertyFusionActiveCooling.set(fusion_active_cooling);
        propertyFusionUpdateRate.set(fusion_update_rate);
        propertyFusionMinSize.set(fusion_min_size);
        propertyFusionMaxSize.set(fusion_max_size);
        propertyFusionElectromagnetPower.set(fusion_electromagnet_power);
        propertyFusionAlternateSound.set(fusion_alternate_sound);
        propertyFusionFuelTime.set(fusion_fuel_time);
        propertyFusionPower.set(fusion_power);
        propertyFusionHeatVariable.set(fusion_heat_variable);
        propertyAcceleratorElectromagnetPower.set(accelerator_electromagnet_power);
        propertyAcceleratorSupercoolerCoolant.set(accelerator_supercooler_coolant);
        propertyBatteryCapacity.set(battery_capacity);
        propertyToolMiningLevel.set(tool_mining_level);
        propertyToolDurability.set(tool_durability);
        propertyToolSpeed.set(tool_speed);
        propertyToolAttackDamage.set(tool_attack_damage);
        propertyToolEnchantability.set(tool_enchantability);
        propertyArmorDurability.set(armor_durability);
        propertyArmorEnchantability.set(armor_enchantability);
        propertyArmorBoron.set(armor_boron);
        propertyArmorTough.set(armor_tough);
        propertyArmorHardCarbon.set(armor_hard_carbon);
        propertyArmorBoronNitride.set(armor_boron_nitride);
        propertyArmorToughness.set(armor_toughness);
        propertyRareDrops.set(rare_drops);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean[] readBooleanArrayFromConfig(Property property) {
        int defaultLength;
        int currentLength = property.getBooleanList().length;
        if (currentLength == (defaultLength = property.getDefaults().length)) {
            return property.getBooleanList();
        }
        boolean[] newArray = new boolean[defaultLength];
        if (currentLength > defaultLength) {
            for (int i = 0; i < defaultLength; ++i) {
                newArray[i] = property.getBooleanList()[i];
            }
        } else {
            int i;
            for (i = 0; i < currentLength; ++i) {
                newArray[i] = property.getBooleanList()[i];
            }
            for (i = currentLength; i < defaultLength; ++i) {
                newArray[i] = property.setToDefault().getBooleanList()[i];
            }
        }
        return newArray;
    }

    public static int[] readIntegerArrayFromConfig(Property property) {
        int defaultLength;
        int currentLength = property.getIntList().length;
        if (currentLength == (defaultLength = property.getDefaults().length)) {
            return property.getIntList();
        }
        int[] newArray = new int[defaultLength];
        if (currentLength > defaultLength) {
            for (int i = 0; i < defaultLength; ++i) {
                newArray[i] = property.getIntList()[i];
            }
        } else {
            int i;
            for (i = 0; i < currentLength; ++i) {
                newArray[i] = property.getIntList()[i];
            }
            for (i = currentLength; i < defaultLength; ++i) {
                newArray[i] = property.setToDefault().getIntList()[i];
            }
        }
        return newArray;
    }

    public static double[] readDoubleArrayFromConfig(Property property) {
        int defaultLength;
        int currentLength = property.getDoubleList().length;
        if (currentLength == (defaultLength = property.getDefaults().length)) {
            return property.getDoubleList();
        }
        double[] newArray = new double[defaultLength];
        if (currentLength > defaultLength) {
            for (int i = 0; i < defaultLength; ++i) {
                newArray[i] = property.getDoubleList()[i];
            }
        } else {
            int i;
            for (i = 0; i < currentLength; ++i) {
                newArray[i] = property.getDoubleList()[i];
            }
            for (i = currentLength; i < defaultLength; ++i) {
                newArray[i] = property.setToDefault().getDoubleList()[i];
            }
        }
        return newArray;
    }

    static {
        update_block_type = true;
    }

    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("nuclearcraft")) {
                NCConfig.syncFromGui();
            }
        }
    }
}

