/*
 * Decompiled with CFR 0.152.
 */
package nc.fluid;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class Tank
extends FluidTank
implements INBTSerializable<NBTTagCompound> {
    public int maxReceive;
    public int maxExtract;
    protected IFluidTankProperties[] tankProperties;
    public String[] allowedFluids;

    public Tank(int capacity, String ... allowedFluids) {
        this(capacity, capacity, capacity, allowedFluids);
    }

    public Tank(int capacity, int maxTransfer, String ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, allowedFluids);
    }

    public Tank(int capacity, int maxReceive, int maxExtract, String ... allowedFluids) {
        super(capacity);
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        if (allowedFluids == null || allowedFluids.length == 0) {
            this.allowedFluids = null;
        } else {
            String[] fluidList = new String[allowedFluids.length];
            for (int i = 0; i < allowedFluids.length; ++i) {
                fluidList[i] = allowedFluids[i];
            }
            this.allowedFluids = fluidList;
        }
    }

    public String getFluidName() {
        if (this.fluid == null) {
            return "nullFluid";
        }
        if (this.fluid.getFluid() == null) {
            return "nullFluid";
        }
        return FluidRegistry.getFluidName((FluidStack)this.getFluid());
    }

    public String getFluidLocalizedName() {
        if (this.fluid == null) {
            return "";
        }
        if (this.fluid.getFluid() == null) {
            return "";
        }
        return this.fluid.getLocalizedName();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.isFluidValid(resource.getFluid()) || this.fluid != null && this.fluid != null && !this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int fluidReceived = Math.min(this.capacity - this.getFluidAmount(), Math.min(this.maxReceive, resource.amount));
        if (doFill) {
            this.fluid = new FluidStack(resource, this.getFluidAmount() + fluidReceived);
        }
        return fluidReceived;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        int fluidExtracted = Math.min(this.getFluidAmount(), Math.min(this.maxExtract, maxDrain));
        if (doDrain) {
            this.fluid = new FluidStack(this.fluid.getFluid(), this.getFluidAmount() - fluidExtracted);
        }
        Fluid type = this.fluid.getFluid();
        if (this.getFluidAmount() <= 0) {
            this.fluid = null;
        }
        return new FluidStack(type, fluidExtracted);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.fluid == null || !this.fluid.isFluidEqual(resource)) {
            return null;
        }
        int fluidExtracted = Math.min(this.getFluidAmount(), Math.min(this.maxExtract, resource.amount));
        if (doDrain) {
            this.fluid = new FluidStack(this.fluid.getFluid(), this.getFluidAmount() - fluidExtracted);
        }
        Fluid type = this.fluid.getFluid();
        if (this.getFluidAmount() <= 0) {
            this.fluid = null;
        }
        return new FluidStack(type, fluidExtracted);
    }

    public void changeFluidStored(Fluid fluid, int amount) {
        this.fluid = new FluidStack(fluid, this.getFluidAmount() + amount);
        if (this.getFluidAmount() > this.capacity) {
            this.fluid = new FluidStack(this.fluid, this.capacity);
        } else if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
    }

    public void setFluidStored(Fluid fluid, int amount) {
        if (amount <= 0) {
            this.fluid = null;
            return;
        }
        this.fluid = new FluidStack(fluid, amount);
        if (this.getFluidAmount() > this.capacity) {
            this.fluid = new FluidStack(this.fluid, this.capacity);
        } else if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
    }

    public void setFluidStored(FluidStack fluid, int amount) {
        if (amount <= 0 || fluid == null) {
            this.fluid = null;
            return;
        }
        this.fluid = new FluidStack(fluid, amount);
        if (this.getFluidAmount() > this.capacity) {
            this.fluid = new FluidStack(this.fluid, this.capacity);
        } else if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
    }

    public void changeFluidStored(int amount) {
        this.changeFluidStored(this.fluid.getFluid(), amount);
    }

    public void setFluidStored(FluidStack stack) {
        if (stack == null || stack.amount <= 0) {
            this.fluid = null;
            return;
        }
        this.fluid = stack;
        if (this.getFluidAmount() > this.capacity) {
            this.fluid = new FluidStack(stack.getFluid(), this.capacity);
        } else if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
    }

    public void setFluidAmount(int amount) {
        if (this.fluid == null) {
            return;
        }
        if (amount < 0) {
            amount = 0;
        } else if (amount > this.capacity) {
            amount = this.capacity;
        }
        this.fluid.amount = amount;
    }

    public void setTankCapacity(int newCapacity) {
        if (newCapacity == this.capacity || newCapacity <= 0) {
            return;
        }
        if (newCapacity < this.capacity) {
            this.setFluidAmount(newCapacity);
        }
        this.capacity = newCapacity;
    }

    public boolean isFluidValid(String name) {
        if (this.allowedFluids == null) {
            return true;
        }
        for (int i = 0; i < this.allowedFluids.length; ++i) {
            if (this.allowedFluids[i] != name) continue;
            return true;
        }
        return false;
    }

    public boolean isFluidValid(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.isFluidValid(fluid.getName());
    }

    public boolean isFluidValid(FluidStack fluid) {
        if (fluid == null) {
            return false;
        }
        return this.isFluidValid(fluid.getFluid().getName());
    }

    public NBTTagCompound serializeNBT() {
        return this.writeAll(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readAll(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
        nbt.func_74768_a("FluidAmount", this.getFluidAmount());
        nbt.func_74778_a("FluidName", this.getFluidName());
        return nbt;
    }

    public final NBTTagCompound writeAll(NBTTagCompound nbt) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.writeToNBT(fluidTag);
        nbt.func_74782_a("fluidStorage", (NBTBase)fluidTag);
        return nbt;
    }

    public Tank readFromNBT(NBTTagCompound nbt) {
        this.fluid = nbt.func_74779_i("FluidName") == "nullFluid" || nbt.func_74762_e("FluidAmount") == 0 ? null : new FluidStack(FluidRegistry.getFluid((String)nbt.func_74779_i("FluidName")), nbt.func_74762_e("FluidAmount"));
        if (this.getFluidAmount() > this.capacity) {
            this.fluid.amount = this.capacity;
        }
        return this;
    }

    public final void readAll(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidStorage")) {
            this.readFromNBT(nbt.func_74775_l("fluidStorage"));
        }
    }
}

