/*
 * Decompiled with CFR 0.152.
 */
package nc.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.fluid.Tank;
import nc.tile.energy.ITileEnergy;
import nc.util.NCMath;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;

public abstract class GuiNC
extends GuiContainer {
    public GuiNC(Container inventory) {
        super(inventory);
    }

    public void drawTooltip(List<String> text, int mouseX, int mouseY, int x, int y, int width, int height) {
        int xPos = x + this.field_147003_i;
        int yPos = y + this.field_147009_r;
        if (mouseX >= xPos && mouseY >= yPos && mouseX < xPos + width && mouseY < yPos + height) {
            this.func_146283_a(text, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void drawTooltip(String text, int mouseX, int mouseY, int x, int y, int width, int height) {
        ArrayList stringList = Lists.newArrayList((Object[])new String[]{text});
        this.drawTooltip(stringList, mouseX, mouseY, x, y, width, height);
    }

    public List<String> fluidInfo(FluidStack fluid, Tank tank) {
        String fluidName = fluid.getLocalizedName();
        String fluidAmount = NCMath.prefix(fluid.amount, tank.getCapacity(), 5, "B", -1);
        return Lists.newArrayList((Object[])new String[]{TextFormatting.GREEN + fluidName + TextFormatting.WHITE + " [" + fluidAmount + "]", TextFormatting.ITALIC + I18n.func_74837_a((String)"gui.container.shift_clear_tank", (Object[])new Object[0])});
    }

    public void drawFluidTooltip(FluidStack fluid, Tank tank, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (fluid == null) {
            return;
        }
        if (fluid.amount <= 0) {
            return;
        }
        this.drawTooltip(this.fluidInfo(fluid, tank), mouseX, mouseY, x, y, width, height + 1);
    }

    public List<String> energyInfo(ITileEnergy tile) {
        String energy = NCMath.prefix(tile.getStorage().getEnergyStored(), tile.getStorage().getMaxEnergyStored(), 5, "RF");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.energy_stored", (Object[])new Object[0]) + TextFormatting.WHITE + " " + energy});
    }

    public List<String> noEnergyInfo() {
        return Lists.newArrayList((Object[])new String[]{TextFormatting.RED + I18n.func_74837_a((String)"gui.container.no_energy", (Object[])new Object[0])});
    }

    public void drawEnergyTooltip(ITileEnergy tile, int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.energyInfo(tile), mouseX, mouseY, x, y, width, height);
    }

    public void drawNoEnergyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.noEnergyInfo(), mouseX, mouseY, x, y, width, height);
    }
}

