/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.generator;

import com.google.common.collect.Lists;
import java.util.List;
import nc.container.generator.ContainerFissionController;
import nc.gui.GuiNC;
import nc.tile.energy.ITileEnergy;
import nc.tile.generator.TileFissionController;
import nc.util.NCMath;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class GuiFissionController
extends GuiNC {
    private final InventoryPlayer playerInventory;
    protected TileFissionController tile;
    protected final ResourceLocation gui_textures;

    public GuiFissionController(EntityPlayer player, TileFissionController tile) {
        super(new ContainerFissionController(player, tile));
        this.playerInventory = player.field_71071_by;
        this.tile = tile;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/fission_controller.png");
        this.field_146999_f = 176;
        this.field_147000_g = 177;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = this.tile.isGenerating ? -1 : (this.tile.complete == 1 ? 0xEEAA00 : 0xEE0000);
        String s = this.tile.complete == 1 ? this.tile.getLengthX() + "*" + this.tile.getLengthY() + "*" + this.tile.getLengthZ() + " " + I18n.func_74837_a((String)"gui.container.fission_controller.reactor", (Object[])new Object[0]) : this.tile.problem;
        this.field_146289_q.func_78276_b(s, 8 + this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, fontColor);
        String s2 = this.tile.problemPosBool == 0 ? "" : I18n.func_74837_a((String)"gui.container.fission_controller.pos", (Object[])new Object[0]) + " " + this.tile.problemPos;
        this.field_146289_q.func_78276_b(s2, 8 + this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s2) / 2, 17, fontColor);
        String cells = I18n.func_74837_a((String)"gui.container.fission_controller.cells", (Object[])new Object[0]) + " " + this.tile.cells;
        this.field_146289_q.func_78276_b(cells, 28, this.field_147000_g - 92, fontColor);
        String power = NCMath.prefix(this.tile.processPower, 5, "RF/t");
        this.field_146289_q.func_78276_b(power, 28, this.field_147000_g - 103, fontColor);
        String fuel = this.tile.getFuelName().endsWith("OXIDE") ? this.tile.getFuelName().substring(0, this.tile.getFuelName().length() - 3) : this.tile.getFuelName();
        this.field_146289_q.func_78276_b(fuel, 28, this.field_147000_g - 114, fontColor);
        String heat = NCMath.prefix(this.tile.heat, 5, "H");
        this.field_146289_q.func_78276_b(heat, 170 - this.field_146289_q.func_78256_a(heat), this.field_147000_g - 92, fontColor);
        String heatGen = NCMath.prefix(this.tile.heatChange, 5, "H/t");
        this.field_146289_q.func_78276_b(heatGen, 170 - this.field_146289_q.func_78256_a(heatGen), this.field_147000_g - 103, fontColor);
        String efficiency = I18n.func_74837_a((String)"gui.container.fission_controller.efficiency", (Object[])new Object[0]) + " " + this.tile.efficiency + "%";
        this.field_146289_q.func_78276_b(efficiency, 170 - this.field_146289_q.func_78256_a(efficiency), this.field_147000_g - 114, fontColor);
        this.drawEnergyTooltip(this.tile, mouseX, mouseY, 8, 6, 6, 85);
        this.drawHeatTooltip(mouseX, mouseY, 18, 6, 6, 85);
    }

    @Override
    public List<String> energyInfo(ITileEnergy tile) {
        String energy = NCMath.prefix(tile.getStorage().getEnergyStored(), tile.getStorage().getMaxEnergyStored(), 5, "RF");
        String power = NCMath.prefix(this.tile.getProcessPower(), 5, "RF/t");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.energy_stored", (Object[])new Object[0]) + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.power_gen", (Object[])new Object[0]) + TextFormatting.WHITE + " " + power});
    }

    public List<String> heatInfo() {
        String heat = NCMath.prefix(this.tile.heat, this.tile.getMaxHeat(), 5, "H");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + I18n.func_74837_a((String)"gui.container.fission_controller.heat", (Object[])new Object[0]) + TextFormatting.WHITE + " " + heat});
    }

    public void drawHeatTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        double e = Math.round((double)this.tile.storage.getEnergyStored() / (double)this.tile.storage.getMaxEnergyStored() * 85.0);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 85 - (int)e, 176, 175 - (int)e, 6, (int)e);
        double h = Math.round((double)this.tile.heat / (double)this.tile.getMaxHeat() * 85.0);
        this.func_73729_b(this.field_147003_i + 18, this.field_147009_r + 6 + 85 - (int)h, 182, 175 - (int)h, 6, (int)h);
        int k = this.getCookProgressScaled(37.0);
        this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 35, 176, 3, k, 16);
    }

    protected int getCookProgressScaled(double pixels) {
        double i = this.tile.func_174887_a_(0);
        double j = this.tile.getProcessTime();
        return j != 0.0 ? (int)Math.round(i * pixels / j) : 0;
    }
}

