/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import com.google.common.collect.Lists;
import java.io.Serializable;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import nc.config.NCConfig;
import nc.integration.crafttweaker.AddRecipe;
import nc.integration.crafttweaker.RemoveRecipe;
import nc.recipe.SorptionType;
import nc.recipe.generator.FissionRecipes;
import nc.recipe.generator.FusionRecipes;
import nc.recipe.processor.AlloyFurnaceRecipes;
import nc.recipe.processor.ChemicalReactorRecipes;
import nc.recipe.processor.CrystallizerRecipes;
import nc.recipe.processor.DecayHastenerRecipes;
import nc.recipe.processor.DissolverRecipes;
import nc.recipe.processor.ElectrolyserRecipes;
import nc.recipe.processor.FuelReprocessorRecipes;
import nc.recipe.processor.InfuserRecipes;
import nc.recipe.processor.IngotFormerRecipes;
import nc.recipe.processor.IrradiatorRecipes;
import nc.recipe.processor.IsotopeSeparatorRecipes;
import nc.recipe.processor.ManufactoryRecipes;
import nc.recipe.processor.MelterRecipes;
import nc.recipe.processor.PressurizerRecipes;
import nc.recipe.processor.SaltMixerRecipes;
import nc.recipe.processor.SupercoolerRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class NCCraftTweaker {
    public static void init() {
        MineTweakerAPI.registerClass(ManufactoryHandler.class);
        MineTweakerAPI.registerClass(IsotopeSeparatorHandler.class);
        MineTweakerAPI.registerClass(DecayHastenerHandler.class);
        MineTweakerAPI.registerClass(FuelReprocessorHandler.class);
        MineTweakerAPI.registerClass(AlloyFurnaceHandler.class);
        MineTweakerAPI.registerClass(InfuserHandler.class);
        MineTweakerAPI.registerClass(MelterHandler.class);
        MineTweakerAPI.registerClass(SupercoolerHandler.class);
        MineTweakerAPI.registerClass(ElectrolyserHandler.class);
        MineTweakerAPI.registerClass(IrradiatorHandler.class);
        MineTweakerAPI.registerClass(IngotFormerHandler.class);
        MineTweakerAPI.registerClass(PressurizerHandler.class);
        MineTweakerAPI.registerClass(ChemicalReactorHandler.class);
        MineTweakerAPI.registerClass(SaltMixerHandler.class);
        MineTweakerAPI.registerClass(CrystallizerHandler.class);
        MineTweakerAPI.registerClass(DissolverHandler.class);
        MineTweakerAPI.registerClass(FissionHandler.class);
        MineTweakerAPI.registerClass(FusionHandler.class);
    }

    @ZenClass(value="mods.nuclearcraft.fusion")
    @ModOnly(value={"nuclearcraft"})
    public static class FusionHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, double fuelTime, double power, double heatVar) {
            MineTweakerAPI.apply(new AddRecipe<FusionRecipes>(FusionRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4}), Lists.newArrayList((Object[])new Double[]{fuelTime, power, heatVar})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            MineTweakerAPI.apply(new RemoveRecipe<FusionRecipes>(FusionRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.fission")
    @ModOnly(value={"nuclearcraft"})
    public static class FissionHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, double fuelTime, double power, double heat, String name) {
            MineTweakerAPI.apply(new AddRecipe<FissionRecipes>(FissionRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Serializable[]{Double.valueOf(fuelTime), Double.valueOf(power), Double.valueOf(heat), name})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<FissionRecipes>(FissionRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.dissolver")
    @ModOnly(value={"nuclearcraft"})
    public static class DissolverHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<DissolverRecipes>(DissolverRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[15]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<DissolverRecipes>(DissolverRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<DissolverRecipes>(DissolverRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.crystallizer")
    @ModOnly(value={"nuclearcraft"})
    public static class CrystallizerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<CrystallizerRecipes>(CrystallizerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[14]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<CrystallizerRecipes>(CrystallizerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<CrystallizerRecipes>(CrystallizerRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.salt_mixer")
    @ModOnly(value={"nuclearcraft"})
    public static class SaltMixerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<SaltMixerRecipes>(SaltMixerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[13]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<SaltMixerRecipes>(SaltMixerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<SaltMixerRecipes>(SaltMixerRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.chemical_reactor")
    @ModOnly(value={"nuclearcraft"})
    public static class ChemicalReactorHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2) {
            MineTweakerAPI.apply(new AddRecipe<ChemicalReactorRecipes>(ChemicalReactorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[12]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<ChemicalReactorRecipes>(ChemicalReactorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1, IIngredient output2) {
            MineTweakerAPI.apply(new RemoveRecipe<ChemicalReactorRecipes>(ChemicalReactorRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.pressurizer")
    @ModOnly(value={"nuclearcraft"})
    public static class PressurizerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<PressurizerRecipes>(PressurizerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[11]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<PressurizerRecipes>(PressurizerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<PressurizerRecipes>(PressurizerRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.ingot_former")
    @ModOnly(value={"nuclearcraft"})
    public static class IngotFormerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<IngotFormerRecipes>(IngotFormerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[10]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<IngotFormerRecipes>(IngotFormerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<IngotFormerRecipes>(IngotFormerRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.irradiator")
    @ModOnly(value={"nuclearcraft"})
    public static class IrradiatorHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2) {
            MineTweakerAPI.apply(new AddRecipe<IrradiatorRecipes>(IrradiatorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[9]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<IrradiatorRecipes>(IrradiatorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1, IIngredient output2) {
            MineTweakerAPI.apply(new RemoveRecipe<IrradiatorRecipes>(IrradiatorRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.electrolyser")
    @ModOnly(value={"nuclearcraft"})
    public static class ElectrolyserHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            MineTweakerAPI.apply(new AddRecipe<ElectrolyserRecipes>(ElectrolyserRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[8]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<ElectrolyserRecipes>(ElectrolyserRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            MineTweakerAPI.apply(new RemoveRecipe<ElectrolyserRecipes>(ElectrolyserRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.supercooler")
    @ModOnly(value={"nuclearcraft"})
    public static class SupercoolerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<SupercoolerRecipes>(SupercoolerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[7]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<SupercoolerRecipes>(SupercoolerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<SupercoolerRecipes>(SupercoolerRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.melter")
    @ModOnly(value={"nuclearcraft"})
    public static class MelterHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<MelterRecipes>(MelterRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[6]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<MelterRecipes>(MelterRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<MelterRecipes>(MelterRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.infuser")
    @ModOnly(value={"nuclearcraft"})
    public static class InfuserHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<InfuserRecipes>(InfuserRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[5]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<InfuserRecipes>(InfuserRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<InfuserRecipes>(InfuserRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.alloy_furnace")
    @ModOnly(value={"nuclearcraft"})
    public static class AlloyFurnaceHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<AlloyFurnaceRecipes>(AlloyFurnaceRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[4]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<AlloyFurnaceRecipes>(AlloyFurnaceRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1, input2}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<AlloyFurnaceRecipes>(AlloyFurnaceRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.fuel_reprocessor")
    @ModOnly(value={"nuclearcraft"})
    public static class FuelReprocessorHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            MineTweakerAPI.apply(new AddRecipe<FuelReprocessorRecipes>(FuelReprocessorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[3]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<FuelReprocessorRecipes>(FuelReprocessorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            MineTweakerAPI.apply(new RemoveRecipe<FuelReprocessorRecipes>(FuelReprocessorRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.decay_hastener")
    @ModOnly(value={"nuclearcraft"})
    public static class DecayHastenerHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<DecayHastenerRecipes>(DecayHastenerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[2]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<DecayHastenerRecipes>(DecayHastenerRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<DecayHastenerRecipes>(DecayHastenerRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.isotope_separator")
    @ModOnly(value={"nuclearcraft"})
    public static class IsotopeSeparatorHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2) {
            MineTweakerAPI.apply(new AddRecipe<IsotopeSeparatorRecipes>(IsotopeSeparatorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[1]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<IsotopeSeparatorRecipes>(IsotopeSeparatorRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1, output2}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1, IIngredient output2) {
            MineTweakerAPI.apply(new RemoveRecipe<IsotopeSeparatorRecipes>(IsotopeSeparatorRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.manufactory")
    @ModOnly(value={"nuclearcraft"})
    public static class ManufactoryHandler {
        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            MineTweakerAPI.apply(new AddRecipe<ManufactoryRecipes>(ManufactoryRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{NCConfig.processor_time[0]})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            MineTweakerAPI.apply(new AddRecipe<ManufactoryRecipes>(ManufactoryRecipes.instance(), Lists.newArrayList((Object[])new IIngredient[]{input1}), Lists.newArrayList((Object[])new IIngredient[]{output1}), Lists.newArrayList((Object[])new Integer[]{processTime})));
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output1) {
            MineTweakerAPI.apply(new RemoveRecipe<ManufactoryRecipes>(ManufactoryRecipes.instance(), SorptionType.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }
}

