/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import nc.integration.jei.JEIMethods;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;
import nc.recipe.RecipeOreStack;
import nc.recipe.SorptionType;
import nc.recipe.StackType;
import net.minecraft.item.ItemStack;

public class RemoveRecipe<T extends BaseRecipeHandler>
implements IUndoableAction {
    public ArrayList<IIngredient> ingredients;
    public SorptionType type;
    public IRecipe recipe;
    public boolean wasNull;
    public boolean wrongSize;
    public T helper;

    public RemoveRecipe(T helper, SorptionType type, ArrayList<Object> ingredients) {
        this.helper = helper;
        this.type = type;
        if (helper instanceof BaseRecipeHandler && (type == SorptionType.OUTPUT ? ingredients.size() != ((BaseRecipeHandler)helper).outputSizeItem + ((BaseRecipeHandler)helper).outputSizeFluid : ingredients.size() != ((BaseRecipeHandler)helper).inputSizeItem + ((BaseRecipeHandler)helper).inputSizeFluid)) {
            MineTweakerAPI.logError((String)("A " + ((RecipeMethods)helper).getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<Object> adaptedIngredients = new ArrayList<Object>();
        for (Object output : ingredients) {
            if (output == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeMethods)helper).getRecipeName()));
                this.wasNull = true;
                return;
            }
            if (output instanceof IItemStack) {
                adaptedIngredients.add(MineTweakerMC.getItemStack((IItemStack)((IItemStack)output)));
                continue;
            }
            if (output instanceof IOreDictEntry) {
                adaptedIngredients.add(new RecipeOreStack(((IOreDictEntry)output).getName(), StackType.ITEM, ((IOreDictEntry)output).getAmount()));
                continue;
            }
            if (output instanceof ILiquidStack) {
                adaptedIngredients.add(((RecipeMethods)helper).buildRecipeObject(MineTweakerMC.getLiquidStack((ILiquidStack)((ILiquidStack)output))));
                continue;
            }
            if (!(output instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeMethods)helper).getRecipeName(), output));
                continue;
            }
            adaptedIngredients.add(output);
        }
        this.ingredients = adaptedIngredients;
        this.recipe = type == SorptionType.OUTPUT ? ((RecipeMethods)helper).getRecipeFromOutputs(adaptedIngredients.toArray()) : ((RecipeMethods)helper).getRecipeFromInputs(adaptedIngredients.toArray());
    }

    public void apply() {
        if (this.recipe == null) {
            MineTweakerAPI.logError((String)String.format("%s: Removing Recipe - Couldn't find matching recipe %s", ((RecipeMethods)this.helper).getRecipeName(), this.ingredients));
            return;
        }
        if (!this.wasNull && !this.wrongSize) {
            boolean removed = ((RecipeMethods)((Object)this.helper)).removeRecipe((IRecipe)this.recipe);
            if (!removed) {
                MineTweakerAPI.logError((String)String.format("%s: Removing Recipe - Failed to remove recipe %s", ((RecipeMethods)this.helper).getRecipeName(), this.ingredients));
            } else {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(JEIMethods.createJEIRecipe(this.recipe, this.helper));
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.recipe != null && !this.wasNull && !this.wrongSize) {
            ((RecipeMethods)((Object)this.helper)).addRecipe((IRecipe)this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(JEIMethods.createJEIRecipe(this.recipe, this.helper));
        }
    }

    public String describe() {
        if (this.recipe == null) {
            return "ERROR: RECIPE IS NULL";
        }
        return String.format("Removing %s recipe (%s = %s)", ((RecipeMethods)this.helper).getRecipeName(), this.recipe.inputs(), this.recipe.outputs());
    }

    public String describeUndo() {
        return String.format("Reverting /%s/", this.describe());
    }

    public Object getOverrideKey() {
        return null;
    }
}

