/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class JEIRecipe<T extends JEIRecipe>
implements IRecipeWrapper {
    public BaseRecipeHandler recipeHandler;
    public IRecipe recipe;
    public List<List<Object>> inputs;
    public List<List<ItemStack>> itemInputs;
    public List<List<FluidStack>> fluidInputs;
    public List<Object> outputs;
    public List<ItemStack> itemOutputs;
    public List<FluidStack> fluidOutputs;
    public int inputSizeItem;
    public int inputSizeFluid;
    public int outputSizeItem;
    public int outputSizeFluid;

    public JEIRecipe(BaseRecipeHandler recipeHandler, IRecipe recipe) {
        this.recipeHandler = recipeHandler;
        this.recipe = recipe;
        this.inputs = BaseRecipeHandler.getIngredientLists(recipe.inputs());
        this.outputs = BaseRecipeHandler.getIngredientList(recipe.outputs());
        this.inputSizeItem = recipeHandler.inputSizeItem;
        this.inputSizeFluid = recipeHandler.inputSizeFluid;
        this.outputSizeItem = recipeHandler.outputSizeItem;
        this.outputSizeFluid = recipeHandler.outputSizeFluid;
        ArrayList<List<ItemStack>> itemInputLists = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < this.inputSizeItem; ++i) {
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
            for (Object object : this.inputs.get(i)) {
                if (!(object instanceof ItemStack)) continue;
                inputList.add((ItemStack)object);
            }
            itemInputLists.add(inputList);
        }
        this.itemInputs = itemInputLists;
        ArrayList<List<FluidStack>> fluidInputLists = new ArrayList<List<FluidStack>>();
        for (int i = this.inputSizeItem; i < this.inputSizeItem + this.inputSizeFluid; ++i) {
            ArrayList inputList = new ArrayList();
            for (Object input : this.inputs.get(i)) {
                if (!(input instanceof FluidStack)) continue;
                inputList.add((FluidStack)input);
            }
            fluidInputLists.add(inputList);
        }
        this.fluidInputs = fluidInputLists;
        ArrayList<ItemStack> itemOutputList = new ArrayList<ItemStack>();
        for (Object e : this.outputs) {
            if (!(e instanceof ItemStack)) continue;
            itemOutputList.add((ItemStack)e);
        }
        this.itemOutputs = itemOutputList;
        ArrayList<FluidStack> fluidOutputList = new ArrayList<FluidStack>();
        for (Object output : this.outputs) {
            if (!(output instanceof FluidStack)) continue;
            fluidOutputList.add((FluidStack)output);
        }
        this.fluidOutputs = fluidOutputList;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.itemInputs);
        ingredients.setInputLists(FluidStack.class, this.fluidInputs);
        ingredients.setOutputs(ItemStack.class, this.itemOutputs);
        ingredients.setOutputs(FluidStack.class, this.fluidOutputs);
    }

    public List getInputs() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (List<ItemStack> input : this.itemInputs) {
            inputs.add(input.get(0));
        }
        return inputs;
    }

    public List getOutputs() {
        return this.itemOutputs;
    }

    public List<FluidStack> getFluidInputs() {
        ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
        for (List<FluidStack> input : this.fluidInputs) {
            inputs.add(input.get(0));
        }
        return inputs;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

