/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.ArrayList;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;

public abstract class BaseRecipeHandler<T extends IRecipe>
extends RecipeMethods<T> {
    public int inputSizeItem;
    public int inputSizeFluid;
    public int outputSizeItem;
    public int outputSizeFluid;
    public boolean shapeless;

    public BaseRecipeHandler(int inputSizeItem, int inputSizeFluid, int outputSizeItem, int outputSizeFluid, boolean shapeless) {
        this.inputSizeItem = inputSizeItem;
        this.inputSizeFluid = inputSizeFluid;
        this.outputSizeItem = outputSizeItem;
        this.outputSizeFluid = outputSizeFluid;
        this.shapeless = shapeless;
        this.addRecipes();
    }

    public void addRecipe(Object ... objects) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        ArrayList<Object> outputs = new ArrayList<Object>();
        ArrayList<Object> additionals = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i < this.inputSizeItem + this.inputSizeFluid) {
                inputs.add(object);
                continue;
            }
            if (i < this.inputSizeItem + this.inputSizeFluid + this.outputSizeItem + this.outputSizeFluid) {
                outputs.add(object);
                continue;
            }
            additionals.add(object);
        }
        this.addRecipe(this.buildDefaultRecipe(inputs, outputs, additionals, this.shapeless));
    }

    @Override
    public boolean isValidRecipe(ArrayList<IIngredient> recipeInputList, ArrayList<IIngredient> recipeOutputList) {
        return recipeInputList.size() == this.inputSizeItem + this.inputSizeFluid && recipeOutputList.size() == this.outputSizeItem + this.outputSizeFluid;
    }
}

