/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;

public abstract class MachineRecipeHandler {
    public int itemInputSize;
    public int fluidInputSize;
    public int totalInputSize;
    public int itemOutputSize;
    public int fluidOutputSize;
    public int totalOutputSize;
    public boolean shapeless;
    public boolean hasExtras;
    public static final int[] INVALID_ORDER = new int[]{-1, -1, -1, -1};
    private Map<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();

    public abstract void addRecipes();

    public MachineRecipeHandler(int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize, boolean shapeless, boolean hasExtras) {
        this.itemInputSize = itemInputSize;
        this.fluidInputSize = fluidInputSize;
        this.totalInputSize = itemInputSize + fluidInputSize;
        this.itemOutputSize = itemOutputSize;
        this.fluidOutputSize = fluidOutputSize;
        this.totalOutputSize = itemOutputSize + fluidOutputSize;
        this.shapeless = itemInputSize == 1 ? false : shapeless;
        this.hasExtras = hasExtras;
        this.addRecipes();
    }

    public Map<Object[], Object[]> getRecipes() {
        return this.recipeList;
    }

    public void addRecipe(Object ... objects) {
        Object[] stack = new Object[objects.length];
        if (objects.length > this.totalInputSize + this.totalOutputSize + (this.hasExtras ? 1 : 0)) {
            FMLLog.warning((String)(this.getClass().getName() + " - a recipe involving " + objects[0].toString() + " was removed because it was too long!"), (Object[])new Object[0]);
            return;
        }
        for (int i = 0; i < this.totalInputSize + this.totalOutputSize; ++i) {
            if (objects[i] == null) {
                FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an entry was null!"), (Object[])new Object[0]);
                return;
            }
            if (objects[i] instanceof String) {
                if (i < this.itemInputSize) {
                    if (this.oreExists((String)objects[i])) {
                        stack[i] = this.oreStack((String)objects[i], 1);
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an oreDict entry for " + (String)objects[i] + " didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize) {
                    if (this.fluidExists((String)objects[i])) {
                        stack[i] = this.fluidStack((String)objects[i], 1000);
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because a fluidReg entry for " + (String)objects[i] + " didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize + this.itemOutputSize) {
                    NonNullList ores = OreDictionary.getOres((String)((String)objects[i]));
                    if (ores.size() > 0) {
                        stack[i] = ores.get(0);
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an oreDict entry for " + (String)objects[i] + " didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i >= this.totalInputSize + this.totalOutputSize) continue;
                if (this.fluidExists((String)objects[i])) {
                    stack[i] = this.fluidStack((String)objects[i], 1000);
                    continue;
                }
                FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because a fluidReg entry for " + (String)objects[i] + " didn't exist!"), (Object[])new Object[0]);
                return;
            }
            if (objects[i] instanceof OreStack) {
                if (i < this.itemInputSize) {
                    if (OreDictionary.getOres((String)((OreStack)objects[i]).oreString).size() > 0) {
                        stack[i] = objects[i];
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an oreDict entry for " + ((OreStack)objects[i]).oreString + " didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize) {
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an there was an input type mismatch!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize + this.itemOutputSize) {
                    NonNullList ores = OreDictionary.getOres((String)((OreStack)objects[i]).oreString);
                    if (ores.size() > 0) {
                        stack[i] = new ItemStack(((ItemStack)ores.get(0)).func_77973_b(), ((OreStack)objects[i]).stackSize, ((ItemStack)ores.get(0)).func_77952_i());
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an oreDict entry for " + ((OreStack)objects[i]).oreString + " didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i >= this.totalInputSize + this.totalOutputSize) continue;
                FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an there was an input type mismatch!"), (Object[])new Object[0]);
                return;
            }
            if (objects[i] instanceof FluidStack) {
                if (i < this.itemInputSize) {
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an there was an input type mismatch!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize) {
                    if (this.fluidExists(((FluidStack)objects[i]).getFluid())) {
                        stack[i] = objects[i];
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because a fluidReg entry didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize + this.itemOutputSize) {
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an there was an input type mismatch!"), (Object[])new Object[0]);
                    return;
                }
                if (i >= this.totalInputSize + this.totalOutputSize) continue;
                if (this.fluidExists(((FluidStack)objects[i]).getFluid())) {
                    stack[i] = objects[i];
                    continue;
                }
                FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because a fluidReg entry didn't exist!"), (Object[])new Object[0]);
                return;
            }
            if (objects[i] instanceof Fluid) {
                if (i < this.itemInputSize) {
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an there was an input type mismatch!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize) {
                    if (this.fluidExists((Fluid)objects[i])) {
                        stack[i] = new FluidStack((Fluid)objects[i], 1000);
                        continue;
                    }
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because a fluidReg entry didn't exist!"), (Object[])new Object[0]);
                    return;
                }
                if (i < this.totalInputSize + this.itemOutputSize) {
                    FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an there was an input type mismatch!"), (Object[])new Object[0]);
                    return;
                }
                if (i >= this.totalInputSize + this.totalOutputSize) continue;
                if (this.fluidExists((Fluid)objects[i])) {
                    stack[i] = new FluidStack((Fluid)objects[i], 1000);
                    continue;
                }
                FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because a fluidReg entry didn't exist!"), (Object[])new Object[0]);
                return;
            }
            if (objects[i] instanceof ItemStack[]) {
                int s = 0;
                while (s < ((ItemStack[])objects[i]).length) {
                    if (((ItemStack[])objects[i])[s] == ItemStack.field_190927_a) {
                        FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an ItemStack input was empty!"), (Object[])new Object[0]);
                        return;
                    }
                    ++i;
                }
                stack[i] = objects[i];
                continue;
            }
            if (objects[i] instanceof FluidStack[]) {
                int s = 0;
                while (s < ((FluidStack[])objects[i]).length) {
                    if (((FluidStack[])objects[i])[s] == null) {
                        FMLLog.warning((String)(this.getClass().getName() + " - a recipe was removed because an input was null!"), (Object[])new Object[0]);
                        return;
                    }
                    ++i;
                }
                stack[i] = objects[i];
                continue;
            }
            stack[i] = this.fixedStack(objects[i]);
        }
        if (this.hasExtras) {
            stack[this.totalInputSize + this.totalOutputSize] = objects[this.totalInputSize + this.totalOutputSize];
        }
        this.addFinal(stack);
    }

    public boolean oreExists(String name) {
        return OreDictionary.getOres((String)name).size() > 0;
    }

    public boolean fluidExists(String name) {
        return FluidRegistry.getFluid((String)name) != null;
    }

    public boolean fluidExists(Fluid fluid) {
        return FluidRegistry.getFluidName((Fluid)fluid) != null;
    }

    private void addFinal(Object[] stacks) {
        Object[] input = new Object[this.totalInputSize];
        Object[] output = new Object[this.totalOutputSize + (this.hasExtras ? 1 : 0)];
        for (int i = 0; i < stacks.length; ++i) {
            if (i < this.totalInputSize) {
                input[i] = stacks[i];
                continue;
            }
            if (i < this.totalInputSize + (this.hasExtras ? 1 : 0) + this.totalOutputSize) {
                output[i - this.totalInputSize] = stacks[i];
                continue;
            }
            throw new RuntimeException("Recipe is too big!");
        }
        this.addRecipe(input, output);
    }

    private ItemStack fixedStack(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77946_l();
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException("Invalid Recipe!");
        }
        return new ItemStack((Block)obj, 1);
    }

    private void addRecipe(Object[] input, Object[] output) {
        this.recipeList.put(this.convertToArrays(input), output);
    }

    public Object getOutput(int output, Object ... input) {
        return this.getOutput(input)[output];
    }

    public Object[] getOutput(Object ... input) {
        Map.Entry<Object[], Object[]> entry;
        if (input.length != this.totalInputSize) {
            Object[] defaultStacks = new Object[this.totalOutputSize];
            for (int i = 0; i < defaultStacks.length; ++i) {
                defaultStacks[i] = null;
            }
            return defaultStacks;
        }
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != ItemStack.field_190927_a && input[i] != null) continue;
            Object[] defaultStacks = new Object[this.totalOutputSize];
            for (int j = 0; j < defaultStacks.length; ++j) {
                defaultStacks[j] = null;
            }
            return defaultStacks;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            Object[] defaultStacks = new Object[this.totalOutputSize];
            for (int j = 0; j < defaultStacks.length; ++j) {
                defaultStacks[j] = null;
            }
            return defaultStacks;
        } while (!this.checkInput(input, (entry = iterator.next()).getKey()));
        return this.convertOutput(entry.getValue());
    }

    public int getInputSize(int input, Object ... output) {
        Object[] inputs = this.getInput(output);
        if (inputs == null) {
            return 1;
        }
        return this.getInputSize(inputs)[input];
    }

    public Object[] getInput(Object ... output) {
        Map.Entry<Object[], Object[]> entry;
        if (output.length != this.totalOutputSize) {
            return new Object[this.totalInputSize];
        }
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != ItemStack.field_190927_a && output[i] != null) continue;
            return new Object[this.totalInputSize];
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return new Object[this.totalInputSize];
        } while (!this.checkOutput(output, (entry = iterator.next()).getValue()));
        return entry.getKey();
    }

    public Object getExtras(Object ... input) {
        Map.Entry<Object[], Object[]> entry;
        if (input.length != this.totalInputSize) {
            return null;
        }
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != ItemStack.field_190927_a && input[i] != null) continue;
            return null;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.checkInput(input, (entry = iterator.next()).getKey()));
        Object[] output = entry.getValue();
        return output[this.totalOutputSize];
    }

    public boolean validInput(Object input) {
        Map.Entry<Object[], Object[]> entry;
        if (input == ItemStack.field_190927_a || input == null) {
            return false;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.containsStack(input, (entry = iterator.next()).getKey(), false).isEmpty());
        return true;
    }

    public boolean validOutput(Object output) {
        Map.Entry<Object[], Object[]> entry;
        if (output == ItemStack.field_190927_a || output == null) {
            return false;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.containsStack(output, (entry = iterator.next()).getKey(), false).isEmpty());
        return true;
    }

    private Object[] convertOutput(Object[] output) {
        Object[] defaultStacks = new Object[output.length - (this.hasExtras ? 1 : 0)];
        for (int j = 0; j < defaultStacks.length; ++j) {
            defaultStacks[j] = null;
        }
        Object[] stack = defaultStacks;
        for (int i = 0; i < output.length - (this.hasExtras ? 1 : 0); ++i) {
            if (output[i] instanceof ItemStack) {
                stack[i] = (ItemStack)output[i];
                continue;
            }
            if (output[i] instanceof OreStack) {
                NonNullList ore = OreDictionary.getOres((String)((OreStack)output[i]).oreString);
                stack[i] = new ItemStack(((ItemStack)ore.get(0)).func_77973_b(), ((OreStack)output[i]).stackSize, ((ItemStack)ore.get(0)).func_77952_i());
                continue;
            }
            if (!(output[i] instanceof FluidStack)) continue;
            stack[i] = (FluidStack)output[i];
        }
        return stack;
    }

    private int[] getInputSize(Object[] input) {
        int[] sizes = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] instanceof ItemStack) {
                sizes[i] = ((ItemStack)input[i]).func_190916_E();
                continue;
            }
            if (input[i] instanceof ItemStack[]) {
                sizes[i] = ((ItemStack[])input[i])[0].func_190916_E();
                continue;
            }
            if (input[i] instanceof FluidStack) {
                sizes[i] = ((FluidStack)input[i]).amount;
                continue;
            }
            if (!(input[i] instanceof FluidStack[])) continue;
            sizes[i] = ((FluidStack[])input[i])[0].amount;
        }
        return sizes;
    }

    private boolean checkInput(Object[] input, Object[] key) {
        if (input.length != key.length && input.length == this.totalInputSize) {
            return false;
        }
        if (!this.shapeless) {
            for (int i = 0; i < key.length; ++i) {
                if (!(key[i] instanceof ItemStack ? !this.equalStack(input[i], (ItemStack)key[i], true) : (key[i] instanceof ItemStack[] ? this.containsStack(input[i], (ItemStack[])key[i], true).isEmpty() : (key[i] instanceof FluidStack ? !this.equalStack(input[i], (FluidStack)key[i], true) : key[i] instanceof FluidStack[] && this.containsStack(input[i], (FluidStack[])key[i], true).isEmpty())))) continue;
                return false;
            }
        } else {
            ArrayList<Integer> currentOrder = new ArrayList<Integer>();
            for (int i = 0; i < key.length; ++i) {
                List<Integer> stackNumbers = this.containsStack(input[i], key, true);
                if (stackNumbers.isEmpty()) {
                    return false;
                }
                boolean check = false;
                for (int stackNumber : stackNumbers) {
                    if (currentOrder.contains(stackNumber)) continue;
                    currentOrder.add(stackNumber);
                    check = true;
                    break;
                }
                if (check) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getInputOrder(Object[] input, Object[] key) {
        if (input.length != key.length && input.length == this.totalInputSize) {
            return INVALID_ORDER;
        }
        int[] order = new int[input.length];
        if (!this.shapeless) {
            for (int i = 0; i < input.length; ++i) {
                order[i] = i;
            }
            return order;
        }
        ArrayList<Integer> currentOrder = new ArrayList<Integer>();
        for (int i = 0; i < input.length; ++i) {
            List<Integer> stackNumbers = this.containsStack(input[i], key, true);
            if (stackNumbers.isEmpty()) {
                return INVALID_ORDER;
            }
            boolean check = false;
            for (int stackNumber : stackNumbers) {
                if (currentOrder.contains(stackNumber)) continue;
                order[i] = stackNumber;
                currentOrder.add(stackNumber);
                check = true;
                break;
            }
            if (check) continue;
            return INVALID_ORDER;
        }
        return order;
    }

    public int[] getItemInputOrder(Object[] input, Object[] key) {
        if (this.itemInputSize == 0) {
            return new int[0];
        }
        if (input.length != key.length && input.length == this.totalInputSize) {
            return INVALID_ORDER;
        }
        int[] order = new int[input.length - this.fluidInputSize];
        if (!this.shapeless) {
            for (int i = 0; i < input.length - this.fluidInputSize; ++i) {
                order[i] = i;
            }
            return order;
        }
        ArrayList<Integer> currentOrder = new ArrayList<Integer>();
        for (int i = 0; i < input.length; ++i) {
            List<Integer> stackNumbers = this.containsStack(input[i], key, true);
            if (stackNumbers.isEmpty()) {
                return INVALID_ORDER;
            }
            boolean check = false;
            for (int stackNumber : stackNumbers) {
                if (currentOrder.contains(stackNumber)) continue;
                order[i] = stackNumber;
                currentOrder.add(stackNumber);
                check = true;
                break;
            }
            if (check) continue;
            return INVALID_ORDER;
        }
        return order;
    }

    public int[] getFluidInputOrder(Object[] input, Object[] key) {
        if (this.fluidInputSize == 0) {
            return new int[0];
        }
        if (input.length != key.length && input.length == this.totalInputSize) {
            return INVALID_ORDER;
        }
        int[] order = new int[input.length - this.itemInputSize];
        if (!this.shapeless) {
            for (int i = 0; i < input.length - this.itemInputSize; ++i) {
                order[i] = i + this.itemInputSize;
            }
            return order;
        }
        ArrayList<Integer> currentOrder = new ArrayList<Integer>();
        for (int i = this.itemInputSize; i < input.length + this.itemInputSize; ++i) {
            List<Integer> stackNumbers = this.containsStack(input[i], key, true);
            if (stackNumbers.isEmpty()) {
                return INVALID_ORDER;
            }
            boolean check = false;
            for (int stackNumber : stackNumbers) {
                if (currentOrder.contains(stackNumber)) continue;
                order[i] = stackNumber - this.itemInputSize;
                currentOrder.add(stackNumber);
                check = true;
                break;
            }
            if (check) continue;
            return INVALID_ORDER;
        }
        return order;
    }

    private boolean checkOutput(Object[] output, Object[] key) {
        if (output.length + (this.hasExtras ? 1 : 0) != key.length && output.length == this.totalOutputSize) {
            return false;
        }
        for (int i = 0; i < output.length; ++i) {
            if (!(key[i] instanceof ItemStack ? !this.equalStack(output[i], (ItemStack)key[i], true) : (key[i] instanceof ItemStack[] ? this.containsStack(output[i], (ItemStack[])key[i], true).isEmpty() : (key[i] instanceof FluidStack ? !this.equalStack(output[i], (FluidStack)key[i], true) : key[i] instanceof FluidStack[] && this.containsStack(output[i], (FluidStack[])key[i], true).isEmpty())))) continue;
            return false;
        }
        return true;
    }

    public List<Integer> containsStack(Object stack, Object[] key, boolean checkSize) {
        ArrayList<Integer> searchResults = new ArrayList<Integer>();
        for (int i = 0; i < key.length; ++i) {
            int s;
            if (key[i] == null) continue;
            if (key[i] instanceof ItemStack) {
                if (!this.equalStack(stack, (ItemStack)key[i], checkSize)) continue;
                searchResults.add(i);
                continue;
            }
            if (key[i] instanceof ItemStack[]) {
                for (s = 0; s < ((ItemStack[])key[i]).length; ++s) {
                    if (((ItemStack[])key[i])[s] == ItemStack.field_190927_a || !(((ItemStack[])key[i])[s] instanceof ItemStack) || !this.equalStack(stack, ((ItemStack[])key[i])[s], checkSize)) continue;
                    searchResults.add(i);
                }
                continue;
            }
            if (key[i] instanceof FluidStack) {
                if (!this.equalStack(stack, (FluidStack)key[i], checkSize)) continue;
                searchResults.add(i);
                continue;
            }
            if (!(key[i] instanceof FluidStack[])) continue;
            for (s = 0; s < ((FluidStack[])key[i]).length; ++s) {
                if (((FluidStack[])key[i])[s] == null || !(((FluidStack[])key[i])[s] instanceof FluidStack) || !this.equalStack(stack, ((FluidStack[])key[i])[s], checkSize)) continue;
                searchResults.add(i);
            }
        }
        return searchResults;
    }

    private boolean equalStack(Object stack, Object key, boolean checkSize) {
        if (stack instanceof ItemStack && key instanceof ItemStack) {
            return ((ItemStack)stack).func_77973_b() == ((ItemStack)key).func_77973_b() && ((ItemStack)stack).func_77952_i() == ((ItemStack)key).func_77952_i() && (!checkSize || ((ItemStack)key).func_190916_E() <= ((ItemStack)stack).func_190916_E());
        }
        if (stack instanceof FluidStack && key instanceof FluidStack) {
            return ((FluidStack)stack).isFluidEqual((FluidStack)key) && ((FluidStack)key).amount <= ((FluidStack)stack).amount;
        }
        return false;
    }

    private int findStackSize(Object stack, Object[] key, int pos) {
        if (key[pos] != null) {
            if (key[pos] instanceof ItemStack) {
                if (this.equalStack(stack, (ItemStack)key[pos], false)) {
                    return ((ItemStack)key[pos]).func_190916_E();
                }
            } else if (key[pos] instanceof FluidStack) {
                if (this.equalStack(stack, (FluidStack)key[pos], false)) {
                    return ((FluidStack)key[pos]).amount;
                }
            } else {
                if (key[pos] instanceof ItemStack[]) {
                    return this.findStackSize(stack, (ItemStack[])key[pos], pos);
                }
                if (key[pos] instanceof FluidStack[]) {
                    return this.findStackSize(stack, (FluidStack[])key[pos], pos);
                }
            }
        }
        return -1;
    }

    private Object[] convertToArrays(Object[] object) {
        Object[] stack = new Object[object.length];
        for (int i = 0; i < object.length; ++i) {
            if (object[i] instanceof ItemStack) {
                stack[i] = (ItemStack)object[i];
                continue;
            }
            if (object[i] instanceof ItemStack[]) {
                stack[i] = (ItemStack[])object[i];
                continue;
            }
            if (object[i] instanceof OreStack) {
                NonNullList ore = OreDictionary.getOres((String)((OreStack)object[i]).oreString);
                ItemStack[] ores = new ItemStack[ore.size()];
                for (int o = 0; o < ore.size(); ++o) {
                    ores[o] = new ItemStack(((ItemStack)ore.get(o)).func_77973_b(), ((OreStack)object[i]).stackSize, ((ItemStack)ore.get(o)).func_77952_i());
                }
                stack[i] = ores;
                continue;
            }
            if (object[i] instanceof FluidStack) {
                stack[i] = (FluidStack)object[i];
                continue;
            }
            if (!(object[i] instanceof FluidStack[])) continue;
            stack[i] = (FluidStack[])object[i];
        }
        return stack;
    }

    public OreStack oreStack(String oreString, int stackSize) {
        return new OreStack(oreString, stackSize);
    }

    public FluidStack fluidStack(String fluidString, int stackSize) {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        if (fluidList.contains(fluidString)) {
            return new FluidStack(FluidRegistry.getFluid((String)fluidString), stackSize);
        }
        return null;
    }

    public static class OreStack {
        public String oreString;
        public int stackSize;

        public OreStack(String oreString, int stackSize) {
            this.oreString = oreString;
            this.stackSize = stackSize;
        }
    }
}

