/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import nc.recipe.BaseRecipe;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.IRecipeGetter;
import nc.recipe.IRecipeStack;
import nc.recipe.RecipeOreStack;
import nc.recipe.RecipeStack;
import nc.recipe.RecipeTransposable;
import nc.recipe.SorptionType;
import nc.recipe.StackType;
import nc.util.NCStackHelper;
import nc.util.OreStackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public abstract class RecipeMethods<T extends IRecipe>
implements IRecipeGetter<T> {
    public ArrayList<T> recipes = new ArrayList();
    public ArrayList<Class<?>> validInputs = Lists.newArrayList((Object[])new Class[]{IIngredient.class, ArrayList.class, String.class, Item.class, Block.class, ItemStack.class, ItemStack[].class, Fluid.class, FluidStack.class});
    public ArrayList<Class<?>> validOutputs = Lists.newArrayList((Object[])new Class[]{IIngredient.class, String.class, Item.class, Block.class, ItemStack.class, Fluid.class, FluidStack.class});
    public ArrayList<Class<?>> needAltering = Lists.newArrayList((Object[])new Class[]{Item.class, Block.class, Fluid.class});

    public abstract void addRecipes();

    @Override
    public abstract String getRecipeName();

    @Override
    public ArrayList<T> getRecipes() {
        return this.recipes;
    }

    @Nullable
    public T getRecipeFromInputs(Object[] inputs) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchingInputs(inputs)) continue;
            return (T)recipe;
        }
        return null;
    }

    @Nullable
    public T getRecipeFromOutputs(Object[] outputs) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchingOutputs(outputs)) continue;
            return (T)recipe;
        }
        return null;
    }

    public ArrayList<IIngredient> getInputList(Object ... outputs) {
        T recipe = this.getRecipeFromOutputs(outputs);
        ArrayList<IIngredient> result = recipe != null ? recipe.inputs() : new ArrayList<IIngredient>();
        return result;
    }

    public ArrayList<IIngredient> getOutputList(Object ... inputs) {
        T recipe = this.getRecipeFromInputs(inputs);
        ArrayList<IIngredient> result = recipe != null ? recipe.outputs() : new ArrayList<IIngredient>();
        return result;
    }

    public boolean addRecipe(T recipe) {
        return recipe != null ? this.recipes.add(recipe) : false;
    }

    public boolean removeRecipe(T recipe) {
        return recipe != null ? this.recipes.remove(recipe) : false;
    }

    public void addValidInput(Class inputTypes) {
        this.validInputs.add(inputTypes);
    }

    private boolean isValidInputType(Object input) {
        for (Class<?> inputType : this.validInputs) {
            ArrayList list;
            if (!(input instanceof ArrayList && inputType == ArrayList.class ? !(list = (ArrayList)input).isEmpty() && this.isValidInputType(list.get(0)) : inputType.isInstance(input))) continue;
            return true;
        }
        return false;
    }

    private boolean isValidOutputType(Object output) {
        for (Class<?> outputType : this.validOutputs) {
            if (!outputType.isInstance(output)) continue;
            return true;
        }
        return false;
    }

    private boolean requiresAdjustment(Object object) {
        for (Class<?> objectType : this.needAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IIngredient buildRecipeObject(Object object) {
        if (this.requiresAdjustment(object)) {
            object = RecipeMethods.adjustObject(object);
        }
        if (object instanceof IIngredient) {
            return (IIngredient)object;
        }
        if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            ArrayList<IIngredient> buildList = new ArrayList<IIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    if (listObject == null) continue;
                    IIngredient recipeObject = this.buildRecipeObject(listObject);
                    if (recipeObject != null) {
                        buildList.add(recipeObject);
                        continue;
                    }
                    return null;
                }
                return new RecipeTransposable(buildList);
            }
            return null;
        }
        if (object instanceof String) {
            if (!OreStackHelper.exists((String)object)) {
                return null;
            }
            return new RecipeOreStack((String)object, StackType.UNSPECIFIED, 1);
        }
        if (object instanceof ItemStack) {
            return new RecipeStack((ItemStack)object);
        }
        if (object instanceof FluidStack) {
            return new RecipeStack((FluidStack)object);
        }
        return null;
    }

    public void addRecipe(ArrayList inputList, ArrayList outputList, ArrayList extrasList, boolean shapeless) {
        this.addRecipe(this.buildDefaultRecipe(inputList, outputList, extrasList, shapeless));
    }

    @Nullable
    public T buildDefaultRecipe(ArrayList inputs, ArrayList outputs, ArrayList additionals, boolean shapeless) {
        ArrayList recipeInputs = Lists.newArrayList();
        ArrayList recipeOutputs = Lists.newArrayList();
        for (Object obj : inputs) {
            if (obj != null && this.isValidInputType(obj)) {
                IIngredient input = this.buildRecipeObject(obj);
                if (input == null) {
                    return null;
                }
                recipeInputs.add(input);
                continue;
            }
            if (obj != null) {
                FMLLog.warning((String)(this.getRecipeName() + " - a recipe was removed because the input " + obj.toString() + " is invalid!"), (Object[])new Object[0]);
            } else {
                FMLLog.warning((String)(this.getRecipeName() + " - a recipe was removed because an input was null!"), (Object[])new Object[0]);
            }
            return null;
        }
        for (Object obj : outputs) {
            if (obj != null && this.isValidOutputType(obj)) {
                IIngredient output = this.buildRecipeObject(obj);
                if (output == null) {
                    return null;
                }
                recipeOutputs.add(output);
                continue;
            }
            if (obj != null) {
                FMLLog.warning((String)(this.getRecipeName() + " - a recipe was removed because the output " + obj.toString() + " is invalid!"), (Object[])new Object[0]);
            } else {
                FMLLog.warning((String)(this.getRecipeName() + " - a recipe was removed because an output was null!"), (Object[])new Object[0]);
            }
            return null;
        }
        if (!this.isValidRecipe(recipeInputs, recipeOutputs)) {
            FMLLog.warning((String)(this.getRecipeName() + " - a recipe was removed: " + recipeInputs.toString() + " -> " + recipeOutputs.toString()), (Object[])new Object[0]);
        }
        return this.buildRecipe(recipeInputs, recipeOutputs, additionals, shapeless);
    }

    public boolean isValidRecipe(ArrayList<IIngredient> recipeInputs, ArrayList<IIngredient> recipeOutputs) {
        return recipeInputs.size() > 0 && recipeOutputs.size() > 0;
    }

    public T buildRecipe(ArrayList<IIngredient> inputList, ArrayList<IIngredient> outputList, ArrayList extrasList, boolean shapeless) {
        return (T)new BaseRecipe(inputList, outputList, extrasList, shapeless);
    }

    public boolean isValidOutput(Object object) {
        for (IRecipe recipe : this.recipes) {
            for (IIngredient output : recipe.outputs()) {
                if (!output.matches(object, SorptionType.OUTPUT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidInput(Object object) {
        for (IRecipe recipe : this.recipes) {
            for (IIngredient input : recipe.inputs()) {
                if (!input.matches(object, SorptionType.INPUT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidManualInput(Object object) {
        for (IRecipe recipe : this.recipes) {
            for (IIngredient input : recipe.inputs()) {
                if (!input.matches(object, SorptionType.NEUTRAL)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object adjustObject(Object object) {
        return NCStackHelper.fixStack(object);
    }

    public static ArrayList<List<Object>> getIngredientLists(ArrayList<IIngredient> ingredientList) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        ingredientList.forEach(object -> values.add(object.getIngredientList()));
        return values;
    }

    public static List<Object> getIngredientList(List<IIngredient> list) {
        ArrayList<Object> values = new ArrayList<Object>();
        list.forEach(object -> values.add(object.getIngredient()));
        return values;
    }

    public static ArrayList getValuesFromList(ArrayList<IIngredient> list) {
        ArrayList values = new ArrayList();
        list.forEach(object -> values.add(object.getIngredient()));
        return values;
    }

    @Nullable
    public static Object getIngredientFromList(ArrayList<IIngredient> list, int pos) {
        IIngredient object;
        if (!list.isEmpty() && pos < list.size() && (object = list.get(pos)) instanceof IRecipeStack) {
            return ((IRecipeStack)((Object)object)).getOutputStack();
        }
        return null;
    }

    public static boolean matchingIngredients(SorptionType sorption, ArrayList<IIngredient> ingredients, boolean shapeless, Object[] objects) {
        ArrayList matches = (ArrayList)ingredients.clone();
        if (ingredients.size() != objects.length) {
            return false;
        }
        int pos = -1;
        block0: for (Object obj : objects) {
            if (obj == null) {
                return false;
            }
            ++pos;
            if (shapeless) {
                for (IIngredient ingredient : (ArrayList)matches.clone()) {
                    if (!ingredient.matches(obj, sorption)) continue;
                    matches.remove(ingredient);
                    continue block0;
                }
            } else if (ingredients.get(pos).matches(obj, sorption)) {
                matches.remove(ingredients.get(pos));
                continue;
            }
            return false;
        }
        return true;
    }

    public RecipeOreStack oreStack(String oreType, int stackSize) {
        if (!OreStackHelper.exists(oreType)) {
            return null;
        }
        return new RecipeOreStack(oreType, StackType.ITEM, stackSize);
    }

    public RecipeOreStack fluidStack(String oreType, int stackSize) {
        if (!OreStackHelper.exists(oreType)) {
            return null;
        }
        return new RecipeOreStack(oreType, StackType.FLUID, stackSize);
    }
}

