/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.generator;

import nc.config.NCConfig;
import nc.recipe.BaseRecipeHandler;
import net.minecraft.util.text.translation.I18n;

public class FissionRecipes
extends BaseRecipeHandler {
    private static final FissionRecipes RECIPES = new FissionRecipes();

    public FissionRecipes() {
        super(1, 0, 1, 0, false);
    }

    public static final FissionRecipes instance() {
        return RECIPES;
    }

    @Override
    public void addRecipes() {
        this.fuelRodDeplete("TBU", NCConfig.fission_thorium_fuel_time, NCConfig.fission_thorium_power, NCConfig.fission_thorium_heat_generation);
        this.fuelRodDeplete("U", NCConfig.fission_uranium_fuel_time, NCConfig.fission_uranium_power, NCConfig.fission_uranium_heat_generation, 233, 235);
        this.fuelRodDeplete("N", NCConfig.fission_neptunium_fuel_time, NCConfig.fission_neptunium_power, NCConfig.fission_neptunium_heat_generation, 236);
        this.fuelRodDeplete("P", NCConfig.fission_plutonium_fuel_time, NCConfig.fission_plutonium_power, NCConfig.fission_plutonium_heat_generation, 239, 241);
        this.addRecipe("fuelRodMOX239", "depletedFuelRodMOX239", NCConfig.fission_mox_fuel_time[0], NCConfig.fission_mox_power[0], NCConfig.fission_mox_heat_generation[0], FissionRecipes.localise("mox_239"));
        this.addRecipe("fuelRodMOX241", "depletedFuelRodMOX241", NCConfig.fission_mox_fuel_time[1], NCConfig.fission_mox_power[1], NCConfig.fission_mox_heat_generation[1], FissionRecipes.localise("mox_241"));
        this.fuelRodDeplete("A", NCConfig.fission_americium_fuel_time, NCConfig.fission_americium_power, NCConfig.fission_americium_heat_generation, 242);
        this.fuelRodDeplete("Cm", NCConfig.fission_curium_fuel_time, NCConfig.fission_curium_power, NCConfig.fission_curium_heat_generation, 243, 245, 247);
        this.fuelRodDeplete("B", NCConfig.fission_berkelium_fuel_time, NCConfig.fission_berkelium_power, NCConfig.fission_berkelium_heat_generation, 248);
        this.fuelRodDeplete("Cf", NCConfig.fission_californium_fuel_time, NCConfig.fission_californium_power, NCConfig.fission_californium_heat_generation, 249, 251);
    }

    public void fuelRodDeplete(String fuel, double[] time, double[] power, double[] heat) {
        this.addRecipe("fuelRod" + fuel, "depletedFuelRod" + fuel, time[0], power[0], heat[0], FissionRecipes.localise(fuel.toLowerCase()));
        this.addRecipe("fuelRod" + fuel + "Oxide", "depletedFuelRod" + fuel + "Oxide", time[1], power[1], heat[1], FissionRecipes.localise(fuel.toLowerCase()) + "-" + FissionRecipes.localise("oxide"));
    }

    public void fuelRodDeplete(String fuel, double[] time, double[] power, double[] heat, int ... types) {
        int count = 0;
        for (int type : types) {
            this.fuelRodDeplete("LE" + fuel, type, count, time, power, heat);
            this.fuelRodDeplete("HE" + fuel, type, count + 2, time, power, heat);
            count += 4;
        }
    }

    public void fuelRodDeplete(String fuel, int type, int meta, double[] time, double[] power, double[] heat) {
        this.addRecipe("fuelRod" + fuel + type, "depletedFuelRod" + fuel + type, time[meta], power[meta], heat[meta], FissionRecipes.localise(fuel.toLowerCase()) + "-" + type);
        this.addRecipe("fuelRod" + fuel + type + "Oxide", "depletedFuelRod" + fuel + type + "Oxide", time[meta + 1], power[meta + 1], heat[meta + 1], FissionRecipes.localise(fuel.toLowerCase()) + "-" + type + "-" + FissionRecipes.localise("oxide"));
    }

    private static String localise(String string) {
        return I18n.func_74837_a((String)("gui.container.fission_controller." + string), (Object[])new Object[0]);
    }

    @Override
    public String getRecipeName() {
        return "fission";
    }
}

