/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import nc.config.NCConfig;
import nc.recipe.BaseRecipeHandler;

public class DecayHastenerRecipes
extends BaseRecipeHandler {
    private static final DecayHastenerRecipes RECIPES = new DecayHastenerRecipes();

    public DecayHastenerRecipes() {
        super(1, 0, 1, 0, false);
    }

    public static final DecayHastenerRecipes instance() {
        return RECIPES;
    }

    @Override
    public void addRecipes() {
        this.decay("Thorium230Base", "dustLead");
        this.decay("Thorium232", "dustLead");
        this.decay("Uranium233", "dustLead");
        this.decay("Uranium235", "dustLead");
        this.decay("Uranium238Base", "Thorium230Base");
        this.decay("Neptunium236", "Thorium232");
        this.decay("Neptunium237Base", "Uranium233");
        this.decay("Plutonium238Base", "Thorium230Base");
        this.decay("Plutonium239", "Uranium235");
        this.decay("Plutonium241", "Neptunium237Base");
        this.decay("Plutonium242Base", "Uranium238Base");
        this.decay("Americium241Base", "Neptunium237Base");
        this.decay("Americium242", "Thorium230Base");
        this.decay("Americium243Base", "Plutonium239");
        this.decay("Curium243", "Plutonium239");
        this.decay("Curium245", "Plutonium241");
        this.decay("Curium246Base", "Plutonium242Base");
        this.decay("Curium247", "Americium243Base");
        this.decay("Berkelium247Base", "Americium243Base");
        this.decay("Berkelium248", "Thorium232");
        this.decay("Californium249", "Curium245");
        this.decay("Californium250Base", "Curium246Base");
        this.decay("Californium251", "Curium247");
        this.decay("Californium252Base", "Thorium232");
    }

    public void decay(String input, String output) {
        boolean isInputBase = input.substring(input.length() - 4, input.length()).equals("Base");
        boolean isOutputBase = output.substring(output.length() - 4, output.length()).equals("Base");
        boolean isLead = output.equals("dustLead");
        for (String size : new String[]{"ingot", "tiny"}) {
            for (String oxide : new String[]{"", "Oxide"}) {
                Object[] objectArray = new Object[3];
                objectArray[0] = size + (oxide.equals("Oxide") && isInputBase || size.equals("tiny") && isInputBase ? input.substring(0, input.length() - 4) : input) + oxide;
                objectArray[1] = isLead ? (size.equals("ingot") ? "dustLead" : "tinyDustLead") : size + (oxide.equals("Oxide") && isOutputBase || size.equals("tiny") && isOutputBase ? output.substring(0, output.length() - 4) : output) + oxide;
                objectArray[2] = size.equals("tiny") ? NCConfig.processor_time[2] / 8 : NCConfig.processor_time[2];
                this.addRecipe(objectArray);
            }
        }
    }

    @Override
    public String getRecipeName() {
        return "decay_hastener";
    }
}

