/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.BaseRecipeHandler;
import nc.util.NCUtil;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class MelterRecipes
extends BaseRecipeHandler {
    private static final MelterRecipes RECIPES = new MelterRecipes();

    public MelterRecipes() {
        super(1, 0, 0, 1, false);
    }

    public static final MelterRecipes instance() {
        return RECIPES;
    }

    @Override
    public void addRecipes() {
        this.metalMelt();
        this.addRecipe("ingotLithium6", this.fluidStack("lithium6", 144), NCConfig.processor_time[6]);
        this.addRecipe("tinyLithium6", this.fluidStack("lithium6", 16), NCConfig.processor_time[6] / 8);
        this.addRecipe("ingotLithium7", this.fluidStack("lithium7", 144), NCConfig.processor_time[6]);
        this.addRecipe("tinyLithium7", this.fluidStack("lithium7", 16), NCConfig.processor_time[6] / 8);
        this.addRecipe("ingotBoron10", this.fluidStack("boron10", 144), NCConfig.processor_time[6]);
        this.addRecipe("tinyBoron10", this.fluidStack("boron10", 16), NCConfig.processor_time[6] / 8);
        this.addRecipe("ingotBoron11", this.fluidStack("boron11", 144), NCConfig.processor_time[6]);
        this.addRecipe("tinyBoron11", this.fluidStack("boron11", 16), NCConfig.processor_time[6] / 8);
        this.addRecipe("dustSulfur", this.fluidStack("sulfur", 666), NCConfig.processor_time[6]);
        this.addRecipe(Blocks.field_150432_aD, this.fluidStack("water", 1000), NCConfig.processor_time[6] / 2);
        this.addRecipe(Blocks.field_185778_de, this.fluidStack("water", 1000), NCConfig.processor_time[6] / 2);
        this.addRecipe(Blocks.field_150403_cj, this.fluidStack("water", 1000), NCConfig.processor_time[6] / 2);
        this.addRecipe("obsidian", this.fluidStack("obsidian", 288), NCConfig.processor_time[6] * 4);
        this.addRecipe("ingotObsidian", this.fluidStack("obsidian", 144), NCConfig.processor_time[6] * 2);
        this.addRecipe(Blocks.field_150354_m, this.fluidStack("glass", 1000), NCConfig.processor_time[6]);
        this.addRecipe("blockGlass", this.fluidStack("glass", 1000), NCConfig.processor_time[6]);
        this.addRecipe("dustRedstone", this.fluidStack("redstone", 100), NCConfig.processor_time[6] / 4);
        this.addRecipe("blockRedstone", this.fluidStack("redstone", 900), NCConfig.processor_time[6] * 2);
        this.addRecipe("dustGlowstone", this.fluidStack("glowstone", 250), NCConfig.processor_time[6] / 2);
        this.addRecipe("glowstone", this.fluidStack("glowstone", 1000), NCConfig.processor_time[6] * 4);
        this.addRecipe(Items.field_151079_bi, this.fluidStack("ender", 250), NCConfig.processor_time[6] / 2);
        this.addRecipe("dustPyrotheum", this.fluidStack("pyrotheum", 250), NCConfig.processor_time[6] / 2);
        this.addRecipe("dustCryotheum", this.fluidStack("cryotheum", 250), NCConfig.processor_time[6] / 2);
        this.addRecipe("dustAerotheum", this.fluidStack("aerotheum", 250), NCConfig.processor_time[6] / 2);
        this.addRecipe("dustPetrotheum", this.fluidStack("petrotheum", 250), NCConfig.processor_time[6] / 2);
        this.addRecipe("dustCoal", this.fluidStack("coal", 100), NCConfig.processor_time[6] / 2);
        this.addRecipe("dustGraphite", this.fluidStack("coal", 100), NCConfig.processor_time[6] / 4);
    }

    public void metalMelt() {
        List<String> oreList = Arrays.asList(OreDictionary.getOreNames());
        ArrayList fluidValueList = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        ArrayList<String> fluidList = new ArrayList<String>();
        for (Fluid fluid : fluidValueList) {
            fluidList.add(fluid.getName());
        }
        for (String fluidName : fluidList) {
            String ore = "ore" + NCUtil.capitalize(fluidName);
            String ingot = "ingot" + NCUtil.capitalize(fluidName);
            String dust = "dust" + NCUtil.capitalize(fluidName);
            if (NCConfig.ore_processing && oreList.contains(ore)) {
                this.addRecipe(ore, this.fluidStack(fluidName, 324), NCConfig.processor_time[6] * 2);
            }
            if (!oreList.contains(ingot) || !oreList.contains(dust)) continue;
            this.addRecipe(ingot, this.fluidStack(fluidName, 144), NCConfig.processor_time[6]);
            this.addRecipe(dust, this.fluidStack(fluidName, 144), NCConfig.processor_time[6]);
        }
    }

    @Override
    public String getRecipeName() {
        return "melter";
    }
}

