/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.dummy;

import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.energy.Storage;
import nc.fluid.EnumTank;
import nc.fluid.Tank;
import nc.tile.ITileInventory;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileDummy
extends TileEnergyFluidSidedInventory {
    public BlockPos masterPosition = null;
    public int tickCount;
    public final int updateRate;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileDummy(String name, int updateRate, String[] ... allowedFluids) {
        this(name, EnumStorage.EnergyConnection.BOTH, EnumTank.FluidConnection.BOTH, updateRate, allowedFluids);
    }

    public TileDummy(String name, EnumStorage.EnergyConnection energyConnection, int updateRate, String[] ... allowedFluids) {
        this(name, energyConnection, EnumTank.FluidConnection.BOTH, updateRate, allowedFluids);
    }

    public TileDummy(String name, EnumTank.FluidConnection fluidConnection, int updateRate, String[] ... allowedFluids) {
        this(name, EnumStorage.EnergyConnection.BOTH, fluidConnection, updateRate, allowedFluids);
    }

    public TileDummy(String name, EnumStorage.EnergyConnection energyConnection, EnumTank.FluidConnection fluidConnection, int updateRate, String[] ... allowedFluids) {
        super(name, 1, 1, energyConnection, new int[]{1}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
        this.updateRate = updateRate;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldUpdate()) {
                this.findMaster();
            }
            this.tick();
        }
    }

    public void tick() {
        this.tickCount = this.tickCount > this.updateRate ? 0 : ++this.tickCount;
    }

    public boolean shouldUpdate() {
        return this.tickCount > this.updateRate;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.findMaster();
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryStacks() {
        if (this.getMaster() != null && this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getInventoryStacks();
        }
        return this.inventoryStacks;
    }

    @Override
    public int func_70302_i_() {
        return this.getInventoryStacks().size();
    }

    @Override
    public boolean func_191420_l() {
        if (this.getMaster() != null && this.getMaster() instanceof IInventory) {
            ((IInventory)this.getMaster()).func_191420_l();
        }
        for (ItemStack itemstack : this.inventoryStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.getInventoryStacks().get(slot);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.getInventoryStacks(), (int)index, (int)count);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getInventoryStacks(), (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (this.getMaster() != null && this.getMaster() instanceof IInventory) {
            ((IInventory)this.getMaster()).func_70299_a(index, stack);
            return;
        }
        ItemStack itemstack = (ItemStack)this.inventoryStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventoryStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.getMaster() != null && this.getMaster() instanceof IInventory) {
            return ((IInventory)this.getMaster()).func_94041_b(slot, stack);
        }
        return false;
    }

    @Override
    public int func_70297_j_() {
        if (this.getMaster() != null && this.getMaster() instanceof IInventory) {
            return ((IInventory)this.getMaster()).func_70297_j_();
        }
        return 1;
    }

    @Override
    public void func_174888_l() {
        this.getInventoryStacks().clear();
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (this.getMaster() != null && this.getMaster() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getMaster()).func_180463_a(side);
        }
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        if (this.getMaster() != null && this.getMaster() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getMaster()).func_180462_a(slot, stack, direction);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        if (this.getMaster() != null && this.getMaster() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getMaster()).func_180461_b(slot, stack, direction);
        }
        return false;
    }

    @Override
    public Storage getStorage() {
        if (this.getMaster() != null && this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getStorage();
        }
        return this.storage;
    }

    @Override
    public EnumStorage.EnergyConnection getEnergyConnection() {
        if (this.getMaster() != null && this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyConnection();
        }
        return this.connection;
    }

    @Override
    public int getEnergyStored() {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergyStorage) {
            return ((IEnergyStorage)this.getMaster()).getEnergyStored();
        }
        return this.getStorage().getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergyStorage) {
            return ((IEnergyStorage)this.getMaster()).getMaxEnergyStored();
        }
        return this.getStorage().getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergyStorage) {
            return ((IEnergyStorage)this.getMaster()).receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergyStorage) {
            return ((IEnergyStorage)this.getMaster()).extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public boolean canExtract() {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergyStorage) {
            return ((IEnergyStorage)this.getMaster()).canExtract();
        }
        return false;
    }

    @Override
    public boolean canReceive() {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergyStorage) {
            return ((IEnergyStorage)this.getMaster()).canReceive();
        }
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getEnergyConnection().canReceive();
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getEnergyConnection().canExtract();
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSourceTier() + 3), (double)(this.getStorage().takePower(this.getStorage().maxExtract, true) / (long)NCConfig.generator_rf_per_eu));
    }

    @Override
    public double getDemandedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSinkTier() + 3), (double)(this.getStorage().givePower(this.getStorage().maxReceive, true) / (long)NCConfig.processor_rf_per_eu));
    }

    @Override
    public void drawEnergy(double amount) {
        this.getStorage().takePower((long)((double)NCConfig.generator_rf_per_eu * amount), false);
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int energyReceived = this.getStorage().receiveEnergy((int)((double)NCConfig.processor_rf_per_eu * amount), true);
        this.getStorage().givePower(energyReceived, false);
        return amount - (double)(energyReceived / NCConfig.processor_rf_per_eu);
    }

    @Override
    public int getSourceTier() {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergySource) {
            return ((IEnergySource)this.getMaster()).getSourceTier();
        }
        return 1;
    }

    @Override
    public int getSinkTier() {
        if (this.getMaster() != null && this.getMaster() instanceof IEnergySink) {
            return ((IEnergySink)this.getMaster()).getSinkTier();
        }
        return 4;
    }

    @Override
    public Tank[] getTanks() {
        if (this.getMaster() != null && this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getTanks();
        }
        return this.tanks;
    }

    @Override
    public EnumTank.FluidConnection[] getFluidConnections() {
        if (this.getMaster() != null && this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getFluidConnections();
        }
        return this.fluidConnection;
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        if (this.getTanks().length == 0 || this.getTanks() == null) {
            return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.getTanks().length];
        for (int i = 0; i < this.getTanks().length; ++i) {
            properties[i] = new FluidTankProperties(this.getTanks()[i].getFluid(), this.getTanks()[i].getCapacity(), this.getFluidConnections()[i].canFill(), this.getFluidConnections()[i].canDrain());
        }
        return properties;
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.getMaster() != null && this.getMaster() instanceof ITileFluid) {
            if (this.getTanks().length == 0 || this.getTanks() == null) {
                return 0;
            }
            for (int i = 0; i < this.getTanks().length; ++i) {
                if (!this.getFluidConnections()[i].canFill() || !this.getTanks()[i].isFluidValid(resource) || !this.canFill(resource, i) || this.getTanks()[i].getFluidAmount() >= this.getTanks()[i].getCapacity() || this.getTanks()[i].getFluid() != null && !this.getTanks()[i].getFluid().isFluidEqual(resource)) continue;
                return this.getTanks()[i].fill(resource, doFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.getMaster() != null && this.getMaster() instanceof ITileFluid) {
            if (this.getTanks().length == 0 || this.getTanks() == null) {
                return null;
            }
            for (int i = 0; i < this.getTanks().length; ++i) {
                if (!this.getFluidConnections()[i].canDrain() || this.getTanks()[i].getFluid() == null || this.getTanks()[i].getFluidAmount() <= 0) continue;
                return this.getTanks()[i].drain(resource.amount, doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getMaster() != null && this.getMaster() instanceof ITileFluid) {
            if (this.getTanks().length == 0 || this.getTanks() == null) {
                return null;
            }
            for (int i = 0; i < this.getTanks().length; ++i) {
                if (!this.getFluidConnections()[i].canDrain() || this.getTanks()[i].getFluid() == null || this.getTanks()[i].getFluidAmount() <= 0) continue;
                return this.getTanks()[i].drain(maxDrain, doDrain);
            }
        }
        return null;
    }

    @Override
    public boolean canFill(FluidStack resource, int tankNumber) {
        if (this.getMaster() != null && this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).canFill(resource, tankNumber);
        }
        return super.canFill(resource, tankNumber);
    }

    @Override
    public void setConnection(EnumStorage.EnergyConnection connection) {
        this.connection = connection;
    }

    @Override
    public void pushEnergy() {
        if (this.getMaster() == null) {
            return;
        }
        if (this.getStorage().getEnergyStored() <= 0 || !this.getEnergyConnection().canExtract()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IEnergyStorage adjStorage;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
            IEnergyStorage iEnergyStorage = adjStorage = tile == null ? null : (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
            if (adjStorage != null && this.storage.canExtract()) {
                this.getStorage().extractEnergy(adjStorage.receiveEnergy(this.getStorage().extractEnergy(this.getStorage().getMaxEnergyStored(), true), false), false);
                continue;
            }
            if (!(tile instanceof IEnergySink)) continue;
            this.getStorage().extractEnergy((int)Math.round(((IEnergySink)tile).injectEnergy(side.func_176734_d(), this.getStorage().extractEnergy(this.getStorage().getMaxEnergyStored(), true) / 24, this.getSourceTier())), false);
        }
    }

    @Override
    public void setConnection(EnumTank.FluidConnection[] connection) {
        if (this.tanks.length > 0 && this.tanks != null) {
            this.fluidConnection = connection;
        }
    }

    @Override
    public void setConnection(EnumTank.FluidConnection connection, int tankNumber) {
        if (this.tanks.length > 0 && this.tanks != null) {
            this.fluidConnection[tankNumber] = connection;
        }
    }

    @Override
    public void pushFluid() {
        if (this.getTanks().length > 0 && this.getTanks() != null) {
            for (int i = 0; i < this.getTanks().length; ++i) {
                if (this.getTanks()[i].getFluidAmount() <= 0 || !this.getFluidConnections()[i].canDrain()) {
                    return;
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    IFluidHandler adjStorage;
                    TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
                    IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                    if (tile instanceof IFluidHandler) {
                        this.getTanks()[i].drain(((IFluidHandler)tile).fill(this.getTanks()[i].drain(this.getTanks()[i].getCapacity(), false), true), true);
                    }
                    if (adjStorage == null) continue;
                    this.getTanks()[i].drain(adjStorage.fill(this.getTanks()[i].drain(this.getTanks()[i].getCapacity(), false), true), true);
                }
            }
        }
    }

    protected abstract void findMaster();

    public abstract boolean isMaster(BlockPos var1);

    public TileEntity getMaster() {
        if (this.masterPosition == null) {
            return null;
        }
        if (this.field_145850_b.func_175625_s(this.masterPosition) == null) {
            return null;
        }
        if (this.isMaster(this.masterPosition)) {
            return this.field_145850_b.func_175625_s(this.masterPosition);
        }
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return (T)this.getStorage();
        }
        if (this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.getStorage();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return super.getCapability(capability, facing);
    }
}

