/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.energy.Storage;
import nc.tile.NCTile;
import nc.tile.energy.ITileEnergy;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileEnergy
extends NCTile
implements ITileEnergy,
IEnergyStorage,
IEnergyTile,
IEnergySink,
IEnergySource {
    public EnumStorage.EnergyConnection connection;
    public final Storage storage;
    public boolean isEnergyTileSet = true;
    public boolean ic2reg = false;

    public TileEnergy(int capacity, EnumStorage.EnergyConnection connection) {
        this(capacity, capacity, capacity, connection);
    }

    public TileEnergy(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection) {
        this(capacity, maxTransfer, maxTransfer, connection);
    }

    public TileEnergy(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection) {
        this.storage = new Storage(capacity, maxReceive, maxExtract);
        this.connection = connection;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.addTileToENet();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeTileFromENet();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.removeTileFromENet();
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public EnumStorage.EnergyConnection getEnergyConnection() {
        return this.connection;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.connection.canExtract() ? this.storage.extractEnergy(maxExtract, simulate) : 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.connection.canReceive() ? this.storage.receiveEnergy(maxReceive, simulate) : 0;
    }

    public boolean canExtract() {
        return this.connection.canExtract();
    }

    public boolean canReceive() {
        return this.connection.canReceive();
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.connection.canReceive();
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.connection.canExtract();
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSourceTier() + 3), (double)(this.storage.takePower(this.storage.maxExtract, true) / (long)NCConfig.generator_rf_per_eu));
    }

    @Override
    public double getDemandedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSinkTier() + 3), (double)(this.storage.givePower(this.storage.maxReceive, true) / (long)NCConfig.processor_rf_per_eu));
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage.takePower((long)((double)NCConfig.generator_rf_per_eu * amount), false);
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int energyReceived = this.storage.receiveEnergy((int)((double)NCConfig.processor_rf_per_eu * amount), true);
        this.storage.givePower(energyReceived, false);
        return amount - (double)(energyReceived / NCConfig.processor_rf_per_eu);
    }

    @Override
    public abstract int getSourceTier();

    @Override
    public abstract int getSinkTier();

    public void addTileToENet() {
        if (!this.field_145850_b.field_72995_K && ModCheck.ic2Loaded() && !this.ic2reg) {
            EnergyNet.instance.addTile(this);
            this.ic2reg = true;
        }
    }

    public void removeTileFromENet() {
        if (!this.field_145850_b.field_72995_K && ModCheck.ic2Loaded() && this.ic2reg) {
            EnergyNet.instance.removeTile(this);
            this.ic2reg = false;
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("energy", this.storage.getEnergyStored());
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.storage.setEnergyStored(nbt.func_74762_e("energy"));
    }

    public void setConnection(EnumStorage.EnergyConnection connection) {
        this.connection = connection;
    }

    public void pushEnergy() {
        if (this.storage.getEnergyStored() <= 0 || !this.connection.canExtract()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IEnergyStorage adjStorage;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
            IEnergyStorage iEnergyStorage = adjStorage = tile == null ? null : (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
            if (adjStorage != null && this.storage.canExtract()) {
                this.storage.extractEnergy(adjStorage.receiveEnergy(this.storage.extractEnergy(this.storage.getMaxEnergyStored(), true), false), false);
                continue;
            }
            if (!(tile instanceof IEnergySink)) continue;
            this.storage.extractEnergy((int)Math.round(((IEnergySink)tile).injectEnergy(side.func_176734_d(), this.storage.extractEnergy(this.storage.getMaxEnergyStored(), true) / 24, this.getSourceTier())), false);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return true;
        }
        if (this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return (T)this.storage;
        }
        if (this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }
}

