/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energyFluid;

import nc.ModCheck;
import nc.energy.EnumStorage;
import nc.fluid.EnumTank;
import nc.fluid.Tank;
import nc.tile.energy.TileEnergy;
import nc.tile.fluid.ITileFluid;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public abstract class TileEnergyFluid
extends TileEnergy
implements ITileFluid,
IFluidHandler {
    public EnumTank.FluidConnection[] fluidConnection;
    public final Tank[] tanks;
    public boolean areTanksShared = false;

    public TileEnergyFluid(int capacity, EnumStorage.EnergyConnection connection, int fluidCapacity, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, new int[]{fluidCapacity}, new int[]{fluidCapacity}, new int[]{fluidCapacity}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, EnumStorage.EnergyConnection connection, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, fluidCapacity, fluidCapacity, fluidCapacity, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, EnumStorage.EnergyConnection connection, int fluidCapacity, int maxFluidTransfer, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, new int[]{fluidCapacity}, new int[]{maxFluidTransfer}, new int[]{maxFluidTransfer}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, EnumStorage.EnergyConnection connection, int[] fluidCapacity, int[] maxFluidTransfer, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, fluidCapacity, maxFluidTransfer, maxFluidTransfer, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, EnumStorage.EnergyConnection connection, int fluidCapacity, int maxFluidReceive, int maxFluidExtract, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, new int[]{fluidCapacity}, new int[]{maxFluidReceive}, new int[]{maxFluidExtract}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, EnumStorage.EnergyConnection connection, int[] fluidCapacity, int[] maxFluidReceive, int[] maxFluidExtract, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, fluidCapacity, maxFluidReceive, maxFluidExtract, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection, int fluidCapacity, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, new int[]{fluidCapacity}, new int[]{fluidCapacity}, new int[]{fluidCapacity}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, fluidCapacity, fluidCapacity, fluidCapacity, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection, int fluidCapacity, int maxFluidTransfer, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, new int[]{fluidCapacity}, new int[]{maxFluidTransfer}, new int[]{maxFluidTransfer}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection, int[] fluidCapacity, int[] maxFluidTransfer, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, fluidCapacity, maxFluidTransfer, maxFluidTransfer, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection, int fluidCapacity, int maxFluidReceive, int maxFluidExtract, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, new int[]{fluidCapacity}, new int[]{maxFluidReceive}, new int[]{maxFluidExtract}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, EnumStorage.EnergyConnection connection, int[] fluidCapacity, int[] maxFluidReceive, int[] maxFluidExtract, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, fluidCapacity, maxFluidReceive, maxFluidExtract, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection, int fluidCapacity, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxReceive, maxExtract, connection, new int[]{fluidCapacity}, new int[]{fluidCapacity}, new int[]{fluidCapacity}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection, int[] fluidCapacity, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxReceive, maxExtract, connection, fluidCapacity, fluidCapacity, fluidCapacity, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection, int fluidCapacity, int maxFluidTransfer, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxReceive, maxExtract, connection, new int[]{fluidCapacity}, new int[]{maxFluidTransfer}, new int[]{maxFluidTransfer}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection, int[] fluidCapacity, int[] maxFluidTransfer, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxReceive, maxExtract, connection, fluidCapacity, maxFluidTransfer, maxFluidTransfer, fluidConnection, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection, int fluidCapacity, int maxFluidReceive, int maxFluidExtract, EnumTank.FluidConnection fluidConnection, String[] ... allowedFluids) {
        this(capacity, maxReceive, maxExtract, connection, new int[]{fluidCapacity}, new int[]{maxFluidReceive}, new int[]{maxFluidExtract}, new EnumTank.FluidConnection[]{fluidConnection}, allowedFluids);
    }

    public TileEnergyFluid(int capacity, int maxReceive, int maxExtract, EnumStorage.EnergyConnection connection, int[] fluidCapacity, int[] maxFluidReceive, int[] maxFluidExtract, EnumTank.FluidConnection[] fluidConnection, String[] ... allowedFluids) {
        super(capacity, maxReceive, maxExtract, connection);
        if (fluidCapacity == null || fluidCapacity.length == 0) {
            this.tanks = null;
        } else {
            int i;
            Tank[] tankList = new Tank[fluidCapacity.length];
            String[][] fluidWhitelists = new String[fluidCapacity.length][];
            for (i = 0; i < fluidCapacity.length; ++i) {
                fluidWhitelists[i] = i < allowedFluids.length ? allowedFluids[i] : new String[0];
            }
            for (i = 0; i < fluidCapacity.length; ++i) {
                tankList[i] = new Tank(fluidCapacity[i], maxFluidReceive[i], maxFluidExtract[i], fluidWhitelists[i]);
            }
            this.tanks = tankList;
        }
        if (fluidConnection == null || fluidConnection.length == 0) {
            this.fluidConnection = null;
        } else {
            EnumTank.FluidConnection[] connectionList = new EnumTank.FluidConnection[fluidConnection.length];
            for (int i = 0; i < fluidConnection.length; ++i) {
                connectionList[i] = fluidConnection[i];
            }
            this.fluidConnection = connectionList;
        }
    }

    @Override
    public boolean getTanksShared() {
        return this.areTanksShared;
    }

    @Override
    public void setTanksShared(boolean shared) {
        this.areTanksShared = shared;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.tanks.length == 0 || this.tanks == null) {
            return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            properties[i] = new FluidTankProperties(this.tanks[i].getFluid(), this.tanks[i].getCapacity(), this.fluidConnection[i].canFill(), this.fluidConnection[i].canDrain());
        }
        return properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.tanks.length == 0 || this.tanks == null) {
            return 0;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.fluidConnection[i].canFill() || !this.tanks[i].isFluidValid(resource) || !this.canFill(resource, i) || this.tanks[i].getFluidAmount() >= this.tanks[i].getCapacity() || this.tanks[i].getFluid() != null && !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return this.tanks[i].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.tanks.length == 0 || this.tanks == null) {
            return null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.fluidConnection[i].canDrain() || this.tanks[i].getFluid() == null || this.tanks[i].getFluidAmount() <= 0) continue;
            return this.tanks[i].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks.length == 0 || this.tanks == null) {
            return null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.fluidConnection[i].canDrain() || this.tanks[i].getFluid() == null || this.tanks[i].getFluidAmount() <= 0) continue;
            return this.tanks[i].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(FluidStack resource, int tankNumber) {
        if (!this.areTanksShared) {
            return true;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (i == tankNumber || !this.fluidConnection[i].canFill() || this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearTank(int tankNo) {
        if (tankNo < this.tanks.length) {
            this.tanks[tankNo].setFluidStored(null);
        }
    }

    @Override
    public Tank[] getTanks() {
        return this.tanks;
    }

    @Override
    public EnumTank.FluidConnection[] getFluidConnections() {
        return this.fluidConnection;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        if (this.tanks.length > 0 && this.tanks != null) {
            for (int i = 0; i < this.tanks.length; ++i) {
                nbt.func_74768_a("fluidAmount" + i, this.tanks[i].getFluidAmount());
                nbt.func_74778_a("fluidName" + i, this.tanks[i].getFluidName());
            }
        }
        nbt.func_74757_a("areTanksShared", this.areTanksShared);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (this.tanks.length > 0 && this.tanks != null) {
            for (int i = 0; i < this.tanks.length; ++i) {
                if (nbt.func_74779_i("fluidName" + i) == "nullFluid" || nbt.func_74762_e("fluidAmount" + i) == 0) {
                    this.tanks[i].setFluidStored(null);
                    continue;
                }
                this.tanks[i].setFluidStored(FluidRegistry.getFluid((String)nbt.func_74779_i("fluidName" + i)), nbt.func_74762_e("fluidAmount" + i));
            }
        }
        this.setTanksShared(nbt.func_74767_n("areTanksShared"));
    }

    public void setConnection(EnumTank.FluidConnection[] connection) {
        if (this.tanks.length > 0 && this.tanks != null) {
            this.fluidConnection = connection;
        }
    }

    public void setConnection(EnumTank.FluidConnection connection, int tankNumber) {
        if (this.tanks.length > 0 && this.tanks != null) {
            this.fluidConnection[tankNumber] = connection;
        }
    }

    public void pushFluid() {
        if (this.tanks.length > 0 && this.tanks != null) {
            for (int i = 0; i < this.tanks.length; ++i) {
                if (this.tanks[i].getFluidAmount() <= 0 || !this.fluidConnection[i].canDrain()) {
                    return;
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    IFluidHandler adjStorage;
                    TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
                    IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                    if (tile instanceof IFluidHandler) {
                        this.tanks[i].drain(((IFluidHandler)tile).fill(this.tanks[i].drain(this.tanks[i].getCapacity(), false), true), true);
                    }
                    if (adjStorage == null) continue;
                    this.tanks[i].drain(adjStorage.fill(this.tanks[i].drain(this.tanks[i].getCapacity(), false), true), true);
                }
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return true;
        }
        if (this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tanks.length > 0 && this.tanks != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability && this.connection.canConnect()) {
            return (T)this.storage;
        }
        if (this.connection != null && ModCheck.teslaLoaded && this.connection.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.connection.canReceive() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.connection.canExtract() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.storage;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tanks.length > 0 && this.tanks != null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

