/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import nc.fluid.EnumTank;
import nc.fluid.Tank;
import nc.tile.NCTile;
import nc.tile.fluid.ITileFluid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public abstract class TileFluid
extends NCTile
implements ITileFluid,
IFluidHandler {
    public EnumTank.FluidConnection[] connection;
    public final Tank[] tanks;
    public boolean areTanksShared = false;

    public TileFluid(int capacity, EnumTank.FluidConnection connection, String[] ... allowedFluids) {
        this(new int[]{capacity}, new int[]{capacity}, new int[]{capacity}, new EnumTank.FluidConnection[]{connection}, allowedFluids);
    }

    public TileFluid(int[] capacity, EnumTank.FluidConnection[] connection, String[] ... allowedFluids) {
        this(capacity, capacity, capacity, connection, allowedFluids);
    }

    public TileFluid(int capacity, int maxTransfer, EnumTank.FluidConnection connection, String[] ... allowedFluids) {
        this(new int[]{capacity}, new int[]{maxTransfer}, new int[]{maxTransfer}, new EnumTank.FluidConnection[]{connection}, allowedFluids);
    }

    public TileFluid(int[] capacity, int[] maxTransfer, EnumTank.FluidConnection[] connection, String[] ... allowedFluids) {
        this(capacity, maxTransfer, maxTransfer, connection, allowedFluids);
    }

    public TileFluid(int capacity, int maxReceive, int maxExtract, EnumTank.FluidConnection connection, String[] ... allowedFluids) {
        this(new int[]{capacity}, new int[]{maxReceive}, new int[]{maxExtract}, new EnumTank.FluidConnection[]{connection}, allowedFluids);
    }

    public TileFluid(int[] capacity, int[] maxReceive, int[] maxExtract, EnumTank.FluidConnection[] connection, String[] ... allowedFluids) {
        if (capacity == null || capacity.length == 0) {
            this.tanks = null;
        } else {
            int i;
            Tank[] tankList = new Tank[capacity.length];
            String[][] fluidWhitelists = new String[capacity.length][];
            for (i = 0; i < capacity.length; ++i) {
                fluidWhitelists[i] = i < allowedFluids.length ? allowedFluids[i] : new String[0];
            }
            for (i = 0; i < capacity.length; ++i) {
                tankList[i] = new Tank(capacity[i], maxReceive[i], maxExtract[i], fluidWhitelists[i]);
            }
            this.tanks = tankList;
        }
        if (connection == null || connection.length == 0) {
            this.connection = null;
        } else {
            EnumTank.FluidConnection[] connectionList = new EnumTank.FluidConnection[connection.length];
            for (int i = 0; i < connection.length; ++i) {
                connectionList[i] = connection[i];
            }
            this.connection = connectionList;
        }
    }

    @Override
    public boolean getTanksShared() {
        return this.areTanksShared;
    }

    @Override
    public void setTanksShared(boolean shared) {
        this.areTanksShared = shared;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.tanks.length == 0 || this.tanks == null) {
            return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            properties[i] = new FluidTankProperties(this.tanks[i].getFluid(), this.tanks[i].getCapacity(), this.connection[i].canFill(), this.connection[i].canDrain());
        }
        return properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.tanks.length == 0 || this.tanks == null) {
            return 0;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.connection[i].canFill() || !this.tanks[i].isFluidValid(resource) || !this.canFill(resource, i) || this.tanks[i].getFluidAmount() >= this.tanks[i].getCapacity() || this.tanks[i].getFluid() != null && !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return this.tanks[i].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.tanks.length == 0 || this.tanks == null) {
            return null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.connection[i].canDrain() || this.tanks[i].getFluid() == null || this.tanks[i].getFluidAmount() <= 0) continue;
            return this.tanks[i].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks.length == 0 || this.tanks == null) {
            return null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.connection[i].canDrain() || this.tanks[i].getFluid() == null || this.tanks[i].getFluidAmount() <= 0) continue;
            return this.tanks[i].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(FluidStack resource, int tankNumber) {
        if (!this.areTanksShared) {
            return true;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            if (i == tankNumber || !this.connection[i].canFill() || this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearTank(int tankNo) {
        if (tankNo < this.tanks.length) {
            this.tanks[tankNo].setFluidStored(null);
        }
    }

    @Override
    public Tank[] getTanks() {
        return this.tanks;
    }

    @Override
    public EnumTank.FluidConnection[] getFluidConnections() {
        return this.connection;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        if (this.tanks.length > 0 && this.tanks != null) {
            for (int i = 0; i < this.tanks.length; ++i) {
                nbt.func_74768_a("fluidAmount" + i, this.tanks[i].getFluidAmount());
                nbt.func_74778_a("fluidName" + i, this.tanks[i].getFluidName());
            }
        }
        nbt.func_74757_a("areTanksShared", this.areTanksShared);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (this.tanks.length > 0 && this.tanks != null) {
            for (int i = 0; i < this.tanks.length; ++i) {
                if (nbt.func_74779_i("fluidName" + i) == "nullFluid" || nbt.func_74762_e("fluidAmount" + i) == 0) {
                    this.tanks[i].setFluidStored(null);
                    continue;
                }
                this.tanks[i].setFluidStored(FluidRegistry.getFluid((String)nbt.func_74779_i("fluidName" + i)), nbt.func_74762_e("fluidAmount" + i));
            }
        }
        this.setTanksShared(nbt.func_74767_n("areTanksShared"));
    }

    public void setConnection(EnumTank.FluidConnection[] connection) {
        if (this.tanks.length > 0 && this.tanks != null) {
            this.connection = connection;
        }
    }

    public void setConnection(EnumTank.FluidConnection connection, int tankNumber) {
        if (this.tanks.length > 0 && this.tanks != null) {
            this.connection[tankNumber] = connection;
        }
    }

    public void pushFluid() {
        if (this.tanks.length > 0 && this.tanks != null) {
            for (int i = 0; i < this.tanks.length; ++i) {
                if (this.tanks[i].getFluidAmount() <= 0 || !this.connection[i].canDrain()) {
                    return;
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    IFluidHandler adjStorage;
                    TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
                    IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                    if (tile instanceof IFluidHandler) {
                        this.tanks[i].drain(((IFluidHandler)tile).fill(this.tanks[i].drain(this.tanks[i].getCapacity(), false), true), true);
                    }
                    if (adjStorage == null) continue;
                    this.tanks[i].drain(adjStorage.fill(this.tanks[i].drain(this.tanks[i].getCapacity(), false), true), true);
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tanks.length > 0 && this.tanks != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tanks.length > 0 && this.tanks != null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

