/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.Random;
import nc.block.fission.BlockCooler;
import nc.block.tile.dummy.BlockFissionPort;
import nc.block.tile.generator.BlockFissionController;
import nc.block.tile.passive.BlockActiveCooler;
import nc.block.tile.passive.BlockBuffer;
import nc.config.NCConfig;
import nc.fluid.Tank;
import nc.handler.EnumHandler;
import nc.init.NCBlocks;
import nc.recipe.generator.FissionRecipes;
import nc.tile.fluid.TileActiveCooler;
import nc.tile.generator.TileItemGenerator;
import nc.util.NCMath;
import nc.util.OreStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.oredict.OreDictionary;

public class TileFissionController
extends TileItemGenerator {
    public int rateMultiplier;
    public int processTime;
    public int processPower;
    public int heat;
    public int cooling;
    public int heatChange;
    public int efficiency;
    public int cells;
    public int tickCountStructureCheck;
    public int tickCountRunCheck;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int lengthX;
    public int lengthY;
    public int lengthZ = 3;
    public int complete;
    public int ready;
    public String problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete", (Object[])new Object[0]);
    public String problemPos = this.stringPos(this.field_174879_c);
    public int problemPosX = 0;
    public int problemPosY = 0;
    public int problemPosZ = 0;
    public int problemPosBool = 0;
    private Random rand = new Random();
    public static final int BASE_CAPACITY = 64000;
    public static final int BASE_MAX_HEAT = 25000;

    public TileFissionController() {
        super("fission_controller", 1, 1, 0, 64000, FissionRecipes.instance());
        this.setCapacity();
    }

    @Override
    public void updateGenerator() {
        boolean flag = this.isGenerating;
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K && this.time == 0) {
            this.consume();
        }
        this.tickStructureCheck();
        this.checkStructure();
        if (!this.field_145850_b.field_72995_K) {
            this.tickRunCheck();
            this.run();
            if (this.overheat()) {
                return;
            }
            if (this.canProcess() && this.isPowered()) {
                this.isGenerating = true;
                this.time += this.getRateMultiplier();
                this.storage.changeEnergyStored(this.getProcessPower());
                if (this.time >= this.getProcessTime()) {
                    this.time = 0;
                    this.output();
                }
            } else {
                this.isGenerating = false;
            }
            if (flag != this.isGenerating) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
                    this.addTileToENet();
                }
            }
            this.pushEnergy();
            if (this.findAdjacentComparator() && this.shouldStructureCheck()) {
                flag1 = true;
            }
        } else {
            boolean bl = this.isGenerating = this.canProcess() && this.isPowered();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @Override
    public void setBlockState() {
        BlockFissionController.setState(this.isGenerating, this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.checkStructure();
        }
    }

    public void tickStructureCheck() {
        this.tickCountStructureCheck = this.tickCountStructureCheck > NCConfig.fission_update_rate ? 0 : ++this.tickCountStructureCheck;
    }

    public boolean shouldStructureCheck() {
        return this.tickCountStructureCheck > NCConfig.fission_update_rate;
    }

    public void tickRunCheck() {
        this.tickCountRunCheck = this.tickCountRunCheck > NCConfig.fission_update_rate * 2 ? 0 : ++this.tickCountRunCheck;
    }

    public boolean shouldRunCheck() {
        return this.tickCountRunCheck > NCConfig.fission_update_rate * 2;
    }

    public boolean findAdjacentComparator() {
        if (this.field_145850_b.func_180495_p(this.position(1, 0, 0)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(-1, 0, 0)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(0, 1, 0)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(0, -1, 0)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(0, 0, 1)).func_177230_c() instanceof BlockRedstoneComparator) {
            return true;
        }
        return this.field_145850_b.func_180495_p(this.position(0, 0, -1)).func_177230_c() instanceof BlockRedstoneComparator;
    }

    public boolean overheat() {
        if (this.heat >= this.getMaxHeat() && NCConfig.fission_overheat) {
            this.meltdown();
            return true;
        }
        return false;
    }

    public void meltdown() {
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150353_l.func_176223_P());
        for (int i = this.minX; i <= this.maxX; ++i) {
            for (int j = this.minY; j <= this.maxY; ++j) {
                for (int k = this.minZ; k <= this.maxZ; ++k) {
                    if (!(this.rand.nextDouble() < 0.18)) continue;
                    this.field_145850_b.func_175656_a(this.position(i, j, k), Blocks.field_150353_l.func_176203_a(this.rand.nextInt(2)));
                }
            }
        }
    }

    public BlockPos getCentre() {
        return this.position((this.minX + this.maxX) / 2, (this.minY + this.maxY) / 2, (this.minZ + this.maxZ) / 2);
    }

    public BlockPos getCentreWithRand() {
        double mult = this.rand.nextDouble();
        return this.position(this.minX + (int)NCMath.Round((double)this.maxX * mult, 2), this.minY + (int)NCMath.Round((double)this.maxY * mult, 2), this.minZ + (int)NCMath.Round((double)this.maxZ * mult, 2));
    }

    @Override
    public boolean canProcess() {
        return this.canProcessStacks() && this.complete == 1;
    }

    @Override
    public int getSourceTier() {
        return 4;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public int getRateMultiplier() {
        return Math.max(1, this.rateMultiplier);
    }

    @Override
    public void setRateMultiplier(int value) {
        this.rateMultiplier = Math.max(1, value);
    }

    @Override
    public int getProcessTime() {
        return Math.max(1, this.processTime);
    }

    @Override
    public void setProcessTime(int value) {
        this.processTime = Math.max(1, value);
    }

    @Override
    public int getProcessPower() {
        return this.processPower;
    }

    @Override
    public void setProcessPower(int value) {
        this.processPower = Math.max(0, value);
    }

    public ArrayList getFuelStats() {
        return this.getRecipe(true) != null ? this.getRecipe(true).extras() : null;
    }

    public double getBaseTime() {
        if (this.getFuelStats() != null && this.getFuelStats().get(0) instanceof Double) {
            return (Double)this.getFuelStats().get(0) * NCConfig.fusion_fuel_use;
        }
        return 1.0;
    }

    public double getBasePower() {
        if (this.getFuelStats() != null && this.getFuelStats().get(1) instanceof Double) {
            return (Double)this.getFuelStats().get(1);
        }
        return 0.0;
    }

    public double getBaseHeat() {
        if (this.getFuelStats() != null && this.getFuelStats().get(2) instanceof Double) {
            return (Double)this.getFuelStats().get(2);
        }
        return 0.0;
    }

    public String getFuelName() {
        if (this.getFuelStats() != null && this.getFuelStats().get(3) instanceof String) {
            return ((String)this.getFuelStats().get(3)).replace('_', '-');
        }
        return I18n.func_74837_a((String)"gui.container.fission_controller.no_fuel", (Object[])new Object[0]);
    }

    public int getLengthX() {
        return this.lengthX - 2;
    }

    public int getLengthY() {
        return this.lengthY - 2;
    }

    public int getLengthZ() {
        return this.lengthZ - 2;
    }

    public int getMaxHeat() {
        if (this.atLimit(this.getLengthX(), this.getLengthY(), this.getLengthZ(), 25000)) {
            return Integer.MAX_VALUE;
        }
        if (this.getLengthX() <= 0 || this.getLengthY() <= 0 || this.getLengthZ() <= 0) {
            return 25000;
        }
        return 25000 * this.getLengthX() * this.getLengthY() * this.getLengthZ();
    }

    private boolean findFromOreName(int x, int y, int z, String ... names) {
        ItemStack stack;
        int i;
        int xCheck = this.func_174877_v().func_177958_n();
        int yCheck = this.func_174877_v().func_177956_o() + y;
        int zCheck = this.func_174877_v().func_177952_p();
        ArrayList types = new ArrayList();
        for (i = 0; i < names.length; ++i) {
            NonNullList stacks = OreDictionary.getOres((String)names[i]);
            types.addAll(stacks);
        }
        if (this.func_145832_p() == 4) {
            for (i = 0; i < names.length; ++i) {
                stack = OreStackHelper.blockToStack(this.field_145850_b.func_180495_p(new BlockPos(xCheck + x, yCheck, zCheck + z)));
                for (ItemStack oreStack : types) {
                    if (!oreStack.func_77969_a(stack)) continue;
                    return true;
                }
            }
        }
        if (this.func_145832_p() == 2) {
            for (i = 0; i < names.length; ++i) {
                stack = OreStackHelper.blockToStack(this.field_145850_b.func_180495_p(new BlockPos(xCheck - z, yCheck, zCheck + x)));
                for (ItemStack oreStack : types) {
                    if (!oreStack.func_77969_a(stack)) continue;
                    return true;
                }
            }
        }
        if (this.func_145832_p() == 5) {
            for (i = 0; i < names.length; ++i) {
                stack = OreStackHelper.blockToStack(this.field_145850_b.func_180495_p(new BlockPos(xCheck - x, yCheck, zCheck - z)));
                for (ItemStack oreStack : types) {
                    if (!oreStack.func_77969_a(stack)) continue;
                    return true;
                }
            }
        }
        if (this.func_145832_p() == 3) {
            for (i = 0; i < names.length; ++i) {
                stack = OreStackHelper.blockToStack(this.field_145850_b.func_180495_p(new BlockPos(xCheck + z, yCheck, zCheck - x)));
                for (ItemStack oreStack : types) {
                    if (!oreStack.func_77969_a(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean find(int x, int y, int z, Object ... blocks) {
        int i;
        int xCheck = this.func_174877_v().func_177958_n();
        int yCheck = this.func_174877_v().func_177956_o() + y;
        int zCheck = this.func_174877_v().func_177952_p();
        if (this.func_145832_p() == 4) {
            for (i = 0; i < blocks.length; ++i) {
                if (!(blocks[i] instanceof IBlockState)) continue;
                if (this.field_145850_b.func_180495_p(new BlockPos(xCheck + x, yCheck, zCheck + z)) == blocks[i]) {
                    return true;
                }
                if (!(blocks[i] instanceof Block) || this.field_145850_b.func_180495_p(new BlockPos(xCheck + x, yCheck, zCheck + z)).func_177230_c() != blocks[i]) continue;
                return true;
            }
        }
        if (this.func_145832_p() == 2) {
            for (i = 0; i < blocks.length; ++i) {
                if (!(blocks[i] instanceof IBlockState)) continue;
                if (this.field_145850_b.func_180495_p(new BlockPos(xCheck - z, yCheck, zCheck + x)) == blocks[i]) {
                    return true;
                }
                if (!(blocks[i] instanceof Block) || this.field_145850_b.func_180495_p(new BlockPos(xCheck - z, yCheck, zCheck + x)).func_177230_c() != blocks[i]) continue;
                return true;
            }
        }
        if (this.func_145832_p() == 5) {
            for (i = 0; i < blocks.length; ++i) {
                if (!(blocks[i] instanceof IBlockState)) continue;
                if (this.field_145850_b.func_180495_p(new BlockPos(xCheck - x, yCheck, zCheck - z)) == blocks[i]) {
                    return true;
                }
                if (!(blocks[i] instanceof Block) || this.field_145850_b.func_180495_p(new BlockPos(xCheck - x, yCheck, zCheck - z)).func_177230_c() != blocks[i]) continue;
                return true;
            }
        }
        if (this.func_145832_p() == 3) {
            for (i = 0; i < blocks.length; ++i) {
                if (!(blocks[i] instanceof IBlockState)) continue;
                if (this.field_145850_b.func_180495_p(new BlockPos(xCheck + z, yCheck, zCheck - x)) == blocks[i]) {
                    return true;
                }
                if (!(blocks[i] instanceof Block) || this.field_145850_b.func_180495_p(new BlockPos(xCheck + z, yCheck, zCheck - x)).func_177230_c() != blocks[i]) continue;
                return true;
            }
        }
        return false;
    }

    private IBlockState getBlockState(int x, int y, int z) {
        int xCheck = this.func_174877_v().func_177958_n();
        int yCheck = this.func_174877_v().func_177956_o() + y;
        int zCheck = this.func_174877_v().func_177952_p();
        if (this.func_145832_p() == 4) {
            return this.field_145850_b.func_180495_p(new BlockPos(xCheck + x, yCheck, zCheck + z));
        }
        if (this.func_145832_p() == 2) {
            return this.field_145850_b.func_180495_p(new BlockPos(xCheck - z, yCheck, zCheck + x));
        }
        if (this.func_145832_p() == 5) {
            return this.field_145850_b.func_180495_p(new BlockPos(xCheck - x, yCheck, zCheck - z));
        }
        if (this.func_145832_p() == 3) {
            return this.field_145850_b.func_180495_p(new BlockPos(xCheck + z, yCheck, zCheck - x));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private BlockPos position(int x, int y, int z) {
        int xCheck = this.func_174877_v().func_177958_n();
        int yCheck = this.func_174877_v().func_177956_o() + y;
        int zCheck = this.func_174877_v().func_177952_p();
        if (this.func_145832_p() == 4) {
            return new BlockPos(xCheck + x, yCheck, zCheck + z);
        }
        if (this.func_145832_p() == 2) {
            return new BlockPos(xCheck - z, yCheck, zCheck + x);
        }
        if (this.func_145832_p() == 5) {
            return new BlockPos(xCheck - x, yCheck, zCheck - z);
        }
        if (this.func_145832_p() == 3) {
            return new BlockPos(xCheck + z, yCheck, zCheck - x);
        }
        return new BlockPos(xCheck + x, yCheck, zCheck + z);
    }

    private boolean adjacentOr(int x, int y, int z, Object ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            if (this.find(x + 1, y, z, blocks[i])) {
                return true;
            }
            if (this.find(x - 1, y, z, blocks[i])) {
                return true;
            }
            if (this.find(x, y + 1, z, blocks[i])) {
                return true;
            }
            if (this.find(x, y - 1, z, blocks[i])) {
                return true;
            }
            if (this.find(x, y, z + 1, blocks[i])) {
                return true;
            }
            if (!this.find(x, y, z - 1, blocks[i])) continue;
            return true;
        }
        return false;
    }

    private boolean adjacentAnd(int x, int y, int z, Object ... blocks) {
        if (blocks.length > 6) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < blocks.length; ++i) {
            if (this.find(x + 1, y, z, blocks[i])) {
                ++count;
                continue;
            }
            if (this.find(x - 1, y, z, blocks[i])) {
                ++count;
                continue;
            }
            if (this.find(x, y + 1, z, blocks[i])) {
                ++count;
                continue;
            }
            if (this.find(x, y - 1, z, blocks[i])) {
                ++count;
                continue;
            }
            if (this.find(x, y, z + 1, blocks[i])) {
                ++count;
                continue;
            }
            if (!this.find(x, y, z - 1, blocks[i])) continue;
            ++count;
        }
        return count >= blocks.length;
    }

    private boolean surrounding(int x, int y, int z, Object ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            if (!this.find(x + 1, y, z, blocks[i]) || !this.find(x - 1, y, z, blocks[i]) || !this.find(x, y + 1, z, blocks[i]) || !this.find(x, y - 1, z, blocks[i]) || !this.find(x, y, z + 1, blocks[i]) || !this.find(x, y, z - 1, blocks[i])) continue;
            return true;
        }
        return false;
    }

    private boolean betweenOr(int x, int y, int z, Object ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            if (this.find(x + 1, y, z, blocks[i]) && this.find(x - 1, y, z, blocks[i])) {
                return true;
            }
            if (this.find(x, y + 1, z, blocks[i]) && this.find(x, y - 1, z, blocks[i])) {
                return true;
            }
            if (!this.find(x, y, z + 1, blocks[i]) || !this.find(x, y, z - 1, blocks[i])) continue;
            return true;
        }
        return false;
    }

    private boolean betweenAnd(int x, int y, int z, Object ... blocks) {
        if (blocks.length > 3) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < blocks.length; ++i) {
            if (this.find(x + 1, y, z, blocks[i])) {
                if (!this.find(x - 1, y, z, blocks[i])) continue;
                ++count;
                continue;
            }
            if (this.find(x, y + 1, z, blocks[i])) {
                if (!this.find(x, y - 1, z, blocks[i])) continue;
                ++count;
                continue;
            }
            if (!this.find(x, y, z + 1, blocks[i]) || !this.find(x, y, z - 1, blocks[i])) continue;
            ++count;
        }
        return count >= blocks.length;
    }

    private boolean sandwich(int x, int y, int z, Object block) {
        if (this.find(x + 1, y, z, block) && this.find(x - 1, y, z, block)) {
            if (this.find(x, y + 1, z, block) && this.find(x, y - 1, z, block)) {
                return true;
            }
            if (this.find(x, y, z + 1, block) && this.find(x, y, z - 1, block)) {
                return true;
            }
        }
        return this.find(x, y + 1, z, block) && this.find(x, y - 1, z, block) && this.find(x, y, z + 1, block) && this.find(x, y, z - 1, block);
    }

    private int adjacent(int x, int y, int z, Object ... block) {
        int count = 0;
        if (this.find(x + 1, y, z, block)) {
            ++count;
        }
        if (this.find(x - 1, y, z, block)) {
            ++count;
        }
        if (this.find(x, y + 1, z, block)) {
            ++count;
        }
        if (this.find(x, y - 1, z, block)) {
            ++count;
        }
        if (this.find(x, y, z + 1, block)) {
            ++count;
        }
        if (this.find(x, y, z - 1, block)) {
            ++count;
        }
        return count;
    }

    private boolean findCooler(int x, int y, int z, int meta) {
        if (this.getBlockState(x, y, z).func_177230_c() instanceof BlockCooler) {
            return ((BlockCooler)this.getBlockState(x, y, z).func_177230_c()).func_176201_c(this.getBlockState(x, y, z)) == meta;
        }
        return false;
    }

    private int adjacentToActiveGraphite(int x, int y, int z) {
        String graphite = "blockGraphite";
        IBlockState cell = NCBlocks.cell_block.func_176223_P();
        int count = 0;
        if (this.findFromOreName(x + 1, y, z, graphite) && this.adjacentOr(x + 1, y, z, cell)) {
            ++count;
        }
        if (this.findFromOreName(x - 1, y, z, graphite) && this.adjacentOr(x - 1, y, z, cell)) {
            ++count;
        }
        if (this.findFromOreName(x, y + 1, z, graphite) && this.adjacentOr(x, y + 1, z, cell)) {
            ++count;
        }
        if (this.findFromOreName(x, y - 1, z, graphite) && this.adjacentOr(x, y - 1, z, cell)) {
            ++count;
        }
        if (this.findFromOreName(x, y, z + 1, graphite) && this.adjacentOr(x, y, z + 1, cell)) {
            ++count;
        }
        if (this.findFromOreName(x, y, z - 1, graphite) && this.adjacentOr(x, y, z - 1, cell)) {
            ++count;
        }
        return count;
    }

    private boolean isAdjacentToActiveGraphite(int x, int y, int z) {
        String graphite = "blockGraphite";
        IBlockState cell = NCBlocks.cell_block.func_176223_P();
        if (this.findFromOreName(x + 1, y, z, graphite) && this.adjacentOr(x + 1, y, z, cell)) {
            return true;
        }
        if (this.findFromOreName(x - 1, y, z, graphite) && this.adjacentOr(x - 1, y, z, cell)) {
            return true;
        }
        if (this.findFromOreName(x, y + 1, z, graphite) && this.adjacentOr(x, y + 1, z, cell)) {
            return true;
        }
        if (this.findFromOreName(x, y - 1, z, graphite) && this.adjacentOr(x, y - 1, z, cell)) {
            return true;
        }
        if (this.findFromOreName(x, y, z + 1, graphite) && this.adjacentOr(x, y, z + 1, cell)) {
            return true;
        }
        return this.findFromOreName(x, y, z - 1, graphite) && this.adjacentOr(x, y, z - 1, cell);
    }

    private boolean isAdjacentToActiveCooler(int x, int y, int z, int meta) {
        ArrayList<int[]> posList = new ArrayList<int[]>();
        if (this.findCooler(x + 1, y, z, meta)) {
            posList.add(new int[]{x + 1, y, z});
        }
        if (this.findCooler(x - 1, y, z, meta)) {
            posList.add(new int[]{x - 1, y, z});
        }
        if (this.findCooler(x, y + 1, z, meta)) {
            posList.add(new int[]{x, y + 1, z});
        }
        if (this.findCooler(x, y - 1, z, meta)) {
            posList.add(new int[]{x, y - 1, z});
        }
        if (this.findCooler(x, y, z + 1, meta)) {
            posList.add(new int[]{x, y, z + 1});
        }
        if (this.findCooler(x, y, z - 1, meta)) {
            posList.add(new int[]{x, y, z - 1});
        }
        if (posList.isEmpty()) {
            return false;
        }
        for (int[] pos : posList) {
            IBlockState cell;
            Block trapdoor;
            Block door;
            Block buffer;
            Block port;
            IBlockState casing_transparent;
            IBlockState casing;
            if (!(meta == 1 ? this.adjacentOr(pos[0], pos[1], pos[2], casing = NCBlocks.fission_block.func_176203_a(0), casing_transparent = NCBlocks.reactor_casing_transparent.func_176223_P(), port = NCBlocks.fission_port, buffer = NCBlocks.buffer, door = NCBlocks.reactor_door, trapdoor = NCBlocks.reactor_trapdoor) : (meta == 2 ? this.adjacentOr(pos[0], pos[1], pos[2], cell = NCBlocks.cell_block.func_176223_P()) : meta == 3 && this.isAdjacentToActiveGraphite(pos[0], pos[1], pos[2])))) continue;
            return true;
        }
        return false;
    }

    private boolean findCasingPort(int x, int y, int z) {
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)) == NCBlocks.fission_block.func_176203_a(0)) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)) == NCBlocks.reactor_casing_transparent.func_176203_a(0)) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockFissionPort) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockBuffer) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() == NCBlocks.reactor_door) {
            return true;
        }
        return this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() == NCBlocks.reactor_trapdoor;
    }

    private boolean findController(int x, int y, int z) {
        return this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockFissionController;
    }

    private boolean findActiveCooler(int x, int y, int z) {
        return this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockActiveCooler;
    }

    private boolean findCasingControllerPort(int x, int y, int z) {
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)) == NCBlocks.fission_block.func_176203_a(0)) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)) == NCBlocks.reactor_casing_transparent.func_176203_a(0)) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockFissionController) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockFissionPort) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() instanceof BlockBuffer) {
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() == NCBlocks.reactor_door) {
            return true;
        }
        return this.field_145850_b.func_180495_p(this.position(x, y, z)).func_177230_c() == NCBlocks.reactor_trapdoor;
    }

    private String stringPos(BlockPos pos) {
        return "[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]";
    }

    private boolean checkStructure() {
        if (this.shouldStructureCheck()) {
            int y;
            int x;
            int y2;
            int z;
            int l = NCConfig.fission_max_size + 2;
            boolean f = false;
            int rz = 0;
            int z0 = 0;
            int x0 = 0;
            int y0 = 0;
            int z1 = 0;
            int x1 = 0;
            int y1 = 0;
            for (z = 0; z <= l; ++z) {
                if (this.findCasingPort(0, 1, 0) || this.findCasingPort(0, -1, 0) || (this.findCasingPort(1, 1, 0) || this.findCasingPort(1, -1, 0)) && this.findCasingPort(1, 0, 0) || this.findCasingPort(1, 1, 0) && !this.findCasingPort(1, -1, 0) && !this.findCasingPort(1, 0, 0) || !this.findCasingPort(1, 1, 0) && this.findCasingPort(1, -1, 0) && !this.findCasingPort(1, 0, 0)) {
                    if (this.findCasingPort(0, 1, -z) || this.findCasingPort(0, -1, -z) || !this.findCasingControllerPort(0, 0, -z + 1) && !this.findCasingControllerPort(0, 1, -z + 1) && !this.findCasingControllerPort(0, -1, -z + 1)) continue;
                    rz = l - z;
                    z0 = -z;
                    f = true;
                    break;
                }
                if (this.findCasingPort(0, 0, -z) || this.findCasingPort(1, 1, -z) || this.findCasingPort(1, -1, -z) || !this.findCasingControllerPort(0, 0, -z + 1) || !this.findCasingPort(1, 0, -z) || !this.findCasingPort(1, 1, -z + 1) || !this.findCasingPort(1, -1, -z + 1)) continue;
                rz = l - z;
                z0 = -z;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete", (Object[])new Object[0]);
                this.problemPosBool = 0;
                return false;
            }
            f = false;
            for (y2 = 0; y2 <= l; ++y2) {
                if (this.findCasingPort(x0, -y2 + 1, z0) || this.findCasingPort(x0 + 1, -y2, z0) || this.findCasingPort(x0, -y2, z0 + 1) || !this.findCasingControllerPort(x0 + 1, -y2, z0 + 1) || !this.findCasingControllerPort(x0, -y2 + 1, z0 + 1) || !this.findCasingControllerPort(x0 + 1, -y2 + 1, z0)) continue;
                y0 = -y2;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete", (Object[])new Object[0]);
                this.problemPosBool = 0;
                return false;
            }
            f = false;
            for (z = 0; z <= rz; ++z) {
                if (this.findCasingPort(x0, y0 + 1, z) || this.findCasingPort(x0 + 1, y0, z) || this.findCasingPort(x0, y0, z - 1) || !this.findCasingControllerPort(x0 + 1, y0, z - 1) || !this.findCasingControllerPort(x0, y0 + 1, z - 1) || !this.findCasingControllerPort(x0 + 1, y0 + 1, z)) continue;
                z1 = z;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete", (Object[])new Object[0]);
                this.problemPosBool = 0;
                return false;
            }
            f = false;
            for (int x2 = 0; x2 <= l; ++x2) {
                if (this.findCasingPort(x0 + x2, y0 + 1, z0) || this.findCasingPort(x0 + x2 - 1, y0, z0) || this.findCasingPort(x0 + x2, y0, z0 + 1) || !this.findCasingControllerPort(x0 + x2 - 1, y0, z0 + 1) || !this.findCasingControllerPort(x0 + x2, y0 + 1, z0 + 1) || !this.findCasingControllerPort(x0 + x2 - 1, y0 + 1, z0)) continue;
                x1 = x0 + x2;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete", (Object[])new Object[0]);
                this.problemPosBool = 0;
                return false;
            }
            f = false;
            for (y2 = 0; y2 <= l; ++y2) {
                if (this.findCasingPort(x0, y0 + y2 - 1, z0) || this.findCasingPort(x0 + 1, y0 + y2, z0) || this.findCasingPort(x0, y0 + y2, z0 + 1) || !this.findCasingControllerPort(x0 + 1, y0 + y2, z0 + 1) || !this.findCasingControllerPort(x0, y0 + y2 - 1, z0 + 1) || !this.findCasingControllerPort(x0 + 1, y0 + y2 - 1, z0)) continue;
                y1 = y0 + y2;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete", (Object[])new Object[0]);
                this.problemPosBool = 0;
                return false;
            }
            f = false;
            if (x0 > 0 || x1 < 0 || y0 > 0 || y1 < 0 || z0 > 0 || z1 < 0 || x1 - x0 < 1 || y1 - y0 < 1 || z1 - z0 < 1) {
                this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.invalid_structure", (Object[])new Object[0]);
                this.complete = 0;
                this.problemPosBool = 0;
                return false;
            }
            for (z = z0; z <= z1; ++z) {
                for (x = x0; x <= x1; ++x) {
                    for (y = y0; y <= y1; ++y) {
                        if (!this.findController(x, y, z) || x == 0 && y == 0 && z == 0) continue;
                        this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.multiple_controllers", (Object[])new Object[0]);
                        this.complete = 0;
                        this.problemPosBool = 1;
                        this.problemPosX = x;
                        this.problemPosY = y;
                        this.problemPosZ = z;
                        this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                }
            }
            for (z = z0 + 1; z <= z1 - 1; ++z) {
                for (x = x0 + 1; x <= x1 - 1; ++x) {
                    if (!(this.findCasingPort(x, y0, z) || x == 0 && y0 == 0 && z == 0)) {
                        this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete_at", (Object[])new Object[0]);
                        this.complete = 0;
                        this.problemPosBool = 1;
                        this.problemPosX = x;
                        this.problemPosY = y0;
                        this.problemPosZ = z;
                        this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (this.findCasingPort(x, y1, z) || x == 0 && y1 == 0 && z == 0) continue;
                    this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete_at", (Object[])new Object[0]);
                    this.complete = 0;
                    this.problemPosBool = 1;
                    this.problemPosX = x;
                    this.problemPosY = y1;
                    this.problemPosZ = z;
                    this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                    return false;
                }
            }
            for (y2 = y0 + 1; y2 <= y1 - 1; ++y2) {
                for (x = x0 + 1; x <= x1 - 1; ++x) {
                    if (!(this.findCasingPort(x, y2, z0) || x == 0 && y2 == 0 && z0 == 0)) {
                        this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete_at", (Object[])new Object[0]);
                        this.complete = 0;
                        this.problemPosBool = 1;
                        this.problemPosX = x;
                        this.problemPosY = y2;
                        this.problemPosZ = z0;
                        this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (this.findCasingPort(x, y2, z1) || x == 0 && y2 == 0 && z1 == 0) continue;
                    this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete_at", (Object[])new Object[0]);
                    this.complete = 0;
                    this.problemPosBool = 1;
                    this.problemPosX = x;
                    this.problemPosY = y2;
                    this.problemPosZ = z1;
                    this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                    return false;
                }
                for (int z2 = z0 + 1; z2 <= z1 - 1; ++z2) {
                    if (!(this.findCasingPort(x0, y2, z2) || x0 == 0 && y2 == 0 && z2 == 0)) {
                        this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete_at", (Object[])new Object[0]);
                        this.complete = 0;
                        this.problemPosBool = 1;
                        this.problemPosX = x0;
                        this.problemPosY = y2;
                        this.problemPosZ = z2;
                        this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                    if (this.findCasingPort(x1, y2, z2) || x1 == 0 && y2 == 0 && z2 == 0) continue;
                    this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_incomplete_at", (Object[])new Object[0]);
                    this.complete = 0;
                    this.problemPosBool = 1;
                    this.problemPosX = x1;
                    this.problemPosY = y2;
                    this.problemPosZ = z2;
                    this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                    return false;
                }
            }
            for (z = z0 + 1; z <= z1 - 1; ++z) {
                for (x = x0 + 1; x <= x1 - 1; ++x) {
                    for (y = y0 + 1; y <= y1 - 1; ++y) {
                        if (!this.findCasingControllerPort(x, y, z)) continue;
                        this.problem = I18n.func_74837_a((String)"gui.container.fission_controller.casing_in_interior", (Object[])new Object[0]);
                        this.complete = 0;
                        this.problemPosBool = 1;
                        this.problemPosX = x;
                        this.problemPosY = y;
                        this.problemPosZ = z;
                        this.problemPos = this.stringPos(this.position(this.problemPosX, this.problemPosY, this.problemPosZ));
                        return false;
                    }
                }
            }
            this.complete = 1;
            this.problemPosBool = 0;
            this.minX = x0;
            this.minY = y0;
            this.minZ = z0;
            this.maxX = x1;
            this.maxY = y1;
            this.maxZ = z1;
            this.lengthX = x1 + 1 - x0;
            this.lengthY = y1 + 1 - y0;
            this.lengthZ = z1 + 1 - z0;
            this.setCapacity();
            return true;
        }
        return this.complete == 1;
    }

    private boolean atLimit(int x, int y, int z, int divider) {
        return x * y * z > Integer.MAX_VALUE / divider;
    }

    private void setCapacity() {
        this.storage.setStorageCapacity(this.getNewCapacity());
        this.storage.setMaxTransfer(this.getNewCapacity());
    }

    private int getNewCapacity() {
        if (this.atLimit(this.getLengthX(), this.getLengthY(), this.getLengthZ(), 64000)) {
            return Integer.MAX_VALUE;
        }
        if (this.getLengthX() <= 0 || this.getLengthY() <= 0 || this.getLengthZ() <= 0) {
            return 64000;
        }
        return 64000 * this.getLengthX() * this.getLengthY() * this.getLengthZ();
    }

    private void run() {
        double energyThisTick = 0.0;
        double fuelThisTick = 0.0;
        double heatThisTick = 0.0;
        double coolerHeatThisTick = 0.0;
        double numberOfCells = 0.0;
        double extraCells = 0.0;
        double adj1 = 0.0;
        double adj2 = 0.0;
        double adj3 = 0.0;
        double adj4 = 0.0;
        double adj5 = 0.0;
        double adj6 = 0.0;
        boolean generating = false;
        double baseRF = this.getBasePower();
        this.processTime = (int)this.getBaseTime();
        double baseHeat = this.getBaseHeat();
        String graphite = "blockGraphite";
        IBlockState cell = NCBlocks.cell_block.func_176223_P();
        IBlockState casing = NCBlocks.fission_block.func_176203_a(0);
        IBlockState casing_transparent = NCBlocks.reactor_casing_transparent.func_176223_P();
        Block port = NCBlocks.fission_port;
        Block buffer = NCBlocks.buffer;
        Block door = NCBlocks.reactor_door;
        Block trapdoor = NCBlocks.reactor_trapdoor;
        IBlockState[] cooler = new IBlockState[EnumHandler.CoolerTypes.values().length];
        for (int i = 0; i < EnumHandler.CoolerTypes.values().length; ++i) {
            cooler[i] = NCBlocks.cooler.func_176203_a(i);
        }
        if (this.canProcess() && this.isPowered()) {
            this.ready = 0;
            generating = true;
        } else if (this.canProcess() && !this.isPowered()) {
            this.ready = 1;
            generating = false;
        } else {
            this.ready = 0;
            generating = false;
        }
        if (this.shouldRunCheck()) {
            int y;
            int x;
            int z;
            if (this.complete == 1) {
                for (z = this.minZ + 1; z <= this.maxZ - 1; ++z) {
                    for (x = this.minX + 1; x <= this.maxX - 1; ++x) {
                        for (y = this.minY + 1; y <= this.maxY - 1; ++y) {
                            if (!this.find(x, y, z, cell)) continue;
                            extraCells = 0.0;
                            if (this.find(x + 1, y, z, cell) || this.findFromOreName(x + 1, y, z, graphite) && this.find(x + 2, y, z, cell)) {
                                extraCells += 1.0;
                            }
                            if (this.find(x - 1, y, z, cell) || this.findFromOreName(x - 1, y, z, graphite) && this.find(x - 2, y, z, cell)) {
                                extraCells += 1.0;
                            }
                            if (this.find(x, y + 1, z, cell) || this.findFromOreName(x, y + 1, z, graphite) && this.find(x, y + 2, z, cell)) {
                                extraCells += 1.0;
                            }
                            if (this.find(x, y - 1, z, cell) || this.findFromOreName(x, y - 1, z, graphite) && this.find(x, y - 2, z, cell)) {
                                extraCells += 1.0;
                            }
                            if (this.find(x, y, z + 1, cell) || this.findFromOreName(x, y, z + 1, graphite) && this.find(x, y, z + 2, cell)) {
                                extraCells += 1.0;
                            }
                            if (this.find(x, y, z - 1, cell) || this.findFromOreName(x, y, z - 1, graphite) && this.find(x, y, z - 2, cell)) {
                                extraCells += 1.0;
                            }
                            if (extraCells == 0.0) {
                                numberOfCells += 1.0;
                                continue;
                            }
                            if (extraCells == 1.0) {
                                adj1 += 1.0;
                                continue;
                            }
                            if (extraCells == 2.0) {
                                adj2 += 1.0;
                                continue;
                            }
                            if (extraCells == 3.0) {
                                adj3 += 1.0;
                                continue;
                            }
                            if (extraCells == 4.0) {
                                adj4 += 1.0;
                                continue;
                            }
                            if (extraCells == 5.0) {
                                adj5 += 1.0;
                                continue;
                            }
                            if (extraCells != 6.0) continue;
                            adj6 += 1.0;
                        }
                    }
                }
            }
            if (this.ready == 1 || generating) {
                energyThisTick += NCConfig.fission_power * baseRF * (numberOfCells + 2.0 * adj1 + 3.0 * adj2 + 4.0 * adj3 + 5.0 * adj4 + 6.0 * adj5 + 7.0 * adj6);
                heatThisTick += NCConfig.fission_heat_generation * baseHeat * (numberOfCells + 3.0 * adj1 + 6.0 * adj2 + 10.0 * adj3 + 15.0 * adj4 + 21.0 * adj5 + 28.0 * adj6);
                if (generating) {
                    fuelThisTick += (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) * NCConfig.fission_fuel_use;
                }
                for (z = this.minZ + 1; z <= this.maxZ - 1; ++z) {
                    for (x = this.minX + 1; x <= this.maxX - 1; ++x) {
                        for (y = this.minY + 1; y <= this.maxY - 1; ++y) {
                            if (!this.findFromOreName(x, y, z, graphite)) continue;
                            heatThisTick += NCConfig.fission_heat_generation * baseRF * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) / 16.0;
                            if (!this.adjacentOr(x, y, z, cell)) continue;
                            energyThisTick += NCConfig.fission_power * baseRF * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) / 8.0;
                        }
                    }
                }
            }
            if (this.complete == 1) {
                for (z = this.minZ + 1; z <= this.maxZ - 1; ++z) {
                    for (x = this.minX + 1; x <= this.maxX - 1; ++x) {
                        for (y = this.minY + 1; y <= this.maxY - 1; ++y) {
                            Tank tank;
                            int fluidAmount;
                            TileEntity tile;
                            if (this.findCooler(x, y, z, 1)) {
                                if (!NCConfig.fission_water_cooler_requirement) {
                                    coolerHeatThisTick -= NCConfig.fission_cooling_rate[0];
                                } else if (this.adjacentOr(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor)) {
                                    coolerHeatThisTick -= NCConfig.fission_cooling_rate[0];
                                }
                            }
                            if (this.findCooler(x, y, z, 2) && this.adjacentOr(x, y, z, cell)) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[1];
                            }
                            if (this.findCooler(x, y, z, 3) && this.isAdjacentToActiveGraphite(x, y, z)) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[2];
                            }
                            if (this.findCooler(x, y, z, 4) && this.isAdjacentToActiveCooler(x, y, z, 1) && this.isAdjacentToActiveCooler(x, y, z, 2)) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[3];
                            }
                            if (this.findCooler(x, y, z, 5) && this.adjacentToActiveGraphite(x, y, z) >= 2) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[4];
                            }
                            if (this.findCooler(x, y, z, 6) && this.adjacentOr(x, y, z, cell) && this.adjacentOr(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor)) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[5];
                            }
                            if (this.findCooler(x, y, z, 7) && this.sandwich(x, y, z, cooler[1]) && (this.adjacentOr(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor) || !NCConfig.fission_water_cooler_requirement)) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[6];
                            }
                            if (this.findCooler(x, y, z, 8) && this.adjacentOr(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor) && this.isAdjacentToActiveCooler(x, y, z, 3)) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[7];
                            }
                            if (this.findCooler(x, y, z, 9) && this.adjacent(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor) >= 3) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[8];
                            }
                            if (this.findCooler(x, y, z, 10) && this.adjacent(x, y, z, cell) >= 2) {
                                coolerHeatThisTick -= NCConfig.fission_cooling_rate[9];
                            }
                            if (!this.findActiveCooler(x, y, z) || (tile = this.field_145850_b.func_175625_s(this.position(x, y, z))) == null || !(tile instanceof TileActiveCooler) || (fluidAmount = (tank = ((TileActiveCooler)tile).getTanks()[0]).getFluidAmount()) <= 0) continue;
                            double amountModified = (double)fluidAmount / (2.0 * (double)NCConfig.fission_update_rate);
                            double currentHeat = (double)this.heat + heatThisTick + coolerHeatThisTick;
                            if (tank.getFluidName() == "water") {
                                if (!NCConfig.fission_water_cooler_requirement) {
                                    coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[0] * amountModified;
                                } else if (this.adjacentOr(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor)) {
                                    coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[0] * amountModified;
                                }
                            } else if (tank.getFluidName() == "redstone") {
                                if (this.adjacentOr(x, y, z, cell)) {
                                    coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[1] * amountModified;
                                }
                            } else if (tank.getFluidName() == "glowstone") {
                                if (this.adjacentToActiveGraphite(x, y, z) >= 2) {
                                    coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[2] * amountModified;
                                }
                            } else if (tank.getFluidName() == "liquidhelium") {
                                if (this.adjacentOr(x, y, z, casing, casing_transparent, port, buffer, door, trapdoor) && this.isAdjacentToActiveCooler(x, y, z, 3)) {
                                    coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[3] * amountModified;
                                }
                            } else if (tank.getFluidName() == "ender") {
                                if (this.adjacent(x, y, z, casing, port, buffer, door, trapdoor) >= 3) {
                                    coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[4] * amountModified;
                                }
                            } else if (tank.getFluidName() == "cryotheum" && this.adjacent(x, y, z, cell) >= 2) {
                                coolerHeatThisTick -= NCConfig.fission_active_cooling_rate[5] * amountModified;
                            }
                            if (this.ready != 0 || !generating || !(currentHeat > 0.0)) continue;
                            double newHeat = (double)this.heat + heatThisTick + coolerHeatThisTick;
                            if (newHeat >= 0.0) {
                                ((TileActiveCooler)this.field_145850_b.func_175625_s(this.position(x, y, z))).getTanks()[0].drain(fluidAmount, true);
                                continue;
                            }
                            double heatFraction = currentHeat / (currentHeat - newHeat);
                            ((TileActiveCooler)this.field_145850_b.func_175625_s(this.position(x, y, z))).getTanks()[0].drain((int)((double)fluidAmount * heatFraction), true);
                        }
                    }
                }
            }
            if (this.complete == 1) {
                this.heatChange = (int)(heatThisTick + coolerHeatThisTick);
                this.cooling = (int)coolerHeatThisTick;
                this.efficiency = (int)(100.0 * energyThisTick / (NCConfig.fission_power * baseRF * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6)));
                this.cells = (int)(numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6);
                this.setProcessPower((int)energyThisTick);
                this.setRateMultiplier((int)fuelThisTick);
            } else {
                this.heatChange = 0;
                this.cooling = 0;
                this.efficiency = 0;
                this.cells = 0;
                this.setProcessPower(0);
                this.setRateMultiplier(0);
            }
        }
        if (this.ready == 0 && generating) {
            this.heat = this.heat + this.heatChange >= 0 ? (this.heat += this.heatChange) : 0;
        } else if (this.ready == 1 && !generating || this.complete == 1) {
            this.heat = this.heat + this.cooling >= 0 ? (this.heat += this.cooling) : 0;
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("processPower", this.processPower);
        nbt.func_74768_a("rateMultiplier", this.rateMultiplier);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("cooling", this.cooling);
        nbt.func_74768_a("efficiency", this.efficiency);
        nbt.func_74768_a("cells", this.cells);
        nbt.func_74768_a("minX", this.minX);
        nbt.func_74768_a("minY", this.minY);
        nbt.func_74768_a("minZ", this.minZ);
        nbt.func_74768_a("maxX", this.maxX);
        nbt.func_74768_a("maxY", this.maxY);
        nbt.func_74768_a("maxZ", this.maxZ);
        nbt.func_74768_a("lengthX", this.lengthX);
        nbt.func_74768_a("lengthY", this.lengthY);
        nbt.func_74768_a("lengthZ", this.lengthZ);
        nbt.func_74768_a("heatChange", this.heatChange);
        nbt.func_74768_a("complete", this.complete);
        nbt.func_74768_a("ready", this.ready);
        nbt.func_74778_a("problem", this.problem);
        nbt.func_74778_a("problemPos", this.problemPos);
        nbt.func_74768_a("problemPosX", this.problemPosX);
        nbt.func_74768_a("problemPosY", this.problemPosY);
        nbt.func_74768_a("problemPosZ", this.problemPosZ);
        nbt.func_74768_a("problemPosBool", this.problemPosBool);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.processPower = nbt.func_74762_e("processPower");
        this.rateMultiplier = nbt.func_74762_e("rateMultiplier");
        this.heat = nbt.func_74762_e("heat");
        this.cooling = nbt.func_74762_e("cooling");
        this.efficiency = nbt.func_74762_e("efficiency");
        this.cells = nbt.func_74762_e("cells");
        this.minX = nbt.func_74762_e("minX");
        this.minY = nbt.func_74762_e("minY");
        this.minZ = nbt.func_74762_e("minZ");
        this.maxX = nbt.func_74762_e("maxX");
        this.maxY = nbt.func_74762_e("maxY");
        this.maxZ = nbt.func_74762_e("maxZ");
        this.lengthX = nbt.func_74762_e("lengthX");
        this.lengthY = nbt.func_74762_e("lengthY");
        this.lengthZ = nbt.func_74762_e("lengthZ");
        this.heatChange = nbt.func_74762_e("heatChange");
        this.complete = nbt.func_74762_e("complete");
        this.ready = nbt.func_74762_e("ready");
        this.problem = nbt.func_74779_i("problem");
        this.problemPos = nbt.func_74779_i("problemPos");
        this.problemPosX = nbt.func_74762_e("problemPosX");
        this.problemPosY = nbt.func_74762_e("problemPosY");
        this.problemPosZ = nbt.func_74762_e("problemPosZ");
        this.problemPosBool = nbt.func_74762_e("problemPosBool");
    }

    @Override
    public int func_174890_g() {
        return 19;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
            case 2: {
                return this.getProcessTime();
            }
            case 3: {
                return this.getProcessPower();
            }
            case 4: {
                return this.heat;
            }
            case 5: {
                return this.cooling;
            }
            case 6: {
                return this.efficiency;
            }
            case 7: {
                return this.cells;
            }
            case 8: {
                return this.getRateMultiplier();
            }
            case 9: {
                return this.lengthX;
            }
            case 10: {
                return this.lengthY;
            }
            case 11: {
                return this.lengthZ;
            }
            case 12: {
                return this.heatChange;
            }
            case 13: {
                return this.complete;
            }
            case 14: {
                return this.ready;
            }
            case 15: {
                return this.problemPosX;
            }
            case 16: {
                return this.problemPosY;
            }
            case 17: {
                return this.problemPosZ;
            }
            case 18: {
                return this.problemPosBool;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
                break;
            }
            case 2: {
                this.setProcessTime(value);
                break;
            }
            case 3: {
                this.setProcessPower(value);
                break;
            }
            case 4: {
                this.heat = value;
                break;
            }
            case 5: {
                this.cooling = value;
                break;
            }
            case 6: {
                this.efficiency = value;
                break;
            }
            case 7: {
                this.cells = value;
                break;
            }
            case 8: {
                this.setRateMultiplier(value);
                break;
            }
            case 9: {
                this.lengthX = value;
                break;
            }
            case 10: {
                this.lengthY = value;
                break;
            }
            case 11: {
                this.lengthZ = value;
                break;
            }
            case 12: {
                this.heatChange = value;
                break;
            }
            case 13: {
                this.complete = value;
                break;
            }
            case 14: {
                this.ready = value;
                break;
            }
            case 15: {
                this.problemPosX = value;
                break;
            }
            case 16: {
                this.problemPosY = value;
                break;
            }
            case 17: {
                this.problemPosZ = value;
                break;
            }
            case 18: {
                this.problemPosBool = value;
            }
        }
    }
}

