/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;
import nc.recipe.SorptionType;
import nc.tile.IGui;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.TileEnergySidedInventory;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public abstract class TileItemGenerator
extends TileEnergySidedInventory
implements IInterfaceable,
IGui {
    public final int inputSize;
    public final int outputSize;
    public final int otherSlotsSize;
    public int time;
    public boolean isGenerating;
    public boolean hasConsumed;
    public int tickCount;
    public final BaseRecipeHandler recipes;

    public TileItemGenerator(String name, int inSize, int outSize, int otherSize, int capacity, BaseRecipeHandler recipes) {
        super(name, 2 * inSize + outSize + otherSize, capacity, EnumStorage.EnergyConnection.OUT);
        this.inputSize = inSize;
        this.outputSize = outSize;
        this.otherSlotsSize = otherSize;
        this.recipes = recipes;
        int[] topSlots1 = new int[inSize];
        for (int i = 0; i < topSlots1.length; ++i) {
            topSlots1[i] = i;
        }
        this.topSlots = topSlots1;
        int[] sideSlots1 = new int[inSize + outSize];
        for (int i = 0; i < sideSlots1.length; ++i) {
            sideSlots1[i] = i;
        }
        this.sideSlots = sideSlots1;
        int[] bottomSlots1 = new int[outSize];
        for (int i = inSize; i < inSize + bottomSlots1.length; ++i) {
            bottomSlots1[i - inSize] = i;
        }
        this.bottomSlots = bottomSlots1;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateGenerator();
    }

    public void updateGenerator() {
        boolean flag = this.isGenerating;
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.time == 0) {
                this.consume();
            }
            if (this.canProcess() && this.isPowered()) {
                this.isGenerating = true;
                this.time += this.getRateMultiplier();
                this.storage.changeEnergyStored(this.getProcessPower());
                if (this.time >= this.getProcessTime()) {
                    this.time = 0;
                    this.output();
                }
            } else {
                this.isGenerating = false;
            }
            if (flag != this.isGenerating) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
                    this.addTileToENet();
                }
            }
            this.pushEnergy();
        } else {
            boolean bl = this.isGenerating = this.canProcess() && this.isPowered();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public abstract void setBlockState();

    public void tick() {
        this.tickCount = this.tickCount > NCConfig.generator_update_rate ? 0 : ++this.tickCount;
    }

    public boolean shouldCheck() {
        return this.tickCount > NCConfig.generator_update_rate;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.isGenerating = this.isGenerating();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.hasConsumed = this.hasConsumed();
        }
    }

    public boolean isGenerating() {
        if (this.field_145850_b.field_72995_K) {
            return this.isGenerating;
        }
        return this.isPowered() && this.time > 0;
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < this.inputSize; ++i) {
            if (((ItemStack)this.inventoryStacks.get(i + this.inputSize + this.outputSize + this.otherSlotsSize)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcess() {
        return this.canProcessStacks();
    }

    public abstract int getRateMultiplier();

    public abstract void setRateMultiplier(int var1);

    public abstract int getProcessTime();

    public abstract void setProcessTime(int var1);

    public abstract int getProcessPower();

    public abstract void setProcessPower(int var1);

    public boolean canProcessStacks() {
        Object[] output;
        for (int i = 0; i < this.inputSize; ++i) {
            if (!((ItemStack)this.inventoryStacks.get(i)).func_190926_b() || this.hasConsumed) continue;
            return false;
        }
        if (this.time >= this.getProcessTime()) {
            return true;
        }
        Object[] objectArray = output = this.hasConsumed ? this.outputs() : this.outputs();
        if (output == null || output.length != this.outputSize) {
            return false;
        }
        for (int j = 0; j < this.outputSize; ++j) {
            if (output[j] == ItemStack.field_190927_a || output[j] == null) {
                return false;
            }
            if (((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190926_b()) continue;
            if (!((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_77969_a((ItemStack)output[j])) {
                return false;
            }
            if (((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190916_E() + ((ItemStack)output[j]).func_190916_E() <= ((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void consume() {
        IRecipe recipe = this.getRecipe(false);
        Object[] outputs = this.outputs();
        int[] inputOrder = this.inputOrder();
        if (outputs == null || inputOrder == NCUtil.INVALID) {
            return;
        }
        if (!this.hasConsumed) {
            int i;
            for (i = 0; i < this.inputSize; ++i) {
                if (((ItemStack)this.inventoryStacks.get(i + this.inputSize + this.outputSize + this.otherSlotsSize)).func_190926_b()) continue;
                this.inventoryStacks.set(i + this.inputSize + this.outputSize + this.otherSlotsSize, (Object)ItemStack.field_190927_a);
            }
            for (i = 0; i < this.inputSize; ++i) {
                if (this.recipes != null) {
                    this.inventoryStacks.set(i + this.inputSize + this.outputSize + this.otherSlotsSize, (Object)new ItemStack(((ItemStack)this.inventoryStacks.get(i)).func_77973_b(), recipe.inputs().get(inputOrder[i]).getStackSize(), ((ItemStack)this.inventoryStacks.get(i)).func_77960_j()));
                    ((ItemStack)this.inventoryStacks.get(i)).func_190918_g(recipe.inputs().get(inputOrder[i]).getStackSize());
                } else {
                    this.inventoryStacks.set(i + this.inputSize + this.outputSize + this.otherSlotsSize, (Object)new ItemStack(((ItemStack)this.inventoryStacks.get(i)).func_77973_b(), 1, ((ItemStack)this.inventoryStacks.get(i)).func_77960_j()));
                    ((ItemStack)this.inventoryStacks.get(i)).func_190918_g(1);
                }
                if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() > 0) continue;
                this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
            }
            this.hasConsumed = true;
        }
    }

    public void output() {
        if (this.hasConsumed) {
            Object[] outputs = this.outputs();
            for (int j = 0; j < this.outputSize; ++j) {
                ItemStack outputStack = (ItemStack)outputs[j];
                if (((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190926_b()) {
                    this.inventoryStacks.set(j + this.inputSize, (Object)outputStack);
                    continue;
                }
                if (!((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_77969_a(outputStack)) continue;
                ((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190917_f(outputStack.func_190916_E());
            }
            for (int i = this.inputSize + this.outputSize + this.otherSlotsSize; i < 2 * this.inputSize + this.outputSize + this.otherSlotsSize; ++i) {
                this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
            }
            this.hasConsumed = false;
        }
    }

    public IRecipe getRecipe(boolean consumed) {
        return this.recipes.getRecipeFromInputs(consumed ? this.consumedInputs() : this.inputs());
    }

    public Object[] inputs() {
        Object[] input = new Object[this.inputSize];
        for (int i = 0; i < this.inputSize; ++i) {
            input[i] = this.inventoryStacks.get(i);
        }
        return input;
    }

    public Object[] consumedInputs() {
        Object[] input = new Object[this.inputSize];
        for (int i = 0; i < this.inputSize; ++i) {
            input[i] = this.inventoryStacks.get(i + this.inputSize + this.outputSize + this.otherSlotsSize);
        }
        return input;
    }

    public int[] inputOrder() {
        int[] inputOrder = new int[this.inputSize];
        IRecipe recipe = this.getRecipe(false);
        if (recipe == null) {
            return new int[0];
        }
        ArrayList<IIngredient> recipeIngredients = recipe.inputs();
        for (int i = 0; i < this.inputSize; ++i) {
            inputOrder[i] = -1;
            for (int j = 0; j < recipeIngredients.size(); ++j) {
                if (!recipeIngredients.get(j).matches(this.inputs()[i], SorptionType.INPUT)) continue;
                inputOrder[i] = j;
                break;
            }
            if (inputOrder[i] != -1) continue;
            return NCUtil.INVALID;
        }
        return inputOrder;
    }

    public Object[] outputs() {
        Object[] output = new Object[this.outputSize];
        IRecipe recipe = this.getRecipe(this.hasConsumed);
        if (recipe == null) {
            return null;
        }
        ArrayList<IIngredient> outputs = recipe.outputs();
        for (int i = 0; i < this.outputSize; ++i) {
            Object out = RecipeMethods.getIngredientFromList(outputs, i);
            if (out == null) {
                return null;
            }
            output[i] = out;
        }
        return output;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        if (slot >= this.inputSize && slot < this.inputSize + this.outputSize) {
            return false;
        }
        return this.recipes.isValidManualInput(stack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.bottomSlots : (side == EnumFacing.UP ? this.topSlots : this.sideSlots);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack) && direction != EnumFacing.DOWN;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.UP && slot >= this.inputSize && slot < this.inputSize + this.outputSize;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("time", this.time);
        nbt.func_74757_a("isGenerating", this.isGenerating);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74762_e("time");
        this.isGenerating = nbt.func_74767_n("isGenerating");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
            }
        }
    }
}

