/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import java.util.ArrayList;
import nc.config.NCConfig;
import nc.energy.EnumStorage;
import nc.init.NCItems;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.IRecipe;
import nc.recipe.RecipeMethods;
import nc.recipe.SorptionType;
import nc.tile.IGui;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.TileEnergySidedInventory;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public abstract class TileEnergyItemProcessor
extends TileEnergySidedInventory
implements IInterfaceable,
IGui {
    public final int defaultProcessTime;
    public int baseProcessTime;
    public final int baseProcessPower;
    public final int inputSize;
    public final int outputSize;
    public int time;
    public boolean isProcessing;
    public final boolean hasUpgrades;
    public final int upgradeMeta;
    public int tickCount;
    public final BaseRecipeHandler recipes;

    public TileEnergyItemProcessor(String name, int inSize, int outSize, int time, int power, BaseRecipeHandler recipes) {
        this(name, inSize, outSize, time, power, false, recipes, 1);
    }

    public TileEnergyItemProcessor(String name, int inSize, int outSize, int time, int power, BaseRecipeHandler recipes, int upgradeMeta) {
        this(name, inSize, outSize, time, power, true, recipes, upgradeMeta);
    }

    public TileEnergyItemProcessor(String name, int inSize, int outSize, int time, int power, boolean upgrades, BaseRecipeHandler recipes, int upgradeMeta) {
        super(name, inSize + outSize + (upgrades ? 2 : 0), 32000, power != 0 ? EnumStorage.EnergyConnection.IN : EnumStorage.EnergyConnection.NON);
        this.inputSize = inSize;
        this.outputSize = outSize;
        this.defaultProcessTime = time;
        this.baseProcessTime = time;
        this.baseProcessPower = power;
        this.hasUpgrades = upgrades;
        this.recipes = recipes;
        this.upgradeMeta = upgradeMeta;
        int[] topSlots1 = new int[inSize];
        for (int i = 0; i < topSlots1.length; ++i) {
            topSlots1[i] = i;
        }
        this.topSlots = topSlots1;
        int[] sideSlots1 = new int[inSize + outSize];
        for (int i = 0; i < sideSlots1.length; ++i) {
            sideSlots1[i] = i;
        }
        this.sideSlots = sideSlots1;
        int[] bottomSlots1 = new int[outSize];
        for (int i = inSize; i < inSize + bottomSlots1.length; ++i) {
            bottomSlots1[i - inSize] = i;
        }
        this.bottomSlots = bottomSlots1;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateProcessor();
    }

    public void updateProcessor() {
        boolean flag = this.isProcessing;
        boolean flag1 = false;
        this.setCapacityFromSpeed();
        if (!this.field_145850_b.field_72995_K) {
            this.tick();
            if (this.canProcess() && !this.isPowered()) {
                this.isProcessing = true;
                this.time += this.getSpeedMultiplier();
                this.storage.changeEnergyStored(-this.getProcessPower());
                if (this.time >= this.baseProcessTime) {
                    this.time = 0;
                    this.process();
                }
            } else {
                this.isProcessing = false;
                if (this.time != 0 && !this.isPowered()) {
                    this.time = MathHelper.func_76125_a((int)(this.time - 2 * this.getSpeedMultiplier()), (int)0, (int)this.baseProcessTime);
                }
            }
            if (flag != this.isProcessing) {
                flag1 = true;
                if (NCConfig.update_block_type) {
                    this.removeTileFromENet();
                    this.setBlockState();
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
                    this.addTileToENet();
                }
            }
        } else {
            boolean bl = this.isProcessing = this.canProcess() && !this.isPowered();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public abstract void setBlockState();

    public void tick() {
        this.tickCount = this.tickCount > NCConfig.processor_update_rate ? 0 : ++this.tickCount;
    }

    public boolean shouldCheck() {
        return this.tickCount > NCConfig.processor_update_rate;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.baseProcessTime = this.defaultProcessTime;
        if (!this.field_145850_b.field_72995_K) {
            this.isProcessing = this.isProcessing();
        }
    }

    public boolean isProcessing() {
        if (this.field_145850_b.field_72995_K) {
            return this.isProcessing;
        }
        return !this.isPowered() && this.canProcess();
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean canProcess() {
        return this.canProcessStacks();
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public int getSinkTier() {
        return 2;
    }

    public int getSpeedMultiplier() {
        if (!this.hasUpgrades) {
            return 1;
        }
        ItemStack speedStack = (ItemStack)this.inventoryStacks.get(this.inputSize + this.outputSize);
        if (speedStack == ItemStack.field_190927_a) {
            return 1;
        }
        return speedStack.func_190916_E() + 1;
    }

    public int getProcessTime() {
        return Math.max(1, this.baseProcessTime / this.getSpeedMultiplier());
    }

    public int getProcessPower() {
        return this.baseProcessPower * this.getSpeedMultiplier() * (this.getSpeedMultiplier() + 1) / 2;
    }

    public int getProcessEnergy() {
        return this.getProcessTime() * this.getProcessPower();
    }

    public void setCapacityFromSpeed() {
        this.storage.setStorageCapacity(MathHelper.func_76125_a((int)(2 * this.getProcessPower()), (int)32000, (int)Integer.MAX_VALUE));
    }

    public boolean canProcessStacks() {
        for (int i = 0; i < this.inputSize; ++i) {
            if (!((ItemStack)this.inventoryStacks.get(i)).func_190926_b()) continue;
            return false;
        }
        if (this.time >= this.baseProcessTime) {
            return true;
        }
        if (this.getProcessEnergy() > this.getMaxEnergyStored() && this.time <= 0 && this.getEnergyStored() < this.getMaxEnergyStored()) {
            return false;
        }
        if (this.getProcessEnergy() <= this.getMaxEnergyStored() && this.time <= 0 && this.getProcessEnergy() > this.getEnergyStored()) {
            return false;
        }
        if (this.getEnergyStored() < this.getProcessPower()) {
            return false;
        }
        Object[] outputs = this.outputs();
        if (outputs == null || outputs.length != this.outputSize) {
            return false;
        }
        for (int j = 0; j < this.outputSize; ++j) {
            if (outputs[j] == ItemStack.field_190927_a || outputs[j] == null) {
                return false;
            }
            if (((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190926_b()) continue;
            if (!((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_77969_a((ItemStack)outputs[j])) {
                return false;
            }
            if (((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190916_E() + ((ItemStack)outputs[j]).func_190916_E() <= ((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_77976_d()) continue;
            return false;
        }
        Object[] inputs = this.inputs();
        if (this.recipes.getRecipeFromInputs(inputs).extras().get(0) instanceof Integer) {
            this.baseProcessTime = (Integer)this.recipes.getRecipeFromInputs(inputs).extras().get(0);
        }
        return true;
    }

    public void process() {
        IRecipe recipe = this.getRecipe();
        Object[] outputs = this.outputs();
        int[] inputOrder = this.inputOrder();
        if (outputs == null || inputOrder == NCUtil.INVALID) {
            return;
        }
        for (int j = 0; j < this.outputSize; ++j) {
            ItemStack outputStack = (ItemStack)outputs[j];
            if (((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190926_b()) {
                this.inventoryStacks.set(j + this.inputSize, (Object)outputStack);
                continue;
            }
            if (!((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_77969_a(outputStack)) continue;
            ((ItemStack)this.inventoryStacks.get(j + this.inputSize)).func_190917_f(outputStack.func_190916_E());
        }
        for (int i = 0; i < this.inputSize; ++i) {
            if (this.recipes != null) {
                ((ItemStack)this.inventoryStacks.get(i)).func_190918_g(recipe.inputs().get(inputOrder[i]).getStackSize());
            } else {
                ((ItemStack)this.inventoryStacks.get(i)).func_190918_g(1);
            }
            if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() > 0) continue;
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public IRecipe getRecipe() {
        return this.recipes.getRecipeFromInputs(this.inputs());
    }

    public Object[] inputs() {
        Object[] input = new Object[this.inputSize];
        for (int i = 0; i < this.inputSize; ++i) {
            input[i] = this.inventoryStacks.get(i);
        }
        return input;
    }

    public int[] inputOrder() {
        int[] inputOrder = new int[this.inputSize];
        IRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return new int[0];
        }
        ArrayList<IIngredient> recipeIngredients = recipe.inputs();
        for (int i = 0; i < this.inputSize; ++i) {
            inputOrder[i] = -1;
            for (int j = 0; j < recipeIngredients.size(); ++j) {
                if (!recipeIngredients.get(j).matches(this.inputs()[i], SorptionType.INPUT)) continue;
                inputOrder[i] = j;
                break;
            }
            if (inputOrder[i] != -1) continue;
            return NCUtil.INVALID;
        }
        return inputOrder;
    }

    public Object[] outputs() {
        Object[] output = new Object[this.outputSize];
        IRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return null;
        }
        ArrayList<IIngredient> outputs = recipe.outputs();
        for (int i = 0; i < this.outputSize; ++i) {
            Object out = RecipeMethods.getIngredientFromList(outputs, i);
            if (out == null) {
                return null;
            }
            output[i] = out;
        }
        return output;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        if (this.hasUpgrades && stack.func_77973_b() == NCItems.upgrade) {
            if (slot == this.inputSize + this.outputSize) {
                return stack.func_77960_j() == 0;
            }
            if (slot == this.inputSize + this.outputSize + 1) {
                return stack.func_77960_j() == this.upgradeMeta;
            }
        }
        if (slot >= this.inputSize) {
            return false;
        }
        return this.recipes.isValidManualInput(stack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.bottomSlots : (side == EnumFacing.UP ? this.topSlots : this.sideSlots);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack) && direction != EnumFacing.DOWN;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.UP && slot >= this.inputSize && slot < this.inputSize + this.outputSize;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74762_e("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.getEnergyStored();
            }
            case 2: {
                return this.baseProcessTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
                break;
            }
            case 2: {
                this.baseProcessTime = value;
            }
        }
    }
}

