/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import nc.block.BlockOre;
import nc.config.NCConfig;
import nc.handler.EnumHandler;
import nc.init.NCBlocks;
import nc.worldgen.UniversalPredicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGen
implements IWorldGenerator {
    private WorldGenerator copper = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.COPPER)), NCConfig.ore_size[0], (Predicate)new UniversalPredicate());
    private WorldGenerator tin = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.TIN)), NCConfig.ore_size[1], (Predicate)new UniversalPredicate());
    private WorldGenerator lead = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.LEAD)), NCConfig.ore_size[2], (Predicate)new UniversalPredicate());
    private WorldGenerator thorium = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.THORIUM)), NCConfig.ore_size[3], (Predicate)new UniversalPredicate());
    private WorldGenerator uranium = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.URANIUM)), NCConfig.ore_size[4], (Predicate)new UniversalPredicate());
    private WorldGenerator boron = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.BORON)), NCConfig.ore_size[5], (Predicate)new UniversalPredicate());
    private WorldGenerator lithium = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.LITHIUM)), NCConfig.ore_size[6], (Predicate)new UniversalPredicate());
    private WorldGenerator magnesium = new WorldGenMinable(NCBlocks.ore.func_176223_P().func_177226_a((IProperty)BlockOre.TYPE, (Comparable)((Object)EnumHandler.OreTypes.MAGNESIUM)), NCConfig.ore_size[7], (Predicate)new UniversalPredicate());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        for (int i = 0; i < NCConfig.ore_dims.length; ++i) {
            dimList.add(NCConfig.ore_dims[i]);
        }
        if (dimList.contains(world.field_73011_w.getDimension()) != NCConfig.ore_dims_list_type) {
            this.generateOres(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal height arguments for WorldGenerator!");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    private void generateOres(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (NCConfig.ore_gen[0]) {
            this.runGenerator(this.copper, world, random, chunkX, chunkZ, NCConfig.ore_rate[0], NCConfig.ore_min_height[0], NCConfig.ore_max_height[0]);
        }
        if (NCConfig.ore_gen[1]) {
            this.runGenerator(this.tin, world, random, chunkX, chunkZ, NCConfig.ore_rate[1], NCConfig.ore_min_height[1], NCConfig.ore_max_height[1]);
        }
        if (NCConfig.ore_gen[2]) {
            this.runGenerator(this.lead, world, random, chunkX, chunkZ, NCConfig.ore_rate[2], NCConfig.ore_min_height[2], NCConfig.ore_max_height[2]);
        }
        if (NCConfig.ore_gen[3]) {
            this.runGenerator(this.thorium, world, random, chunkX, chunkZ, NCConfig.ore_rate[3], NCConfig.ore_min_height[3], NCConfig.ore_max_height[3]);
        }
        if (NCConfig.ore_gen[4]) {
            this.runGenerator(this.uranium, world, random, chunkX, chunkZ, NCConfig.ore_rate[4], NCConfig.ore_min_height[4], NCConfig.ore_max_height[4]);
        }
        if (NCConfig.ore_gen[5]) {
            this.runGenerator(this.boron, world, random, chunkX, chunkZ, NCConfig.ore_rate[5], NCConfig.ore_min_height[5], NCConfig.ore_max_height[5]);
        }
        if (NCConfig.ore_gen[6]) {
            this.runGenerator(this.lithium, world, random, chunkX, chunkZ, NCConfig.ore_rate[6], NCConfig.ore_min_height[6], NCConfig.ore_max_height[6]);
        }
        if (NCConfig.ore_gen[7]) {
            this.runGenerator(this.magnesium, world, random, chunkX, chunkZ, NCConfig.ore_rate[7], NCConfig.ore_min_height[7], NCConfig.ore_max_height[7]);
        }
    }

    public static boolean showOre(int i) {
        return NCConfig.ore_gen[i] || !NCConfig.hide_disabled_ores;
    }
}

