/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.blocks;

import com.chaosthedude.realistictorches.blocks.RealisticTorchesBlocks;
import com.chaosthedude.realistictorches.config.ConfigHandler;
import com.chaosthedude.realistictorches.items.RealisticTorchesItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RealisticTorchBlock
extends TorchBlock {
    public static final String NAME = "torch";
    protected static int initialBurnTime = (Integer)ConfigHandler.torchBurnoutTime.get();
    protected static final IntegerProperty BURNTIME = IntegerProperty.func_177719_a((String)"burntime", (int)0, (int)initialBurnTime);
    protected static final IntegerProperty LITSTATE = IntegerProperty.func_177719_a((String)"litstate", (int)0, (int)2);
    public static final int LIT = 2;
    public static final int SMOLDERING = 1;
    public static final int UNLIT = 0;

    public RealisticTorchBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150478_aa));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)LITSTATE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)BURNTIME, (Comparable)Integer.valueOf(0)));
    }

    public int func_149750_m(BlockState state) {
        if ((Integer)state.func_177229_b((IProperty)LITSTATE) == 2) {
            return 14;
        }
        if ((Integer)state.func_177229_b((IProperty)LITSTATE) == 1) {
            return 12;
        }
        return 0;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((IProperty)LITSTATE) == 2 || (Integer)state.func_177229_b((IProperty)LITSTATE) == 1 && world.func_201674_k().nextInt(2) == 1) {
            super.func_180655_c(state, world, pos, random);
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151033_d || player.func_184586_b(hand).func_77973_b() == RealisticTorchesItems.MATCHBOX) {
            this.playLightingSound(world, pos);
            if (!player.func_184812_l_()) {
                ItemStack heldStack = player.func_184586_b(hand);
                heldStack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
            }
            if (world.func_175727_C(pos)) {
                this.playExtinguishSound(world, pos);
            } else {
                this.changeToLit(world, pos, state);
            }
            return true;
        }
        return super.func_220051_a(state, world, pos, player, hand, hit);
    }

    public int func_149738_a(IWorldReader worldReader) {
        return 1200;
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        if (!world.func_201670_d() && initialBurnTime > 0 && (Integer)state.func_177229_b((IProperty)LITSTATE) > 0) {
            if (world.func_175727_C(pos)) {
                this.playExtinguishSound(world, pos);
                this.changeToUnlit(world, pos, state);
                return;
            }
            int newBurnTime = (Integer)state.func_177229_b((IProperty)BURNTIME) - 1;
            if (newBurnTime <= 0) {
                this.playExtinguishSound(world, pos);
                this.changeToUnlit(world, pos, state);
                world.func_195592_c(pos, (Block)this);
            } else if ((Integer)state.func_177229_b((IProperty)LITSTATE) == 2 && (newBurnTime <= initialBurnTime / 10 || newBurnTime <= 1)) {
                this.changeToSmoldering(world, pos, state, newBurnTime);
                world.func_195592_c(pos, (Block)this);
            } else {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BURNTIME, (Comparable)Integer.valueOf(newBurnTime)));
                world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
            }
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            this.func_196242_c(state, (IWorld)world, pos, 3);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BURNTIME});
        builder.func_206894_a(new IProperty[]{LITSTATE});
    }

    public static IntegerProperty getBurnTime() {
        return BURNTIME;
    }

    public static IntegerProperty getLitState() {
        return LITSTATE;
    }

    public static int getInitialBurnTime() {
        return initialBurnTime;
    }

    public void changeToLit(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)((BlockState)RealisticTorchesBlocks.TORCH.func_176223_P().func_206870_a((IProperty)LITSTATE, (Comparable)Integer.valueOf(2))).func_206870_a((IProperty)BURNTIME, (Comparable)Integer.valueOf(initialBurnTime)));
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
    }

    public void changeToSmoldering(World world, BlockPos pos, BlockState state, int newBurnTime) {
        world.func_175656_a(pos, (BlockState)((BlockState)RealisticTorchesBlocks.TORCH.func_176223_P().func_206870_a((IProperty)LITSTATE, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)BURNTIME, (Comparable)Integer.valueOf(newBurnTime)));
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
    }

    public void changeToUnlit(World world, BlockPos pos, BlockState state) {
        if (((Boolean)ConfigHandler.noRelightEnabled.get()).booleanValue()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else {
            world.func_175656_a(pos, RealisticTorchesBlocks.TORCH.func_176223_P());
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
        }
    }

    public void playLightingSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void playExtinguishSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }
}

