/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.items;

import com.chaosthedude.realistictorches.config.ConfigHandler;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MatchboxItem
extends Item {
    public static final String NAME = "matchbox";

    public MatchboxItem(int maxDamage) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200918_c(maxDamage).func_200915_b(maxDamage));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        BlockPos offsetPos;
        if (!((Boolean)ConfigHandler.matchboxCreatesFire.get()).booleanValue()) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (MatchboxItem.canPlaceFire(world.func_180495_p(offsetPos = (pos = context.func_195995_a()).func_177972_a(context.func_196000_l())), (IWorld)world, offsetPos)) {
            world.func_184133_a(player, offsetPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            BlockState blockstate1 = ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)world, offsetPos);
            world.func_180501_a(offsetPos, blockstate1, 11);
            ItemStack itemstack = context.func_195996_i();
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, offsetPos, itemstack);
                itemstack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        BlockState blockstate = world.func_180495_p(pos);
        if (MatchboxItem.isUnlitCampfire(blockstate)) {
            world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            world.func_180501_a(pos, (BlockState)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            if (player != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static boolean isUnlitCampfire(BlockState state) {
        return state.func_177230_c() == Blocks.field_222433_lV && (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) == false && (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q) == false;
    }

    public static boolean canPlaceFire(BlockState state, IWorld world, BlockPos pos) {
        BlockState blockstate = ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)world, pos);
        boolean flag = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos framePos = pos.func_177972_a(direction);
            if (!world.func_180495_p(framePos).isPortalFrame((IWorldReader)world, framePos) || ((NetherPortalBlock)Blocks.field_150427_aO).func_201816_b(world, pos) == null) continue;
            flag = true;
        }
        return state.func_196958_f() && (blockstate.func_196955_c((IWorldReader)world, pos) || flag);
    }
}

