/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.config;

import com.chaosthedude.realistictorches.RealisticTorches;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public static Configuration config;
    public static int torchBurnout;
    public static int matchboxDurability;
    public static int lightSourceRegistryThreshold;
    public static boolean handheldLightEnabled;
    public static boolean removeRecipesEnabled;
    public static boolean unlitParticlesEnabled;
    public static boolean oreDictionaryEnabled;
    public static boolean noRelightEnabled;
    public static boolean registerLightSourceBlocks;
    public static boolean matchboxCreatesFire;
    public static boolean generateLitTorches;
    public static boolean vanillaTorchDropsUnlit;
    public static String[] lightSourceItems;
    public static String[] lightSourceBlocks;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.init();
        FMLCommonHandler.instance().bus().register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "The amount of time until a torch burns out, in ticks (20 ticks = 1 second). Setting this to a negative value will disable torch burnout.";
        torchBurnout = ConfigHandler.loadInt("torch.burnoutTime", comment, torchBurnout);
        comment = "The durability of the matchbox. Setting this to a negative value will result in unlimited uses.";
        matchboxDurability = ConfigHandler.loadInt("matchbox.durability", comment, matchboxDurability);
        comment = "The threshold for which all blocks with a light level above will be registered as handheld light sources. Acceptable values are between 0 and 15, inclusive.";
        lightSourceRegistryThreshold = ConfigHandler.loadInt("handheldLight.registry.threshold", comment, lightSourceRegistryThreshold);
        comment = "Set this to false to disable certain blocks and items emitting light when held.";
        handheldLightEnabled = ConfigHandler.loadBool("handheldLight.enabled", comment, handheldLightEnabled);
        comment = "Set this to false to disable the removal of other mods' recipes for the vanilla torch.";
        removeRecipesEnabled = ConfigHandler.loadBool("recipes.removeModded", comment, removeRecipesEnabled);
        comment = "Set this to true to enable unlit torch particles.";
        unlitParticlesEnabled = ConfigHandler.loadBool("unlitTorch.particles", comment, unlitParticlesEnabled);
        comment = "Set this to true to register both the lit torch and the vanilla torch in the Ore Dictionary under blockTorch.";
        oreDictionaryEnabled = ConfigHandler.loadBool("torch.oreDictionary", comment, oreDictionaryEnabled);
        comment = "Set this to true to make lit torches disappear after they are extinguished, rather than turning into unlit torches.";
        noRelightEnabled = ConfigHandler.loadBool("torch.noRelight", comment, noRelightEnabled);
        comment = "Set this to false to disable light emitting blocks from automatically being registered as handheld light sources.";
        registerLightSourceBlocks = ConfigHandler.loadBool("handheldLight.registerBlocks", comment, registerLightSourceBlocks);
        comment = "Set this to true to enable matchboxes lighting fires in the world like flint and steel.";
        matchboxCreatesFire = ConfigHandler.loadBool("matchbox.createsFire", comment, matchboxCreatesFire);
        comment = "Set this to false to disable vanilla torches being replaced with lit torches during world generation.";
        generateLitTorches = ConfigHandler.loadBool("world.generateLitTorches", comment, generateLitTorches);
        comment = "Set this to true to enable vanilla torches dropping unlit torches when harvested.";
        vanillaTorchDropsUnlit = ConfigHandler.loadBool("torch.vanilla.dropUnlit", comment, vanillaTorchDropsUnlit);
        comment = "A list of items that will emit light when held, if handheldLight.enabled is set to true.";
        lightSourceItems = ConfigHandler.loadStringArray("lightSources.items", comment, "light_sources", lightSourceItems);
        comment = "A list of blocks that will emit light when held, if handheldLight.enabled is set to true. This list will be used ONLY if handheldLight.registerBlocks is set to false.";
        lightSourceBlocks = ConfigHandler.loadStringArray("lightSources.blocks", comment, "light_sources", lightSourceBlocks);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadInt(String name, String comment, int def) {
        Property prop = config.get("general", name, def);
        prop.comment = comment;
        int val = prop.getInt(def);
        if (val == 0) {
            val = def;
            prop.set(def);
        }
        return val;
    }

    public static boolean loadBool(String name, String comment, boolean def) {
        Property prop = config.get("general", name, def);
        prop.comment = comment;
        return prop.getBoolean(def);
    }

    public static String[] loadStringArray(String name, String comment, String category, String[] def) {
        Property prop = config.get(category, name, def);
        prop.comment = comment;
        return prop.getStringList();
    }

    public static void printConfigInfo() {
        RealisticTorches.logger.info("Torch burnout rate: " + torchBurnout + " ticks (" + (float)(torchBurnout / 1200) + " minutes)");
        if (handheldLightEnabled) {
            RealisticTorches.logger.info("Handheld light sources are enabled.");
        } else {
            RealisticTorches.logger.info("Handheld light sources are disabled.");
        }
    }

    static {
        torchBurnout = 72000;
        matchboxDurability = 64;
        lightSourceRegistryThreshold = 1;
        handheldLightEnabled = true;
        removeRecipesEnabled = true;
        unlitParticlesEnabled = false;
        oreDictionaryEnabled = false;
        noRelightEnabled = false;
        registerLightSourceBlocks = true;
        matchboxCreatesFire = false;
        generateLitTorches = true;
        lightSourceItems = new String[]{"minecraft:lava_bucket", "minecraft:glowstone_dust", "minecraft:blaze_powder", "minecraft:blaze_rod", "RealisticTorches:GlowstoneCrystal"};
        lightSourceBlocks = new String[0];
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.modID.equals("RealisticTorches")) {
                ConfigHandler.init();
            }
        }
    }
}

