/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.handler;

import com.chaosthedude.realistictorches.RealisticTorchesBlocks;
import com.chaosthedude.realistictorches.RealisticTorchesItems;
import com.chaosthedude.realistictorches.config.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TorchHandler {
    public static void extinguishTorch(World world, int x, int y, int z, boolean extinguishFully) {
        if (extinguishFully || world.func_147439_a(x, y, z) == RealisticTorchesBlocks.torchSmoldering) {
            TorchHandler.playTorchSound(world, x, y, z);
            if (!ConfigHandler.noRelightEnabled) {
                int meta = world.func_72805_g(x, y, z);
                world.func_147465_d(x, y, z, (Block)RealisticTorchesBlocks.torchUnlit, meta, 2);
            } else {
                world.func_147468_f(x, y, z);
            }
        } else if (world.func_147439_a(x, y, z) == RealisticTorchesBlocks.torchLit) {
            world.func_147465_d(x, y, z, (Block)RealisticTorchesBlocks.torchSmoldering, world.func_72805_g(x, y, z), 2);
        }
    }

    public static boolean lightTorch(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack stack = player.func_70694_bm();
        if (stack != null && (stack.func_77973_b() == Items.field_151033_d || ConfigHandler.matchboxCreatesFire && stack.func_77973_b() == RealisticTorchesItems.matchbox)) {
            if (ConfigHandler.noRelightEnabled || world.func_147439_a(x, y, z) == RealisticTorchesBlocks.torchUnlit) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                TorchHandler.playTorchSound(world, x, y, z);
                if (!world.func_72951_B(x, y, z)) {
                    world.func_147465_d(x, y, z, (Block)RealisticTorchesBlocks.torchLit, world.func_72805_g(x, y, z), 2);
                }
                return true;
            }
            if (world.func_147439_a(x, y, z) == RealisticTorchesBlocks.torchLit) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                world.func_147465_d(x, y, z, (Block)RealisticTorchesBlocks.torchLit, world.func_72805_g(x, y, z), 2);
                TorchHandler.playTorchSound(world, x, y, z);
                return true;
            }
            if (world.func_147439_a(x, y, z) == RealisticTorchesBlocks.torchSmoldering) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                if (!world.func_72951_B(x, y, z)) {
                    world.func_147465_d(x, y, z, (Block)RealisticTorchesBlocks.torchLit, world.func_72805_g(x, y, z), 2);
                    TorchHandler.playTorchSound(world, x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    public static void updateTorch(World world, int x, int y, int z) {
        if (world.func_72951_B(x, y, z)) {
            TorchHandler.extinguishTorch(world, x, y, z, true);
        }
    }

    public static void playTorchSound(World world, int x, int y, int z) {
        world.func_72908_a((double)x, (double)y, (double)z, "random.fizz", 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }
}

