/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.blocks;

import com.chaosthedude.realistictorches.blocks.RealisticTorchesBlocks;
import com.chaosthedude.realistictorches.config.ConfigHandler;
import com.chaosthedude.realistictorches.items.RealisticTorchesItems;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RealisticTorchBlock
extends TorchBlock {
    public static final String NAME = "torch";
    public static final int TICK_INTERVAL = 1200;
    protected static final int INITIAL_BURN_TIME = (Integer)ConfigHandler.torchBurnoutTime.get();
    protected static final IntegerProperty BURNTIME = IntegerProperty.func_177719_a((String)"burntime", (int)0, (int)INITIAL_BURN_TIME);
    protected static final IntegerProperty LITSTATE = IntegerProperty.func_177719_a((String)"litstate", (int)0, (int)2);
    public static final int LIT = 2;
    public static final int SMOLDERING = 1;
    public static final int UNLIT = 0;

    public RealisticTorchBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150478_aa).func_235838_a_(RealisticTorchBlock.getLightValueFromState()), (IParticleData)ParticleTypes.field_197631_x);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LITSTATE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BURNTIME, (Comparable)Integer.valueOf(0)));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)LITSTATE) == 2 || (Integer)state.func_177229_b((Property)LITSTATE) == 1 && world.func_201674_k().nextInt(2) == 1) {
            super.func_180655_c(state, world, pos, random);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151033_d || player.func_184586_b(hand).func_77973_b() == RealisticTorchesItems.MATCHBOX) {
            this.playLightingSound(world, pos);
            if (!(player.func_184812_l_() || player.func_184586_b(hand).func_77973_b() == RealisticTorchesItems.MATCHBOX && (Integer)ConfigHandler.matchboxDurability.get() <= 0)) {
                ItemStack heldStack = player.func_184586_b(hand);
                heldStack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
            }
            if (world.func_175727_C(pos)) {
                this.playExtinguishSound(world, pos);
            } else {
                this.changeToLit(world, pos, state);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.func_201670_d() && INITIAL_BURN_TIME > 0 && (Integer)state.func_177229_b((Property)LITSTATE) > 0) {
            if (world.func_175727_C(pos)) {
                this.playExtinguishSound((World)world, pos);
                this.changeToUnlit((World)world, pos, state);
                return;
            }
            int newBurnTime = (Integer)state.func_177229_b((Property)BURNTIME) - 1;
            if (newBurnTime <= 0) {
                this.playExtinguishSound((World)world, pos);
                this.changeToUnlit((World)world, pos, state);
                world.func_195593_d(pos, (Block)this);
            } else if ((Integer)state.func_177229_b((Property)LITSTATE) == 2 && (newBurnTime <= INITIAL_BURN_TIME / 10 || newBurnTime <= 1)) {
                this.changeToSmoldering((World)world, pos, state, newBurnTime);
                world.func_195593_d(pos, (Block)this);
            } else {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BURNTIME, (Comparable)Integer.valueOf(newBurnTime)));
                world.func_205220_G_().func_205360_a(pos, (Object)this, 1200);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        world.func_205220_G_().func_205360_a(pos, (Object)this, 1200);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            this.func_176223_P().func_235734_a_((IWorld)world, pos, 3);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BURNTIME});
        builder.func_206894_a(new Property[]{LITSTATE});
    }

    public static IntegerProperty getBurnTime() {
        return BURNTIME;
    }

    public static IntegerProperty getLitState() {
        return LITSTATE;
    }

    public static int getInitialBurnTime() {
        return INITIAL_BURN_TIME;
    }

    public void changeToLit(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)((BlockState)RealisticTorchesBlocks.TORCH.func_176223_P().func_206870_a((Property)LITSTATE, (Comparable)Integer.valueOf(2))).func_206870_a((Property)BURNTIME, (Comparable)Integer.valueOf(INITIAL_BURN_TIME)));
        world.func_205220_G_().func_205360_a(pos, (Object)this, 1200);
    }

    public void changeToSmoldering(World world, BlockPos pos, BlockState state, int newBurnTime) {
        world.func_175656_a(pos, (BlockState)((BlockState)RealisticTorchesBlocks.TORCH.func_176223_P().func_206870_a((Property)LITSTATE, (Comparable)Integer.valueOf(1))).func_206870_a((Property)BURNTIME, (Comparable)Integer.valueOf(newBurnTime)));
        world.func_205220_G_().func_205360_a(pos, (Object)this, 1200);
    }

    public void changeToUnlit(World world, BlockPos pos, BlockState state) {
        if (((Boolean)ConfigHandler.noRelightEnabled.get()).booleanValue()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else {
            world.func_175656_a(pos, RealisticTorchesBlocks.TORCH.func_176223_P());
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1200);
        }
    }

    public void playLightingSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void playExtinguishSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private static ToIntFunction<BlockState> getLightValueFromState() {
        return state -> {
            if ((Integer)state.func_177229_b((Property)LITSTATE) == 2) {
                return 14;
            }
            if ((Integer)state.func_177229_b((Property)LITSTATE) == 1) {
                return 12;
            }
            return 0;
        };
    }
}

