/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xreliquary.init.ModItems;

public class PacketFortuneCoinTogglePressed
implements IMessage,
IMessageHandler<PacketFortuneCoinTogglePressed, IMessage> {
    private InventoryType inventoryType;
    private int slot;

    public PacketFortuneCoinTogglePressed() {
    }

    public PacketFortuneCoinTogglePressed(InventoryType inventoryType, int slot) {
        this.inventoryType = inventoryType;
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.inventoryType = InventoryType.values()[buf.readByte()];
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.inventoryType.ordinal());
        buf.writeInt(this.slot);
    }

    public IMessage onMessage(PacketFortuneCoinTogglePressed message, MessageContext ctx) {
        ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> this.handleMessage(message, messageContext.getServerHandler().field_147369_b));
        return null;
    }

    private void handleMessage(PacketFortuneCoinTogglePressed message, EntityPlayerMP player) {
        ItemStack stack = null;
        switch (message.inventoryType) {
            case MAIN: {
                stack = player.field_71071_by.field_70462_a[message.slot];
                break;
            }
            case OFF_HAND: {
                stack = player.field_71071_by.field_184439_c[0];
                break;
            }
            case BAUBLES: {
                if (!Loader.isModLoaded((String)"Baubles")) break;
                IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
                stack = inventoryBaubles.getStackInSlot(message.slot);
            }
        }
        if (stack.func_77973_b() == ModItems.fortuneCoin) {
            ModItems.fortuneCoin.toggle(stack);
        }
    }

    public static enum InventoryType {
        MAIN,
        OFF_HAND,
        BAUBLES;

    }
}

