/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.items.util.FilteredItemStackHandler;

public class PacketItemHandlerSync
implements IMessage,
IMessageHandler<PacketItemHandlerSync, IMessage> {
    private int playerSlotNumber;
    private EnumHand hand = EnumHand.MAIN_HAND;
    private NBTTagCompound itemHandlerNBT;
    private static final int INVALID_SLOT = -1;

    public PacketItemHandlerSync() {
    }

    public PacketItemHandlerSync(EnumHand hand, NBTTagCompound itemHandlerNBT) {
        this.hand = hand;
        this.itemHandlerNBT = itemHandlerNBT;
        this.playerSlotNumber = -1;
    }

    public PacketItemHandlerSync(int playerSlotNumber, NBTTagCompound itemHandlerNBT) {
        this.playerSlotNumber = playerSlotNumber;
        this.itemHandlerNBT = itemHandlerNBT;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerSlotNumber = buf.readInt();
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        try {
            this.itemHandlerNBT = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerSlotNumber);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.itemHandlerNBT, (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketItemHandlerSync message, MessageContext ctx) {
        FilteredItemStackHandler filteredHandler;
        IItemHandler itemHandler;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = message.playerSlotNumber > -1 ? player.field_71071_by.func_70301_a(message.playerSlotNumber) : player.func_184586_b(message.hand);
        if (stack != null && (itemHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && itemHandler instanceof FilteredItemStackHandler && (filteredHandler = (FilteredItemStackHandler)itemHandler) != null) {
            filteredHandler.deserializeNBT(message.itemHandlerNBT);
        }
        return null;
    }
}

