/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;

public class EntityLyssaHook
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(EntityFishHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean inGround;
    private int ticksInGround = 0;
    private EntityPlayer angler;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private Entity caughtEntity;
    private State currentState = State.FLYING;
    private int lureLevel;
    private int luckOfTheSeaLevel;
    private static final Field HANDS_CHANCES = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_82174_bp");
    private static final Field ARMOR_CHANCES = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184655_bs");

    public EntityLyssaHook(World world) {
        super(world);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public EntityLyssaHook(World worldIn, EntityPlayer fishingPlayer, int lureLevel, int luckOfTheSeaLevel) {
        super(worldIn);
        this.lureLevel = lureLevel;
        this.luckOfTheSeaLevel = luckOfTheSeaLevel;
        this.init(fishingPlayer);
        this.shoot();
        this.speedUp();
    }

    private void init(EntityPlayer player) {
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.angler = player;
    }

    private void shoot() {
        float f = this.angler.field_70127_C + (this.angler.field_70125_A - this.angler.field_70127_C);
        float f1 = this.angler.field_70126_B + (this.angler.field_70177_z - this.angler.field_70126_B);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.angler.field_70169_q + (this.angler.field_70165_t - this.angler.field_70169_q) - (double)f3 * 0.3;
        double d1 = this.angler.field_70167_r + (this.angler.field_70163_u - this.angler.field_70167_r) + (double)this.angler.func_70047_e();
        double d2 = this.angler.field_70166_s + (this.angler.field_70161_v - this.angler.field_70166_s) - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        this.field_70159_w = -f3;
        this.field_70181_x = MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f);
        this.field_70179_y = -f2;
        float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70181_x *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70179_y *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        float f7 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f7) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    private void onUpdateOriginal() {
        super.func_70071_h_();
        if (this.angler == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151586_h) {
                f = BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.field_70128_L) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.caughtEntity.field_70165_t;
                            double d2 = this.caughtEntity.field_70131_O;
                            this.field_70163_u = this.caughtEntity.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.caughtEntity.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (iblockstate.func_185904_a() != Material.field_151586_h) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            this.field_70159_w *= 0.92;
            this.field_70181_x *= 0.92;
            this.field_70179_y *= 0.92;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!this.canBeHooked(entity1) || entity1 == this.angler && this.ticksInAir < 5 || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.caughtEntity = raytraceresult.field_72308_g;
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos p_190621_1_) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_175678_i(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                Block block = worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f))).func_177230_c();
                if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                }
            } else {
                this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                Block block1 = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f)))).func_177230_c();
                if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i) {
                    worldserver.func_175739_a(EnumParticleTypes.WATER_SPLASH, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureLevel * 20 * 5;
        }
    }

    private boolean canBeHooked(Entity entity) {
        return entity.func_70067_L() || entity instanceof EntityItem;
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.caughtEntity instanceof EntityPlayer && ((EntityPlayer)this.caughtEntity).func_175144_cb()) {
            this.bringInHookedEntity();
        }
        super.func_70103_a(id);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.angler != null) {
            this.angler.field_71104_cf = null;
        }
    }

    public EntityPlayer getAngler() {
        return this.angler;
    }

    private void bringInHookedEntityOriginal() {
        if (this.angler != null) {
            double d0 = this.angler.field_70165_t - this.field_70165_t;
            double d1 = this.angler.field_70163_u - this.field_70163_u;
            double d2 = this.angler.field_70161_v - this.field_70161_v;
            this.caughtEntity.field_70159_w += d0 * 0.1;
            this.caughtEntity.field_70181_x += d1 * 0.1;
            this.caughtEntity.field_70179_y += d2 * 0.1;
        }
    }

    private int handleHookRetractionOriginal() {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            int i = 0;
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.caughtEntity instanceof EntityItem ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
                lootcontext$builder.func_186469_a((float)this.luckOfTheSeaLevel + this.angler.func_184817_da());
                lootcontext$builder.func_186470_a(this.angler);
                for (ItemStack itemstack : this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a())) {
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.angler.field_70165_t - this.field_70165_t;
                    double d1 = this.angler.field_70163_u - this.field_70163_u;
                    double d2 = this.angler.field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    entityitem.field_70159_w = d0 * 0.1;
                    entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * 0.1;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.angler.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.angler.field_70170_p, this.angler.field_70165_t, this.angler.field_70163_u + 0.5, this.angler.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                }
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return i;
        }
        return 0;
    }

    private void speedUp() {
        if (this.field_70181_x >= 0.0) {
            this.field_70159_w *= 2.0;
            this.field_70181_x *= 2.0;
            this.field_70179_y *= 2.0;
        }
    }

    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public void func_70071_h_() {
        this.onUpdateOriginal();
        this.pullItemEntitiesTowardsHook();
    }

    private boolean shouldStopFishing() {
        boolean flag1;
        ItemStack itemstack = this.getAngler().func_184614_ca();
        ItemStack itemstack1 = this.getAngler().func_184592_cb();
        boolean flag = itemstack.func_77973_b() == ModItems.rodOfLyssa;
        boolean bl = flag1 = itemstack1.func_77973_b() == ModItems.rodOfLyssa;
        if (!this.getAngler().field_70128_L && this.getAngler().func_70089_S() && (flag || flag1) && (double)this.func_70032_d((Entity)this.getAngler()) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void pullItemEntitiesTowardsHook() {
        if (!this.field_70128_L && this.caughtEntity == null) {
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151586_h) {
                f = BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos);
            }
            if (f <= 0.0f) {
                List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(3.0));
                for (Entity e : list) {
                    Vec3d pullVector = new Vec3d(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v).func_72432_b();
                    e.field_70159_w = pullVector.field_72450_a * 0.4;
                    e.field_70181_x = pullVector.field_72448_b * 0.4;
                    e.field_70179_y = pullVector.field_72449_c * 0.4;
                }
            }
        }
    }

    private void bringInHookedEntity() {
        this.bringInHookedEntityOriginal();
        if (this.caughtEntity instanceof EntityItem) {
            this.caughtEntity.field_70159_w *= 4.0;
            this.caughtEntity.field_70181_x *= 4.0;
            this.caughtEntity.field_70179_y *= 4.0;
        } else if (this.caughtEntity instanceof EntityLivingBase) {
            this.caughtEntity.field_70181_x *= 1.5;
        }
    }

    public int handleHookRetraction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.caughtEntity != null && this.getAngler().func_70093_af() && this.canStealFromEntity()) {
                this.stealFromLivingEntity();
                this.func_70106_y();
            } else {
                this.handleHookRetractionOriginal();
            }
            this.pullItemEntitiesWithHook();
        }
        return 0;
    }

    private boolean canStealFromEntity() {
        return this.caughtEntity instanceof EntityLivingBase && (Settings.Items.RodOfLyssa.stealFromPlayers || !(this.caughtEntity instanceof EntityPlayer));
    }

    private void pullItemEntitiesWithHook() {
        List pullingItemsList = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        for (EntityItem e : pullingItemsList) {
            double d1 = this.getAngler().field_70165_t - this.field_70165_t;
            double d3 = this.getAngler().field_70163_u - this.field_70163_u;
            double d5 = this.getAngler().field_70161_v - this.field_70161_v;
            double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
            double d9 = 0.1;
            e.field_70159_w = d1 * d9;
            e.field_70181_x = d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08;
            e.field_70179_y = d5 * d9;
        }
    }

    private void stealFromLivingEntity() {
        EntityLivingBase livingEntity = (EntityLivingBase)this.caughtEntity;
        EntityEquipmentSlot slotBeingStolenFrom = EntityEquipmentSlot.values()[this.field_70170_p.field_73012_v.nextInt(EntityEquipmentSlot.values().length)];
        ItemStack stolenStack = livingEntity.func_184582_a(slotBeingStolenFrom);
        if (stolenStack.func_190926_b() && Settings.Items.RodOfLyssa.stealFromVacantSlots) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                stolenStack = livingEntity.func_184582_a(slot);
                if (stolenStack.func_190926_b() || !this.canDropFromSlot(livingEntity, slot)) continue;
                slotBeingStolenFrom = slot;
                break;
            }
        }
        float failProbabilityFactor = Settings.Items.RodOfLyssa.useLeveledFailureRate ? 1.0f / ((float)Math.sqrt(Math.max(1, Math.min(this.getAngler().field_71068_ca, Settings.Items.RodOfLyssa.levelCapForLeveledFormula))) * 2.0f) : (float)Settings.Items.RodOfLyssa.flatStealFailurePercentRate / 100.0f;
        if ((this.field_70146_Z.nextFloat() <= failProbabilityFactor || stolenStack.func_190926_b() && Settings.Items.RodOfLyssa.failStealFromVacantSlots) && Settings.Items.RodOfLyssa.angerOnStealFailure) {
            livingEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.getAngler()), 0.0f);
        }
        if (!stolenStack.func_190926_b()) {
            int randomItemDamage = this.field_70170_p.field_73012_v.nextInt(3);
            stolenStack.func_77972_a(randomItemDamage, livingEntity);
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stolenStack);
            entityitem.func_174867_a(5);
            double d1 = this.getAngler().field_70165_t - this.field_70165_t;
            double d3 = this.getAngler().field_70163_u - this.field_70163_u;
            double d5 = this.getAngler().field_70161_v - this.field_70161_v;
            double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
            double d9 = 0.1;
            entityitem.field_70159_w = d1 * d9;
            entityitem.field_70181_x = d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08;
            entityitem.field_70179_y = d5 * d9;
            this.field_70170_p.func_72838_d((Entity)entityitem);
            livingEntity.func_184201_a(slotBeingStolenFrom, ItemStack.field_190927_a);
        }
    }

    private boolean canDropFromSlot(EntityLivingBase entity, EntityEquipmentSlot slot) {
        if (!(entity instanceof EntityLiving)) {
            return true;
        }
        EntityLiving livingEntity = (EntityLiving)entity;
        try {
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                return ((float[])float[].class.cast(HANDS_CHANCES.get(livingEntity)))[slot.func_188454_b()] > -1.0f;
            }
            return ((float[])float[].class.cast(ARMOR_CHANCES.get(livingEntity)))[slot.func_188454_b()] > -1.0f;
        }
        catch (IllegalAccessException e) {
            LogHelper.error(e);
            return false;
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.angler.func_145782_y());
    }

    public void readSpawnData(ByteBuf additionalData) {
        Entity entity = this.field_70170_p.func_73045_a(additionalData.readInt());
        if (entity instanceof EntityPlayer) {
            this.angler = (EntityPlayer)entity;
        }
    }

    private static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

