/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import xreliquary.handler.HandlerPriorityComparator;
import xreliquary.handler.IPlayerDeathHandler;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.util.XRFakePlayerFactory;

@Mod.EventBusSubscriber(modid="xreliquary")
public class CommonEventHandler {
    private static final Set<IPlayerHurtHandler> playerHurtHandlers = Sets.newTreeSet((Comparator)new HandlerPriorityComparator());
    private static final Set<IPlayerDeathHandler> playerDeathHandlers = Sets.newTreeSet((Comparator)new HandlerPriorityComparator());
    private static Map<UUID, Boolean> playersFlightStatus = new HashMap<UUID, Boolean>();

    public static void registerPlayerHurtHandler(IPlayerHurtHandler handler) {
        playerHurtHandlers.add(handler);
    }

    public static void registerPlayerDeathHandler(IPlayerDeathHandler handler) {
        playerDeathHandlers.add(handler);
    }

    @SubscribeEvent
    public static void handleMercyCrossDamage(AttackEntityEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K || !(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        if (event.getEntityPlayer().func_184614_ca().func_77973_b() != ModItems.mercyCross) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)event.getTarget();
        ModItems.mercyCross.updateAttackDamageModifier(target, event.getEntityPlayer());
    }

    @SubscribeEvent
    public static void preventMendingAndUnbreaking(AnvilUpdateEvent event) {
        if (event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        if (event.getLeft().func_77973_b() != ModItems.mobCharm && event.getLeft().func_77973_b() != ModItems.alkahestryTome) {
            return;
        }
        if (EnchantmentHelper.func_82781_a((ItemStack)event.getRight()).keySet().stream().anyMatch(e -> e == Enchantments.field_185307_s)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void blameDrullkus(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_146103_bH().getName().equals("Drullkus") && !event.player.getEntityData().func_74764_b("gift") && event.player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.witchHat))) {
            event.player.getEntityData().func_74757_a("gift", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void beforePlayerHurt(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean cancel = false;
        for (IPlayerHurtHandler handler : playerHurtHandlers) {
            if (!handler.canApply(player, event) || !handler.apply(player, event)) continue;
            cancel = true;
            break;
        }
        if (cancel) {
            event.setCanceled(true);
            event.setResult(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void beforePlayerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean cancel = false;
        for (IPlayerDeathHandler handler : playerDeathHandlers) {
            if (!handler.canApply(player, event) || !handler.apply(player, event)) continue;
            cancel = true;
            break;
        }
        if (cancel) {
            event.setCanceled(true);
            event.setResult(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            XRFakePlayerFactory.unloadWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() == ModItems.rendingGale && ModItems.rendingGale.isFlightMode(player.func_184607_cu()) && ModItems.rendingGale.hasFlightCharge(player, player.func_184607_cu())) {
            playersFlightStatus.put(player.func_146103_bH().getId(), true);
            player.field_71075_bZ.field_75101_c = true;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        } else {
            if (!playersFlightStatus.containsKey(player.func_146103_bH().getId())) {
                playersFlightStatus.put(player.func_146103_bH().getId(), false);
            }
            if (playersFlightStatus.get(player.func_146103_bH().getId()).booleanValue()) {
                playersFlightStatus.put(player.func_146103_bH().getId(), false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                }
            }
        }
    }
}

