/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.util.LogHelper;

@Mod.EventBusSubscriber(modid="xreliquary")
public class ModFluids {
    private static final String XP_JUICE_FLUID_NAME = "xpjuice";
    private static final String MILK_FLUID_NAME = "milk";
    private static boolean registeredXpJuice = false;
    private static boolean registeredMilk = false;

    public static Fluid milk() {
        return FluidRegistry.getFluid((String)MILK_FLUID_NAME);
    }

    public static Fluid xpJuice() {
        return FluidRegistry.getFluid((String)XP_JUICE_FLUID_NAME);
    }

    public static void preInit() {
        if (!FluidRegistry.isFluidRegistered((String)XP_JUICE_FLUID_NAME)) {
            LogHelper.info("XP Juice registered by Reliquary.");
            Fluid fluidXpJuice = new Fluid(XP_JUICE_FLUID_NAME, new ResourceLocation("xreliquary", "fluids/xpjuice_still"), new ResourceLocation("xreliquary", "fluids/xpjuice_flowing")).setLuminosity(10).setDensity(800).setViscosity(1500).setUnlocalizedName("xreliquary.xpjuice");
            FluidRegistry.registerFluid((Fluid)fluidXpJuice);
            registeredXpJuice = true;
        }
        if (!FluidRegistry.isFluidRegistered((String)MILK_FLUID_NAME)) {
            Fluid milk = new Fluid(MILK_FLUID_NAME, new ResourceLocation("xreliquary", "fluids/milk_still"), new ResourceLocation("xreliquary", "fluids/milk_flowing")).setTemperature(320);
            FluidRegistry.registerFluid((Fluid)milk);
            registeredMilk = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onIconLoad(TextureStitchEvent.Pre event) {
        TextureMap textureMap = event.getMap();
        if (registeredXpJuice) {
            ModFluids.registerFluidSprites(textureMap, ModFluids.xpJuice());
        }
        if (registeredMilk) {
            ModFluids.registerFluidSprites(textureMap, ModFluids.milk());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerFluidSprites(TextureMap textureMap, Fluid fluid) {
        if (fluid != null) {
            textureMap.func_174942_a(fluid.getStill());
            textureMap.func_174942_a(fluid.getFlowing());
        }
    }
}

