/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util.fluid;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.util.XpHelper;

public class FluidHandlerHeroMedallion
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack heroMedallion;

    public FluidHandlerHeroMedallion(ItemStack heroMedallion) {
        this.heroMedallion = heroMedallion;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(ModFluids.xpJuice(), 1000), Integer.MAX_VALUE)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() != ModFluids.xpJuice()) {
            return 0;
        }
        if (doFill) {
            ModItems.heroMedallion.setExperience(this.heroMedallion, ModItems.heroMedallion.getExperience(this.heroMedallion) + XpHelper.liquidToExperience(resource.amount));
        }
        return resource.amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.getFluid() != ModFluids.xpJuice()) {
            return null;
        }
        int experienceToRemove = Math.min(XpHelper.liquidToExperience(resource.amount), ModItems.heroMedallion.getExperience(this.heroMedallion));
        if (doDrain) {
            ModItems.heroMedallion.setExperience(this.heroMedallion, ModItems.heroMedallion.getExperience(this.heroMedallion) - experienceToRemove);
        }
        return new FluidStack(ModFluids.xpJuice(), XpHelper.experienceToLiquid(experienceToRemove));
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(new FluidStack(ModFluids.xpJuice(), maxDrain), doDrain);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.heroMedallion;
    }
}

