/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.reference.Settings;

public class BlockInterdictionTorch
extends BlockTorch {
    public BlockInterdictionTorch() {
        this.func_149663_c("interdiction_torch");
        this.func_149647_a(Reliquary.CREATIVE_TAB);
        this.func_149711_c(0.0f);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(BlockTorch.field_149766_f);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        world.func_180497_b(pos, (Block)this, this.tickRate(), 1);
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        world.func_180497_b(pos, (Block)this, this.tickRate(), 1);
        if (world.field_72995_K) {
            return;
        }
        int radius = Settings.InterdictionTorch.pushRadius;
        List<String> entitiesThatCanBePushed = Settings.InterdictionTorch.entitiesThatCanBePushed;
        List<String> projectilesThatCanBePushed = Settings.InterdictionTorch.projectilesThatCanBePushed;
        List entities = world.func_72872_a(Entity.class, new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)(pos.func_177956_o() - radius), (double)(pos.func_177952_p() - radius), (double)(pos.func_177958_n() + radius), (double)(pos.func_177956_o() + radius), (double)(pos.func_177952_p() + radius)));
        for (Entity entity : entities) {
            double distance;
            Class<?> entityClass;
            String entityName;
            if (entity instanceof EntityPlayer || !entitiesThatCanBePushed.contains(entityName = (String)EntityList.field_75626_c.get(entityClass = entity.getClass())) && (!projectilesThatCanBePushed.contains(entityName) || !Settings.InterdictionTorch.canPushProjectiles) || (distance = entity.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) >= (double)radius || distance == 0.0) continue;
            if (distance < 1.0) {
                distance = 1.0;
            }
            double knockbackMultiplier = 1.0 + 1.0 / distance;
            double reductionCoefficient = 0.04;
            Vec3 angleOfAttack = new Vec3(entity.field_70165_t - ((double)pos.func_177958_n() + 0.5), entity.field_70163_u - (double)pos.func_177956_o(), entity.field_70161_v - ((double)pos.func_177952_p() + 0.5));
            double xForce = angleOfAttack.field_72450_a * knockbackMultiplier * reductionCoefficient;
            double yForce = angleOfAttack.field_72448_b * knockbackMultiplier * reductionCoefficient;
            double zForce = angleOfAttack.field_72449_c * knockbackMultiplier * reductionCoefficient;
            entity.field_70159_w += xForce;
            entity.field_70181_x += yForce;
            entity.field_70179_y += zForce;
        }
    }

    public int tickRate() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        double xOffset = (float)pos.func_177958_n() + 0.5f;
        double yOffset = (float)pos.func_177956_o() + 0.7f;
        double zOffset = (float)pos.func_177952_p() + 0.5f;
        double verticalModifier = 0.22;
        double horizontalModifier = 0.27;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
        if (facing.func_176740_k().func_176722_c()) {
            EnumFacing oppositeFacing = facing.func_176734_d();
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, xOffset + horizontalModifier * (double)oppositeFacing.func_82601_c(), yOffset + verticalModifier, zOffset + horizontalModifier * (double)oppositeFacing.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, xOffset + horizontalModifier * (double)oppositeFacing.func_82601_c(), yOffset + verticalModifier, zOffset + horizontalModifier * (double)oppositeFacing.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

