/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.BlocksTC;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.tile.TileEntityBase;
import xreliquary.client.particle.EntityCauldronBubbleFX;
import xreliquary.client.particle.EntityCauldronSteamFX;
import xreliquary.compat.waila.provider.IWailaDataChangeIndicator;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.ItemPotionEssence;
import xreliquary.reference.Settings;
import xreliquary.util.RegistryHelper;
import xreliquary.util.potions.PotionEssence;

public class TileEntityCauldron
extends TileEntityBase
implements IWailaDataChangeIndicator {
    public int redstoneCount = 0;
    public PotionEssence potionEssence = null;
    public int glowstoneCount = 0;
    public boolean hasGunpowder = false;
    public boolean hasNetherwart = false;
    public int cookTime = 0;
    private int liquidLevel = 0;
    private boolean dataChanged = true;

    public void func_73660_a() {
        if (this.getHeatSources().contains(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, 0)).func_177230_c()) && this.getLiquidLevel() > 0) {
            if (this.potionEssence != null && this.cookTime < this.getCookTime()) {
                ++this.cookTime;
            }
            if (this.field_145850_b.field_72995_K) {
                for (int particleCount = 0; particleCount <= 2; ++particleCount) {
                    this.spawnBoilingParticles();
                }
                if (this.hasGunpowder) {
                    this.spawnGunpowderParticles();
                }
                if (this.glowstoneCount > 0) {
                    this.spawnGlowstoneParticles();
                }
                if (this.hasNetherwart) {
                    this.spawnNetherwartParticles();
                    if (this.finishedCooking()) {
                        this.spawnFinishedParticles();
                    }
                }
                if (this.redstoneCount > 0) {
                    this.spawnRedstoneParticles();
                }
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnBoilingParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(this.getCookTime() * this.getCookTime()) > this.cookTime * this.cookTime) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.33f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.33f;
        int color = this.getColor(this.potionEssence);
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color >> 0 & 0xFF) / 256.0f;
        EntityCauldronBubbleFX bubble = new EntityCauldronBubbleFX(Minecraft.func_71410_x().func_110434_K(), this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)this.func_174877_v().func_177956_o() + 0.01 + (double)this.getRenderLiquidLevel(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0, red, green, blue);
        EntityCauldronSteamFX steam = new EntityCauldronSteamFX(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)this.func_174877_v().func_177956_o() + 0.01 + (double)this.getRenderLiquidLevel(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.05 + (double)(0.02f * this.getRenderLiquidLevel()), 0.0, red, green, blue);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)bubble);
        if (this.field_145850_b.field_73012_v.nextInt(6) == 0) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)steam);
        }
    }

    private float getRenderLiquidLevel() {
        int j = MathHelper.func_76125_a((int)this.getLiquidLevel(), (int)0, (int)3);
        return (float)(6 + 3 * j) / 16.0f;
    }

    public int getColor(PotionEssence essence) {
        return PotionHelper.func_77911_a(essence == null ? null : essence.getEffects());
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnGunpowderParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnGlowstoneParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f);
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, gauss, gauss, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnNetherwartParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f);
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, gauss, 0.0, gauss, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnRedstoneParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(10) / this.redstoneCount > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 1.0, 0.0, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnFinishedParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0, new int[0]);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setLiquidLevel(tag.func_74765_d("liquidLevel"));
        this.glowstoneCount = tag.func_74762_e("glowstoneCount");
        this.hasNetherwart = tag.func_74767_n("hasNetherwart");
        this.hasGunpowder = tag.func_74767_n("hasGunpowder");
        this.redstoneCount = tag.func_74762_e("redstoneCount");
        this.cookTime = tag.func_74762_e("cookTime");
        this.potionEssence = new PotionEssence((NBTTagCompound)tag.func_74781_a("potionEssence"));
        if (this.potionEssence.getEffects().size() == 0) {
            this.potionEssence = null;
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("liquidLevel", this.getLiquidLevel());
        tag.func_74768_a("cookTime", this.cookTime);
        tag.func_74768_a("redstoneCount", this.redstoneCount);
        tag.func_74768_a("glowstoneCount", this.glowstoneCount);
        tag.func_74757_a("hasGunpowder", this.hasGunpowder);
        tag.func_74757_a("hasNetherwart", this.hasNetherwart);
        tag.func_74782_a("potionEssence", (NBTBase)(this.potionEssence == null ? new NBTTagCompound() : this.potionEssence.writeToNBT()));
    }

    public boolean finishedCooking() {
        return this.hasNetherwart && this.potionEssence != null && this.cookTime >= this.getCookTime();
    }

    public NBTTagCompound removeContainedPotion(World world) {
        if (!this.hasNetherwart || this.potionEssence == null || this.getLiquidLevel() <= 0) {
            return null;
        }
        this.setLiquidLevel(this.getLiquidLevel() - 1);
        NBTTagCompound tag = this.getFinishedPotion();
        if (this.getLiquidLevel() <= 0) {
            this.clearAllFields();
        }
        return tag;
    }

    public NBTTagCompound getFinishedPotion() {
        NBTTagCompound tag = this.potionEssence.writeToNBT();
        NBTTagList effectsList = tag.func_150295_c("effects", 10);
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74782_a("effects", (NBTBase)effectsList);
        newTag.func_74757_a("hasPotion", true);
        if (this.hasGunpowder) {
            newTag.func_74757_a("splash", true);
        }
        return newTag;
    }

    public void clearAllFields() {
        this.cookTime = 0;
        this.glowstoneCount = 0;
        this.hasGunpowder = false;
        this.hasNetherwart = false;
        this.redstoneCount = 0;
        this.potionEssence = null;
        this.dataChanged = true;
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public boolean isItemValidForInput(ItemStack ist) {
        if (this.getLiquidLevel() < 3) {
            return false;
        }
        return ist.func_77973_b() instanceof ItemPotionEssence && this.potionEssence == null || ist.func_77973_b() == Items.field_151016_H && !this.hasGunpowder || ist.func_77973_b() == Items.field_151114_aO && this.glowstoneCount < this.getGlowstoneAmpLimit() || ist.func_77973_b() == Items.field_151137_ax && this.redstoneCount < this.getRedstoneAmpLimit() || ist.func_77973_b() == Items.field_151075_bm && !this.hasNetherwart;
    }

    public void addItem(ItemStack ist) {
        if (ist.func_77973_b() instanceof ItemPotionEssence) {
            this.potionEssence = new PotionEssence(ist.func_77978_p());
        } else if (ist.func_77973_b() == Items.field_151016_H) {
            this.hasGunpowder = true;
        } else if (ist.func_77973_b() == Items.field_151114_aO) {
            ++this.glowstoneCount;
            this.potionEssence.addGlowstone(this.glowstoneCount);
        } else if (ist.func_77973_b() == Items.field_151137_ax) {
            ++this.redstoneCount;
            this.potionEssence.addRedstone(this.redstoneCount);
        } else if (ist.func_77973_b() == Items.field_151075_bm) {
            this.hasNetherwart = true;
        }
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public int getGlowstoneAmpLimit() {
        return Settings.ApothecaryCauldron.glowstoneLimit;
    }

    public int getRedstoneAmpLimit() {
        return Settings.ApothecaryCauldron.redstoneLimit;
    }

    public List<Block> getHeatSources() {
        ArrayList<Block> heatSources = new ArrayList<Block>();
        List<String> heatSourceBlockNames = Settings.ApothecaryCauldron.heatSources;
        for (String blockName : heatSourceBlockNames) {
            if (heatSources.contains(RegistryHelper.getBlockFromName(blockName))) continue;
            heatSources.add(RegistryHelper.getBlockFromName(blockName));
        }
        heatSources.add((Block)Blocks.field_150353_l);
        heatSources.add((Block)Blocks.field_150356_k);
        heatSources.add((Block)Blocks.field_150480_ab);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            heatSources.add(BlocksTC.nitor);
        }
        return heatSources;
    }

    public int getCookTime() {
        return Settings.ApothecaryCauldron.cookTime;
    }

    public void handleCollidingEntity(World world, BlockPos pos, Entity collidingEntity) {
        int l = 3;
        float f = (float)pos.func_177956_o() + (6.0f + (float)(3 * l)) / 16.0f;
        if (collidingEntity.func_174813_aQ().field_72338_b <= (double)f) {
            if (collidingEntity.func_70027_ad() && l > 0) {
                collidingEntity.func_70066_B();
            }
            if (collidingEntity instanceof EntityLivingBase) {
                if (this.potionEssence == null) {
                    return;
                }
                for (PotionEffect effect : this.potionEssence.getEffects()) {
                    Potion potion = Potion.field_76425_a[effect.func_76456_a()];
                    if (potion.func_76403_b() && world.func_72820_D() % 20L != 0L) continue;
                    PotionEffect reducedEffect = new PotionEffect(effect.func_76456_a(), potion.func_76403_b() ? 1 : effect.func_76459_b() / 20, Math.max(0, effect.func_76458_c() - 1));
                    ((EntityLivingBase)collidingEntity).func_70690_d(reducedEffect);
                }
                if (this.cookTime > 0 && world.func_72820_D() % 20L != 0L) {
                    collidingEntity.func_70097_a(DamageSource.field_76372_a, 1.0f);
                }
            }
            if (collidingEntity instanceof EntityItem) {
                ItemStack item = ((EntityItem)collidingEntity).func_92059_d();
                while (this.isItemValidForInput(item)) {
                    this.addItem(item);
                    if (--item.field_77994_a >= 1) continue;
                    collidingEntity.func_70106_y();
                }
            }
        }
    }

    public int getColorMultiplier() {
        return PotionHelper.func_77911_a(this.potionEssence == null ? new ArrayList() : this.potionEssence.getEffects());
    }

    public int getLiquidLevel() {
        return this.liquidLevel;
    }

    public void fillWithRain(World world) {
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            this.setLiquidLevel(this.getLiquidLevel() + 1);
        }
    }

    public boolean handleBlockActivation(World world, EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack.func_77973_b() == Items.field_151131_as || itemStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack).equals((Object)new FluidStack(FluidRegistry.WATER, 1000))) {
            if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (itemStack.func_77973_b() == Items.field_151131_as) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
                    } else {
                        ((IFluidContainerItem)itemStack.func_77973_b()).drain(itemStack, 1000, true);
                    }
                }
                this.setLiquidLevel(3);
                this.cookTime = 0;
            }
            return true;
        }
        if (!(itemStack.func_77973_b() != ModItems.potion || itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("hasPotion"))) {
            if (this.getLiquidLevel() > 0 && this.finishedCooking()) {
                ItemStack potion = new ItemStack((Item)ModItems.potion, 1, 0);
                potion.func_77982_d(this.removeContainedPotion(world));
                --itemStack.field_77994_a;
                if (itemStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, potion);
                } else if (!player.field_71071_by.func_70441_a(potion)) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, potion));
                }
            }
        } else if (this.isItemValidForInput(itemStack)) {
            this.addItem(itemStack);
            --itemStack.field_77994_a;
            if (itemStack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        return true;
    }

    public void setLiquidLevel(int liquidLevel) {
        this.liquidLevel = liquidLevel;
        if (this.field_145850_b != null) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            blockState = blockState.func_177226_a((IProperty)BlockApothecaryCauldron.LEVEL, (Comparable)Integer.valueOf(liquidLevel));
            this.field_145850_b.func_175656_a(this.func_174877_v(), blockState);
            this.field_145850_b.func_175666_e(this.field_174879_c, (Block)ModBlocks.apothecaryCauldron);
        }
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.dataChanged = true;
    }
}

