/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.api.IPedestalItemWrapper;
import xreliquary.api.IPedestalRedstoneItem;
import xreliquary.api.IPedestalRedstoneItemWrapper;
import xreliquary.blocks.tile.TileEntityInventory;
import xreliquary.util.InventoryHelper;
import xreliquary.util.XRFakePlayerFactory;
import xreliquary.util.pedestal.PedestalRegistry;

public class TileEntityPedestal
extends TileEntityInventory
implements IPedestal,
IFluidHandler {
    private boolean tickable = false;
    private int[] actionCooldowns = new int[0];
    private int currentItemIndex;
    private Map<Integer, IPedestalActionItem> actionItems = new HashMap<Integer, IPedestalActionItem>();
    private Map<Integer, IPedestalActionItemWrapper> itemWrappers = new HashMap<Integer, IPedestalActionItemWrapper>();
    private Map<Integer, IPedestalRedstoneItem> redstoneItems = new HashMap<Integer, IPedestalRedstoneItem>();
    private List<ItemStack> fluidContainers = new ArrayList<ItemStack>();
    private FakePlayer fakePlayer = null;
    private boolean switchedOn = false;
    private List<Long> onSwitches = new ArrayList<Long>();
    private boolean initRedstone = false;

    public TileEntityPedestal() {
        super(1);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList items = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte b0 = item.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.updateSpecialItems();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            this.inventory[i].func_77955_b(item);
            item.func_74774_a("Slot", (byte)i);
            items.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)items);
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            PedestalRegistry.unregisterPosition(this.field_145850_b.field_73011_w.func_177502_q(), this.field_174879_c);
        }
        super.onChunkUnload();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            PedestalRegistry.registerPosition(this.field_145850_b.field_73011_w.func_177502_q(), this.field_174879_c);
        }
        super.onLoad();
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (stack == null && this.redstoneItems.containsKey(slot)) {
            this.redstoneItems.get(slot).onRemoved(this.inventory[slot], this);
        }
        super.func_70299_a(slot, stack);
        this.updateSpecialItems();
        this.updateRedstone();
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    private void updateSpecialItems() {
        this.tickable = false;
        this.fluidContainers.clear();
        this.itemWrappers.clear();
        this.actionItems.clear();
        this.redstoneItems.clear();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null) continue;
            if (item.func_77973_b() instanceof IPedestalActionItem) {
                this.tickable = true;
                this.actionItems.put(i, (IPedestalActionItem)item.func_77973_b());
            } else if (item.func_77973_b() instanceof IPedestalRedstoneItem) {
                this.redstoneItems.put(i, (IPedestalRedstoneItem)item.func_77973_b());
            } else {
                IPedestalItemWrapper wrapper = PedestalRegistry.getItemWrapper(item);
                if (wrapper != null) {
                    if (wrapper instanceof IPedestalActionItemWrapper) {
                        this.tickable = true;
                        this.itemWrappers.put(i, (IPedestalActionItemWrapper)wrapper);
                    }
                    if (wrapper instanceof IPedestalRedstoneItemWrapper) {
                        this.redstoneItems.put(i, (IPedestalRedstoneItem)((Object)wrapper));
                    }
                }
            }
            if (!(item.func_77973_b() instanceof IFluidContainerItem)) continue;
            this.fluidContainers.add(item);
        }
        this.actionCooldowns = new int[this.inventory.length];
        Arrays.fill(this.actionCooldowns, 0);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.initRedstone) {
            this.initRedstone = true;
            this.updateRedstone();
        }
        if ((this.isPowered() || this.switchedOn) && this.tickable) {
            this.currentItemIndex = 0;
            while (this.currentItemIndex < this.inventory.length) {
                if (this.actionCooldowns[this.currentItemIndex] > 0) {
                    int n = this.currentItemIndex;
                    this.actionCooldowns[n] = this.actionCooldowns[n] - 1;
                } else {
                    ItemStack item = this.inventory[this.currentItemIndex];
                    if (this.actionItems.containsKey(this.currentItemIndex)) {
                        this.actionItems.get(this.currentItemIndex).update(item, this);
                    } else if (this.itemWrappers.containsKey(this.currentItemIndex)) {
                        this.itemWrappers.get(this.currentItemIndex).update(this.inventory[this.currentItemIndex], this);
                    }
                }
                ++this.currentItemIndex;
            }
        }
    }

    public void updateRedstone() {
        this.currentItemIndex = 0;
        while (this.currentItemIndex < this.inventory.length) {
            if (this.redstoneItems.containsKey(this.currentItemIndex)) {
                this.redstoneItems.get(this.currentItemIndex).updateRedstone(this.inventory[this.currentItemIndex], this);
            }
            ++this.currentItemIndex;
        }
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    @Override
    public World getTheWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public int addToConnectedInventory(ItemStack stack) {
        List<IInventory> adjacentInventories = this.getAdjacentInventories();
        int sizeAdded = 0;
        for (IInventory inventory : adjacentInventories) {
            if ((sizeAdded += InventoryHelper.tryToAddToInventory(stack, inventory, 0, stack.field_77994_a - sizeAdded)) >= stack.field_77994_a) break;
        }
        return sizeAdded;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack, boolean doFill) {
        List<IFluidHandler> adjacentTanks = this.getAdjacentTanks();
        int fluidFilled = 0;
        FluidStack copy = fluidStack.copy();
        for (IFluidHandler tank : adjacentTanks) {
            if (tank.fill(EnumFacing.UP, copy, false) != copy.amount) continue;
            if ((fluidFilled += tank.fill(EnumFacing.UP, copy, doFill)) >= fluidStack.amount) break;
            copy.amount = fluidStack.amount - fluidFilled;
        }
        return fluidFilled;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack) {
        return this.fillConnectedTank(fluidStack, true);
    }

    @Override
    public void setActionCoolDown(int coolDownTicks) {
        if (this.currentItemIndex < this.actionCooldowns.length) {
            this.actionCooldowns[this.currentItemIndex] = coolDownTicks;
        }
    }

    @Override
    public FakePlayer getFakePlayer() {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        WorldServer world = (WorldServer)this.field_145850_b;
        return XRFakePlayerFactory.get(world);
    }

    @Override
    public void destroyCurrentItem() {
        this.func_70299_a(this.currentItemIndex, null);
    }

    @Override
    public void replaceCurrentItem(ItemStack stack) {
        this.func_70299_a(this.currentItemIndex, stack);
    }

    @Override
    public List<BlockPos> getPedestalsInRange(int range) {
        return PedestalRegistry.getPositionsInRange(this.field_145850_b.field_73011_w.func_177502_q(), this.field_174879_c, range);
    }

    @Override
    public void switchOn(BlockPos switchedOnFrom) {
        if (!this.onSwitches.contains(switchedOnFrom.func_177986_g())) {
            this.onSwitches.add(switchedOnFrom.func_177986_g());
        }
        this.switchedOn = true;
    }

    @Override
    public void switchOff(BlockPos switchedOffFrom) {
        this.onSwitches.remove(switchedOffFrom.func_177986_g());
        if (this.onSwitches.size() == 0) {
            this.switchedOn = false;
        }
    }

    public List<IInventory> getAdjacentInventories() {
        BlockPos south = this.func_174877_v().func_177971_a(EnumFacing.SOUTH.func_176730_m());
        BlockPos north = this.func_174877_v().func_177971_a(EnumFacing.NORTH.func_176730_m());
        BlockPos east = this.func_174877_v().func_177971_a(EnumFacing.EAST.func_176730_m());
        BlockPos west = this.func_174877_v().func_177971_a(EnumFacing.WEST.func_176730_m());
        ArrayList<IInventory> adjacentInventories = new ArrayList<IInventory>();
        IInventory inventory = this.getInventoryAtPos(south);
        if (inventory != null) {
            adjacentInventories.add(inventory);
        }
        if ((inventory = this.getInventoryAtPos(north)) != null) {
            adjacentInventories.add(inventory);
        }
        if ((inventory = this.getInventoryAtPos(east)) != null) {
            adjacentInventories.add(inventory);
        }
        if ((inventory = this.getInventoryAtPos(west)) != null) {
            adjacentInventories.add(inventory);
        }
        return adjacentInventories;
    }

    private IInventory getInventoryAtPos(BlockPos pos) {
        if (this.field_145850_b.func_175625_s(pos) instanceof IInventory) {
            return (IInventory)this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    public List<IFluidHandler> getAdjacentTanks() {
        BlockPos south = this.func_174877_v().func_177971_a(EnumFacing.SOUTH.func_176730_m());
        BlockPos north = this.func_174877_v().func_177971_a(EnumFacing.NORTH.func_176730_m());
        BlockPos east = this.func_174877_v().func_177971_a(EnumFacing.EAST.func_176730_m());
        BlockPos west = this.func_174877_v().func_177971_a(EnumFacing.WEST.func_176730_m());
        ArrayList<IFluidHandler> adjacentTanks = new ArrayList<IFluidHandler>();
        IFluidHandler tank = this.getTankAtPos(south);
        if (tank != null) {
            adjacentTanks.add(tank);
        }
        if ((tank = this.getTankAtPos(north)) != null) {
            adjacentTanks.add(tank);
        }
        if ((tank = this.getTankAtPos(east)) != null) {
            adjacentTanks.add(tank);
        }
        if ((tank = this.getTankAtPos(west)) != null) {
            adjacentTanks.add(tank);
        }
        return adjacentTanks;
    }

    private IFluidHandler getTankAtPos(BlockPos pos) {
        if (this.field_145850_b.func_175625_s(pos) instanceof IFluidHandler) {
            return (IFluidHandler)this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int totalFilled = 0;
        FluidStack resourceCopy = resource.copy();
        for (ItemStack container : this.fluidContainers) {
            IFluidContainerItem fluidContainer = (IFluidContainerItem)container.func_77973_b();
            resourceCopy.amount = resource.amount - (totalFilled += fluidContainer.fill(container, resourceCopy, doFill));
            if (totalFilled < resource.amount) continue;
            break;
        }
        return totalFilled;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        int totalDrained = 0;
        for (ItemStack container : this.fluidContainers) {
            IFluidContainerItem fluidContainer = (IFluidContainerItem)container.func_77973_b();
            FluidStack drainedStack = fluidContainer.drain(container, resource.amount - totalDrained, doDrain);
            if ((totalDrained += drainedStack.amount) < resource.amount) continue;
            break;
        }
        return new FluidStack(resource.getFluid(), totalDrained);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.fluidContainers.size() == 0) {
            return null;
        }
        ItemStack container = this.fluidContainers.get(0);
        Fluid fluid = this.getContainerFluid(container);
        return this.drain(from, new FluidStack(fluid, maxDrain), doDrain);
    }

    private Fluid getContainerFluid(ItemStack container) {
        return ((IFluidContainerItem)container.func_77973_b()).getFluid(container).getFluid();
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.fluidContainers.size() == 0) {
            return false;
        }
        for (ItemStack container : this.fluidContainers) {
            if (((IFluidContainerItem)container.func_77973_b()).fill(container, new FluidStack(fluid, 1), false) != 1) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.fluidContainers.size() == 0) {
            return false;
        }
        for (ItemStack container : this.fluidContainers) {
            if (((IFluidContainerItem)container.func_77973_b()).drain(container, 1, false) != new FluidStack(fluid, 1)) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[this.fluidContainers.size()];
        for (int i = 0; i < this.fluidContainers.size(); ++i) {
            ItemStack container = this.fluidContainers.get(i);
            IFluidContainerItem fluidContainer = (IFluidContainerItem)container.func_77973_b();
            tankInfo[i] = new FluidTankInfo(fluidContainer.getFluid(container), fluidContainer.getCapacity(container));
        }
        return tankInfo;
    }

    private boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public void removeRedstoneItems() {
        for (Map.Entry<Integer, IPedestalRedstoneItem> item : this.redstoneItems.entrySet()) {
            item.getValue().onRemoved(this.inventory[item.getKey()], this);
        }
    }
}

