/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.waila.provider;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.compat.waila.provider.CachedBodyDataProvider;
import xreliquary.init.ModBlocks;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.XRPotionHelper;

public class DataProviderCauldron
extends CachedBodyDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return new ItemStack((Block)ModBlocks.apothecaryCauldron);
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaBodyToCache(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!(accessor.getBlock() instanceof BlockApothecaryCauldron) || !(accessor.getTileEntity() instanceof TileEntityCauldron)) {
            return currenttip;
        }
        TileEntityCauldron cauldron = (TileEntityCauldron)accessor.getTileEntity();
        if (cauldron == null || cauldron.potionEssence == null) {
            return currenttip;
        }
        if (!cauldron.hasNetherwart) {
            currenttip.add(ChatFormatting.RED + StatCollector.func_74838_a((String)"waila.xreliquary.cauldron.missing_netherwart") + ChatFormatting.RESET);
        }
        StringBuilder ingredients = new StringBuilder();
        if (cauldron.redstoneCount > 0) {
            ingredients.append(cauldron.redstoneCount);
            ingredients.append("x");
            ingredients.append(new ItemStack(Items.field_151137_ax).func_82833_r());
            ingredients.append(" ");
        }
        if (cauldron.glowstoneCount > 0) {
            ingredients.append(cauldron.glowstoneCount);
            ingredients.append("x");
            ingredients.append(new ItemStack(Items.field_151114_aO).func_82833_r());
        }
        currenttip.add(ingredients.toString());
        if (cauldron.hasGunpowder) {
            currenttip.add(ChatFormatting.WHITE.toString() + cauldron.getLiquidLevel() + "x" + StatCollector.func_74838_a((String)"waila.xreliquary.cauldron.splash") + ChatFormatting.RESET);
        } else {
            currenttip.add(ChatFormatting.WHITE.toString() + cauldron.getLiquidLevel() + "x" + StatCollector.func_74838_a((String)"waila.xreliquary.cauldron.potion") + ChatFormatting.RESET);
        }
        this.addEffectsInfo(currenttip, cauldron.potionEssence);
        return currenttip;
    }

    private void addEffectsInfo(List<String> currenttip, PotionEssence essence) {
        ArrayList effectLines = new ArrayList();
        XRPotionHelper.addPotionInfo(essence, effectLines, false);
        StringBuilder sb = new StringBuilder();
        int effectsInLine = 0;
        Iterator iterator = effectLines.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            sb.append(line);
            if (++effectsInLine == 2) {
                effectsInLine = 0;
                currenttip.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        if (sb.length() > 0) {
            currenttip.add(sb.toString());
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return null;
    }
}

