/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.ItemAlkahestryTome;
import xreliquary.items.ItemDestructionCatalyst;
import xreliquary.items.ItemEnderStaff;
import xreliquary.items.ItemGlacialStaff;
import xreliquary.items.ItemHandgun;
import xreliquary.items.ItemHarvestRod;
import xreliquary.items.ItemHeroMedallion;
import xreliquary.items.ItemIceMagusRod;
import xreliquary.items.ItemInfernalChalice;
import xreliquary.items.ItemMidasTouchstone;
import xreliquary.items.ItemPyromancerStaff;
import xreliquary.items.ItemRendingGale;
import xreliquary.items.ItemSojournerStaff;
import xreliquary.items.ItemVoidTear;
import xreliquary.items.util.HarvestRodPlayerProps;
import xreliquary.reference.Colors;
import xreliquary.reference.Settings;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ClientEventHandler {
    private static RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    private static int time;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G || mc.func_175598_ae().func_78716_a() == null) {
            return;
        }
        this.handleTickIncrement(event);
        this.handleHandgunHUDCheck(mc);
        this.handleSojournerHUDCheck(mc);
        this.handleTomeHUDCheck(mc);
        this.handleDestructionCatalystHUDCheck(mc);
        this.handleEnderStaffHUDCheck(mc);
        this.handleIceMagusRodHUDCheck(mc);
        this.handleVoidTearHUDCheck(mc);
        this.handleMidasTouchstoneHUDCheck(mc);
        this.handleHarvestRodHUDCheck(mc);
        this.handleInfernalChaliceHUDCheck(mc);
        this.handleHeroMedallionHUDCheck(mc);
        this.handlePyromancerStaffHUDCheck(mc);
        this.handleRendingGaleHUDCheck(mc);
    }

    public void handleTickIncrement(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        time = ClientEventHandler.getTime() > 4096 ? 0 : ++time;
    }

    public static int getTime() {
        return time;
    }

    public void handleTomeHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemAlkahestryTome)) {
            return;
        }
        ItemStack tomeStack = player.func_71045_bC();
        ItemStack chargeStack = Settings.AlkahestryTome.baseItem.func_77946_l();
        chargeStack.field_77994_a = NBTHelper.getInteger("charge", tomeStack);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, tomeStack, chargeStack, Settings.HudPositions.alkahestryTome, 0, 0);
    }

    public void handleDestructionCatalystHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemDestructionCatalyst)) {
            return;
        }
        ItemStack destructionCatalystStack = player.func_71045_bC();
        ItemStack gunpowderStack = new ItemStack(Items.field_151016_H, NBTHelper.getInteger("gunpowder", destructionCatalystStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, destructionCatalystStack, gunpowderStack, Settings.HudPositions.destructionCatalyst, 0, 0);
    }

    public void handleEnderStaffHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemEnderStaff)) {
            return;
        }
        ItemStack enderStaffStack = player.func_71045_bC();
        ItemEnderStaff enderStaffItem = (ItemEnderStaff)enderStaffStack.func_77973_b();
        String staffMode = enderStaffItem.getMode(enderStaffStack);
        ItemStack displayItemStack = new ItemStack(Items.field_151079_bi, NBTHelper.getInteger("ender_pearls", enderStaffStack), 0);
        if (staffMode.equals("node_warp")) {
            displayItemStack = new ItemStack((Block)ModBlocks.wraithNode, NBTHelper.getInteger("ender_pearls", enderStaffStack), 0);
        } else if (staffMode.equals("long_cast")) {
            displayItemStack = new ItemStack(Items.field_151061_bv, NBTHelper.getInteger("ender_pearls", enderStaffStack), 0);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, enderStaffStack, displayItemStack, Settings.HudPositions.enderStaff, 0, 0);
    }

    public void handleIceMagusRodHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemIceMagusRod)) {
            return;
        }
        ItemStack iceRodStack = player.func_71045_bC();
        ItemStack snowballStack = new ItemStack(Items.field_151126_ay, NBTHelper.getInteger("snowballs", iceRodStack), 0);
        int hudPosition = player.func_71045_bC().func_77973_b() instanceof ItemGlacialStaff ? Settings.HudPositions.glacialStaff : Settings.HudPositions.iceMagusRod;
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, iceRodStack, snowballStack, hudPosition, 0, NBTHelper.getInteger("snowballs", iceRodStack));
    }

    public void handleVoidTearHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemVoidTear)) {
            return;
        }
        ItemStack voidTearStack = player.func_71045_bC();
        ItemVoidTear voidTearItem = (ItemVoidTear)voidTearStack.func_77973_b();
        ItemStack containedItemStack = voidTearItem.getContainedItem(voidTearStack);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, voidTearStack, containedItemStack, Settings.HudPositions.voidTear, 0, 0);
    }

    public void handleMidasTouchstoneHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemMidasTouchstone)) {
            return;
        }
        ItemStack midasTouchstoneStack = player.func_71045_bC();
        ItemStack glowstoneStack = new ItemStack(Items.field_151114_aO, NBTHelper.getInteger("glowstone", midasTouchstoneStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, midasTouchstoneStack, glowstoneStack, Settings.HudPositions.midasTouchstone, 0, 0);
    }

    public void handleHarvestRodHUDCheck(Minecraft mc) {
        ItemStack secondaryStack;
        EntityPlayerSP player = mc.field_71439_g;
        HarvestRodPlayerProps props = HarvestRodPlayerProps.get((EntityPlayer)player);
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHarvestRod)) {
            return;
        }
        ItemStack harvestRodStack = player.func_71045_bC();
        ItemHarvestRod harvestRod = ModItems.harvestRod;
        if (harvestRod.getMode(harvestRodStack).equals("plantable")) {
            secondaryStack = harvestRod.getPlantableItems(harvestRodStack).get(harvestRod.getCurrentPlantableIndex(harvestRodStack)).func_77946_l();
            int plantableCount = harvestRod.getPlantableQuantity(harvestRodStack, harvestRod.getCurrentPlantableIndex(harvestRodStack));
            if (player.func_71039_bw()) {
                plantableCount -= props.getTimesUsed();
            }
            secondaryStack.field_77994_a = plantableCount;
        } else if (harvestRod.getMode(harvestRodStack).equals("bone_meal")) {
            int boneMealCount = harvestRod.getBoneMealCount(harvestRodStack);
            if (player.func_71039_bw()) {
                boneMealCount -= props.getTimesUsed();
            }
            secondaryStack = new ItemStack(Items.field_151100_aR, boneMealCount, 15);
        } else {
            secondaryStack = new ItemStack(Items.field_151017_I);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, harvestRodStack, secondaryStack, Settings.HudPositions.harvestRod, 0, 0);
    }

    public void handleInfernalChaliceHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemInfernalChalice)) {
            return;
        }
        ItemStack infernalChaliceStack = player.func_71045_bC();
        ItemStack lavaStack = new ItemStack(Items.field_151129_at, NBTHelper.getInteger("fluidStacks", infernalChaliceStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, infernalChaliceStack, lavaStack, Settings.HudPositions.infernalChalice, Colors.get("AA0000"), lavaStack.field_77994_a / 1000);
    }

    public void handleHeroMedallionHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHeroMedallion)) {
            return;
        }
        ItemStack heroMedallionStack = player.func_71045_bC();
        int experience = NBTHelper.getInteger("experience", heroMedallionStack);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, heroMedallionStack, null, Settings.HudPositions.heroMedallion, Colors.get("009900"), experience);
    }

    public void handlePyromancerStaffHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemPyromancerStaff)) {
            return;
        }
        ItemStack pyromancerStaffStack = player.func_71045_bC();
        int charge = 0;
        int blaze = 0;
        NBTTagCompound tagCompound = NBTHelper.getTag(pyromancerStaffStack);
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                Item containedItem = RegistryHelper.getItemFromName(itemName);
                int quantity = tagItemData.func_74762_e("Quantity");
                if (containedItem == Items.field_151065_br) {
                    blaze = quantity;
                    continue;
                }
                if (containedItem != Items.field_151059_bz) continue;
                charge = quantity;
            }
        }
        String staffMode = ((ItemPyromancerStaff)pyromancerStaffStack.func_77973_b()).getMode(pyromancerStaffStack);
        ItemStack fireChargeStack = new ItemStack(Items.field_151059_bz, charge, 0);
        ItemStack blazePowderStack = new ItemStack(Items.field_151065_br, blaze, 0);
        ClientEventHandler.renderPyromancerStaffHUD(mc, (EntityPlayer)player, pyromancerStaffStack, fireChargeStack, blazePowderStack, staffMode);
    }

    private static void renderPyromancerStaffHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, ItemStack tertiaryStack, String staffMode) {
        int color = Colors.get("FFFFFF");
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 8;
        int hudOverlayY = 8;
        boolean leftSide = Settings.HudPositions.pyromancerStaff == 0 || Settings.HudPositions.pyromancerStaff == 2;
        switch (Settings.HudPositions.pyromancerStaff) {
            case 1: {
                hudOverlayX = sr.func_78326_a() - 8;
                break;
            }
            case 2: {
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = sr.func_78326_a() - 8;
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), hudStack, hudOverlayX - (leftSide ? 0 : 15), hudOverlayY, overlayOpacity, overlayScale);
        String friendlyStaffMode = "";
        if (staffMode.equals("eruption")) {
            friendlyStaffMode = "ERUPT";
        }
        if (secondaryStack != null && staffMode.equals("charge")) {
            renderItem.func_180450_b(secondaryStack, hudOverlayX + (leftSide ? 0 : -(16 + Integer.toString(secondaryStack.field_77994_a).length() * 6)), hudOverlayY + 24);
            minecraft.func_175598_ae().func_78716_a().func_175063_a(Integer.toString(secondaryStack.field_77994_a), (float)(hudOverlayX + (leftSide ? 16 : -(Integer.toString(secondaryStack.field_77994_a).length() * 6))), (float)(hudOverlayY + 30), color);
        } else if (tertiaryStack != null && (staffMode.equals("eruption") || staffMode.equals("blaze"))) {
            renderItem.func_180450_b(tertiaryStack, hudOverlayX + (leftSide ? 0 : -(16 + Integer.toString(tertiaryStack.field_77994_a).length() * 6)), hudOverlayY + 24);
            minecraft.func_175598_ae().func_78716_a().func_175063_a(Integer.toString(tertiaryStack.field_77994_a), (float)(hudOverlayX + (leftSide ? 16 : -(Integer.toString(tertiaryStack.field_77994_a).length() * 6))), (float)(hudOverlayY + 30), color);
            if (staffMode.equals("eruption")) {
                minecraft.func_175598_ae().func_78716_a().func_175063_a(friendlyStaffMode, (float)(hudOverlayX - (leftSide ? 0 : friendlyStaffMode.length() * 6)), (float)(hudOverlayY + 18), color);
            }
        } else if (staffMode.equals("flint_and_steel")) {
            renderItem.func_180450_b(new ItemStack(Items.field_151033_d, 1, 0), hudOverlayX - (leftSide ? 0 : 15), hudOverlayY + 24);
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void handleRendingGaleHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemRendingGale)) {
            return;
        }
        ItemStack rendingGaleStack = player.func_71045_bC();
        ItemStack featherStack = new ItemStack(Items.field_151008_G, NBTHelper.getInteger("feathers", rendingGaleStack), 0);
        int charge = featherStack.field_77994_a;
        if (player.func_71039_bw()) {
            int count = rendingGaleStack.func_77973_b().func_77626_a(rendingGaleStack) - (player.func_71052_bv() - 1);
            charge -= count * ItemRendingGale.getChargeCost();
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, rendingGaleStack, featherStack, Settings.HudPositions.rendingGale, 0, Math.max(charge /= 100, 0));
    }

    public void handleHandgunHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHandgun)) {
            return;
        }
        ItemStack handgunStack = player.func_71045_bC();
        ItemHandgun handgunItem = (ItemHandgun)handgunStack.func_77973_b();
        ItemStack bulletStack = new ItemStack((Item)ModItems.bullet, handgunItem.getBulletCount(handgunStack), handgunItem.getBulletType(handgunStack));
        ClientEventHandler.renderHandgunHUD(mc, (EntityPlayer)player, handgunStack, bulletStack);
    }

    private static void renderHandgunHUD(Minecraft minecraft, EntityPlayer player, ItemStack handgunStack, ItemStack bulletStack) {
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 8;
        int hudOverlayY = 8;
        boolean leftSide = Settings.HudPositions.handgun == 0 || Settings.HudPositions.handgun == 2;
        switch (Settings.HudPositions.handgun) {
            case 0: {
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                break;
            }
            case 2: {
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), handgunStack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale);
        if (bulletStack.field_77994_a == 0) {
            if (ClientEventHandler.getTime() % 32 > 16) {
                ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), new ItemStack((Item)ModItems.magazine, 1, 0), hudOverlayX - (leftSide ? 0 : 8), hudOverlayY + 12, overlayOpacity, overlayScale / 2.0f);
            }
        } else {
            for (int xOffset = 0; xOffset < bulletStack.field_77994_a; ++xOffset) {
                ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), bulletStack, hudOverlayX - (leftSide ? 0 : 8) - 1 * (leftSide ? -1 : 1) * (xOffset * 10), hudOverlayY + 12, 1.0f, overlayScale / 2.0f);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void handleSojournerHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemSojournerStaff)) {
            return;
        }
        ItemStack sojournerStack = player.func_71045_bC();
        ItemSojournerStaff sojournerItem = (ItemSojournerStaff)sojournerStack.func_77973_b();
        String placementItemName = sojournerItem.getTorchPlacementMode(sojournerStack);
        int amountOfItem = sojournerItem.getTorchCount(sojournerStack);
        Item placementItem = null;
        if (placementItemName != null) {
            placementItem = RegistryHelper.getItemFromName(placementItemName);
        }
        ItemStack placementStack = null;
        if (placementItem != null) {
            placementStack = new ItemStack(placementItem, amountOfItem, 0);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, sojournerStack, placementStack, Settings.HudPositions.sojournerStaff, 0, 0);
    }

    private static void renderStandardTwoItemHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, int hudPosition, int colorOverride, int stackSizeOverride) {
        int stackSize = 0;
        if (stackSizeOverride > 0) {
            stackSize = stackSizeOverride;
        }
        int color = Colors.get("FFFFFF");
        if (colorOverride > 0) {
            color = colorOverride;
        }
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 8;
        int hudOverlayY = 8;
        boolean leftSide = hudPosition == 0 || hudPosition == 2;
        switch (hudPosition) {
            case 1: {
                hudOverlayX = sr.func_78326_a() - 8;
                break;
            }
            case 2: {
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = sr.func_78326_a() - 8;
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), hudStack, hudOverlayX - (leftSide ? 0 : 15), hudOverlayY, overlayOpacity, overlayScale);
        if (hudStack.func_77973_b() instanceof ItemRendingGale) {
            ItemRendingGale staffItem = (ItemRendingGale)hudStack.func_77973_b();
            String staffMode = staffItem.getMode(hudStack);
            staffMode = staffMode.equals("flight") ? "FLIGHT" : (staffMode.equals("push") ? "PUSH" : (staffMode.equals("pull") ? "PULL" : "BOLT"));
            minecraft.func_175598_ae().func_78716_a().func_175063_a(staffMode, (float)(hudOverlayX - (leftSide ? 0 : staffMode.length() * 6)), (float)(hudOverlayY + 18), color);
        }
        if (secondaryStack != null) {
            if (stackSize == 0) {
                stackSize = secondaryStack.field_77994_a;
            }
            renderItem.func_180450_b(secondaryStack, hudOverlayX - (leftSide ? 0 : 16 + Integer.toString(stackSize).length() * 6), hudOverlayY + 25);
            hudOverlayX += leftSide ? 16 : 0;
        }
        GL11.glDisable((int)2896);
        minecraft.field_71466_p.func_175063_a(Integer.toString(stackSize), (float)(hudOverlayX - (leftSide ? 0 : Integer.toString(stackSize).length() * 6)), (float)(hudOverlayY + 29), color);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderItemIntoGUI(FontRenderer fontRenderer, ItemStack itemStack, int x, int y, float opacity, float scale) {
        renderItem.func_175042_a(itemStack, x, y);
    }
}

