/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xreliquary.handler.config.AlkahestConfiguration;
import xreliquary.handler.config.BlockItemConfiguration;
import xreliquary.handler.config.EasyModeConfiguration;
import xreliquary.handler.config.HudConfiguration;
import xreliquary.handler.config.MobDropConfiguration;
import xreliquary.reference.Settings;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile, true);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        HudConfiguration.loadHudPositions();
        EasyModeConfiguration.loadEasyModeSettings();
        MobDropConfiguration.loadMobDropProbabilities();
        BlockItemConfiguration.loadBlockAndItemSettings();
        Settings.chestLootEnabled = ConfigurationHandler.getBoolean("chest_loot_enabled", "general", true);
        configuration.getCategory("general").get("chest_loot_enabled").setRequiresMcRestart(true);
        Settings.wailaShiftForInfo = ConfigurationHandler.getBoolean("waila_shift_for_info", "general", false);
        Settings.dropCraftingRecipesEnabled = ConfigurationHandler.getBoolean("mob_drop_crafting_recipes_enabled", "general", false);
        configuration.getCategory("general").get("mob_drop_crafting_recipes_enabled").setRequiresMcRestart(true);
        Settings.mobDropsEnabled = ConfigurationHandler.getBoolean("mob_drops_enabled", "general", true);
        configuration.getCategory("general").get("mob_drops_enabled").setRequiresMcRestart(true);
        Settings.disabledItemsBlocks = ConfigurationHandler.getStringList("disabled_items_blocks", "general", Collections.EMPTY_LIST);
        configuration.getCategory("general").get("disabled_items_blocks").setRequiresMcRestart(true);
    }

    public static void postInit() {
        BlockItemConfiguration.loadEntitiesSettings();
        AlkahestConfiguration.loadAlkahestCraftingRecipes();
        AlkahestConfiguration.loadAlkahestChargingRecipes();
        AlkahestConfiguration.loadAlkahestBaseItem();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static List<String> getStringList(String name, String category, List<String> defaultValue) {
        return Arrays.asList(configuration.getStringList(name, category, defaultValue.toArray(new String[defaultValue.size()]), ConfigurationHandler.getTranslatedComment(category, name), new String[0], ConfigurationHandler.getLabelLangRef(category, name)));
    }

    public static boolean getBoolean(String name, String category, boolean defaultValue) {
        return configuration.getBoolean(name, category, defaultValue, ConfigurationHandler.getTranslatedComment(category, name), ConfigurationHandler.getLabelLangRef(category, name));
    }

    public static int getInt(String name, String category, int defaultValue, int minValue, int maxValue) {
        return configuration.getInt(name, category, defaultValue, minValue, maxValue, ConfigurationHandler.getTranslatedComment(category, name), ConfigurationHandler.getLabelLangRef(category, name));
    }

    public static String getString(String name, String category, String defaultValue) {
        return configuration.getString(name, category, defaultValue, ConfigurationHandler.getTranslatedComment(category, name), ConfigurationHandler.getLabelLangRef(category, name));
    }

    public static String getTranslatedComment(String category, String config) {
        return StatCollector.func_74838_a((String)("config." + category + "." + config + ".comment"));
    }

    public static String getLabelLangRef(String category, String config) {
        return "config." + category + "." + config + ".label";
    }

    public static void setCategoryTranslations(String categoryName, boolean setComment) {
        ConfigCategory category = configuration.getCategory(categoryName);
        category.setLanguageKey("config." + categoryName + ".label");
        if (setComment) {
            category.setComment(StatCollector.func_74838_a((String)("config." + categoryName + ".comment")));
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("xreliquary")) {
            ConfigurationHandler.loadConfiguration();
            ConfigurationHandler.postInit();
        }
    }
}

