/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler.config;

import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import xreliquary.handler.ConfigurationHandler;
import xreliquary.init.XRRecipes;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionEssenceComparator;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class PotionConfiguration {
    public static void loadPotionMap() {
        ConfigCategory category = ConfigurationHandler.configuration.getCategory("potion_map");
        if (category.isEmpty()) {
            PotionConfiguration.addDefaultPotionMap(category);
        }
        PotionConfiguration.loadPotionMapIntoSettings(category);
        LogHelper.debug("Starting calculation of potion combinations");
        PotionConfiguration.loadPotionCombinations();
        PotionConfiguration.loadUniquePotions();
        LogHelper.debug("Done with potion combinations");
        ConfigurationHandler.setCategoryTranslations("potion_map", true);
    }

    private static void loadUniquePotions() {
        Settings.Potions.uniquePotionEssences.clear();
        Settings.Potions.uniquePotions.clear();
        for (PotionEssence essence : Settings.Potions.potionCombinations) {
            boolean found = false;
            for (PotionEssence uniqueEssence : Settings.Potions.uniquePotionEssences) {
                if (!PotionConfiguration.effectsEqual(essence.effects, uniqueEssence.effects)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Settings.Potions.uniquePotionEssences.add(essence);
            PotionConfiguration.addUniquePotions(essence);
        }
        Settings.Potions.uniquePotionEssences.sort(new PotionEssenceComparator());
        Settings.Potions.uniquePotions.sort(new PotionEssenceComparator());
    }

    private static void addUniquePotions(PotionEssence essence) {
        Settings.Potions.uniquePotions.add(essence);
        if (Settings.Potions.redstoneAndGlowstone) {
            PotionEssence redstone = new PotionEssence(essence.writeToNBT());
            redstone.addRedstone(1);
            Settings.Potions.uniquePotions.add(redstone);
            PotionEssence glowstone = new PotionEssence(essence.writeToNBT());
            glowstone.addGlowstone(1);
            Settings.Potions.uniquePotions.add(glowstone);
            PotionEssence redstoneGlowstone = new PotionEssence(essence.writeToNBT());
            redstoneGlowstone.addRedstone(1);
            redstoneGlowstone.addGlowstone(1);
            Settings.Potions.uniquePotions.add(redstoneGlowstone);
        }
    }

    private static void loadPotionCombinations() {
        Settings.Potions.potionCombinations.clear();
        for (PotionIngredient ingredient1 : Settings.Potions.potionMap) {
            for (PotionIngredient ingredient2 : Settings.Potions.potionMap) {
                if (ingredient1.item.func_77973_b() == ingredient2.item.func_77973_b() && ingredient1.item.func_77960_j() == ingredient2.item.func_77960_j()) continue;
                PotionEssence twoEssence = new PotionEssence(ingredient1, ingredient2);
                if (twoEssence.effects.size() <= 0 || twoEssence.effects.size() > Settings.Potions.maxEffectCount) continue;
                PotionConfiguration.addPotionCombination(twoEssence);
                if (!Settings.Potions.threeIngredients) continue;
                for (PotionIngredient ingredient3 : Settings.Potions.potionMap) {
                    if (ingredient3.item.func_77973_b() == ingredient1.item.func_77973_b() && ingredient3.item.func_77960_j() == ingredient1.item.func_77960_j() || ingredient3.item.func_77973_b() == ingredient2.item.func_77973_b() && ingredient3.item.func_77960_j() == ingredient2.item.func_77960_j()) continue;
                    PotionEssence threeEssence = new PotionEssence(ingredient1, ingredient2, ingredient3);
                    if (PotionConfiguration.effectsEqual(twoEssence.effects, threeEssence.effects)) continue;
                    PotionConfiguration.addPotionCombination(threeEssence);
                }
            }
        }
    }

    private static void addPotionCombination(PotionEssence newEssence) {
        for (PotionEssence essence : Settings.Potions.potionCombinations) {
            if (PotionConfiguration.ingredientsEqual(essence.ingredients, newEssence.ingredients)) {
                return;
            }
            if (!PotionConfiguration.effectsEqual(essence.effects, newEssence.effects, Settings.Potions.differentDurations, true) || PotionConfiguration.effectsEqual(essence.effects, newEssence.effects)) continue;
            return;
        }
        Settings.Potions.potionCombinations.add(newEssence);
    }

    private static boolean ingredientsEqual(List<PotionIngredient> a, List<PotionIngredient> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionIngredient ingredientA : a) {
            boolean found = false;
            for (PotionIngredient ingredientB : b) {
                if (ingredientA.item.func_77973_b() != ingredientB.item.func_77973_b() || ingredientA.item.func_77960_j() != ingredientB.item.func_77960_j()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean effectsEqual(List<PotionEffect> a, List<PotionEffect> b) {
        return PotionConfiguration.effectsEqual(a, b, true, true);
    }

    private static boolean effectsEqual(List<PotionEffect> a, List<PotionEffect> b, boolean compareDuration, boolean comparePotency) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionEffect effectA : a) {
            boolean found = false;
            for (PotionEffect effectB : b) {
                if (effectA.func_76456_a() != effectB.func_76456_a() || compareDuration && effectA.func_76459_b() != effectB.func_76459_b() || comparePotency && effectA.func_76458_c() != effectB.func_76458_c()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void loadPotionMapIntoSettings(ConfigCategory category) {
        Settings.Potions.potionMap.clear();
        for (Map.Entry entry : category.getValues().entrySet()) {
            int meta;
            String name;
            String[] nameParts = ((String)entry.getKey()).split("\\|");
            String[] effects = ((Property)entry.getValue()).getStringList();
            String modId = nameParts[0].split(":")[0];
            ItemStack stack = StackHelper.getItemStackFromNameMeta(modId, name = nameParts[0].split(":")[1], meta = Integer.parseInt(nameParts[1]));
            if (stack == null) continue;
            PotionIngredient ingredient = new PotionIngredient(stack);
            for (int i = 0; i < effects.length; ++i) {
                String[] effectValues = effects[i].split("\\|");
                int potionId = XRPotionHelper.getPotionIdByName(effectValues[0]);
                if (potionId <= 0) continue;
                short durationWeight = Short.parseShort(effectValues[1]);
                short ampWeight = Short.parseShort(effectValues[2]);
                ingredient.addEffect(potionId, durationWeight, ampWeight);
            }
            if (ingredient.effects.size() <= 0) continue;
            Settings.Potions.potionMap.add(ingredient);
        }
    }

    private static void addDefaultPotionMap(ConfigCategory category) {
        PotionConfiguration.addPotionConfig(category, Items.field_151102_aT, PotionConfiguration.speed(3, 0), PotionConfiguration.haste(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151034_e, PotionConfiguration.heal(0), PotionConfiguration.hboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151044_h, PotionConfiguration.blind(1, 0), PotionConfiguration.absorb(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151044_h, 1, PotionConfiguration.invis(1, 0), PotionConfiguration.wither(0, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151008_G, PotionConfiguration.jump(3, 0), PotionConfiguration.weak(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151014_N, PotionConfiguration.harm(0), PotionConfiguration.hboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151015_O, PotionConfiguration.heal(0), PotionConfiguration.hboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151145_ak, PotionConfiguration.harm(0), PotionConfiguration.dboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151147_al, PotionConfiguration.slow(1, 0), PotionConfiguration.fatigue(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151116_aA, PotionConfiguration.resist(3, 0), PotionConfiguration.absorb(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151119_aD, PotionConfiguration.slow(1, 0), PotionConfiguration.hboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151110_aK, PotionConfiguration.absorb(3, 0), PotionConfiguration.regen(0, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151100_aR, 1, PotionConfiguration.heal(0), PotionConfiguration.hboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151100_aR, 11, PotionConfiguration.jump(3, 0), PotionConfiguration.weak(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151100_aR, 2, PotionConfiguration.resist(3, 0), PotionConfiguration.absorb(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151100_aR, 15, PotionConfiguration.weak(1, 0), PotionConfiguration.fatigue(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151080_bb, PotionConfiguration.invis(1, 0), PotionConfiguration.fireres(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151082_bd, PotionConfiguration.slow(1, 0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151076_bf, PotionConfiguration.nausea(1, 0), PotionConfiguration.poison(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151078_bh, PotionConfiguration.nausea(1, 0), PotionConfiguration.hunger(1, 0), PotionConfiguration.wither(0, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151074_bl, PotionConfiguration.dboost(0, 0), PotionConfiguration.haste(0, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151172_bF, PotionConfiguration.vision(3, 0), PotionConfiguration.hboost(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151174_bG, PotionConfiguration.hboost(3, 0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151115_aP, PotionConfiguration.satur(0), PotionConfiguration.breath(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151070_bp, PotionConfiguration.vision(4, 0), PotionConfiguration.poison(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151065_br, PotionConfiguration.dboost(4, 0), PotionConfiguration.harm(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151042_j, PotionConfiguration.resist(4, 0), PotionConfiguration.slow(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151007_F, PotionConfiguration.slow(2, 0), PotionConfiguration.fatigue(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151025_P, PotionConfiguration.hboost(4, 0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151157_am, PotionConfiguration.fatigue(2, 0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151123_aH, PotionConfiguration.resist(4, 0), PotionConfiguration.fireres(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_179566_aV, PotionConfiguration.satur(0), PotionConfiguration.breath(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151100_aR, 4, PotionConfiguration.haste(4, 0), PotionConfiguration.dboost(4, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151100_aR, 0, PotionConfiguration.blind(2, 0), PotionConfiguration.invis(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151103_aS, PotionConfiguration.weak(2, 0), PotionConfiguration.fatigue(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151106_aX, PotionConfiguration.heal(0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151127_ba, PotionConfiguration.heal(0), PotionConfiguration.speed(4, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151083_be, PotionConfiguration.resist(4, 0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151077_bg, PotionConfiguration.jump(4, 0), PotionConfiguration.satur(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151168_bH, PotionConfiguration.satur(0), PotionConfiguration.regen(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151170_bI, PotionConfiguration.poison(2, 0), PotionConfiguration.wither(1, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151128_bU, PotionConfiguration.harm(0), PotionConfiguration.dboost(4, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.ZOMBIE_HEART, PotionConfiguration.nausea(2, 0), PotionConfiguration.hunger(2, 0), PotionConfiguration.wither(1, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.SQUID_BEAK, PotionConfiguration.hunger(2, 0), PotionConfiguration.breath(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151158_bO, PotionConfiguration.invis(1, 0), PotionConfiguration.fireres(1, 0), PotionConfiguration.speed(3, 0), PotionConfiguration.haste(3, 0), PotionConfiguration.absorb(3, 0), PotionConfiguration.regen(0, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151064_bs, PotionConfiguration.dboost(4, 0), PotionConfiguration.harm(0), PotionConfiguration.resist(4, 0), PotionConfiguration.fireres(2, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151060_bw, PotionConfiguration.dboost(3, 0), PotionConfiguration.haste(3, 0), PotionConfiguration.heal(0), PotionConfiguration.speed(4, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151073_bk, PotionConfiguration.regen(3, 0), PotionConfiguration.absorb(5, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151071_bq, PotionConfiguration.vision(4, 0), PotionConfiguration.poison(2, 0), PotionConfiguration.speed(3, 0), PotionConfiguration.haste(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151150_bK, PotionConfiguration.dboost(3, 0), PotionConfiguration.haste(3, 0), PotionConfiguration.hboost(3, 0), PotionConfiguration.vision(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151043_k, PotionConfiguration.dboost(4, 0), PotionConfiguration.haste(4, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.RIB_BONE, PotionConfiguration.weak(3, 0), PotionConfiguration.fatigue(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151079_bi, PotionConfiguration.invis(5, 0), PotionConfiguration.speed(5, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151072_bj, PotionConfiguration.dboost(8, 0), PotionConfiguration.harm(0));
        PotionConfiguration.addPotionConfig(category, Items.field_151059_bz, PotionConfiguration.dboost(4, 0), PotionConfiguration.harm(0), PotionConfiguration.blind(1, 0), PotionConfiguration.absorb(3, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.CREEPER_GLAND, PotionConfiguration.regen(3, 0), PotionConfiguration.hboost(5, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.CHELICERAE, PotionConfiguration.poison(3, 0), PotionConfiguration.weak(3, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.SLIME_PEARL, PotionConfiguration.resist(5, 0), PotionConfiguration.absorb(5, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.SHELL_FRAGMENT, PotionConfiguration.absorb(5, 0), PotionConfiguration.breath(5, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.BAT_WING, PotionConfiguration.jump(5, 0), PotionConfiguration.weak(3, 0));
        PotionConfiguration.addPotionConfig(category, Items.field_151045_i, PotionConfiguration.resist(6, 1), PotionConfiguration.absorb(6, 1), PotionConfiguration.fireres(6, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.WITHER_RIB, PotionConfiguration.wither(2, 1), PotionConfiguration.weak(3, 1), PotionConfiguration.slow(3, 1), PotionConfiguration.fatigue(3, 1));
        PotionConfiguration.addPotionConfig(category, Items.field_151061_bv, PotionConfiguration.dboost(6, 1), PotionConfiguration.invis(6, 0), PotionConfiguration.speed(6, 1), PotionConfiguration.harm(1));
        PotionConfiguration.addPotionConfig(category, Items.field_151166_bC, PotionConfiguration.haste(6, 1), PotionConfiguration.speed(6, 1), PotionConfiguration.hboost(6, 1));
        PotionConfiguration.addPotionConfig(category, Items.field_151156_bN, PotionConfiguration.hboost(24, 1), PotionConfiguration.regen(24, 1), PotionConfiguration.absorb(24, 1));
        PotionConfiguration.addPotionConfig(category, XRRecipes.MOLTEN_CORE, PotionConfiguration.dboost(6, 1), PotionConfiguration.fireres(6, 0), PotionConfiguration.harm(1));
        PotionConfiguration.addPotionConfig(category, XRRecipes.STORM_EYE, PotionConfiguration.haste(24, 1), PotionConfiguration.speed(24, 1), PotionConfiguration.jump(24, 1), PotionConfiguration.harm(1));
        PotionConfiguration.addPotionConfig(category, XRRecipes.FERTILE_ESSENCE, PotionConfiguration.hboost(8, 1), PotionConfiguration.regen(3, 1), PotionConfiguration.heal(1), PotionConfiguration.satur(1), PotionConfiguration.weak(9, 1), PotionConfiguration.fatigue(9, 1));
        PotionConfiguration.addPotionConfig(category, XRRecipes.FROZEN_CORE, PotionConfiguration.absorb(6, 1), PotionConfiguration.slow(3, 1), PotionConfiguration.fatigue(3, 1), PotionConfiguration.harm(1), PotionConfiguration.fireres(6, 0));
        PotionConfiguration.addPotionConfig(category, XRRecipes.NEBULOUS_HEART, PotionConfiguration.vision(6, 0), PotionConfiguration.invis(6, 0), PotionConfiguration.harm(1), PotionConfiguration.hboost(6, 1), PotionConfiguration.dboost(6, 1), PotionConfiguration.speed(6, 1), PotionConfiguration.haste(6, 1));
        PotionConfiguration.addPotionConfig(category, XRRecipes.INFERNAL_CLAW, PotionConfiguration.harm(1), PotionConfiguration.resist(6, 1), PotionConfiguration.fireres(6, 0), PotionConfiguration.dboost(6, 1), PotionConfiguration.satur(1), PotionConfiguration.heal(1));
    }

    public static String harm(int potency) {
        return PotionConfiguration.effectString("harm", Integer.toString(0), Integer.toString(potency));
    }

    public static String heal(int potency) {
        return PotionConfiguration.effectString("heal", Integer.toString(0), Integer.toString(potency));
    }

    public static String satur(int potency) {
        return PotionConfiguration.effectString("saturation", Integer.toString(0), Integer.toString(potency));
    }

    public static String invis(int duration, int potency) {
        return PotionConfiguration.effectString("invisibility", Integer.toString(duration), Integer.toString(potency));
    }

    public static String absorb(int duration, int potency) {
        return PotionConfiguration.effectString("absorption", Integer.toString(duration), Integer.toString(potency));
    }

    public static String hboost(int duration, int potency) {
        return PotionConfiguration.effectString("healthBoost", Integer.toString(duration), Integer.toString(potency));
    }

    public static String dboost(int duration, int potency) {
        return PotionConfiguration.effectString("damageBoost", Integer.toString(duration), Integer.toString(potency));
    }

    public static String speed(int duration, int potency) {
        return PotionConfiguration.effectString("moveSpeed", Integer.toString(duration), Integer.toString(potency));
    }

    public static String haste(int duration, int potency) {
        return PotionConfiguration.effectString("digSpeed", Integer.toString(duration), Integer.toString(potency));
    }

    public static String slow(int duration, int potency) {
        return PotionConfiguration.effectString("moveSlowdown", Integer.toString(duration), Integer.toString(potency));
    }

    public static String fatigue(int duration, int potency) {
        return PotionConfiguration.effectString("digSlowDown", Integer.toString(duration), Integer.toString(potency));
    }

    public static String breath(int duration, int potency) {
        return PotionConfiguration.effectString("waterBreathing", Integer.toString(duration), Integer.toString(potency));
    }

    public static String vision(int duration, int potency) {
        return PotionConfiguration.effectString("nightVision", Integer.toString(duration), Integer.toString(potency));
    }

    public static String resist(int duration, int potency) {
        return PotionConfiguration.effectString("resistance", Integer.toString(duration), Integer.toString(potency));
    }

    public static String fireres(int duration, int potency) {
        return PotionConfiguration.effectString("fireResistance", Integer.toString(duration), Integer.toString(potency));
    }

    public static String weak(int duration, int potency) {
        return PotionConfiguration.effectString("weakness", Integer.toString(duration), Integer.toString(potency));
    }

    public static String jump(int duration, int potency) {
        return PotionConfiguration.effectString("jump", Integer.toString(duration), Integer.toString(potency));
    }

    public static String nausea(int duration, int potency) {
        return PotionConfiguration.effectString("confusion", Integer.toString(duration), Integer.toString(potency));
    }

    public static String hunger(int duration, int potency) {
        return PotionConfiguration.effectString("hunger", Integer.toString(duration), Integer.toString(potency));
    }

    public static String regen(int duration, int potency) {
        return PotionConfiguration.effectString("regeneration", Integer.toString(duration), Integer.toString(potency));
    }

    public static String poison(int duration, int potency) {
        return PotionConfiguration.effectString("poison", Integer.toString(duration), Integer.toString(potency));
    }

    public static String wither(int duration, int potency) {
        return PotionConfiguration.effectString("wither", Integer.toString(duration), Integer.toString(potency));
    }

    public static String blind(int duration, int potency) {
        return PotionConfiguration.effectString("blindness", Integer.toString(duration), Integer.toString(potency));
    }

    public static String effectString(String name, String duration, String potency) {
        return name + "|" + duration + "|" + potency;
    }

    private static void addPotionConfig(ConfigCategory category, ItemStack ingredient, String ... effects) {
        PotionConfiguration.addPotionConfig(category, ingredient.func_77973_b(), ingredient.func_77960_j(), effects);
    }

    private static void addPotionConfig(ConfigCategory category, Item ingredient, String ... effects) {
        PotionConfiguration.addPotionConfig(category, ingredient, 0, effects);
    }

    private static void addPotionConfig(ConfigCategory category, Item ingredient, int meta, String ... effects) {
        Property prop = new Property(String.format("%s|%d", ingredient.getRegistryName(), meta), effects, Property.Type.STRING);
        category.put(prop.getName(), prop);
    }
}

